/******************************************************************************
*  C H A R G E N  *  C P M S Y S 8  *  T h o m a s   H o l t e  * 8 4 0 9 2 3 *
*******************************************************************************
*  									      *
*     F O N T   F I L E   E D I T O R   F O R   T H E   G E N I E   I I I     *
*     ===================================================================     *
*                                                                             *
*            	    M I C R O C O M P U T E R   S Y S T E M		      *
*                   =======================================       	      *
*  									      *
*                            						      *
*  Version 1.0                                                  Thomas Holte  *
*  									      *
******************************************************************************/
    
#include <stdio.h>

/* ASCII control codes */
#define ETX 0x03		/* end of text      	 */
#define EOT 0x04		/* end of transmission   */
#define ENQ 0x05		/* enquiry		 */
#define BS  0x08		/* backspace        	 */
#define HT  0x09		/* horizontal tabulation */
#define CR  0x0D		/* carriage return	 */
#define DC1 0x11		/* device control 1	 */
#define DC2 0x12		/* device control 2	 */
#define NAK 0x15		/* negative acknowledge  */
#define CAN 0x18		/* cancel		 */
#define ESC 0x1B		/* escape		 */


xmain ()
{
  extern wtab[][4];
  extern char zbuf[];
  char chr[16], cfont (), cset[256][16], fname[15], heigth, j, key, length,
       option, width;	 
  int i, index, int2;
  BOOL edit, error = FALSE;
  FILE *fontfile;

  /* font borders */
  static char hborder []  = " 0 1 2 3 4 5 6 7";
  static char vborderl[] = " 0 1 2 3 4 5 6 7 8 9101112131415";
  static char vborderr[] = "0 1 2 3 4 5 6 7 8 9 101112131415";

  /* clear font buffer */
  setmem (cset, sizeof cset, 0);

  /* turn on graphics mode */
  outp (0xF5, 0);

  /* get parameters loop */
  for (i = 0;; i++)
  {
    index  = wtab[i][3] >> 4;
    option = wtab[i][3] &  7;  

    key = window(wtab[i][0], wtab[i][1], wtab[i][2], &zbuf[index]);

    /* check BACKTAB function */
    if (key == BS || key == ENQ)
    {
      while (i > 8 && wtab[--i][0] != 0x7F14);
      i--;
      continue;
    }

    /* check ESC function */
    if (key == NAK)	
    {
      puts  ("\33=7 \n");
      abort (0);
    }

    /* check options */
    switch (option)
    {
      /* ASCII --> binary --> ASCII */
      case 1: int2 = convert(0, (long)int2, 0, wtab[i][2] - wtab[i][1] + 1,
			     &zbuf[index]);
	      break;

      case 2: /* isolate filename */
	      length = 14;
	      while ((zbuf[index] == ' ' || zbuf[index] == 0x7F) && length)
	      {
		index++;
		length--;
	      }
	      for (j = 0; j < length; j++)
		if ((fname[j] = zbuf[index + j]) == ' ' || fname[j] == 0x7F)
		  break;
	      fname[j] = '\0';		/* terminate string */

       	      /* open font file */	
	      if ((fontfile = open(fname, 0)) != ERROR)
	      {
		read  (fontfile, cset, sizeof cset);
		close (fontfile);
		wtab[9][0] = 0;
	      }
	      else if ((fontfile = creat(fname, 0)) != ERROR)
	           {	
		     close (fontfile);
		     wtab[9][0] = 3;
	      	   }
		   else i--;

	      break; 		

      case 3: /* read width of dot matrix */
 	      if (int2 > 0 && int2 <= 8) width = int2 - 1; else i -= 2;
	      break;	
	      	
      case 4: /* read heigth of dot matrix */
	      if (int2 > 0 && int2 <= 16)
	      {
		heigth = int2 - 1;

		/* output font border */
		window (3, 431		     , 432 		  + width * 2,
			hborder );
		window (3, 529		     , 530 + heigth * 100	     ,
			vborderl);		
		window (3, 533 + width  *   2, 534 + heigth * 100 + width * 2,
			vborderr);
		window (3, 631 + heigth * 100, 632 + heigth * 100 + width * 2,
		 	hborder );
	      }
	      else i -= 3;
	      break;

      case 5: /* get character code */
	      int2 = hexconv(-1, (long)int2, 2, &zbuf[index]);
	      edit = FALSE;

	      /* check completion key */
	      switch (key)
	      {
		case DC2: if (int2) int2--;
			  break;

		case ETX: if (int2 < 255) int2++;
  			  break;

		case HT : edit = TRUE;
			  break;

		case ESC: puts ("\33=7 \n");
			  if ((fontfile = open(fname, 1)) == ERROR ||
			      write(fontfile, cset, sizeof cset) < sizeof cset)
			    error = TRUE;
			  close (fontfile);
			  if (error) abort (1); else return;
	      }
	      hexconv (1, (long)int2, 2, &zbuf[index]);
	      break;

      case 6: /* output and edit character font */
	      movmem (cset[int2], chr, sizeof chr);
	      if (edit)
	      {
		if (cfont(4, width, heigth, chr) == 'S')
		  movmem (chr, cset[int2], sizeof chr);
	      }
	      else cfont(3, width, heigth, chr);
	      i -= 2;
    }
  }
} 		


static char cfont (ctrl, width, heigth, buffer)
  char ctrl, width, heigth, buffer[];

{
  char code, es, ez, ls, lz;
  BOOL escape;

  static char init  [] = "\33\14\33I%\33J \33K?\33L \33  \33O\36",
              setcur[] = "\33=  ";

  code = 0;

  /* Berechnen der letzten Zeile des Fensters */
  init[7] = (ez = heigth) + '%';

  /* Berechnen der letzten Spalte des Fensters */
  init[13] = (es = width) * 2 + '@';

  puts (init);

  for (lz = 0; lz <= ez; lz++)
  {
    for (ls = 0; ls <= es; ls++)
      if (buffer[lz] >> 7 - ls & 1) puts ("\277\277"); else puts ("  ");
    if (lz < ez) putchar ('\n');
  }

  if (ctrl == 4)
  {
    lz = ls = 0;
    for (;;)
    {
      setcur[2] = lz     + ' ';
      setcur[3] = ls * 2 + ' ';
      puts (setcur);
      if (buffer[lz] >> 7 - ls & 1) puts ("\246\231"); else puts ("\231\246");
      puts ("\b\b");

      /* Holen eines Zeichens von der Tastatur */
      escape_sequence:
      while (!(code = bdos(6, 0xFF)));

      /* CTRL-Q ? */
      if (code == DC1)
      {
	escape = TRUE;
	goto escape_sequence;
      }

      if (buffer[lz] >> 7 - ls & 1) puts ("\277\277"); else puts ("  ");
      puts ("\b\b");

      if (code < ' ' || escape)
      {
	escape = FALSE;
	switch (code)
      	{
          case EOT: if (ls < es) ls++;	/* cursor right		*/
		    continue;

          case ENQ: if (lz) lz--;  	/* cursor up 		*/	
		    continue;

          case BS : if (ls) ls--;       /* cursor left          */
		    continue;

          case CR : if (lz < ez) lz++;	/* NEW LINE 		*/
		    ls = 0;
		    continue;

	  case NAK: break;		/* BREAK		*/

          case CAN: if (lz < ez) lz++; 	/* cursor down 		*/
		    continue;

          case 'C': lz = ez;		/* SHIFT + cursor down  */
		    continue;

          case 'D': ls = es;		/* SHIFT + cursor right */
		    continue;

          case 'R': lz = 0;		/* SHIFT + cursor up    */
		    continue;

          case 'S': ls = 0;		/* SHIFT + cursor left */
	  default : continue;
        }
	break;
      }

      switch (toupper(code))
      {
        case ' ': buffer[lz] &= ~(0x80 >> ls);
		  puts ("  ");
		  if (ls < es) ls++;
		  continue;

        case '.': buffer[lz] |= 0x80 >> ls;
	          puts ("\277\277");
	          if (ls < es) ls++;
		  continue;

	case 'E' :
	case 'S': break;
		
        default : continue;
      }
    break;
    }
  } 
  puts ("\36\33I \33J7\33K \33Lo\33  \33N\33\15");
  return code;
}
