/******************************************************************************
*  B A C K U P  *  U T I L S 0 0 2  *  T h o m a s   H o l t e  * 8 4 0 2 1 9 *
*******************************************************************************
* 									      *
*    B A C K U P   U T I L I T Y   F O R   L A R G E   M A S S   M E D I A    *
*    =====================================================================    *
* 									      *
*    O N   C P / M - B A S E D   M I C R O C O M P U T E R   S Y S T E M S    *
*    =====================================================================    *
* 									      *
* 									      *
*   Thomas Holte			                         Version 1.0  *
* 									      *
******************************************************************************/

#include <stdio.h>

#define ETX 3

#define WRDIR    1	/* write to directory   */
#define WRUAL    2	/* write to unallocated */


struct dpbase {
	   	char *XLT;
	   	int filler[3];
	   	char *DIRBUF;
	   	struct dpb {
		             int SPT;
		             char BSH, BLM, EXM;
		             int DSM, DRM;
		             char AL0, AL1;
		             int CKS, OFF;
		      	   } *DPB;
	   	char *CSV, *ALV;
	      };


main (argc, argv)
  int argc;
  char *argv[];
{
  char *blocks, *buf, class, disk, *dmaadr, disks[255], errmsg (), errno,
       adate[25], lastdisk, recio (), s[80], state, temp, val, work;
  int blockindex, count, dblocksiz, dirsize, i, j, lastblock, no, record, 
      sblocksiz, start, temprec;
  BOOL equal (), first, init;

  struct {
	   char mode[5], source, dest, verify;
	 } list;

  struct dpbase *SDPBASE, *DDPBASE;

  struct {
	   char del, name[8], type[3], extent, reserved[2], eof;
	   union {
		   char sno[16];
		   int lno[8];
		 } block;
	 } *entry;
  struct {
	   char header[25], number;
	   BOOL last;
	   struct dpb SDPB, DDPB;
	   int blockcount, blockno[0];
	 } *ownentry;

  /* structure of the decision table:
     a) states:     0. initial
 		    1. mode encountered
 		    2. source drive encountered
 		    3. destination drive encountered
 		    4. end
     b) activities: 0. NOP
 		    1. save copy mode
 		    2. save source drive
 		    3. save destination drive
 		    4. save option

   	     		   mode drive option */
  static char tab[][3] = {{0x11, 0x22, 0x44},
			  {0x40, 0x22, 0x44},
			  {0x40, 0x33, 0x44},
			  {0x40, 0x40, 0x44}};


  /* initialize control structure */
  list.mode[0] = list.verify = 0;
  list.source  = list.dest   = 0xFF;

  /* initialize control variables */
  state = 0;
  start = 1;

  printf ("\nBACKUP VER 1.0\n");

  for (;;)
  {
    /* convert arguments to upper case */
    for (i = start; i < argc; i++) for (j = 0; j < strlen(argv[i]); j++)
      argv[i][j] = toupper(argv[i][j]);

    for (i = start; i < argc; i++)
    {		
        			  			    class = 0xFF;
      if (streq("SAVE", argv[i]) || streq("REST", argv[i])) class = 0;
      if (strlen(argv[i]) == 1 && *argv[i] >= 'A' && *argv[i] <= 'P')
        			  			    class = 1;
      if (streq("[V]", argv[i]))  			    class = 2;

      if (class == 0xFF) break;

      /* get table entry */
      val = tab[state][class]; 

      /* working entry */
      work = val & 7;

      switch (work)
      {
        case 1 : strcpy (list.mode, argv[i]);
	         break;
        case 2 : list.source = *argv[i] - 'A';
	         break;
        case 3 : list.dest   = *argv[i] - 'A';
	         break;
        case 4 : list.verify = index(argv[i], 'V');
      }

      if ((state = val >> 4) == 4) break;
    }

    argc  = 1;
    start = state = 0;
  
    if (list.mode[0] == 'E') return;

    if (list.mode[0] == '\0')
    {
      printf ("\nMODE   FUNCTION\n\n");
      printf ("SAVE   SAVE CONTENTS OF MASS MEDIA\n");
      printf ("REST   RESTORE CONTENTS OF MASS MEDIA\n");
      printf ("\nENTER YOUR BACKUP MODE: ");
      gets   (argv[0] = s);	
      if (strlen(s) <= 1) argv[0][0] = '\0';
      continue;
    }
            
    if (list.source == 0xFF)
    {
      printf ("\nENTER SOURCE DRIVE: ");
      gets   (argv[0] = s);
      continue;
    }
    else if (!(SDPBASE = bios(SELDSK, list.source, 0)))
         {
           printf ("\nDISK SELECT ERROR ON SOURCE\n");
           abort  (1);
         }

    if (list.dest == 0xFF)
    {
      printf ("\nENTER DESTINATION DRIVE: ");
      gets   (argv[0] = s);
      state   = 2;
      continue;
    }
    else
      if (list.dest == list.source || !(DDPBASE = bios(SELDSK, list.dest, 0)))
      {
        printf ("\nDISK SELECT ERROR ON DESTINATION\n");
        abort  (1);
      }
      else bios (HOME, 0, 0);

    break;   
  }

  /* calc block size of source & destination disk */
  sblocksiz = (SDPBASE->DPB->BLM + 1) * REC_SIZE;
  dblocksiz = (DDPBASE->DPB->BLM + 1) * REC_SIZE;

  printf ("\n(^C TO ABORT)\n");

  if (list.mode[0] == 'S')	/* save */
  {
    printf ("RETURN TO SAVE CONTENTS OF DRIVE %c ", list.source + 'A');
    gets   ();

    /* calc block count of source directory */
    dirsize = 0;
    temp    = SDPBASE->DPB->AL0;
    for (i = 0; i < 8; i++, temp <<= 1) if (temp) dirsize++; else break;
    temp = SDPBASE->DPB->AL1;
    for (i = 0; i < 8; i++, temp <<= 1) if (temp) dirsize++; else break;

    /* get directory buffer and buffer for table of allocated blocks */
    if (!(dmaadr = entry = alloc(dirsize * sblocksiz  )) ||
	!(blocks = 	   alloc(SDPBASE->DPB->DSM + 1)))
    {
      printf ("\nOUT OF MEMORY\n");
      abort  (1);
    }

    /* read directory of source disk & allocate directory blocks */
    for (i = 0; i < dirsize; i++, dmaadr += sblocksiz)
    {
      blockio (list.source, i, dmaadr, READ, 0);
      blocks[i] = TRUE;
    }	

    for (i = lastblock = dirsize; i <= SDPBASE->DPB->DSM; i++)
      blocks[i] = FALSE;

    /* detect unallocated blocks */
    for (i = 0; i <= SDPBASE->DPB->DRM; i++)
      if (entry[i].del != 0xE5)
        if (SDPBASE->DPB->DSM > 255)
          for (j = 0; j < 8; j++)
	  {
 	    if (no = entry[i].block.lno[j]) blocks[no] = TRUE;	
	    lastblock = max(lastblock, no);
	  }
        else 
          for (j = 0; j < 16; j++) 
	  {
	    if (no = entry[i].block.sno[j]) blocks[no] = TRUE;
	    lastblock = max(lastblock, no);
	  }

    free (entry);		/* free directory buffer */

    /* calc source block count on destination disk */
    count = ((DDPBASE->DPB->DSM + 1) * (DDPBASE->DPB->BLM + 1)
	   + (DDPBASE->DPB->OFF - 1) *  DDPBASE->DPB->SPT)
	   / (SDPBASE->DPB->BLM + 1); 
		
    /* get I/O buffer and buffer for own directory */
    if (!(buf 	   = alloc(sblocksiz		       		   )) ||
	!(ownentry = alloc(sizeof *ownentry + count * sizeof i)))
    {
      printf ("\nOUT OF MEMORY\n");
      abort  (1);
    }
   

    /* build header */
    strcpy ( ownentry->header    , "BACKUP ");
    strcpy (&ownentry->header[ 7], date()   );
    strcpy (&ownentry->header[16], time()   );
    ownentry->header[15] = ' ';

    /* copy disk parameter blocks */
    movmem (SDPBASE->DPB, &ownentry->SDPB, sizeof ownentry->SDPB);
    movmem (DDPBASE->DPB, &ownentry->DDPB, sizeof ownentry->DDPB);

    /* reset block indices and disk counter */
    blockindex 	   = disk = ownentry->blockcount = 0;
    record     	   = DDPBASE->DPB->SPT;	/* set first record number of dest */

    ownentry->last = FALSE;

    /* copy loop */
    printf ("\nCOPYING BLOCK     ");
    for (i = 0; i <= lastblock; i++)
      if (ownentry->blockcount < count)
      {
        if (!blocks[i]) continue;
        printf  ("\b\b\b\b%04d", ownentry->blockno[blockindex++] = i);
        blockio (list.source, i, buf, READ, 0);

	retry:
        for (j = temprec = 0; j < sblocksiz; j += REC_SIZE, temprec++)
	  if (errno = recio(list.dest, record + temprec, &buf[j], WRITE))
	  {
	    switch (errmsg(errno))
	    {
	      case 'C': abort (1);
	      case 'R': j 	= -REC_SIZE;
			temprec = -1;
	    }
	    printf ("\nCOPYING BLOCK %04d", i);
	  }

	if (list.verify)
	{
	  for (j = temprec = 0; j < sblocksiz; j += REC_SIZE, temprec++)
	    if (errno = recio(list.dest, record + temprec, disks, READ))
	    {
	      switch (errmsg(errno))
	      {
		case 'C': abort  (1);
		case 'R': printf ("\nCOPYING BLOCK %04d", i);
			  goto retry;
	      }  
	      printf ("\nCOPYING BLOCK %04d", i);
	    }
	}
	record += SDPBASE->DPB->BLM + 1;	/* increment record counter */
        ownentry->blockcount++;		    /* increment dest block counter */
      }	
      else
      {
	/* write own directory */
	ownentry->number = disk++;
	write_dir (list.dest, ownentry);

	for (;;)
	{
          /* prompt for next disk */
          printf  ("\n\nINSERT NEXT DISK INTO DRIVE %c AND PRESS <NEW LINE> ",
	           list.dest + 'A');
          getchar ();
	
	  /* check for previous */
	  for (;;)
	  {
	    if (errno = recio(list.dest, 0, buf, READ))
	      switch (errmsg(errno))
	      {
		case 'C': abort (1);
		case 'R': bios  (HOME, 0, 0);
			  continue;
	      }		
	    break;
	  }
	  if (streq(ownentry->header, buf))
	  {
	    printf ("\n*** ATTENTION *** WRONG DISK ***");
	    bios   (HOME, 0, 0);
	  }
	  else break;
	}	

	/* reset counters */
        blockindex = ownentry->blockcount = 0;
        record     = DDPBASE->DPB->SPT;
	i--;

	printf ("\nCOPYING BLOCK     ");
      }	

    /* write own directory */
    ownentry->number = disk;
    ownentry->last   = TRUE;
    write_dir (list.dest, ownentry);
  }
  else
  {
    printf ("RETURN TO RESTORE CONTENTS OF DRIVE %c ", list.dest + 'A');
    gets   ();

    /* get I/O buffer and buffer for own directory */
    if (!(buf 	   = alloc(dblocksiz		       )) ||
	!(ownentry = alloc(SDPBASE->DPB->SPT * REC_SIZE)))
    {
      printf ("\nOUT OF MEMORY\n");
      abort  (1);
    }
   
    /* reset disk remarkers */
    first    = init = TRUE;
    lastdisk = -1;
    for (i = 0; i < 255; i++) disks[i] = FALSE; 

    /* copy loop */
    for (;;)
    {
      for (;;)
      {
        /* insert prompt */
	if (!init)
	{
	  printf ("\n\nINSERT NEXT DISK INTO DRIVE %c AND PRESS <NEW LINE> ",
		  list.source + 'A');
	  gets   ();
	}
	
	init = FALSE;

	/* read own directory */
	read_dir (list.source, ownentry);

	if (first)
	{
	  /* check header & disk parameter blocks */
	  if (streq(ownentry->header, "BACKUP")   			  &&
	      equal(&ownentry->SDPB, DDPBASE->DPB, sizeof ownentry->SDPB) &&
	      equal(&ownentry->DDPB, SDPBASE->DPB, sizeof ownentry->DDPB))	
	  {
	    strcpy (adate, ownentry->header);
	    first = FALSE;
	    break;
	  }
	}
	else if (streq(ownentry->header, adate)) if (!disks[ownentry->number])
						   break;

	printf ("\n*** ATTENTION *** WRONG DISK ***");
	bios   (HOME, 0, 0);
      }		 
 	
      /* remark disk number */ 	
      disks[ownentry->number] = TRUE;
      if (ownentry->last) lastdisk = ownentry->number;

      record = SDPBASE->DPB->SPT;	/* reset record counter */

      printf ("\nCOPYING BLOCK     ");
      for (i = 0; i < ownentry->blockcount; i++)
      {
	printf ("\b\b\b\b%04d", ownentry->blockno[i]);
        for (j = temprec = 0; j < dblocksiz; j += REC_SIZE, temprec++)
	  if (errno = recio(list.source, record + temprec, &buf[j], READ))
	  {
	    switch (errmsg(errno))
	    {
	      case 'C': abort (1);
	      case 'R': j 	= -REC_SIZE;
			temprec = -1;
			bios (HOME, 0, 0);
	    }
	    printf ("\nCOPYING BLOCK %04d", ownentry->blockno[i]);
	  }
	record += DDPBASE->DPB->BLM + 1;	/* inc record counter */

        blockio (list.dest, ownentry->blockno[i], buf, WRITE, list.verify);
      }
		
      /* done ? */
      if (lastdisk != 0xFF)
      {	
	for (i = 0; i <= lastdisk; i++) if (!disks[i]) break;
        if (i == lastdisk + 1)
	{
	  /* flush destination buffer */
	  recio (list.source, record - 1, buf, READ);
	  break;
	}
      }
    }  
  } 
}


static BOOL equal (buf1, buf2, n)
  char *buf1, *buf2;
  int n;
{
  int i;

  for (i = 0; i < n; i++) if (buf1[i] != buf2[i]) return FALSE;
						  return TRUE;
}


static read_dir (drive, buffer)
  char drive, *buffer;
{
  char errno;
  int record;
  struct dpbase *DPBASE;

  DPBASE = bios(SELDSK, drive, 0);
    
  for (record = 0; record < DPBASE->DPB->SPT; record++)
    if (errno = recio(drive, record, &buffer[record * REC_SIZE], READ))
      switch (errmsg(errno))
      {
        case 'C': abort (1);
	case 'R': record = -1;
		  bios (HOME, 0, 0);
      }
}
 	    

static write_dir (drive, buffer)
  char drive, *buffer;
{
  char dummy[REC_SIZE], errno;
  int record;
  struct dpbase *DPBASE;

  DPBASE = bios(SELDSK, drive, 0);

  retry:    
  for (record = 0; record < DPBASE->DPB->SPT; record++)
    recio(drive, record, &buffer[record * REC_SIZE], WRITE);
  for (record = 0; record < DPBASE->DPB->SPT; record++)
    if (errno = recio(drive, record, dummy, READ))
      switch (errmsg(errno))
      {
        case 'C': abort (1);
	case 'R': goto retry;
      }
}
 	    

static blockio (drive, blockno, buffer, mode, verify)
  char drive, *buffer, mode;
  int blockno;
  BOOL verify;
{
  struct dpbase *DPBASE;
  unsigned firstrec, lastrec, record;
  char dummy[REC_SIZE], errno, *iobuf;	

  lastrec = (firstrec = blockno * ((DPBASE = bios(SELDSK, drive, 0))->DPB->BLM
	    + 1)) + DPBASE->DPB->BLM;

  retry:
  iobuf = buffer;
  for (record = firstrec; record <= lastrec; record++)
  {
    bios (SETTRK, record / DPBASE->DPB->SPT + DPBASE->DPB->OFF, 0);
    bios (SETSEC, bios(SECTRAN, record % DPBASE->DPB->SPT, 0) , 0);
    bios (SETDMA, iobuf 				      , 0);

    if (errno = bios(mode, WRUAL, 0))
      switch (errmsg(errno))
      {
	case 'C': abort (1);
	case 'R': record = firstrec - 1;
		  iobuf  = buffer;
                  continue;
      }

    iobuf += REC_SIZE;
  }

  if (mode == WRITE && verify)
  {
    bios (SETDMA, dummy, 0);
    for (record = firstrec; record <= lastrec; record++)
    {
      bios (SETTRK, record / DPBASE->DPB->SPT + DPBASE->DPB->OFF, 0);
      bios (SETSEC, bios(SECTRAN, record % DPBASE->DPB->SPT, 0) , 0);
    
      if (errno = bios(READ, 0, 0))
      {
        switch (errmsg(errno))
        {
	  case 'C': abort (1);
	  case 'P': continue;
        }
	goto retry;
      }
    }	
  }    
}


static char recio (drive, recno, buffer, mode)
  char drive, *buffer, mode;
  unsigned recno;
{
  struct dpbase *DPBASE;

  DPBASE = bios(SELDSK, drive, 0);

  bios (SETTRK, 	      recno / DPBASE->DPB->SPT     , 0);
  bios (SETSEC, bios(SECTRAN, recno % DPBASE->DPB->SPT, 0) , 0);
  bios (SETDMA, buffer				      	   , 0);

  return bios(mode, WRUAL, 0);
}


static char errmsg (errno)
  char errno;
{
  char c;

  printf ("\n\n");
  switch (errno)
  {
    case 1: printf ("ILLEGAL DRIVE #\n");
	    abort  (1);
    case 2: printf ("TRACK # TOO HIGH\n");
	    abort  (1);
    case 3: printf ("SECTOR # TOO HIGH\n");
	    abort  (1);	
    case 4: printf ("DEVICE NOT AVAILABLE\n");
	    break;
    case 5: printf ("WRITE PROTECTED DISKETTE\n");
 	    break;
    case 6: printf ("WRITE FAULT ON DISK DRIVE\n");
	    abort  (1);
    case 7: printf ("DATA RECORD NOT FOUND\n");
	    break;
    case 8: printf ("PARITY ERROR\n");
	    break;
    case 9: printf ("LOST DATA\n");
	    abort  (1);
  }
  printf ("REPLY C (CANCEL), R (RETRY) OR P (PROCEED)\n");
  do
  {
    printf ("\b");
    c = toupper(getchar());
  }
  while (c != 'C' && c != 'P' && c != 'R');
  printf ("\n");
  return c;
}
