

					   Lesson 7

					  FORMATTING

	Perfect Writer provides two means of formatting a document. 
The first is called 'edit-time formatting', in which you are
responsible for the layout of your document, much as you would be
if you were writing on a `typewriter'.  As you create the document,
you must take care to properly indent paragraphs, set tab stops,
center lines and headings, wrap and fill lines.  When you have
thus 'formatted'  your document on screen, Perfect Writer will
then print it exactly as it appears.

	Such 'edit-time formatting' will be perfectly suitable for
most of the  documents that you will create--letters, memos, etc.
For many of us it represents the comfortable and familiar way of
formatting a document.  After all, we have been formatting this
way on typewriters all of our lives.   

	 You may wish to use 'edit-time formatting' until such time
as you  become familiar with Perfect Writer's `Document Design
Commands', the second (and preferable) means of formatting a
document which Perfect Writer provides.  These commands relieve
you of the tedious drudgery  of  having to change margins, tabs,
indentions, and linespacing each time you wish to arrange or
`format' a section of text. They are well suited for documents
requiring complex or involved formats.  We feel that once you are
familiar with them, you will use them more often than not in
formatting your documents.

	In this lesson we will present these two methods of
formatting, first telling you how you can format a document
yourself, and then introducing Perfect Writer's Document Design
Commands.

				 EDIT-TIME FORMATTING

	Actually, you used `edit-time formatting' in Lesson 1, where
you wrote the short letter to a friend. In that lesson you
formatted your document the way you wanted it, indenting and
spacing paragraphs, wrapping and filling lines.  When you were
finished, you told Perfect Writer to print it exactly as you had
created it on the screen. 

	  'Edit-time Formatting' is just that:  laying out your
document on the screen the way you want it, and then having
Perfect Writer print it.

	When printing 'typewriter style', as it is also called,
Perfect Writer does not wrap and fill lines, justify margins, or
group paragraphs.  It prints your document exactly as it appears
on the screen.

	Because in edit-time formatting the exact layout of the
document is left up to you,  Perfect Writer provides several
commands that allow you to 'set-up' the screen in ways that
facilitate your task of formatting. These commands  change screen
margins, center words or lines on the screen, and alter tab
spacing.

	At this time move the cursor to the middle of the screen and
CREATE TWO WINDOWS:


					 Control--X  2

	Using the FIND DOCUMENT Command (Control--X  Control--F) call
into the top window a new file in which you can practice
formatting.  Call the new file 'b:format.mss'.  When Perfect
Writer presents the blank screen, enter two short paragraphs of
sample text  (anything you wish). 


					MARGIN COMMANDS

	By default, Perfect Writer begins every editing session
with the left screen margin set at column 0  (zero) and the right
screen margin set at column 65.  The right screen margin is also
called the 'Fill column', since lines of characters, when they
reach this point on the screen, are automatically 'wrapped' and
'filled' to the next line on the screen.   You have already
observed how this action takes place.

	Screen margin settings can be changed using two simple
commands:

	SET LEFT SCREEN MARGIN		Control---X  .  (period)
	SET RIGHT SCREEN MARGIN		Control---X  F  (for 'fill')

	The procedure is the same for both commands.  Move the
cursor to the position on the screen where you wish the left or
giht margin to be (using the `arrow keys' or the `space bar'),
and type the appropriate margin command.  Perfect Writer will
respond with the message:

Perfect Writer will respond with the message:

			 `Left margin is <column number>'
						 
						 or

			 `Right margin is <column number>'

	The change will also be reflected in the `Ruler'.  The
double bars which indicate the current margins will be positioned
at the new setting.

	Let's try it.  On any line of the first paragraph which
you typed in the top window, position the cursor about 10 spaces 
from the left margin.  Type the SET LEFT MARGIN Command:

				Control--X  .  (a period)

	Perfect Writer responds: "Left Margin is now 10".  
	
	So far, nothing appears to have happened, except  that the 
left vertical bars are now positioned on the Ruler at column 10. 
However, the paragraph is still displayed as it was previously.  
With the cursor anywhere in the first paragraph, give the ADJUST
PARAGRAPH Command:
					 Escape. . .Q

	Immediately, the lines of the paragraph are adjusted.
Column 10  has become the new 'left' margin for this paragraph
and all subsequent paragraphs that you will create. Move the
cursor to the second paragraph and adjust its lines also, using
the ADJUST PARAGRAPH Command.

	  You can do the same with the right margin.  Move the
cursor  to column 45, (i.e. 35 spaces to the right of the new left
margin).  Give the SET RIGHT MARGIN Command:

					 Control--X  F

	Perfect Writer responds with the message:

				"Right margin is 45"

	Again, nothing appears to have happened (except again, the
right vertical bars on the `Ruler' have moved to column 45.
However,  both paragraphs look  the same as before. To
adjust  both paragraphs use the ADJUST PARAGRAPH Command
(Escape. . .Q).  What do you get?  One  very long, thin column of
text.

	In this way you can indent whole sections of text to
whatever margins you desire. This is convenient for  such things
as with quotations, which are often indented for purposes of
display.  When you have finished entering the  text to be offset,
you can return the margins to their regular settings.

					  TAB SPACING

	Perfect Writer employs a system of 'fixed length' tab
spacing, wherein screen 'Tabs' are set  at regular intervals.  At
the beginning of any editing session this interval is 5
spaces--i.e. a tab occurs at columns 5, 10, 15, 20, 25, 30, etc. 
The Ruler which divides the screen displays the current tab
settings as square `boxes'.   Tab intervals can be changed to
whatever column setting you like, using:

	    SET TAB SPACING Command 	Control--X  <Tab Key>


	However, before issuing this command, it is necessary to
type the 'Esc' key followed by the number which will represent
the new tab interval.  For example, to set the interval for tab
spacings at every 10 columns, type:

					 Esc. . .10

	Perfect Writer responds:  'Argument: 10'

Follow this with:  

				  Control--X  <Tab Key>

	Try this command procedure on your sample text.  The square
boxes on the Ruler will change to reflect the new setting.  The
regular tab settings can be reset by performing the command
routine again.  Also, at the end of an editing session Perfect
Writer will automatically reset tabs to the default (5).

					CENTERING TEXT

	When doing 'Edit-time formatting' you will perhaps want
to center a word or line on the screen.  Perfect Writer provides
a command to do this:

		    CENTER LINE Command		Escape. . .S

	 Position the cursor anywhere on the line containing the
text you wish to center, and type the command. Perfect Writer
automatically centers the text on the screen. Try  this command 
on a short line.  (If you have not already done so, you may have
to reset wider margins for the command to function properly.)


			    PRINTING `TYPEWRITER STYLE'

	Using the above commands you should be able to format your
document however you wish.  The important thing to remember is
that the screen layout which you create using these commands will
only be presevered using the 'Typewriter Style' formatting
option on Perfect Writer's  formatting menu (or when using the
PRINT DOCUMENT Command while editing (Control--X  Control--P). 
(Review Lesson 1 for instructions on printing your document.)

	

	At this time you may wish to end the split screen by
switching the cursor to the bottom window:

			 Control--X  O  (the letter 'o') 

and  typing the CREATE ONE WINDOW Command:

					Control---X  1




				 THE PAGE-BREAK COMMAND

	When creating your own layout, you will want to know where
page breaks occur.   This will allow you to avoid awkward layouts
before they are printed (e.g. A `heading' at the very bottom of
the page).

	Perfect Writer provides a command that will automatically
insert `page-breaks' at a specified number of lines (default =
50) throughout your document.  Here's how to do it:

	-  Move the cursor to  the beginning of the document, using
the `Home' Key.

	-  Type the PAGE-BREAK Command:

				  Esc. . .@  (at-sign)

	-  Perfect Writer will respond:

			  "Number of lines per page <50>"

	-  You can specify a new number of lines, or accept the
default of 50 by typing a carriage return.  Perfect Writer will
automatically insert a `@newpage' command every <50> lines.

	You can then scroll through your document, identifying those
places where a page-break is inappropriate.  To change a page
break simply delete the `@newpage' command, and move it where
you wish it to be.

	NOTE:  An 8 x 11 sheet of paper is 66 lines long.  With top
and bottom margins of 6 lines each, you will normally get 54
lines of actual text per page (66 - 12 = 54), if you do not use
the PAGE-BREAK Command to insert page-breaks.  The default of 50
which the PAGE-BREAK Command produces will leave you 4 lines in
which to correct improper page breaks.  If you attempt to move an
`@newpage' command up or down more than four lines, you will in
all likelihood create further improper page breaks later in the
document.

	To eliminate `@newpage' commands from your document, use
the SEARCH AND REPLACE Command:

					 Escape. . .R

	You would replace `@newpage[NL]' with  `nothing'.

	[NOTE:  `[NL]' indicates a `newline' character, which must
be appended to the search string using a carriage return.]


			   The DOCUMENT DESIGN COMMANDS

	Perfect Writer's 'Document Design Commands' commands mark a
major departure in the formatting capability offered  by other
word processors. By contrast, most first generation word
processors are simply fancy typewriters in disguise.  Although
they allow you to design and layout a document however you wish,
they require that YOU do the work--using just such procedures as
we have outlined above in 'Edit-time formatting'!  You must set
all the tab stops, margins, indentions, and line spacing,  and
you must do this each time you want to achieve a specific layout
for your text.

	While this may be convenient for short, relatively simple
documents, it is not always the best way to format documents
which have complicated layouts.  For example, suppose you are
typing the glossary to your book, which will contain about two
hundred entries, and  you want it to look like this:

    Apple		The red, yellow, or green edible fruit of
			a tree belonging to a family of fruit
			trees including the pear, quince, medlar,
			hawthorn, and shadbush.

    Apricot	The orange-colored fruit of a tree of the
			peach family,  resembling in flavor both 
			peach and plum.

    Avocado	The pulpy fruit of a tropical American 
			tree of the laurel family.  Normally green or
			purple in color.

    Banana	The fruit of a large-leaved perennial 
			tropical plant. . . .

    . . . . .etc.


	On an ordinary typewriter, as well as other word processors,
this would be a nightmare of setting and re-setting margins, of
tabbing  indentions, and of spacing. Of course, it could be done,
but what work!

	Perfect Writer provides a formatting command that will do
this automatically.  Called the 'Description' Environment
Command, it works like this:

@begin(Description)

Apple@/The red, yellow, or green edible fruit of a tree belonging
to a family of fruit trees including the pear, quince, medlar,
hawthorn, and shadbush.

Apricot@/The orange-colored fruit of a tree. . . .

Avocado@/The pulpy fruit of a tropical American tree. . . .

Banana@/The fruit of a large-leaved perennial tropical plant. . . .

 . . . . .etc.
@end(Description)

	This simple format command produces the same layout shown
previously, without your having  to worry about line spacing,
indentions, tab settings, or margins.  Simply separate each item
from its definition by an '@/', and the items from each other by
a blankline.  Perfect Writer knows what you want done by the
'@begin(Description). . .@end(Description)' format command.

	Besides the 'description' format, Perfect Writer provides a
variety of other  commands that allow you to layout your document
any way you wish. The commands fall into several categories:
Some, like the 'Description' command, determine the arrangement
of text on the page (numbered or itemize lists, quotations,
examples, centered text, etc.).  Others  determine  'typeface'
(i.e. italics, boldface, underlining). There are commands which
section and number your document, which determine certain 'style'
parameters such as line spacing and indentions, which govern
superscripting and subscripting, and more.

	The best way to begin learning the Document Design Commands
is to begin using them a few at a time, even while you are
continue to format and print `typewriter style'.  In typewriter
style all of Perfect Writer's commands are respected EXCEPT those
which produce special typefaces:  boldface, italics, underlining,
etc.

	Since space does not allow, we will not attempt in this
lesson to cover every format command which Perfect Writer
provides.  Rather, we will give an overview of how the commands 
are used, followed by one or two examples.  Following this
discussion you will want  to consult the Perfect Writer User's
Guide for further examples and illustrations.


			    PLACING A FORMAT COMMAND

	Format commands are placed in the text of your document at
the time it is created, prior to 'formatting'--i.e. before
selecting  'F--Format a Document' on Perfect Writer's Main Menu. 

	All format commands begin with an '@' sign, which is
placed immediately before the command name, or before the
abbreviation which represents the command.  This signals to
Perfect Writer that what follows is a formatting command.  

	Besides the '@' sign, two things must be indicated for
every format command:


	1. The command name of the format option to be used. (These
are sometimes abbreviated.)

	2. The  portion of text to be formatted, which is normally
 enclosed within 'fences'.  These can be any of the following:

	       (...) {...} [...] <...> "..." '...'


	EXAMPLE:

	You wish to boldface a number of words in a sentence. 
The Boldface  command form is:

		    @b<text to be boldfaced>

 where "@b" is the command abbreviation for "boldface". This
command would be placed as follows:

	This is a sample sentence. This is a sample sentence.
This is a sample sentence.  @b(This sentence is boldfaced!).
This is a sample sentence.This is a sample sentence.

	Notice that NO blank spaces are allowed between the
format command and the fence!

				'NESTING' FORMAT COMMANDS

	It is possible to 'nest' format commands, that is, to
place one within another.  For example, the following line, when
printed, will be  'centered' on the page.  Within it several
words will be  'boldfaced':


@center<This line will be centered and @b[partially boldfaced]>


	The '@center<     >' format command causes the line to be
centered, while the nested '@b[    ]' causes certain words to be
boldfaced.  Notice that two different fences were used with each
command:  brackets, [ ], for the boldface, and angle-brackets, <  >,
for the centering.  This was done to avoid confusing the
commands.  When nesting formatting commands it is extremely
important not to omit or confuse fences.  Missing fences, or
similar pairs of fences which are nested, will cause Perfect
Writer to format incorrectly.

			    The BEGIN/END Command Form

	We have already seen how Begin/End  command form works  (see
the 'Description' command above).  It is used when the text to be
formatted is long and contains other 'nested' format commands. 
The Begin/End command form can only be used with certain format
commands, namely 'Environment' Commands, like 'Description' which
govern the layout and positioning of text.


				   The 'ENVIRONMENTS'

	Perfect Writer provides sixteen different format
`environments', which can be applied to a document as a whole, or
to any portion of it.   'Environment' commands govern the
'layout' of text, how it is spaced and configured on the
page--e.g. whether it is indented, centered, placed 'flushleft'
or 'flushright', treated as a "quotation", an itemized/numbered
list, and much more. 

	Two  format 'environments' deserve particular mention.

	1)  The 'Text' Environment

	Perfect Writer makes use of one 'environment' for everything
that it does.  This is the 'Text' environment, which is the
'default' environment which Perfect Writer uses to format every
document that you create. 'Text' specifies that all text on the
screen which is separated by at least one blank line shall be
grouped into paragraphs, indented, the left and right margins
justified, with the lines properly 'wrapped' and 'filled'.

	On the screen your text may appear ragged, the lines uneven,
the paragraphs not indented, the margins not justified.  However,
when printing  Perfect Writer (unless instructed otherwise) will
'clean-up' these irregularities (following the rules outlined by
'Text') producing a document in which the margins are straight
and justified, all lines 'wrapped' and 'filled' and each
paragraph properly indented.

	 Any of the other 'environments' can be used to
'override' the 'Text' environment.  For example, the '@Center'
command can be used at any point to 'center' a word, line or
lines.  The '@Quotation' Environment can be used within a 'Text'
environment to display  a quotation as it should be displayed.

	2)  The 'Verbatim' Environment

	Both the `Typewriter style' option on the Formating Menu and
the PRINT DOCUMENT Command (Control--X  Control--P)  invoke the
`Verbatim' environment for the document as a whole.  When
printing your practice letter of Lesson 1, Perfect Writer invoked
the `Verbatim' environment command which 'overrode' the default
'Text' environment, causing your document to be printed exactly
as it appeared on the screen--i.e. 'verbatim'.  `Verbatim' is the
environment which MUST be used with 'Edit-time formatting'.  

	However, `Verbatim' can also be invoked anywhere in a
document for any region of text.  For example, if this lesson
were formatted and printed in hardcopy, every paragraph would be
grouped and justified and indented, with all lines properly
wrapped and filled, EXCEPT the following three lines, which would
be printed exactly as they appear here:

@verbatim<

	This sentence will be 
printed
		just as it appears on the screen.>



				 GREATER EDITING FREEDOM

	As you may have observed, when using Perfect Writer's
Document Design Commands, 'What you see on the screen, is not
necessarily what you get! 

	Although at first you may  find this a strange and perhaps
awkward way of doing things, you will soon realize that its
ultimate effect is to 'free' you from the burden of constantly
having to adjust margins, tabs, line spacing, indentions, etc. 
Of course, it may take a little getting used to, since it is
always initially difficult  to surrender up familiar tasks we are
used to doing ourselves.  

	However, we GUARANTEE (!) that once you turn over to
Perfect Writer the drudgery of formatting a document, you will
never again attempt to do it yourself!

	We are nearly at the end of our lesson.  Let us see 
some of Perfect Writer's document design commands in action. 
Following is a short letter containing several formatting
commands.  Examine the document closely, determining if you can,
what each command will do.  Following the letter  we will
outline the steps for transferring this letter to its own file
and  for printing it to hardcopy, so that you can see if your
guesses are correct.





@style(spacing 2 lines)

@address(4 July 1983
1776 Any Street
Anytown, Anystate 12345)


@flushleft(My Dear Friend, )

Hello!	You'll @b(never) guess what I'm doing! I am testing a new
word processor today, called @i[Perfect Writer]. It's really an
amazing thing.  Would you like me to tell you about it?  So far
it works just like a  typewriter, except that the characters are
displayed to a video screen instead of being printed on paper. 
Once the words are on the screen you can move them around however
you like.  

The commands are easier to learn than I thought they
would be, and you don't have to know them all to begin using
Perfect Writer right away. So far I have learned how to:

@begin(itemize)
Split the screen and display two documents simultaneously

Delete and insert text

Copy and move text

Search the document for words, changing them if I wish

Manipulate up to seven documents simultaneously

Format a document

Print a document
@end(itemize)

	That sounds like a lot, I know, and I have to admit I
can't remember right now how to do some of them.  Still, I've
seen them work and none of it's very difficult.  I guess it's just
a matter of using the commands over and over till I remember them.  

	The manual is easy to understand, too, with lots of
pictures that makes reading it easy.  There's also a reference
card which you can keep by the computer that  summarizes
everything that perfect Writer can do.

	Without a doubt Perfect Writer is going to make my life a
@un(lot) easier!

@closing(Sincerely,)

@blankspace(2 lines)

@flushleft[P.S.  You write as much as I do. @b(You) should think about
getting @i(Perfect Writer), too.  It's available from:]

@Display{Perfect Software, Inc.
1400 Shattuck Ave.
Berkeley, CA  9409}

					(end of letter)

				 -----------------------
	
	Do you remember steps for transferring this document to its
own file, prior  to printing?  Here they are again:

	1) Split the screen into two windows  (Control--X  2)

	2) Into the top window   call a new empty file using the
FIND DOCUMENT Command (Control--X  Control--F).  Call the file
something like 'b:printhis'.

	3) Switch to the bottom window (Control--X o )

	4) In the bottom window, mark the upper boundary of the
letter using the Mark Set command (Escape. . .<space bar>). Move
the cursor to the end of the letter and copy it into the Save
Buffer using the  COPY REGION Command  (Escape...W).

	5) Switch to the top window (Control--X  o) and restore
the  letter to the new file using the 'Yankback' Command 
(Control---Y).

	6)  Save the new document using Control--X 
Control--S.

	7)  Return to the bottom window and end the split
split-screen  (Control--X  1).




				 PRINTING A '.FIN' DOCUMENT


	When printing this letter, you will not want to use the
 PRINT DOCUMENT Command described in Lesson 1  (Control--X 
Control--P).  The  print option does not allow for certain
features which your printer may be capable of--such as
boldfacing, italicizing, and underlining.  

	To perform these functions, Perfect Writer  must convert the
code of your '.mss' document into a form that your printer will
understand.  It inserts special codes that tell your printer when
to  boldface, italicize, or underline a word, how far to indent a
paragraph, etc.

	The result of this process is an intermediate file called
a '.FIN' file which contains this translated code.  For example,
in formatting the document 'b:printhis.mss', Perfect Writer will
produce a second file called 'b:printhis.fin'.  It is this file
that will ultimately be sent to the printer.  A 'FIN' file is
only accessable by Perfect Writer.  You cannot call it to the
screen for editing  in the same way you would display a  file
bearing the file  extension '.MSS'.

	We explain this so that you will understand what selections
to make on Perfect Writer's menus in order to format and print
the document 'printhis.mss'.

	As you recall Perfect Writer's Main Menu looks like this:
	
-----------------------------------------------------------------
Perfect Writer	Version 1.00		Main Selection Menu
(C) 1982, 1983 Perfect Software, Inc.
	Selections:
	C reate a document
	F ormat a document
	P rint a document
	R evise a document
	S pelling check

	D irectory of a disk
	E rase a document

	Q uit to DOS

Type one character to indicate your selection now:

-----------------------------------------------------------------

	The selection you must choose from this first menu is
`F ormat a document'.

	Perfect Writer will ask for the document you wish to print
(prompting with the name of the document you were just editing).
If you wish to format the document you have just finished
editing, type a carriage return.

	Perfect Writer will then present the `formatting menu'
which looks like this:


-----------------------------------------------------------------
(Perfect Writer)			Perfect Formatter Selection Menu
(C) 1982, 1983 Perfect Software, Inc.
	Available options for the formatter are:
		
	C onsole display only
	D irect print from formatter
	T yperwriter style--no page numbering
	P ause for each page to be manually inserted
	S elect a different printer

	G o
	Q uit this menu


pf <printhis.mss>
Your choice:

-----------------------------------------------------------------


	 You should select only one option from this menu:  `G o'.

	Perfect Writer will begin formatting the document,
displaying  the number of each page as it is  formatted.  When it
has finished formatting the file (i.e. when the intermediate
'FIN' file has been created), Perfect Writer returns you to the
Main Menu.

	At the Main Menu select option 'P rint a document'.

	Perfect Writer	will ask:

	"Name of document you wish to print [printhis.fin]:"

	Notice that Perfect Writer is prompting with the name of the
document you have just formatted.  Type a carriage return to
indicate this document is the one you wish to print.

	Perfect Writer will present the following `print menu':

---------------------------------------------------------------------
(Perfect Writer)  Perfect Printer Selection Menu
(C) 1982, 1983  Perfect Software, Inc.

	Available options for Perfect Printer are:
	  B egin printing at a page other than one
	  M ultiple copies
	  P ause for each page to be manually inserted
	 
	  G o
	  Q uit this menu

pp printhis.fin
Your choice:

-----------------------------------------------------------------

	Select option `G o'. After a few moments, Perfect Writer
will ask:

"Printing file 'b:printhis.fin' on device <name of your printer>. Okay?"

	Answer 'Yes', and the printing will begin.

					  CONCLUSION

	This concludes our final lesson introducing Perfect
Writer.  We hope that these lessons have been of significant
value to you.  Of course, they are only a first step.  As you
acquire confidence and proficiency in using Perfect Writer you
will want to study the explanations and examples in the
Perfect Writer User's Guide.

	As a review  of what has been presented in these lessons
you may wish to read through the file 'advintro' which is
held on the same diskette as these lessons.

	At this time type the QUIT Command to exit to the Main
Menu, where you should attempt to print the document
'b:printhis':

		Control--X  Control---C

	[ IMPORTANT:  Perfect Writer may respond with the message:
"Ignore Changes this session?".  Answer:  'Yes'  !! ]


					End of Lesson 7