
					   Lesson 6

				 USING MULTIPLE BUFFERS
						  &
				    DOCUMENT COMMANDS


	Already you know a good deal about what we're going to talk
about in this lesson, although you may not realize it! It is one
of  Perfect Writer's most valuable and useful features:  its
system of multiple buffers.


	What is a 'buffer' and what does it do?


	A 'buffer' is somewhat like a mailbox in computer memory
that temporarily holds your documents while you are working on
them.  Changes made to the copy held in the buffer do not affect
the original document on disk until you `save' it (using
Control--X  Control--S).


	Perfect Writer provides seven separate buffers for you to
use while editing.  This means that you can have up to seven
separate documents in computer memory at one time.  It is Perfect
Writer's multiple buffers that allow you to display two separate
documents to the screen simultaneously.


	  If you suspect that you have been using multiple buffers
all along in these lessons, you are right!  Every time you split
the screen and call a different 'practice' document into the top
window you are activating a new buffer in computer memory.  Each
window is simply displaying the contents of a separate buffer.


	Let us practice manipulating buffers.  Let us split the
screen, and in the top window create a number of separate
documents which will be stored  in a separate buffers. Following
this  we will practice the various commands that are used to
manipulate buffers. 


	Move the cursor to the center of the screen and give the
CREATE TWO WINDOWS Command:

					Control---X  2


	With the cursor in the top window, call up the practice
letter you have been working with, using the  FIND FILE Command,
followed by the file name:  `b:practice'.

				Control---X  Control---F

	Let us suppose that you are going to send this letter not
only to one friend but to a half a dozen (or more).  You will
want to say the same thing to each friend (with slight
variations).

	One way to do this is to copy this letter into several other
buffers in memory.  Once in separate buffers the letter can be
individualized for each recipient.

	How to do this?  Here are the steps:

	1)  Copy the letter into the Save Buffer, using the COPY
REGION procedure  (i.e.  Set Mark, move the cursor, and type
`Control--W').

	2)  With the letter copied into the Save Buffer, give the
FIND DOCUMENT Command:  Control--X  Control--F.

	3)  Perfect Writer will ask "File to find".  Type the name
of the person the letter will be addressed to--e.g. `Belinda'.

	4)  Perfect Writer assuming that this must be a `new file' will
open a new buffer in memory under the name you have given.

	5) Recall the practice letter into this new buffer using the
YANKBACK Command:  Control--Y.

	NOTE:  The practice letter is still in the Save Buffer and
will remain there until the next deletion larger than a single
character is made.  Therefore, you can continue giving the FIND
DOCUMENT Command to copy the letter into several successive new
buffers, naming each new document differently:  `Marcy',
`Joe', `Fred', etc.
	
	Repeat until Perfect Writer displays the message:

				   "Too many buffers"

	This means that all of Perfect Writer's buffers are now in
use, and you cannot create any more documents in memory.  (You
will only be able to create  6 new files, since  the file holding
this lesson  occupies one of the seven possible buffers.)

	How do you remember all of the letters you have created? 
Perfect Writer provides a 'Buffers Directory' which lists all of
the active buffers together with the documents they contain.  The
directory will appear in the top left corner of the screen,
overwriting whatever text is being displayed.  

	Any command which causes the screen to scroll and redisplay
will erase this directory.  Therefore, as we proceed with this
discussion you may have to redisplay the directory.  

	At this time type the BUFFERS DIRECTORY Command:

				 Control--X  Control--B

	On the LEFT of the directory are  the 'Buffer Names'. 
Notice that a buffer takes its name from the first portion of the
file name, which are listed on the RIGHT of the directory.  For
example,  the buffer 'belinda'  holds the file called
'B:BELINDA.MSS'.

	The presence of a 'star', or asterisk, indicates that the
document held in the buffer has been modified, but not yet saved
to disk.  (Only the buffer 'lesson6' should be without a star.)

	The number indicates the length of the file in 'characters'.

	You should proceed to `customize' some of these letters,
changing the salutation and text to match the appropriate friend.
Any revisions you make will be restricted to the particular
buffer.  Thus, changes made to one letter will affect only that
letter.

	To get from one buffer to another use the SWITCH BUFFERS
Command   (Notice the similarity to the BUFFERS DIRECTORY
Command):

	BUFFERS DIRECTORY 		Control---X  Control---B
	SWITCH BUFFERS 		Control---X  B

	When the SWITCH BUFFERS Command is typed, Perfect Writer
will ask:

			    "Switch to Buffer <cr>:  "

	 Type the name of the 'buffer' you wish to switch to,
followed by a carriage return. (Perfect Writer will NOT accept a
'filename', which has a prefix 'b:' and the extension '.mss').

	With the cursor in the top window practice switching between 
buffers, using the SWITCH BUFFERS Command.   Each time, prior to
giving this command, you may wish to view the Buffers Directory
in order to remind yourself of the names of the buffers. 
Therefore, type the BUFFERS DIRECTORY Command:

				 Control--X  Control--B

followed by the SWITCH BUFFERS Command:

					 Control--X  B

	 If you switch back and forth between two buffers
exclusively, you need not type the buffer name each time.  When
the message

			    "Switch to buffer <cr>:   "

appears, type a carriage return. Perfect Writer will switch you
back to the buffer LAST SWITCHED FROM.

	Buffers are really not very difficult.  Although one of the
more `powerful' features of Perfect Writer, they are simple and
easy to use.



					DOCUMENT COMMANDS

	You are already familiar with several of the 'Document
Commands' which Perfect Writer uses to read documents into and
out of memory buffers.  Let us review them to discover the
significant differences between them.  The first are two  which
save documents to disk.  These are:

	SAVE DOCUMENT Command		Control--X  Control--S
	WRITE DOCUMENT Command		Control--X  Control--W

	You used the SAVE DOCUMENT  Command in an earlier lesson to
save your practice letter after revising.  As you recall, the
command simply copied the document  to the diskette, overwriting
the earlier version.

	The WRITE DOCUMENT Command offers a convenient variation to this. 
It also copies a current document to disk, but in the process 
allows you to change the filename.  

	  For example, suppose you have just revised a document, and
want to keep both versions, the old (still on disk) and the new
(in memory). If you save the new version using the SAVE DOCUMENT
Command (Control--X  Control--S), the old version will be
overwritten and lost.  To avoid this, you can use the WRITE
DOCUMENT Command:

				 Control--X  Control--W

which will prompt you for the new file name:

				 "File to write <cr>:  "

	 Type the new file name, followed by a carriage return. 
Perfect Writer writes the document to disk under the new name, at the
same time changing the name of the copy remaining in memory. If
you modify it thereafter, and save this modification to disk, it
will overwrite the new document that you have just created.


	Let us practice the WRITE DOCUMENT Command.  With the cursor
in the top window occupying one of the sample buffers created
previously, type the command:

				 Control--X  Control--W

followed by a new filename and a carriage return. 

	 Notice in the Mode Line that although the filename changed
following this operation, the buffer name did not!  What does
this mean?  Well, it means that a buffer name, once established
during an editing session, a buffer name does not change even
though the documents which the buffer holds, change.  

	The two commands  used to bring documents into memory buffers
are:

	FIND DOCUMENT Command		Control--X  Control--F
	READ DOCUMENT Command		Control--X  Control--R

	You are already familiar with both of these commands.  The
FIND DOCUMENT Command causes Perfect Writer to search the
diskette for a named document, and to read this document into an
empty buffer in memory.  If it cannot find the document, it
assumes that it is new and so creates a 'New File' in an empty
buffer, under the name you have given. If the document is already
in a buffer, it will switch you to that buffer.

	The READ DOCUMENT Command works slightly differently.  This
command reads a document from disk into the current buffer,
OVERWRITING whatever document is there.  We have used this
command several times in calling up these lessons.

	If the current buffer holds a document which you have modified
but not yet saved to disk, Perfect Writer will respond to the
READ DOCUMENT Command with the message:

		   "Discard modifications you have made?"

	If you answer 'Yes', Perfect Writer then asks:

				 "File to read <cr>:  "

	 Type the filename, followed by a carriage return.  Perfect
Writer reads the document you request into the buffer which the
cursor is currently occupying, OVERWRITING whatever modified
document may be there.

	If you answer 'No', Perfect Writer cancels the command,
and returns  to the document (in effect, giving you the chance
to save the  document before overwriting it).

	Let us practice this command by reading into a 'current'
buffer the exercise document `That Wonderful Writing Machine'.
With the cursor in the top window, in any one of the practice
buffers you have created, type the READ DOCUMENT Command
(discarding any modifications you have made):

				 Control--X  Control--R

	Enter the file name 'b:wonder', followed by a carriage
return.  

	Notice that in the Mode Line the filename changed but the
buffer name did not!  This will also be reflected in the Buffers
Directory  (Control--X  Control--B).

	As you can see, the READ DOCUMENT Command offers the advantage
of not having to first delete a buffer, should all available
buffers be in use, or should you not wish to keep the document you
have been editing.  As well, the READ DOCUMENT Command is useful for
'starting over' in a document you have been revising.


	This concludes our lesson on 'Using Multiple Buffers' and
`Document Commands.'  At this time switch the cursor to the bottom
window using the OTHER WINDOW Command:

		Control---X  o  (the letter 'o')

	End the split-screen using the ONE WINDOW Command:

					Control---X   1

	The window holding these instruction will become the only
window on the screen.


					   SUMMARY

	In this lesson we have reviewed several valuable commands
for manipulating buffers and for 'reading' and 'writing' documents
into and out-of buffers.  The commands are:

	BUFFERS DIRECTORY			Control--X  Control--B
	SWITCH BUFFERS 			Control--X  B

	SAVE DOCUMENT 				Control--X  Control--S
	WRITE DOCUMENT 				Control--X  Control--W

	FIND DOCUMENT					Control--X  Control--F
	READ DOCUMENT 				Control--X  Control--R

	
	If you wish at this time to continue on to Lesson 7, which
discusses `Formatting', type the  READ DOCUMENT Command:

				Control---X  Control---R

	[ IMPORTANT:   Perfect Writer may respond with the
message: "Discard modifications you have made?"  Answer: 'Yes' ! ]

	 Perfect Writer will then display the message "File to read:
<cr>".  Type the file name  "b:lesson7", followed by a carriage
return.  Perfect Writer retrieve Lesson 7 from disk and displays
it to the screen, ready for you to continue.

	If you do not wish to continue with the lessons, type the
QUIT Command:

				 Control--X  Control---C

	[ IMPORTANT:  Perfect Writer may respond with the message:
"Ignore Changes This Session?".  Answer: `y' for 'Yes'  !! ]

	Perfect Writer returns you to its Main Menu, from which
you may exit to your operating system.

					END OF LESSON 6