Imports System
Imports System.IO

Module Module1

    Dim LEADERBYTE As Byte = &HAA
    Dim SYNCBYTE As Byte = &H66
    Dim THRESHOLD As Integer = &H1
    Dim CGCLOCK As Long = 2216750
    Dim BAUDRATE As Long = 1280
    Dim currentLevel As Integer
    Dim samplesPerBit As Double
    Dim headerFound As Boolean

    Function readData(ByRef wav As FileStream, ByVal size As Long) As Integer

        Dim bytes As Byte()
        ReDim bytes(size)
        Dim retval As Integer

        If wav.Read(bytes, 0, size) <> size Then
            'Throw New Exception
            'MsgBox("Error", MsgBoxStyle.Critical, "Error")
        End If

        Select Case size
            Case 1
                'retval = (bytes(0)) - 128
                If bytes(0) > &H80 Then
                    Return bytes(0) - 127
                Else
                    Return bytes(0) - 128
                End If
            Case 2
                retval = ((bytes(1) * 256) Or bytes(0))
                If retval >= &H8000 Then
                    Return retval - 65536
                Else
                    Return retval
                End If
        End Select

    End Function

    Function doHist(ByVal signal As Integer) As Integer
        If signal > 0 + THRESHOLD Then
            doHist = 1
        ElseIf signal < 0 - THRESHOLD Then
            doHist = 0
        End If
    End Function

    Function getTapeBit(ByRef wav As FileStream, ByVal size As Long, _
               ByRef totalClks As Double) As Integer

        Dim c As Double
        Dim newLevel As Integer
        Dim transitions As Integer

        transitions = 0

        ' Wait until first edge transition
        Do
            Dim level As Integer = readData(wav, size)
            newLevel = doHist(level)
        Loop Until wav.Position >= wav.Length _
                    Or (newLevel <> currentLevel)

        currentLevel = newLevel
        c = 0
        ' Count the number of level changes within the 1/baudrate interval
        Do
            Dim level As Integer = readData(wav, size)
            newLevel = doHist(level)
            If newLevel <> currentLevel Then
                transitions += 1
                currentLevel = newLevel
            End If
            c = c + 1
        Loop Until wav.Position >= wav.Length _
                    Or (c >= samplesPerBit)

        'totalClks = c - samplesPerBit
        Return ((transitions - 1) And 1) Xor 1

    End Function

    Function process(ByVal wavFileName As String, ByRef cas As FileStream)

        Dim i As Integer
        Dim wav As WaveFile = New WaveFile
        Dim wavStream As FileStream

        wav.OpenFile(wavFileName)

        Dim samplesPerCycle As Double = wav.SamplingFrequency / CGCLOCK
        Dim cyclesPerSample As Double = CGCLOCK / wav.SamplingFrequency
        Dim bitsPerSec As Double = 1 / BAUDRATE
        Dim bitsPerCycle As Double = BAUDRATE / CGCLOCK
        samplesPerBit = wav.SamplingFrequency * bitsPerSec

        Dim wavDataOffset As Long = wav.BufferStartPosition
        Dim wavDataLength As Long = wav.ReadbufferSize
        Dim wavBitRate As Long = wav.BitsPerSample
        Dim bytesPerSample As Long = wav.BitsPerSample / 8

        wav.CloseFile()

        Dim sampleCount As Long = 0
        Dim byteCount As Long = 0
        Dim bitCount As Integer
        Dim currentByte As Byte
        Dim sumCycles As Double

        wavStream = New FileStream(wavFileName, FileMode.Open)
        wavStream.Seek(48, SeekOrigin.Begin) ' wavDataOffset

        currentLevel = doHist(readData(wavStream, bytesPerSample))

        ' Write leader bytes as these are not read from the WAV
        For i = 1 To 255
            cas.WriteByte(LEADERBYTE)
        Next i

        Console.WriteLine("Looking for sync byte... Press Ctrl+C to abort.")
        headerFound = False
        Do
            currentByte = 0
            bitCount = 0
            Do
                Dim b As Integer = getTapeBit(wavStream, bytesPerSample, sumCycles)
                If Not headerFound Then
                    currentByte = (currentByte << 1) Or b
                    ' Look for sync byte
                    If (currentByte And &HFF) = SYNCBYTE Then
                        Console.WriteLine("Sync byte found.")
                        headerFound = True
                        bitCount = 8
                    End If
                Else
                    currentByte = (currentByte << 1) Or b
                    bitCount = bitCount + 1
                End If

            Loop Until (bitCount = 8)
            cas.WriteByte(currentByte)
        Loop Until wavStream.Length = wavStream.Position

        wavStream.Close()
        cas.Close()

        Return 0
    End Function

    Sub Main()

        Dim args As String() = Environment.GetCommandLineArgs()

        If args.Length >= 3 Then
            Dim inpFileName As String = args(1)
            Dim outFileName As String = args(2)
            Dim wf As WaveFile = New WaveFile
            Dim cas As FileStream = New FileStream(outFileName, FileMode.Create)

            'Console.WriteLine("Input" & inpFileName & ", output : " & outFileName)
            Console.WriteLine("Working...")
            process(inpFileName, cas)
            Console.WriteLine("Done.")
        Else
            ' [threshold] [baudrate]
            Console.WriteLine("Usage: wav2cgc <input WAV file> <output CAS name>")
        End If
    End Sub

End Module
