Option Strict
Option Explicit

'
'   WaveFile class
'     written in VB.NET                          Version: 1.0
'     by The KPD-Team                            Date: 2002/01/16
'     Copyright  2002                           Comments to: KPDTeam@allapi.net
'                                                URL: http://www.allapi.net/
'
'
'  You are free to use this class file in your own applications,
'  but you are expressly forbidden from selling or otherwise
'  distributing this code as source without prior written consent.
'  This includes both posting samples on a web site or otherwise
'  reproducing it in text or html format.
'
'  Although much care has gone into the programming of this class
'  file, The KPD-Team does not accept any responsibility for damage
'  caused by possible errors in this class and/or by misuse of this
'  class.
'
'  Many thanks to Mark Hurd for removing a serious bug from this
'  class file.
'

Imports System.Runtime.InteropServices
Imports System.Text
Imports System.IO
Imports Microsoft.VisualBasic
Imports System

'/// <summary>This is an abstract representation of a WAVE file.</summary>
Friend Class WaveFile
    '<API-DECLARES>
    Private Const CALLBACK_WINDOW As Integer = &H10000
    Private Const CALLBACK_FUNCTION As Integer = &H30000
    Private Const MMIO_READ As Integer = &H0
    Private Const MMIO_FINDCHUNK As Integer = &H10
    Private Const MMIO_FINDRIFF As Integer = &H20
    Private Const MM_WOM_DONE As Integer = &H3BD
    Private Const MMSYSERR_NOERROR As Integer = 0
    Private Const SEEK_CUR As Integer = 1
    Private Const SEEK_END As Integer = 2
    Private Const SEEK_SET As Integer = 0
    Private Const TIME_BYTES As Integer = &H4
    Private Const WHDR_DONE As Integer = &H1
    Private Const NUM_BUFFERS As Integer = 5
    Private Const BUFFER_SECONDS As Single = 0.1

    <StructLayout(LayoutKind.Sequential)> _
Private Structure MMIOINFO
        Public dwFlags As Integer
        Public fccIOProc As Integer
        Public pIOProc As Integer
        Public wErrorRet As Integer
        Public htask As Integer
        Public cchBuffer As Integer
        Public pchBuffer As String
        Public pchNext As String
        Public pchEndRead As String
        Public pchEndWrite As String
        Public lBufOffset As Integer
        Public lDiskOffset As Integer
        Public adwInfo1 As Integer
        Public adwInfo2 As Integer
        Public adwInfo3 As Integer
        Public adwInfo4 As Integer
        Public dwReserved1 As Integer
        Public dwReserved2 As Integer
        Public hmmio As Integer
    End Structure
    <StructLayout(LayoutKind.Sequential)> _
Private Structure WAVEHDR
        Public lpData As Integer
        Public dwBufferLength As Integer
        Public dwBytesRecorded As Integer
        Public dwUser As Integer
        Public dwFlags As Integer
        Public dwLoops As Integer
        Public lpNext As Integer
        Public Reserved As Integer
    End Structure
    <StructLayout(LayoutKind.Sequential)> _
Private Structure WAVEINCAPS
        Public wMid As Short
        Public wPid As Short
        Public vDriverVersion As Integer
        Public szPname As String
        Public dwFormats As Integer
        Public wChannels As Short
    End Structure
    <StructLayout(LayoutKind.Sequential)> _
Private Structure WAVEFORMAT
        Public wFormatTag As Short
        Public nChannels As Short
        Public nSamplesPerSec As Integer
        Public nAvgBytesPerSec As Integer
        Public nBlockAlign As Short
        Public wBitsPerSample As Short
        Public cbSize As Short
    End Structure
    <StructLayout(LayoutKind.Sequential)> _
Private Structure MMCKINFO
        Public ckid As Integer
        Public ckSize As Integer
        Public fccType As Integer
        Public dwDataOffset As Integer
        Public dwFlags As Integer
    End Structure
    <StructLayout(LayoutKind.Sequential)> _
Private Structure MMTIME
        Public wType As Integer
        Public u As Integer
        Public x As Integer
    End Structure
    Private Declare Function waveOutGetPosition Lib "winmm.dll" (ByVal hWaveOut As IntPtr, ByRef lpInfo As MMTIME, ByVal uSize As Integer) As Integer
    Private Declare Ansi Function waveOutOpen Lib "winmm.dll" (ByRef hWaveOut As IntPtr, ByVal uDeviceID As Integer, ByVal format() As Byte, ByVal dwCallback As WaveDelegate, ByRef fPlaying As Integer, ByVal dwFlags As Integer) As Integer
    Private Declare Function waveOutPrepareHeader Lib "winmm.dll" (ByVal hWaveIn As IntPtr, ByRef lpWaveInHdr As WAVEHDR, ByVal uSize As Integer) As Integer
    Private Declare Function waveOutPrepareHeaderPtr Lib "winmm.dll" (ByVal hWaveIn As IntPtr, ByVal lpWaveInHdr As Integer, ByVal uSize As Integer) As Integer
    Private Declare Function waveOutReset Lib "winmm.dll" (ByVal hWaveIn As IntPtr) As Integer
    Private Declare Function waveOutUnprepareHeader Lib "winmm.dll" (ByVal hWaveIn As IntPtr, ByRef lpWaveInHdr As WAVEHDR, ByVal uSize As Integer) As Integer
    Private Declare Function waveOutClose Lib "winmm.dll" (ByVal hWaveIn As IntPtr) As Integer
    Private Declare Function waveOutWrite Lib "winmm.dll" (ByVal hWaveOut As IntPtr, ByRef lpWaveOutHdr As WAVEHDR, ByVal uSize As Integer) As Integer
    Private Declare Function waveOutPause Lib "winmm.dll" (ByVal hWaveOut As IntPtr) As Integer
    Private Declare Function waveOutRestart Lib "winmm.dll" (ByVal hWaveOut As IntPtr) As Integer
    Private Declare Function waveOutSetVolume Lib "winmm.dll" (ByVal uDeviceID As IntPtr, ByVal dwVolume As UInt32) As Integer
    Private Declare Function waveOutGetVolume Lib "winmm.dll" (ByVal uDeviceID As IntPtr, ByRef lpdwVolume As Integer) As Integer
    Private Declare Function mmioClose Lib "winmm.dll" (ByVal hmmio As IntPtr, ByVal uFlags As Integer) As Integer
    Private Declare Function mmioDescend Lib "winmm.dll" (ByVal hmmio As IntPtr, ByRef lpck As MMCKINFO, ByRef lpckParent As MMCKINFO, ByVal uFlags As Integer) As Integer
    Private Declare Function mmioDescendParent Lib "winmm.dll" Alias "mmioDescend" (ByVal hmmio As IntPtr, ByRef lpck As MMCKINFO, ByVal x As Integer, ByVal uFlags As Integer) As Integer
    Private Declare Ansi Function mmioOpen Lib "winmm.dll" Alias "mmioOpenA" (ByVal szFileName As String, ByRef lpmmioinfo As MMIOINFO, ByVal dwOpenFlags As Integer) As IntPtr
    Private Declare Function mmioRead Lib "winmm.dll" (ByVal hmmio As IntPtr, ByVal pch As Integer, ByVal cch As Integer) As Integer
    Private Declare Function mmioReadString Lib "winmm.dll" Alias "mmioRead" (ByVal hmmio As IntPtr, ByVal pch() As Byte, ByVal cch As Integer) As Integer
    Private Declare Function mmioSeek Lib "winmm.dll" (ByVal hmmio As IntPtr, ByVal lOffset As Integer, ByVal iOrigin As Integer) As Integer
    Private Declare Ansi Function mmioStringToFOURCC Lib "winmm.dll" Alias "mmioStringToFOURCCA" (ByVal sz As String, ByVal uFlags As Integer) As Integer
    Private Declare Function mmioAscend Lib "winmm.dll" (ByVal hmmio As IntPtr, ByRef lpck As MMCKINFO, ByVal uFlags As Integer) As Integer
    Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Integer, ByVal dwBytes As Integer) As IntPtr
    Private Declare Function GlobalLock Lib "kernel32" (ByVal hmem As IntPtr) As IntPtr
    Private Declare Function GlobalFree Lib "kernel32" (ByVal hmem As IntPtr) As Integer
    Private Declare Function GlobalUnlock Lib "kernel32" (ByVal hmem As IntPtr) As Integer
    Private Declare Sub CopyWaveFormatFromBytes Lib "kernel32" Alias "RtlMoveMemory" (ByRef dest As WAVEFORMAT, ByVal source() As Byte, ByVal cb As Integer)
    Private Declare Sub CopyWaveHeaderFromPointer Lib "kernel32" Alias "RtlMoveMemory" (ByRef dest As WAVEHDR, ByVal source As Integer, ByVal cb As Integer)
    Private Declare Function IsBadWritePtr Lib "kernel32" (ByVal lp As Integer, ByVal ucb As Integer) As Integer
    '</API-DECLARES>
    Private Delegate Sub WaveDelegate(ByVal hwo As IntPtr, ByVal uMsg As Integer, ByVal dwInstance As Integer, ByRef wavhdr As WAVEHDR, ByVal dwParam2 As Integer)

    '---------------------------------------------------------------------------------------------
    'Added 05/03/05
    '---------------------------------------------------------------------------------------------

    Private m_lBufferSize As Integer
    Private m_FileOpen As Boolean
    Private m_lPtrBuffer As IntPtr = IntPtr.Zero
    Private m_lCurrentReadSize As Integer
    Private m_hMemBuffer As IntPtr = IntPtr.Zero
    Private m_hPtrBuffer As IntPtr = IntPtr.Zero


    Public Sub New()
        MyBase.New()
        Initialize()
    End Sub

    Private Sub Initialize()
        m_lBufferSize = 131072
        m_FileOpen = False
    End Sub

    Public Sub SeekRelative(ByVal lSampleOffset As Integer)
        Dim lSample As Integer
        lSample = mmioSeek(m_MmioIn, SEEK_CUR, 0) - m_DataOffset
        If (lSample + lSampleOffset * 4) > m_AudioLength Then
            Throw New MediaException("Position out of range")
        ElseIf (lSample - lSampleOffset * 4) < 0 Then
            Throw New MediaException("Position out of range")
        Else
            mmioSeek(m_MmioIn, lSampleOffset * 4, SEEK_CUR)
        End If
    End Sub

    Public Sub SeekAbsolute(ByVal lSample As Integer)
        If ((lSample * 4) > m_AudioLength) Or (lSample < 0) Then
            Throw New MediaException("Position out of range")
        Else
            mmioSeek(m_MmioIn, (lSample * 4) + m_DataOffset, SEEK_SET)
        End If
    End Sub

    Public Function Read() As Boolean
        Dim dataRemaining As Integer
        Dim lR As Integer

        If (m_MmioIn.Equals(IntPtr.Zero)) Then
            Throw New MediaException("No Wave File Open")
            Exit Function
        End If

        dataRemaining = (m_DataOffset + m_AudioLength - mmioSeek(m_MmioIn, 0, SEEK_CUR))
        If (m_lBufferSize < dataRemaining) Then
            lR = mmioRead(m_MmioIn, m_hPtrBuffer.ToInt32, m_lBufferSize)
            m_lCurrentReadSize = m_lBufferSize
            Read = True
        ElseIf (dataRemaining > 0) Then
            lR = mmioRead(m_MmioIn, m_hPtrBuffer.ToInt32, dataRemaining)
            m_lCurrentReadSize = dataRemaining
            Read = False
        Else
            Read = False
        End If
    End Function

    Public Property Filename() As String
        Get
            Filename = m_Filename
        End Get
        Set(ByVal Value As String)
            If OpenFile(Value) Then
                m_Filename = Value
            End If
        End Set
    End Property

    Public ReadOnly Property FileOpen() As Boolean
        Get
            FileOpen = m_FileOpen
        End Get
    End Property

    Public ReadOnly Property BufferStartPosition() As Integer
        Get
            BufferStartPosition = mmioSeek(m_MmioIn, 0, SEEK_CUR) - m_DataOffset
        End Get
    End Property

    Public ReadOnly Property AudioLength() As Integer
        Get
            AudioLength = m_AudioLength \ 4
        End Get
    End Property

    Public ReadOnly Property ReadbufferSize() As Integer
        Get
            ReadbufferSize = m_lBufferSize \ 4
        End Get
    End Property

    Public ReadOnly Property ReadSize() As Integer
        Get
            ReadSize = m_lCurrentReadSize \ 4
        End Get
    End Property

    Public ReadOnly Property ReadBufferPtr() As IntPtr
        Get
            ReadBufferPtr = m_hPtrBuffer
        End Get
    End Property

    Private Function AllocateBuffer() As Boolean
        FreeBuffer()
        m_hMemBuffer = GlobalAlloc(0, m_lBufferSize * 4)
        If Not (m_hMemBuffer.Equals(IntPtr.Zero)) Then
            m_hPtrBuffer = GlobalLock(m_hMemBuffer)
            AllocateBuffer = Not (m_hPtrBuffer.Equals(IntPtr.Zero))
        End If
    End Function

    Private Sub FreeBuffer()
        If Not (m_hPtrBuffer.Equals(IntPtr.Zero)) Then
            GlobalUnlock(m_hMemBuffer)
            m_hPtrBuffer = IntPtr.Zero
        End If
        If Not (m_hMemBuffer.Equals(IntPtr.Zero)) Then
            GlobalFree(m_hMemBuffer)
            m_hMemBuffer = IntPtr.Zero
        End If
    End Sub

    Public Sub CloseFile()
        If Not m_MmioIn.Equals(IntPtr.Zero) Then
            mmioClose(m_MmioIn, 0)
            m_MmioIn = IntPtr.Zero
            FreeBuffer()
            m_lCurrentReadSize = 0
            m_DataOffset = 0
            m_AudioLength = 0
        End If
    End Sub

    Public Function OpenFile(ByVal sSoundFile As String) As Boolean
        '    'Make sure the file exists
        If (sSoundFile = "") Then
            Exit Function
        End If
        If Not File.Exists(sSoundFile) Then
            Throw New FileNotFoundException
            Exit Function
        End If
        Dim mmckinfoParentIn As MMCKINFO
        Dim mmckinfoSubchunkIn As MMCKINFO
        Dim mmioinf As MMIOINFO

        Dim rc As Integer

        CloseFile()

        'Open the input file
        m_MmioIn = mmioOpen(sSoundFile, mmioinf, MMIO_READ)
        If (InputHandle.ToInt64 = 0) Then
            Throw New MediaException("Error while opening the input file.")
            Exit Function
        End If

        'Check if this is a wave file
        mmckinfoParentIn.fccType = mmioStringToFOURCC("WAVE", 0)
        rc = mmioDescendParent(InputHandle, mmckinfoParentIn, 0, MMIO_FINDRIFF)
        If (rc <> MMSYSERR_NOERROR) Then
            CloseFile()
            Throw New MediaException("Invalid file type.")
        End If

        'Get format info
        mmckinfoSubchunkIn.ckid = mmioStringToFOURCC("fmt", 0)
        rc = mmioDescend(InputHandle, mmckinfoSubchunkIn, mmckinfoParentIn, MMIO_FINDCHUNK)
        If (rc <> MMSYSERR_NOERROR) Then
            CloseFile()
            Throw New MediaException("Couldn't find format chunk.")
        End If

        rc = mmioReadString(InputHandle, m_FormatBuffer, mmckinfoSubchunkIn.ckSize)
        If (rc = -1) Then
            CloseFile()
            Throw New MediaException("Couldn't read from WAVE file.")
        End If

        rc = mmioAscend(InputHandle, mmckinfoSubchunkIn, 0)
        CopyWaveFormatFromBytes(m_Format, m_FormatBuffer, Len(m_Format))

        'If Not (m_Format.wBitsPerSample = 16) Or Not (m_Format.nChannels = 2) Then
        '    CloseFile()
        '    Throw New MediaException("Only stereo 16bit wave files supported")
        '    Exit Function
        'End If

        'Find the data subchunk
        mmckinfoSubchunkIn.ckid = mmioStringToFOURCC("data", 0)
        rc = mmioDescend(InputHandle, mmckinfoSubchunkIn, mmckinfoParentIn, MMIO_FINDCHUNK)
        If (rc <> MMSYSERR_NOERROR) Then
            CloseFile()
            Throw New MediaException("Unable to find the data chunk.")
        End If
        m_DataOffset = mmioSeek(InputHandle, 0, SEEK_CUR)

        'Get the length of the audio
        m_AudioLength = mmckinfoSubchunkIn.ckSize

        If Not AllocateBuffer() Then
            CloseFile()
            Throw New MediaException("Unable to Allocate Buffer")
            Exit Function
        End If

        '    'Allocate audio buffers
        '    m_BufferSize = CType(m_Format.nSamplesPerSec * m_Format.nBlockAlign * m_Format.nChannels * BUFFER_SECONDS, Integer)
        '    m_BufferSize = m_BufferSize - (m_BufferSize Mod m_Format.nBlockAlign)
        '    For i = 0 To NUM_BUFFERS - 1
        '        GlobalFree(hmem(i))
        '        hmem(i) = GlobalAlloc(0, m_BufferSize)
        '        pmem(i) = GlobalLock(hmem(i))
        '    Next


        '    'The class in successfully initialized
        '    m_Initialized = True

        OpenFile = True
        m_FileOpen = True
    End Function

    '---------------------------------------------------------------------------------------------
    'Added
    '---------------------------------------------------------------------------------------------

    Public ReadOnly Property Channels() As Int16
        Get
            Return m_Format.nChannels
        End Get
    End Property

    ''' <summary>
    ''' Gets the sample frequency of the file.
    ''' </summary>
    Public ReadOnly Property SamplingFrequency() As Integer
        Get
            Return m_Format.nSamplesPerSec
        End Get
    End Property

    ''' <summary>
    ''' Gets the number of bits per sample in the wave file.
    ''' </summary>
    Public ReadOnly Property BitsPerSample() As Int16
        Get
            Return m_Format.wBitsPerSample
        End Get
    End Property

    '---------------------------------------------------------------------------------------------

    '/// <summary>Gets the length of the WAVE file.</summary>
    '/// <value>The length of the WAVE file.</value>
    Public ReadOnly Property Length() As Integer
        Get
            Return m_AudioLength \ m_Format.nBlockAlign
        End Get
    End Property
 
    '/// <summary>Returns the handle of the input device.</summary>
    '/// <value>The handle of the input device.</value>
    Private ReadOnly Property InputHandle() As IntPtr
        Get
            Return m_MmioIn
        End Get
    End Property
    ''/// <summary>Returns the handle of the output device.</summary>
    ''/// <value>The handle of the output device.</value>
    'Private ReadOnly Property WaveOutHandle() As IntPtr
    '    Get
    '        Return m_WaveOut
    '    End Get
    'End Property
    '/// <summary>Called when the class gets GCed.</summary>
    Protected Overrides Sub Finalize()
        CloseFile()
        MyBase.Finalize()
    End Sub
  
    'Private variables
    Private m_Tel As Integer
    Private m_Filename As String
    Private m_Initialized As Boolean = False
    Private m_MmioIn As IntPtr = IntPtr.Zero
    Private m_DataOffset As Integer = 0
    Private m_AudioLength As Integer = 0
    Private m_BufferSize As Integer = 0
    Private hmem(NUM_BUFFERS - 1) As IntPtr  ' memory handles
    Private pmem(NUM_BUFFERS - 1) As IntPtr  ' memory pointers
    Private hdr(NUM_BUFFERS - 1) As WAVEHDR  ' wave headers
    Private m_Format As WAVEFORMAT   ' waveformat structure
    Private m_WaveOut As IntPtr = IntPtr.Zero
    Private m_Playing As Boolean = False
    Private m_StartPos As Integer = 0
    Private m_DataRemaining As Integer = 0
    Private m_FormatBuffer(49) As Byte
    Private m_Callback As WaveDelegate
    Private m_Paused As Boolean
    Private hHdr As GCHandle
End Class
