daten      equ     020h
sektor     equ     024h
spur       equ     022h
status     equ     026h

cseg       segment para public 'code'

ram        proc far
           assume cs:cseg, es:cseg, ss:cseg, ds:cseg

start      equ $

           dd      -1
           dw      2000h
           dw      devstrategy
           dw      devint
           db      1
           db      7 dup (?)

rhoff      dw      0
rhseg      dw      0

bpb        label   word
           dw      128
           db      4
           dw      1
           db      1
           dw      192
           dw      8192
           db      0fch
           dw      25

bpbptr     dw      bpb

funtab     label   byte
           dw      init
           dw      mediacheck
           dw      buildbpb
           dw      ioctlin
           dw      input
           dw      ndinput
           dw      instat
           dw      inflush
           dw      output
           dw      outverify
           dw      outstat
           dw      outflush
           dw      ioctlout


devstrategy:
           mov     cs:rhseg,es
           mov     cs:rhoff,bx
           ret


devint:    cld
           push    ds
           push    es
           push    ax
           push    bx
           push    cx
           push    dx
           push    di
           push    si
           mov     al,es:[bx]+2
           rol     al,1
           lea     di,funtab
           xor     ah,ah
           add     di,ax
           jmp     word ptr [di]


init:      push    cs
           pop     dx
           lea     ax,cs:ende
           mov     cl,4
           ror     ax,cl
           add     dx,ax
           mov     es:word ptr 14[bx],0
           mov     es:word ptr 16[bx],dx
           mov     es:byte ptr 13[bx],1
           lea     dx,bpbptr
           mov     es:18[bx],dx
           mov     es:20[bx],cs
           mov     di,cs
           mov     ds,di
           mov     si,offset bootrec
           mov     ax,0
           mov     cx,96
initl1:    call    outsec
           inc     ax
           loop    initl1
           mov     es,cs:rhseg
           mov     bx,cs:rhoff
           or      es:word ptr 3[bx],100h
           jmp     exit


mediacheck:
           mov     es:byte ptr 14[bx],1
           or      es:word ptr 3[bx],100h
           jmp     exit


buildbpb:  lea     dx,bpb
           mov     es:18[bx],dx
           mov     es:20[bx],cs
           or      es:3[bx],100h
           jmp     exit


ioctlin:
ioctlout:
ndinput:
instat:
inflush:
outstat:
outflush:
           or      es:3[bx],100h
           jmp     exit


input:     call    setup
           mov     es,di
           mov     di,bx
inloop:    call    insec
           inc     ax
           loop    inloop
           jmp     exit


output:
outverify: call    setup
           mov     ds,di
           mov     si,bx
outloop:   call    outsec
           inc     ax
           loop    outloop
           jmp     exit


exit:      pop     si
           pop     di
           pop     dx
           pop     cx
           pop     bx
           pop     ax
           pop     es
           pop     ds
           ret

ram        endp



setup      proc near
           or      es:3[bx],100h
           mov     ax,es:word ptr 14[bx]
           push    ax
           mov     cl,4
           clc
           shr     ax,cl
           add     ax,es:word ptr 16[bx]
           mov     di,ax
           mov     ax,es:word ptr 20[bx]
           mov     cx,es:word ptr 18[bx]
           pop     bx
           and     bx,0fh
           cmp     cx,512
           jl      set1
           cmp     bx,0
           jnz     set2
           mov     cx,512
           jmp     short set1
set2:      mov     cx,511
set1:      ret

setup      endp



insec      proc near
           push    ax
           push    cx
           out     spur,al
           mov     al,ah
           out     sektor,al
           mov     cx,128
inkloop:   in      al,daten
           stosb
           loop    inkloop
           pop     cx
           pop     ax
           ret

insec      endp



outsec     proc near
           push    ax
           push    cx
           out     spur,al
           mov     al,ah
           out     sektor,al
           mov     cx,128
outkloop:  lodsb
           out     daten,al
           loop    outkloop
           pop     cx
           pop     ax
           ret

outsec     endp

org        ($-start)+16-(($-start) mod 16)
ende       label word
bootrec    equ     $
           db      3 dup (0)
           db      'RAMDISK '
           dw      128
           db      4
           dw      1
           db      1
           dw      192
           dw      8192
           db      0fch
           dw      25
           db      104 dup (0)
           db      0fch,0ffh,0ffh
           db      125 dup (0)
           db      24*128 dup (0)
           db      'I/O RAMDISK'
           db      8
           db      10 dup (0)
           dw      6000h
           dw      0c21h
           dd      0
           db      49*128 dup (0)

cseg       ends
           end

