#include <conio.h>
#include <stdio.h>


#define SIO_STATUS         0xaa
#define SIO_DATEN          0xa8
#define EMPFAENGER_EMPTY   0x02
#define SENDER_EMPTY       0x01
#define TIMER_STEUER       0x9e
#define TIMER_KANAL2       0x9c


RS232_init()
{
  /*
  ** Hier wird die RS232-Schnittstelle Nr. 2 auf 1200 Baud initialisiert:
  ** Dazu werden in den Timer folgende Werte eingeschrieben:
  **   Zaehler_Kanal 2, lowbyte + highbyte, Betriebsart 3, Dualzaehler
  ** Der Schnittstellenbaustein 8251 wird mit folgenden Werten initialisier:
  **   Asynchrone Uebertragung, Takt x16, ohne/ungerade Paritaet, 1 Stopbit,
  **   Fehlerbits loeschen, Empfaenger und Sender freigeben.
  ** Das erste Byte wird gleich aus der Schnittstelle gelesen, weil es so-
  ** wieso nur Unsinn ergibt.
  */

  int high_baud=0x00;              /* fuer 1200 Baud */
  int low_baud=0x10;               /* fuer 1200 Baud */
  int timer_steuerwort=0xb6;       /* Dualzaehler, Betriebsart 3 */
  int sio_moduswort=0x4e;          /* 8 Bit, 1Stopbit, Takt x16 */
  int sio_kommandowort=0x27;       /* Fehlerbits loeschen, freigeben */
  int q;
  
  outp(TIMER_STEUER,timer_steuerwort);
  outp(TIMER_KANAL2,low_baud);
  outp(TIMER_KANAL2,high_baud);
  
  outp(SIO_STATUS,0);              /* Folge 0 0 0 40h ausgeben, damit */
  outp(SIO_STATUS,0);              /* der 8251 ein Moduswort empfangen */
  outp(SIO_STATUS,0);              /* kann (RESET) */
  outp(SIO_STATUS,0x40);
  
  outp(SIO_STATUS,sio_moduswort);
  outp(SIO_STATUS,sio_kommandowort);

  q=inp(SIO_DATEN);
}




main()
{
	RS232_init();
	printf("\n\r2.RS232-Schnittstelle mit 9600 Baud initialisiert\n\r");
}

