                    title 'terminal'
;-----------------------------------------------------------------------------
; Terminal-Programm: der CT-Rechner wird nur noch als VIDEO-Terminal genutzt
; Baudrate und andere Parameter als Equates einstellbar...
;-----------------------------------------------------------------------------
;
;
sio_status          equ 0aah
sio_daten           equ 0a8h
;
empfaenger_ready    equ 002h
sender_empty        equ 001h
;
timer_steuer        equ 09eh
timer_daten         equ 09ch
;
high_baudrate       equ 0                    ; fuer 2400 Baud
low_baudrate        equ 008h                 ; fuer 2400 Baud
;
timer_steuerwort    equ 0b6h                 ; Dualzaehler, Betriebsart 3
sio_moduswort       equ 04eh                 ; 8 Bit, 1 Stop, Takt x16
sio_kommandowort    equ 027h                 ; Fehlerbits loeschen, freigeben
;
full_duplex         equ 0
clear_screen        equ 01ah
logout              equ 0ffh
;
;
;-----------------------------------------------------------------------------
; Macros und Unterroutinen ...
;-----------------------------------------------------------------------------
;
;
dosint              macro fkt_nr
                    mov ah,fkt_nr
                    int 021h
                    endm
;
waiting             macro laenge
                    local wait1
                    mov cx,laenge
wait1:              loop wait1
                    endm
;
print               macro
                    local print1
                    push ax
print1:             in al,0a2h
                    test al,01
                    jz print1
                    pop ax
                    out 0a0h,al
                    endm
;
;
;-----------------------------------------------------------------------------
; Die Segmentdefinitionen
;-----------------------------------------------------------------------------
;
;
sseg                segment page stack
                    org 0100h
sseg                ends
;
;
dseg                segment page
                    org 0100h
dseg                ends
;
;
cseg                segment page
                    assume cs:cseg, ds:dseg, ss:sseg
;
;
;-----------------------------------------------------------------------------
; und jetzt das eigentliche Programm
;-----------------------------------------------------------------------------
;
;
start:              mov dl,clear_screen      ; Bildschirm loeschen
                    dosint 002h
rs232_init:         mov al,timer_steuerwort  ; Timer initialisieren
                    out timer_steuer,al
                    waiting 01000h
                    mov al,low_baudrate      ; Baudrate einstellen
                    out timer_daten,al
                    waiting 01000h
                    mov al,high_baudrate
                    out timer_daten,al
                    waiting 01000h
                    mov al,0                 ; SIO initialisieren
                    out sio_status,al
                    waiting 01000h
                    out sio_status,al
                    waiting 01000h
                    out sio_status,al
                    waiting 01000h
                    mov al,040h
                    out sio_status,al
                    waiting 01000h
                    mov al,sio_moduswort     ; Modus
                    out sio_status,al
                    waiting 01000h
                    mov al,sio_kommandowort  ; Kommando
                    out sio_status,al
                    waiting 01000h
                    in al,sio_daten          ; erstes Byte sowieso Dreck...


empfangen:          in al,sio_status         ; SIO-Status abfragen
                    test al,empfaenger_ready ; wenn nichts da ist,
                    je weiter                ; dann zum Senden
                    in al,sio_daten          ; ansonsten Zeichen holen
                    cmp al,logout            ; bei logout terminal
                    je ende                  ; beenden
                    print                    ; auf Bildschirm ausgeben
                    jp empfangen

weiter:             in al,sio_status
                    test al,00111000b        ; die "errors" testen
                    jz senden
                    mov al,00010101b         ; errors loeschen, freigeben
                    out sio_status,al

senden:             mov dl,0ffh              ; Tastaturstatus holen
                    dosint 006h
                    je  empfangen            ; keine Taste: empfangen       
                    out sio_daten,al         ; sonst ausgeben

                    jp empfangen             ; zurueck zum Empfangen

ende:               dosint 04ch              ; ciao
;
;
cseg                ends
                    end start

