                title 'INT10H'

; Emulation des Interrupt 10h fuer Terminalschnittstelle v24 (8251)
; Steuercode fuer Terminal TV950ct


;-----------------------------------------------------------------------------
; MACROS UND VARIABLEN (-FELDER)
;-----------------------------------------------------------------------------

prn             macro x0
                mov al,x0
                call v24out
                endm


code            segment
                assume cs:code, ds:code

                org 0100h

;-----------------------------------------------------------------------------
; DAS EIGENTLICHE PROGRAMM MIT INTERRUPTEINHAENGEN ...
;-----------------------------------------------------------------------------

start:          mov ah,25h                   ; Interrupt 10h auf
                mov al,10h                   ; eigene Emulation
                mov dx,offset emulation      ; umhaengen
                int 21h

          
ende:           mov ah,31h                   ; Programm beenden,
                mov al,0                     ; aber ohne Speicher-
                mov dx,0100h                 ; freigabe, es werden
                int 21h                      ; 4 kB reserviert
                int 3


;-----------------------------------------------------------------------------
; V24 AUSGABE AUF BAUSTEIN 8251
;-----------------------------------------------------------------------------

v24out:         sti                          ; Ausgabe des Zeichens
                push ax                      ; in al an die
ok1:            in al,0a2h                   ; V24-Schnittstelle1
                test al,1
                jz ok1
                pop ax
                out 0a0h,al
                ret


;-----------------------------------------------------------------------------
; DER INTERRUPT-HANDLER SELBST...
;-----------------------------------------------------------------------------

emulation:      cmp ah,2
                je set_curpos                ; Cursor positionieren
                cmp ah,9
                je out_zeiloop               ; Zeichen CX-mal ausgeben
                cmp ah,0ah
                je out_zei                   ; Zeichen ausgeben
                cmp ah,0eh
                je out_zei                   ; Zeichen ausgeben
                iret


;-----------------------------------------------------------------------------
; CURSORPOSITION SETZEN
;-----------------------------------------------------------------------------

set_curpos:     prn 1bh                      ; Ausgebe an Terminal:
                prn 3dh                      ; 3D, Zeile+20h (offset)
                mov al,dh                    ; Spalte+20h (offset)
                add al,20h
                prn al
                mov al,dl
                add al,20h
                prn al
                iret


;-----------------------------------------------------------------------------
; AUSGEBE EINES ZEICHEN AUF DEN BILDSCHIRM
;-----------------------------------------------------------------------------

out_zei:        prn al
                iret


;-----------------------------------------------------------------------------
; AUSGABE EINES ZEICHENS CX-MAL AUF DEN BILDSCHIRM
;-----------------------------------------------------------------------------

out_zeiloop:    prn al
                loop out_zeiloop
                iret


code            ends
                end start

