
	TITLE 'System Control Block Definition for CP/M3 BIOS'

	PUBLIC	@CIVEC,	@COVEC,	@AIVEC,	@AOVEC,	@LOVEC,	@BNKBF
	PUBLIC	@CRDMA,	@CRDSK,	@VINFO,	@RESEL,	@FX, @USRCD
	PUBLIC	@MLTIO,	@ERMDE,	@ERDSK,	@MEDIA,	@BFLGS
	PUBLIC	@DATE, @HOUR, @MIN, @SEC, ?ERJMP, @MXTPA


SCB$BASE EQU	0FE00H		; Base of the SCB

@CIVEC	EQU	SCB$BASE+22H	; Console Input Redirection
				; Vector (word, R/W)
@COVEC	EQU	SCB$BASE+24H	; Console Output Redirection
				; Vector (word, R/W)
@AIVEC	EQU	SCB$BASE+26H	; Auxiliary Input Redirection
				; Vector (word, R/W)
@AOVEC	EQU	SCB$BASE+28H	; Auxiliary Output Redirection
				; Vector (word, R/W)
@LOVEC	EQU	SCB$BASE+2AH	; List Output Redirection
				; Vector (word, R/W)
@BNKBF	EQU	SCB$BASE+35H	; Address of 128 Byte Buffer
				; For Banked BIOS (word, R/O)
@CRDMA	EQU	SCB$BASE+3CH	; Current DMA Address
				; (Word, R/O)
@CRDSK	EQU	SCB$BASE+3EH	; Current Disk (byte, R/O)
@VINFO	EQU	SCB$BASE+3FH	; BDOS Variable "INFO"
				; (Word, R/O)
@RESEL	EQU	SCB$BASE+41H	; FCB Flag (byte, R/O)
@FX	EQU	SCB$BASE+43H	; BDOS Function for Error
				; Messages (byte, R/O)
@USRCD	EQU	SCB$BASE+44H	; Current User Code (byte, R/O)
@MLTIO	EQU	SCB$BASE+4AH	; Current Multi-Sector Count
				; (Byte,R/W)
@ERMDE	EQU	SCB$BASE+4BH	; BDOS Error Mode (byte, R/O)
@ERDSK	EQU	SCB$BASE+51H	; BDOS Error Disk (byte,R/O)
@MEDIA	EQU	SCB$BASE+54H	; Set by BIOS to indicate
				; Open door (byte,R/W)
@BFLGS	EQU	SCB$BASE+57H	; BDOS Message Size Flag (byte,R/O)
@DATE	EQU	SCB$BASE+58H	; Date in Days Since 1 Jan 78
				; (Word, R/W)
@HOUR	EQU	SCB$BASE+5AH	; Hour in BCD (byte, R/W)
@MIN	EQU	SCB$BASE+5BH	; Minute in BCD (byte, R/W)
@SEC	EQU	SCB$BASE+5CH	; Second in BCD (byte, R/W)
?ERJMP	EQU	SCB$BASE+5FH	; BDOS Error Message Jump
				; (Word, R/W)
@MXTPA	EQU	SCB$BASE+62H	; Top of User TPA
				; (Address at 6,7)(word, R/O)
	END

