/* The actual format tables.  In a future version of this program they
   will be stored in external files. */

#include "mf.h"

struct Fmt
   *ft, *selectFormat();

struct Fmt
   fmtSpec[] = {

/* Default formats at the head of the list, all others in alpahabetic
   order regardless of disk type. */

      {
	{"Morrow/Compupro 2D"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	8, 1024,			/* sectors per track, sector size */
	2048, 256,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, exm, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,4,7,2,5,8,3,6}		/* Logical skew table */
      },
      {
	{"Access Matrix 1D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	40,				/* tracks per disk */
	9, 512,				/* sectors per track, sector size */
	1024, 64,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 480,			/* Filler byte, pre-index gap length */
	32,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	24, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9},		/* Physical skew table */
	{1,4,7,2,5,8,3,6,9}		/* Logical skew table */
      },
      {
	{"AED 2D"},			/* Description */
	EIGHT, MFM,			/* Size & density */
	EXTENDED_SURFACE,		/* sides, dsMethod */	
	154,				/* tracks per disk */
	17, 512,			/* sectors per track, sector size */
	2048, 192,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, exm, reserved tracks */
	CPM_FILL, 18,			/* Filler byte, pre-index gap length */
	16,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	16, 8, 3,			/* Gap III lengths */
	{1,6,11,16,4,9,14,		/* Physical skew table */
	 2,7,12,17,5,10,15,3,8,13},
	{1,4,7,10,13,16,2,5,8,		/* Logical skew table */
	 11,14,17,3,6,9,12,15}
      },
      {
	{"Archive 2D"},			/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	9, 512,				/* sectors per track, sector size */
	2048, 64,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, exm, reserved tracks */
	CPM_FILL, 82,			/* Filler byte, pre-index gap length */
	64,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	80, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9}		/* Logical skew table */
      },
      {
	{"Colex 2D"},			/* Description */
	FIVE_80, MFM,			/* Size & density */
	LONG_TRACK,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	20, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10,		/* Physical skew table */
	 11,12,13,14,15,16,17,18,19,20},
	{1,5,9,3,7,2,6,10,4,8,		/* Logical skew table */
	 11,15,19,13,17,12,16,20,14,18}
      },
      {
	{"ADDS Multivision 2D"},	/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* Sides, dsMethod */
	80,				/* Tracks per disk */
	10, 512,			/* Sectors per track, sector size */
	1024, 128,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I length */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,6,2,7,3,8,4,9,5,10},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9,10}		/* Logical skew table */
      },
      {
	{"Altos 4D"},			/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* Sides, dsMethod */
	160,				/* Tracks per disk */
	9, 512,				/* Sectors per track, sector size */
	4096, 256,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I length */
	22, 12, 3,			/* Gap II lengths */
	80, 12, 3,			/* Gap III lengths */
	{1,6,2,7,3,8,4,9,5},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9}		/* Logical skew table */
      },
      {
	{"Ampro 782K 2D"},		/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* Sides, dsMethod */
	160,				/* Tracks per disk */
	5, 1024,			/* Sectors per track, sector size */
	2048, 256,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I length */
	22, 12, 3,			/* Gap II lengths */
	99, 12, 3,			/* Gap III lengths */
	{0x11,0x14,0x12,0x15,0x13},	/* Physical skew table */
	{0x11,0x12,0x13,0x14,0x15}	/* Logical skew table */
      },
      {
	{"Amstrad 4D"},			/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* Sides, dsMethod */
	160,				/* Tracks per disk */
	9, 512,				/* Sectors per track, sector size */
	2048, 256,			/* CP/M block size, dir entries */
	0, dEXM, 1,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I length */
	22, 12, 3,			/* Gap II lengths */
	80, 12, 3,			/* Gap III lengths */
	{3,8,4,9,5,1,6,2,7},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9}		/* Logical skew table */
      },
      {
	{"Amstrad CPC 6128 1D"},	/* Description */
	FIVE_40, MFM,			/* Size & density */
	ONE_SIDED,			/* Sides, dsMethod */
	40,				/* Tracks per disk */
	9, 512,				/* Sectors per track, sector size */
	1024, 64,			/* CP/M block size, dir entries */
	0, dEXM, 0,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I length */
	22, 12, 3,			/* Gap II lengths */
	82, 12, 3,			/* Gap III lengths */
	{0xC1,0xC6,0xC2,0xC7,0xC3,
	 0xC8,0xC4,0xC9,0xC5},		/* Physical skew table */
	{0xC1,0xC2,0xC3,0xC4,0xC5,
	 0xC6,0xC7,0xC8,0xC9}		/* Logical skew table */
      },
      {
	{"Aussie Byte 2D 1024"},	/* Description */
	EIGHT, MFM,			/* Size and density */
	CYLINDER,			/* Sides, dsMethod */
	154,				/* Tracks per disk */
	8, 1024,			/* Sectors per track, sector size */
	2048, 256,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 72,			/* Filler byte, pre-index gap length */
	50,				/* Gap I length */
	22,12,3,			/* Gap II lengths */
	125,12,3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,3,5,7,2,4,6,8}		/* BIOS skew table */
      },
      {
	{"Bondwell 14 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	EXTENDED_SURFACE,		/* sides, dsMethod */	
	80,				/* tracks per disk */
	18, 256,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	12,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	12, 12, 3,			/* Gap III lengths */
	{0,9,1,10,2,11,3,12,4,		/* Physical skew table */
	 13,5,14,6,15,7,16,8,17},
	{0,1,2,3,4,5,6,7,8,9,10,11,	/* Logical skew table */
	 12,13,14,15,16,17},
      },
      {
	{"CCS 2D 1024"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	8, 1024,			/* sectors per track, sector size */
	8192, 128,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,4,7,2,5,8,3,6}		/* Logical skew table */
      },
      {
	{"Cromemco C10"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	LONG_TRACK,			/* sides, dsMethod */	
	40,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 1,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10,		/* Physical skew table */
	 11,12,13,14,15,16,17,18,19,20},
	{1,5,9,3,7,2,6,10,4,8,		/* Logical skew table */
	 11,15,19,13,17,12,16,20,14,18}
      },

/*
 *  This is a bit wierd and I am not sure I have it right.  The Datamax
 *  seems to have 50 sectors per track but only uses 48 of them for data.
 *  Data (not quite) max?
 */

      {
	{"Datamax 1D format"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	77,				/* tracks per disk */
	50, 128,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 16,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1, 9,17,25,33,41,		/* Physical skew table */
	 2,10,18,26,34,42,
	 3,11,19,27,35,43,
	 4,12,20,28,36,44,
	 5,13,21,29,37,45,
	 6,14,22,30,38,46,
	 7,15,23,31,39,47,
	 8,16,24,32,40,48,49,50},
	{1, 2, 3, 4, 5, 6, 7, 8, 9,10,	/* Logical skew table */
	11,12,13,14,15,16,17,18,19,20,
	21,22,23,24,25,26,27,28,29,30,
	31,32,33,34,35,36,37,38,39,40,
	41,42,43,44,45,46,47,48,49,50}
      },
      {
	{"Datamax 1D read/write"},	/* Description */
	EIGHT, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	77,				/* tracks per disk */
	48, 128,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 16,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1, 9,17,25,33,41,		/* Physical skew table */
	 2,10,18,26,34,42,
	 3,11,19,27,35,43,
	 4,12,20,28,36,44,
	 5,13,21,29,37,45,
	 6,14,22,30,38,46,
	 7,15,23,31,39,47,
	 8,16,24,32,40,48},
	{1, 2, 3, 4, 5, 6, 7, 8, 9,10,	/* Logical skew table */
	11,12,13,14,15,16,17,18,19,20,
	21,22,23,24,25,26,27,28,29,30,
	31,32,33,34,35,36,37,38,39,40,
	41,42,43,44,45,46,47,48}
      },
      {
	{"DEC Rainbow 1D"},		/* Description */
	FIVE_80, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{1,3,5,7,9,2,4,6,8,10}		/* Logical skew table */
      },
      {
	{"Epson QX-10 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	78,				/* tracks per disk */
	16, 256,			/* sectors per track, sector size */
	2048, 64,			/* CP/M block size, dir entries */
	0, dEXM, 8,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	66,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10,11,12,	/* Physical skew table */
	 13,14,15,16},
	{1,2,3,4,5,6,7,8,9,10,11,12,	/* Logical skew table */
	 13,14,15,16}
      },
      {
	{"Epson QX+10 400K 2D"},	/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	5, 1024,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 0,			/* alv, reserved tracks */
	CPM_FILL, 78,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	116, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5},			/* Physical skew table */
	{1,2,3,4,5}			/* Logical skew table */
      },
      {
	{"Glass Typewriter II 2D"},	/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* Sides, dsMethod */
	160,				/* Tracks per disk */
	10, 512,			/* Sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I length */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{1,4,7,10,3,6,9,2,5,8}		/* Logical skew table */
      },
      {
	{"Glass Typewriter II 2D"},	/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* Sides, dsMethod */
	80,				/* Tracks per disk */
	10, 512,			/* Sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I length */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{1,4,7,10,3,6,9,2,5,8}		/* Logical skew table */
      },
      {
	{"Gemini 2D (modified)"},	/* Description */
	FIVE_80, MFM,			/* Size & density */
	EXTENDED_SURFACE,		/* sides, dsMethod */	
	160,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	4096, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9,10}		/* Logical skew table */
      },
      {
	{"IBM-PC CP/M 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	EXTENDED_SURFACE,		/* sides, dsMethod */	
	80,				/* tracks per disk */
	8, 512,				/* sectors per track, sector size */
	2048, 64,			/* CP/M block size, dir entries */
	0, dEXM, 1,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	102, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,2,3,4,5,6,7,8}		/* Logical skew table */
      },
      {
	{"IBM-PC 2Dx9"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	9, 512,				/* sectors per track, sector size */
	2048, 1,			/* Irrelevant for MS-DOS */
	0, dEXM, 0,			/* Irrelevant for MS-DOS */
	MS_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	80, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9}		/* Logical skew table */
      },
      { /* N.B. Kaypro has 64 directory entries but 4 directory blocks */
	{"Kaypro II 1D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	40,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	1024, 64,			/* CP/M block size, dir entries */
	4, dEXM, 1,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	32,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	24, 12, 3,			/* Gap III lengths */
	{0,8,3,6,1,9,4,7,2,5},		/* Physical skew table */
	{0,1,2,3,4,5,6,7,8,9}		/* Logical skew table */
      },
      {
	{"Kaypro 4/10 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	LONG_TRACK,			/* sides, dsMethod */	
	40,				/* tracks per disk */
	20, 512,			/* sectors per track, sector size */
	2048, 64,			/* CP/M block size, dir entries */
	0, dEXM, 1,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	32,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	24, 12, 3,			/* Gap III lengths */
	{0,8,3,6,1,9,4,7,2,5,		/* Physical skew table */
	 10,18,13,16,11,19,14,17,12,15},
	{0,1,2,3,4,5,6,7,8,9,		/* Logical skew table */
	 10,11,12,13,14,15,16,17,18,19}
      },
      {
	{"Labtam 2D"},			/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	8, 1024,			/* sectors per track, sector size */
	4096, 256,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	16,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	16, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,2,3,4,5,6,7,8}		/* Logical skew table */
      },
      {
	{"Labtam 2D"},			/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	160,				/* tracks per disk */
	5, 1024,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	40, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5},			/* Physical skew table */
	{1,2,3,4,5}			/* Logical skew table */
      },
      {
	{"Microbee 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{2,5,8,1,4,7,10,3,6,9}		/* Logical skew table */
      },
      {
	{"Microbee 4D"},		/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	160,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{2,5,8,1,4,7,10,3,6,9}		/* Logical skew table */
      },
      {
	{"Morrow/Compupro 1D"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	77,				/* tracks per disk */
	8, 1024,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,4,7,2,5,8,3,6}		/* Logical skew table */
      },
      {
	{"Morrow MD2 1D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	40,				/* tracks per disk */
	5, 1024,			/* sectors per track, sector size */
	1024, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	102, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5},			/* Physical skew table */
	{1,4,2,5,3}			/* Logical skew table */
      },
      {
	{"Morrow MD3 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	5, 1024,			/* sectors per track, sector size */
	2048, 192,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	102, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5},			/* Physical skew table */
	{1,4,2,5,3}			/* Logical skew table */
      },
      {
	{"Osborne 1D"},			/* Description */
	FIVE_40, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	40,				/* tracks per disk */
	5, 1024,			/* sectors per track, sector size */
	1024, 64,			/* CP/M block size, dir entries */
	0, dEXM, 3,			/* reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	102, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5},			/* Physical skew table */
	{1,2,3,4,5}			/* Logical skew table */
      },
      {
	{"Oki if800 Model 30 2D"},	/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	26, 256,			/* sectors per track, sector size */
	4096, 128,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 0,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,		/* Physical skew table */
	 9,10,11,12,13,14,15,16,
	 17,18,19,20,21,22,23,24,
	 25,26},
	{1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
	 16,17,18,19,20,21,22,23,24,25,26}
      },
      {
	{"Portapak 784K 2D"},		/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	160,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 3,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	40, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{1,3,5,7,9,2,4,6,8,10}		/* Logical skew table */
      },
      {
	{"Sanyo 550 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	16, 256,			/* sectors per track, sector size */
	2048, 64,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 32,			/* Filler byte, pre-index gap length */
	32,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10,11,	/* Physical skew table */
	 12,13,14,15,16},
	{1,4,7,10,13,16,3,6,9,12,	/* Logical skew table */
	 15,2,5,8,11,14},
      },
      {
	{"SME Systems 1D"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	77,				/* tracks per disk */
	50, 128,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	34,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{ 1,26, 2,27, 3,28, 4,29, 5,30,	/* Physical skew table */
	  6,31, 7,32, 8,33, 9,34,10,35,
	 11,36,12,37,13,38,14,39,15,40,
	 16,41,17,42,18,43,19,44,20,45,
	 21,46,22,47,23,48,24,49,25,50},
	{ 1, 3, 5, 7, 9,11,13,15,17,19,	/* Logical skew table */
	 21,23,25,27,29,31,33,35,37,39,
	 41,43,45,47,49,
	  2, 4, 6, 8,10,12,14,16,18,20,
	 22,24,26,28,30,32,34,36,38,40,
	 42,44,46,48,50}
      },
      {
	{"SME Systems 2D"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	50, 128,			/* sectors per track, sector size */
	2048, 256,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	34,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{ 1,26, 2,27, 3,28, 4,29, 5,30,	/* Physical skew table */
	  6,31, 7,32, 8,33, 9,34,10,35,
	 11,36,12,37,13,38,14,39,15,40,
	 16,41,17,42,18,43,19,44,20,45,
	 21,46,22,47,23,48,24,49,25,50},
	{ 1, 3, 5, 7, 9,11,13,15,17,19,	/* Logical skew table */
	 21,23,25,27,29,31,33,35,37,39,
	 41,43,45,47,49,
	  2, 4, 6, 8,10,12,14,16,18,20,
	 22,24,26,28,30,32,34,36,38,40,
	 42,44,46,48,50}
      },
      {
	{"Standard CP/M 1S (3740)"},	/* Description */
	EIGHT, FM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	77,				/* tracks per disk */
	26, 128,			/* sectors per track, sector size */
	1024, 64,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	26,				/* Gap I lengths */
	11, 6, 0,			/* Gap II lengths */
	27, 6, 0,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,		/* Physical skew table */
	 9,10,11,12,13,14,15,16,
	 17,18,19,20,21,22,23,24,
	 25,26},
	{1,7,13,19,25,5,11,17,23,3,9,15,21,
	 2,8,14,20,26,6,12,18,24,4,10,16,22}
      },
      {
	{"QT Systems 1D (3741)"},	/* Description */
	EIGHT, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	77,				/* tracks per disk */
	26, 256,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	26,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,		/* Physical skew table */
	 9,10,11,12,13,14,15,16,
	 17,18,19,20,21,22,23,24,
	 25,26},
	{1,7,13,19,25,5,11,17,23,3,9,15,21,
	 2,8,14,20,26,6,12,18,24,4,10,16,22}
      },
      {
	{"QT Systems 2D (3741)"},	/* Description */
	EIGHT, MFM,			/* Size & density */
	EXTENDED_SURFACE,		/* sides, dsMethod */	
	154,				/* tracks per disk */
	26, 256,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	26,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,		/* Physical skew table */
	 9,10,11,12,13,14,15,16,
	 17,18,19,20,21,22,23,24,
	 25,26},
	{1,7,13,19,25,5,11,17,23,3,9,15,21,
	 2,8,14,20,26,6,12,18,24,4,10,16,22}
      },
      {
	{"Tandy/Montezuma 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	18, 256,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 20,			/* Filler byte, pre-index gap length */
	20,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	24, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10,		/* Physical skew table */
	 11,12,13,14,15,16,17,18},
	{1,3,5,7,9,11,13,15,17,		/* BIOS skew table */
	 2,4,6,8,10,12,14,16,18}
      },
      {
	{"Tandy Model 3 1D (CP/M+)"},	/* Description */
	EIGHT, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	77,				/* tracks per disk */
	16, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,5,9,13,2,6,10,14,		/* Physical skew table */
	 3,7,11,15,4,8,12,16},
	{1,2,3,4,5,6,7,8,9,10,		/* BIOS skew table */
	 11,12,13,14,15,16}
      },
      {
	{"Telectronics CP/M68K 2D"},	/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	18, 256,			/* sectors per track, sector size */
	2048, 64,			/* CP/M block size, dir entries */
	0, dEXM, 4,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	12, 12, 3,			/* Gap III lengths */
	{1,10,2,11,3,12,4,13,5,14,	/* Physical skew table */
	 6,15,7,16,8,17,9,18},
	{1,2,3,4,5,6,7,8,9,10,11,12,	/* Logical skew table */
	 13,14,15,16,17,18},
      },
      {
	{"Telectronics something"},	/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	8, 1024,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, exm, reserved tracks */
	CPM_FILL, 76,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	116, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,4,7,2,5,8,3,6}		/* Logical skew table */
      },
      {
	{"Televideo 802/803 2D"},	/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	18, 256,			/* sectors per track, sector size */
	2048, 64,			/* CP/M block size, dir entries */
	0, 0, 4,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	12,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	12, 12, 3,			/* Gap III lengths */
	{1,4,7,10,13,16,2,5,8,11,14,	/* Physical skew table */
	 17,3,6,9,12,15,18},
	{1,2,3,4,5,6,7,8,9,10,11,12,	/* Logical skew table */
	 13,14,15,16,17,18},
      },
      {
	{"Toshiba T100 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	70,				/* tracks per disk */
	16, 256,			/* sectors per track, sector size */
	1024, 64,			/* CP/M block size, dir entries */
	0, dEXM, 6,			/* alv, reserved tracks */
	CPM_FILL, 32,			/* Filler byte, pre-index gap length */
	32,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	54, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10,11,	/* Physical skew table */
	 12,13,14,15,16},
	{1,5,9,13,2,6,10,14,3,7,11,	/* Logical skew table */
	 15,4,8,12,16},
      },
      {
	{"TRS-80 Model 1 1S"},
	FIVE_40, FM,
	ONE_SIDED,
	40,
	10, 256,
	1024, 64,
	0, dEXM, 0,
	CPM_FILL, 20,
	50,
	11,6,3,
	11,6,3,
	{0,1,2,3,4,5,6,7,8,9},
	{0,1,2,3,4,5,6,7,8,9}
      },
      {
	{"Unskewed 2D 8*1024 cyl"},	/* Description */
	EIGHT, MFM,			/* Size and density */
	CYLINDER,			/* Sides, dsMethod */
	154,				/* Tracks per disk */
	8, 1024,			/* Sectors per track, sector size */
	2048, 256,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 72,			/* Filler byte, pre-index gap length */
	50,				/* Gap I length */
	22,12,3,			/* Gap II lengths */
	125,12,3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,2,3,4,5,6,7,8}		/* BIOS skew table */
      },
      {
	{"Unskewed 10*512 2D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	80,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9,10}		/* Logical skew table */
      },
      {
	{"Unskewed 10*512 4D"},		/* Description */
	FIVE_80, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	160,				/* tracks per disk */
	10, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9,10}		/* Logical skew table */
      },
      {
	{"Unskewed 16*512 2D"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	16, 512,			/* sectors per track, sector size */
	2048, 128,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 52,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	52, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8,9,10,
	    11,12,13,14,15,16},		/* Physical skew table */
	{1,2,3,4,5,6,7,8,9,10,
	    11,12,13,14,15,16}		/* Logical skew table */
      },
      {
	{"Williams One 2D"},		/* Description */
	EIGHT, MFM,			/* Size & density */
	CYLINDER,			/* sides, dsMethod */	
	154,				/* tracks per disk */
	8, 1024,			/* sectors per track, sector size */
	2048, 256,			/* CP/M block size, dir entries */
	0, dEXM, 2,			/* alv, reserved tracks */
	CPM_FILL, 40,			/* Filler byte, pre-index gap length */
	50,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	80, 12, 3,			/* Gap III lengths */
	{1,2,3,4,5,6,7,8},		/* Physical skew table */
	{1,4,7,2,5,8,3,6}		/* Logical skew table */
      },
      {
	{"Xerox 820-II 1D"},		/* Description */
	FIVE_40, MFM,			/* Size & density */
	ONE_SIDED,			/* sides, dsMethod */	
	40,				/* tracks per disk */
	17, 256,			/* sectors per track, sector size */
	1024, 64,			/* CP/M block size, dir entries */
	0, dEXM, 3,			/* alv, reserved tracks */
	CPM_FILL, 80,			/* Filler byte, pre-index gap length */
	22,				/* Gap I lengths */
	22, 12, 3,			/* Gap II lengths */
	22, 12, 3,			/* Gap III lengths */
	{1,10,2,11,3,12,4,13,5,14,	/* Physical skew table */
	 6,15,7,16,8,17,9},
	{1,2,3,4,5,6,7,8,9,10,		/* Logical skew table */
	 11,12,13,14,15,16,17}
      },
      {
	{0}				/* Format list terminator */
      }
    };

char junk1[] = {'D','r','i','v','e',' ','r','a','n','g','e',' ',
                '(','l','o','w',',','h','i','g','h',')',' ','>'};
char loDrive = 'E';
char hiDrive = 'G';

char junk2[] = {'<','D','r','i','v','e',' ','t','y','p','e','s',' ','>'};

char dkTypes[] =
  {
    FIVE_80,		/* Drive 0 - 80cyl 5" floppy */
    FIVE_40,		/* Drive 1 - 40cyl 5" floppy */
    FIVE_80,		/* Drive 2 - 80cyl 3.5" floppy */
    EIGHT		/* Drive 3 - 8" floppy */
  };
/* Note that the difference between hiDrive and loDrive determines the number
   of elements in dkTypes[] that are actually used.  */

char junk3[] = {'<'};
