/*-----------------------------------------------------------------------------

				M F 4 . C
				=========

	Routines to construct an extended disk parameter header, a disk
	parameter block and a sector translate table from the information
	in the format tables and to assign a format to a drive via an
	implementor-defined BIOS call.

-----------------------------------------------------------------------------*/

#include "mf.h"

void show();
extern void delay();

char *dsMethod[] =
	{
		{"None"},
		{"Long Track"},
		{"Cylinder Mode"},
		{"Extended Surface"}
	};

void assign(drive,ft)
byte drive;
struct Fmt *ft;
{
  extern char getKey();
  register byte x;
  word dirsPerBlock;
  union
    {
      word	alw;
      struct
	{
	  byte	al1;
	  byte	al0;
	} alb;
     } alv;
  struct xDPH xdph;
  struct Dpb  dpb;

/* Fill in the relevant bits of the XDPH. */

  xdph.dsMethod = ft->dsMethod;		/* DS method or SS */
  xdph.tpd = ft->tpd;			/* Tracks per disk */
  xdph.xltt = &(ft->lSkew[0]);		/* Sector translate table address */
  xdph.dpb = &dpb;			/* Disk parameter block address */
  if (ft->type == EIGHT)		/* Disk size:-	*/
    xdph.selBits = 0;			/*	8"	*/
  else					/* or		*/
    xdph.selBits = 0x20;		/*	5.25"	*/
  if (ft->density == FM)		/* Density */
    xdph.selBits |= 0x80;

/* That was the easy bit; now for the hard stuff.  We construct a complete
   Disk Parameter Block (DPB) */

  dpb.spt = ft->spt * (ft->pss / 128);	/* Logical sectors per track */
  x = dpb.psh = sectorSize(ft->pss);	/* Physical sector shift factor */
  dpb.psm = (1 << x) - 1;		/* Physical sector shift mask */
  dpb.drm = ft->ndir - 1;		/* Maximum direcory entry number */
  x = dpb.bsh = sectorSize(ft->blksiz);	/* Block shift factor */
  dpb.blm = (1 << x) - 1;		/* Block shift mask */
  dpb.dsm = (ft->tpd-ft->off) * dpb.spt	/* Blocks per disk */
	  / (ft->blksiz / 128) - 1;
  dpb.exm = dpb.blm >> 3;		/* Extent mask */
  if (dpb.dsm > 255)
    dpb.exm >>= 1;
  if (ft->exm != dEXM)			/* If explicit extent mask */
    dpb.exm = ft->exm;			/*   then use it. */
  if (ft->alloc)			/* If explicit allocation */
    x = ft->alloc;			/*   then use it, */
  else					/* otherwise... */
    {
      dirsPerBlock = ft->blksiz / 32;	/* AL0, AL1.  We do it this way */
      x = (ft->ndir + dirsPerBlock - 1)	/* to avoid overflow & truncation */
	  / dirsPerBlock;		/* errors */
    }
  alv.alw = ~(0xFFFF >> x);
  dpb.al0 = alv.alb.al0;
  dpb.al1 = alv.alb.al1;
  dpb.cks = dpb.drm/4 + 1;		/* Checksum vector size */
  dpb.off = ft->off;			/* Reserved tracks */

/* Tell the user everything and ask if it is OK to proceed */

  cls();
  show(2,0,"Drive",10,drive,"%c:");
  show(2,30,"Format",40,ft->name,"%s");
  show(3,0,"Size",10,(ft->type==EIGHT?"8-inch":"5.25-inch"),"%s");
  show(3,30,"Sides",40,(ft->dsMethod==ONE_SIDED?1:2),"%d");
  show(4,0,"CP/M block size",30,ft->blksiz,"%6u");
  show(5,0,"Drive capacity",30,((dpb.dsm+1)*(ft->blksiz/1024)),"%6u Kb");
  show(6,0,"Physical sector size",30,ft->pss,"%6u");
  show(7,0,"Treatment of 2-sided disks",30,dsMethod[ft->dsMethod],"%s");
  cursor(12,0);
  highlight();
  printf("Disk parameter block (DPB):");
  show(14,5,"SPT",20,dpb.spt,"%04x");  printf(" (%d)",dpb.spt);
  show(14,40,"BSH",55,dpb.bsh,"  %02x");
  show(15,5,"BLM",20,dpb.blm,"  %02x");
  show(15,40,"EXM",55,dpb.exm,"  %02x");
  show(16,5,"DSM",20,dpb.dsm,"%04x");  printf(" (%d)",dpb.dsm);
  show(16,40,"DRM",55,dpb.drm,"%04x");  printf(" (%d)",dpb.drm);
  show(17,5,"AL0,AL1",20,alv.alw,"%04x");
  show(17,40,"CKS",55,dpb.cks,"%04x");  printf(" (%d)",dpb.cks);
  show(18,5,"OFF",20,dpb.off,"%04x");  printf(" (%d)",dpb.off);
  show(19,5,"PSH",20,dpb.psh,"  %02x");
  show(19,40,"PSM",55,dpb.psm,"  %02x");
  cursor(23,0);
  printf("Assign this format to drive %c: [%d]?  ",drive,drive-'A');
  cursor(ON);
  if ((getKey() & 0x5F) == 'Y')
    {
      bios3(USERF,0,drive-'A',&(xdph.xltt),0);
      printf("\nFormat assigned!");
      delay(1);
    }
}

void show(line,sCol,stub,vCol,val,fmt)
byte line, sCol, *stub, vCol, *fmt;
word val;
{
  cursor(line,sCol);
  highlight();
  printf("%s:",stub);
  standard();
  cursor(line,vCol);
  printf(fmt,val);
}
