/*=============================================================================

				  M F 2 . C
				  ---------

			Utility functions used by MF.C

=============================================================================*/

#include "stdio.h"
#include "mf.h"

/*-----------------------------------------------------------------------------

				 g e t K e y
				 ===========

	Obtains a keystroke from the console.  Does not echo the character.

----------------------------------------------------------------------------*/

char getKey()
{
  return (char)bdos(6,0xFD);
}

/*----------------------------------------------------------------------------

				g e t D r i v e
				===============

	Prompts for a disk drive letter.  Returns upper-case.  Caller is
	responsible for checking validity.

----------------------------------------------------------------------------*/

char getDrive()
{
  printf("\nEnter drive identifier: ");
  return getKey() & 0x5F;
}

/*----------------------------------------------------------------------------

                   Object-patchable terminal control strings

 	All strings are in length-prefix form for generality so that
	a nul may be part of a control string.

----------------------------------------------------------------------------*/

char junkT[] = {'V','D','U',' ','c','o','n','t','r','o','l','s',' ','>'};
byte vClear[]     = {2, 0x15, 0x17, 0, 0, 0, 0, 0 };
byte vHighlight[] = {2, 0x1B, 6, 0, 0, 0, 0, 0};
byte vInverse[]   = {2, 0x1B, 5, 0, 0, 0, 0, 0};
byte vNormal[]    = {2, 0x1B, 4, 0, 0, 0, 0, 0};
byte vCursOff[]   = {1, 0x19, 0, 0, 0, 0, 0, 0};
byte vCursOn[]    = {1, 0x18, 0, 0, 0, 0, 0, 0};
byte vPrefix[]    = {1, 9, 0, 0, 0, 0, 0, 0};
byte vInfix[]     = {0, 0, 0, 0, 0, 0, 0, 0};
byte vSuffix[]    = {0, 0, 0, 0, 0, 0, 0, 0};
byte vRowOffset   = 0;
byte vColOffset   = 0;
byte vRowFirst	  = FALSE;
byte vASCII	  = FALSE;

/*----------------------------------------------------------------------------

                                 v i d e o
                                 =========

        Sends a length-prefixed string to the terminal.

----------------------------------------------------------------------------*/

void video(str)
byte *str;
{
    char n;
    for (n=*str++; n--; ++str)
        bdos(*str < 0xF0 ? 6 : 2, *str);
}

/*----------------------------------------------------------------------------

                                   c o o r d
                                   =========

        Sends a cursor-positioning coordinate to the VDU.

----------------------------------------------------------------------------*/

void coord(v)
byte v;
{
    if (vASCII)
        printf("%d",v);
    else
        bdos(v < 0xF0 ? 6 : 2, v);
}

/*----------------------------------------------------------------------------

				  c u r s o r
				  ===========

	Positions the cursor on the console screen for display of text
	or entry of data.  Can also turn the cursor display on or off.

----------------------------------------------------------------------------*/

void cursor(row,col)
  char row, col;
{
  if (row == CURSOR)	/* then "cursor ON" or "cursor OFF" */ 
    video(col==CURSOFF ? vCursOff : vCursOn);
  else
    {
      video(vPrefix);
      coord(vRowFirst ? (byte)row+vRowOffset : (byte)col+vColOffset);
      video(vInfix);
      coord(vRowFirst ? (byte)col+vColOffset : (byte)row+vRowOffset);
      video(vSuffix);
    }
}

/*-----------------------------------------------------------------------------

				   b i o s 3
				   =========

	This routine handles calls to the host system BIOS.  On CP/M 2.2
	systems it simply calls the compiler's run-time library function
	bios() but on CP/M 3.1 systems it uses BDOS function 50 instead.

----------------------------------------------------------------------------*/

word bios3(fn,aReg,bcReg,deReg,hlReg)
byte fn, aReg;
word bcReg,deReg,hlReg;
{
  extern word bios();
  extern word bdos(), bdoshl();

  struct BiosPB {
		  byte  func;
		  byte	aVal;
		  word	bcVal;
		  word  deVal;
		  word  hlVal;
		} biosPB;

  if ((bdos(GETVSN,0) & 0xFF) < 0x30)
    return bios(fn,bcReg,deReg);

  biosPB.func = fn;
  biosPB.aVal = aReg;
  biosPB.bcVal = bcReg;
  biosPB.deVal = deReg;
  biosPB.hlVal = hlReg;

  switch (fn)
    {
case 9:		/* SELDSK */
case 16:	/* SECTRAN (not used by this program) */
case 20:	/* DEVTBL (not used by this program) */
case 22:	/* DRVTBL (not used by this program) */
      return bdoshl(50,(char *)&biosPB);
default:
      return bdos  (50,(char *)&biosPB);
    }
}
