/*=============================================================================

				   M F 1 . C
				   ---------

	This module contains the routines to examine a disk.

=============================================================================*/

#include "stdio.h"
#include "mf.h"

extern char dkTypes[];

extern byte *malloc();
extern char getKey();
extern void showError();
extern word mount();
extern void dismount();
extern word readTrack();

byte	show256();
void	show16();

#define RTMASK	0xB0		/* Status mask for READ TRACK */

/*-----------------------------------------------------------------------------

				e x a m i n e
				=============

	Prompts for drive, track, side and density.  On a successful
	track read displays the track in hex and ASCII, pausing every
	256 bytes and allowing WordStar-type cursor movement:-

	^E	Up 1 line,	^X	Down 1 line
	^S	Back 1 byte	^D	Forward 1 byte
	^R	Back 256 bytes	^C	Forward 256 bytes

-----------------------------------------------------------------------------*/

void examine(drive)
byte drive;
{
  short int	trk, cylinder, side, density;
  byte		*track;
  byte		fdError;
  byte		goAhead = TRUE;
  word		offset;

  cls();

  printf("\nExamining disk in drive %c\n",drive);

  while (goAhead)
    {
      printf("\nWhich track (cylinder)? ");
      scanf("%d",&cylinder);
      printf("Which side (0 or 1)? ");
      scanf("%d",&side);
      printf("What density (S or D)? ");
      density = getKey();
      putchar('\n');
      switch(density)
	{
case 's':
case 'S':
	  density = 1;
	  break;
case 'd':
case 'D':
	  density = 0;
	  break;
default:
	  return;
	}

/* Make sure the disk is loaded in the drive.  Allow the option of quitting
   if the disk is not loaded. */

      do
	if (fdError=mount(drive-loDrive,dkTypes[drive-loDrive],density,READ))
	  {
	    showError(fdError);
	    printf("\nPress ESC to abort, any other when disk is ready: ");
	    if(getKey()==ESC)
	      goAhead = FALSE;
	  }
      while (goAhead && fdError);

/* Position to the correct track */

      if (goAhead)
	{
	  for (trk=0;trk<cylinder;++trk)
	    if (fdError = stepIn())
	      {
	        showError(fdError);
		getKey();
	        goAhead = FALSE;
	      }
	}

/* Read the track */

      if (goAhead)
	{
	  track = malloc(TRKBUFSZ);
	  if (fdError=readTrack(track,side)&RTMASK)
	    {
	      showError(fdError);
	      getKey();
	      goAhead = FALSE;
	    }
	}

/* Unconditionally dismount the disk */

      dismount();

/* Display the track */

      for (offset = 0; goAhead && offset < TRKBUFSZ; offset += 256)
	goAhead = show256(track,offset);

/* Release the track buffer */

      dismount();
    }      
}

/*----------------------------------------------------------------------------

				s h o w 2 5 6
				=============

	Displays 256 bytes in hex and ASCII by calling show16().

----------------------------------------------------------------------------*/

byte show256(track,offset)
  byte *track;
  word offset;
{
  word o;
  byte c = TRUE;
  for (o = offset; o < TRKBUFSZ && o < offset+256; o+=16)
    show16(track,o);

  printf("\nPress any key: ");
  if (getKey() == ESC)
    c = FALSE;
  putchar('\r');
  return c;
}

/*---------------------------------------------------------------------------

				s h o w 1 6
				===========

	Displays 16 bytes of track buffer.

---------------------------------------------------------------------------*/

void show16(track,offset)
  byte *track;
  word offset;
{
  word o;
  byte r;
  char c;

  printf("%04x: ",offset);
  for (o=offset; o < offset+16; ++o)
    printf("%02x ",*(track+o));

  r = FALSE;
  putchar(' ');
  putchar(' ');
  for (o=offset; o < offset+16; ++o)
  {
    if ((c = *(track+o)) & 0x80)
    {
      if (!r)
      {
        r = TRUE;
        video(vInverse);
      }
    }
    else
    {
      if (r)
      {
        r = FALSE;
        video(vNormal);
      }
    }
    c &= 0x7F;
    if (c < 0x20 || c == 0x7F)
      putchar('.');
    else
      putchar(c);
  }
  video(vNormal);
  putchar('\n');
}
