#define word			unsigned short int
#define byte			unsigned char

#define FALSE			0
#define TRUE			-1
#define ESC			0x1B

#define	READ			0xBF
#define WRITE			0xFF

/*
 * Do not change these "cursor" #defines even though they do not look right
 * for your terminal.  The values are trapped in cursor() and translated to
 * the appropriate calls on video() which in turn uses strings tailored to
 * a particular terminal. 
 */

#define	CURSOR			-44	/* Cursor on/off sentinel */
#define	CURSON			0x18
#define	CURSOFF			0x19
#define	ON			CURSOR,CURSON
#define	OFF			CURSOR,CURSOFF

#define ONE_SIDED		0
#define	LONG_TRACK		1
#define CYLINDER		2
#define EXTENDED_SURFACE	3
#define SERPENTINE		4

#define EIGHT			0
#define FIVE_80			1		/* Also 3.5" */
#define FIVE_40			2
#define HARD			0xFF

#define FM			1
#define MFM			0
#define FM_FILL			0xFF
#define MFM_FILL		0x4E
#define DAM			0xFB
#define	IDAM			0xFE
#define INDEX_MARK		0xFC
#define CPM_FILL		0xE5
#define MS_FILL			0xF6

#define RESETDRIVE		37
#define CURDSK			25
#define SETDRIVE		14
#define GETVSN			12
#define SELDSK			 9
#define USERF			30

/* Format descriptor layout.  Note that not all of these fields are used for
   formatting.  The data contained herein is also used to build tables for
   for hot-patching the BIOS. */

struct Fmt
  {
    char	name[30];	/* Description for menu display */
    byte	type;		/* Identifies disk size (8", 5"x40, 5"x80) */
    byte	density;	/* Single/Double-density flag */
    byte	dsMethod;	/* How to handle 2-sided disks */
    byte	tpd;		/* Tracks per disk (count both sides) */
    byte	spt;		/* Physical sectors per track */
    word	pss;		/* Physical sector size (in bytes) */
    word	blksiz;		/* CP/M block size (in bytes) */
    word	ndir;		/* Number of directory entries */
    word	alloc;		/* Non-0 if ndir doesn't determine it */
    byte	exm;		/* 0xFF if calculated */
    word	off;		/* Number of reserved tracks */
    byte	edByte;		/* Erased data byte */
    word	pigap;		/* Pre-index gap length */
    word	gap1;		/* Gap 1 length */
    word	gap2a;		/* Gap 2 length */
    byte	gap2b;
    byte	gap2c;
    word	gap3a;		/* Gap 3 length */
    byte	gap3b;
    byte	gap3c;
    byte	pSkew[52];	/* Physical skew table */
    byte	lSkew[52];	/* Logical skew table */
  };

#define dEXM	0xFF

/* Track buffer size.  An 8" disk has about 10400 to 10700 bytes per track
   so if we make our buffer 11000 we should be safe.) */

#define TRKBUFSZ 11000

struct DkP
  {
    byte	type;
/*  byte	selBits;  */
/*  byte	stepRate; */
  };

struct Dpb
  {
    word	spt;		/* Logical sectors per track */
    byte	bsh;		/* Block shift factor */
    byte	blm;		/* Block mask */
    byte	exm;		/* Extent mask */
    word	dsm;		/* Data blocks */
    word	drm;		/* Directory entries */
    byte	al0, al1;	/* Directory block allocation */
    word	cks;		/* Checksum vector size */
    word	off;		/* System tracks */
    byte	psh;		/* Physical sector shift factor */
    byte	psm;		/* Physical sector shift mask */
  };

struct xDPH
  {
    byte	dsMethod;
    byte	tpd;
    word	routine[4];
    byte	rDrv;
    byte	selBits;
    byte	*xltt;
    byte	rsv[10];
    struct Dpb	*dpb;
    word	*csv;
    word	*alv;
    word	*dirBCB;
    word	*dtaBCB;
    word	*hash;
    byte	hBank;
  };

extern char loDrive, hiDrive;	/* (Patchable) range of disk drives */
extern byte vClear[], vHighlight[], vInverse[], vNormal[];

#define cls()        video(vClear)
#define highlight()  video(vHighlight)
#define standard()   video(vNormal)
void video();
void cursor();
