/*----------------------------------------------------------------------------

				    M F
				    ===

	Multi-format disk handler for Colex CP/M+ systems with special
	BIOS.  Allows Colex to format, read and write foreign disks.

	Copyright (C)1985:	Jon Saxton
				Tardis Pty Limited.

---------------------------------------------------------------------------*/

#include "stdio.h"
#include "mf.h"

char	*fdcErrs[] =
	    {
		"Not Ready",
		"Write Protected",
		"Write Fault",
		"Seek Error",
		"CRC Error",
		"Lost Data"
	    };

extern char *malloc();
extern byte scc();

extern char selectOne();
extern word bios3();
extern void assign();
extern void examine();

extern struct Fmt
   *ft, *selectFormat();

main()
{
  char	cpmDisk, drive;
  char	select;

  cpmDisk = bdos(CURDSK,0);

  do
    {
      cls();
      highlight();
      printf("\tMulti-format disk handler for Colex 850-series computers\n");
      printf("\twith specially-tailored CP/M Plus floppy-disk BIOS module\n");
      printf("\n\n\tA public-domain program by\tJonathan Richard Saxton\n");
      printf("\t\t\t\t\tP.O. Box 242,\n\t\t\t\t\tDural, NSW 2158\n");
      printf("\t\t\t\t\tAUSTRALIA\n");
      standard();
      printf("\n\n\t\tA.\tAssign a format to a drive");
      printf("\n\n\t\tF.\tFormat a disk");
      printf("\n\n\t\tE.\tExamine a disk");
      cursor(23,8);
      highlight();
      printf("Select option: ");
      standard();
      select = getKey() & 0x5F;
      cls();
      switch (select)
 	{
case 'F':
	  do
	    {
	      if ((drive=getDrive()) >= loDrive && drive <= hiDrive)
		if ((ft = selectFormat(drive)) != (struct Fmt *)NULL)
		  format(drive,ft);
	    }
	  while(drive >= loDrive && drive <= hiDrive);
	  break;

case 'A':
	  if ((drive=getDrive()) >= loDrive && drive <= hiDrive)
	    if ((ft = selectFormat(drive)) != (struct Fmt *)NULL)
	      assign(drive,ft);
	  break;

case 'E':
	  if ((drive=getDrive()) >= loDrive && drive <= hiDrive)
	    examine(drive);

	}
    }
  while (select == 'A' || select == 'E' || select == 'F');

  bios3(SELDSK,0,cpmDisk,1,0);
  bdos(SETDRIVE,cpmDisk);
}

showError(code)
byte code;
{
  word c = 0;
  highlight();
  printf("Disk error: ");
  standard();
  while(code)
    {
      if (code & 0x80)
	printf("%s, ",fdcErrs[c]);
      code <<= 1;
      ++c;
    }
  putchar('\n');
}
