	TITLE 'Colex 800 series diskette tables'
;---------------------------------------------------------------------
;
;	I moved all the floppy disk tables out of the FLOPPY.ASM
;	file because I wanted to translate it to Zilog mnemonics
;	and M80's macro expansion is not good enough to handle
;	the complex macros used in CPM3.LIB.
;
;	Apart from relieving me of the burden of fighting with
;	stupid Intel mnemonics, the relocation of the disk tables
;	speeds up the assembly of FLOPPY.MAC.
;
;
;	Jon Saxton
;	SYSOP,
;	Tesseract RCPM+
;	P.O. Box 242,
;	Dural, NSW 2158,
;	Australia.
;
;---------------------------------------------------------------------

DAVEB	EQU	0

	DSEG

	MACLIB	EQUATES

	 IF	FLOPPIES GT 0
	PUBLIC	FDXD0
	 ENDIF
	 IF	FLOPPIES GT 1
	PUBLIC	FDXD1
	 ENDIF
	 IF	FLOPPIES GT 2
	PUBLIC	FDXD2
	 ENDIF
	 IF	FLOPPIES GT 3
	PUBLIC	FDXD3
	 ENDIF
	PUBLIC	COLEXD,	DPB5A	; Needed by fdInit

	MACLIB	CPM3		; Cp/m 3 disk definition macros
	MACLIB	FDJRS		; My EQUates

	EXTRN	FDINIT,FDLOGI,FDREAD,FDWRIT

;****************************************************************
;*								*
;*	XDPHs for the floppies (each has extra bytes for mode)	*
;*								*
;****************************************************************

	 IF	FLOPPIES GT 0
	DB	LONGTRACK	; High-numbered sectors on side 1
	DB	80		; Number of tracks
	DW	FDWRIT		; Floppy write
	DW	FDREAD		; Floppy read
	DW	FDLOGI		; Floppy login
	DW	FDINIT		; Floppy init
	DB	0		; Relative drive 0
	DB	DDEN OR	FIVE OR	1 ; Mode bits (Drive select mask)
FDXD0:	DPH	TRAN5A,DPB5A	; Params for largest possible drive
	 ENDIF

	 IF	FLOPPIES GT 1
	DB	CYLINDER	; Odd tracks on side 1
	DB	80		; Number of tracks (40 per side)
	DW	FDWRIT		; Floppy write
	DW	FDREAD		; Floppy read
	DW	FDLOGI		; Floppy login
	DW	FDINIT		; Floppy init
	DB	1		; Relative drive 1
	DB	DDEN OR	FIVE OR	2 ; Mode bits (drive select mask)
FDXD1:	DPH	TRAN4B,DPB4B	; 40-track drive
	 ENDIF

	 IF	FLOPPIES GT 2
	 IF	SYSTEM EQ WORK
	DB	CYLINDER	; Odd tracks on side 1
	DB	80		; Number of tracks (40 per side)
	DW	FDWRIT		; Floppy write
	DW	FDREAD		; Floppy read
	DW	FDLOGI		; Floppy login
	DW	FDINIT		; Floppy init
	DB	1		; Relative drive 1
	DB	DDEN OR	FIVE OR	4 ; Mode bits (drive select mask)
FDXD2:	DPH	TRAN5C,DPB5C	; 40-track drive
	 ENDIF
	 IF	SYSTEM EQ RCPM
	DB	CYLINDER	; Odd tracks on side 1
	DB	154		; Number of tracks (77 per side)
	DW	FDWRIT		; Floppy write
	DW	FDREAD		; Floppy read
	DW	FDLOGI		; Floppy login
	DW	FDINIT		; Floppy init
	DB	2		; Relative drive 2
	DB	DDEN OR	EIGHT OR 4 ; Mode bits (Drive select mask)
FDXD2:	DPH	TRAN8C,DPB8C	; Params for largest posible drive
	 ENDIF
	 ENDIF

	 IF	FLOPPIES GT 3
	DB	CYLINDER	; Odd tracks on side 1
	DB	154		; Number of tracks (77 per side)
	DW	FDWRIT		; Floppy write
	DW	FDREAD		; Floppy read
	DW	FDLOGI		; Floppy login
	DW	FDINIT		; Floppy init
	DB	3		; Relative drive 3
	DB	DDEN OR	EIGHT OR 8 ; Mode bits (Drive select mask)
FDXD3:	DPH	TRAN8D,DPB8D	; Params for largest posible drive
	 ENDIF

;****************************************************************
;*								*
;*		The disk parameter blocks.			*
;*								*
;****************************************************************
	CSEG

;5.25" configurations (80-track)

	 IF	FLOPPIES GT 0
DPB5A:	DPB	1024,10,80,2048,256,0 ; 5" ds/dd 1024 b/s (TurboDOS)
	 ENDIF

;5.25" configurations (40-track)

	 IF	FLOPPIES GT 1
DPB4B:	DPB	1024,5,80,2048,192,2 ; 5" ds/dd 1024 b/s (MD3)
	 ENDIF

;8" configurations

	 IF	FLOPPIES GT 2
	 IF	SYSTEM EQ WORK
DPB5C:	DPB	1024,10,80,2048,256,0 ; 5" ds/dd 1024 b/s (TurboDOS)
	 ENDIF
	 IF	SYSTEM EQ RCPM
DPB8C:	DPB	1024,8,154,2048,256,4
	 ENDIF
	 ENDIF

	 IF	FLOPPIES GT 3
DPB8D:	DPB	1024,8,154,2048,256,4
	 ENDIF

	DSEG			; Colex DPB in banked memory
COLEXD:
	DPB	512,20,80,2048,128,2

;****************************************************************
;*								*
;*		The sector skew tables. 			*
;*								*
;****************************************************************
	DSEG

;5.25" sector skew tables

	 IF	FLOPPIES GT 0
TRAN5A:	SKEW	10,4,1
	SKEW	10,4,11
	DS	TTLENGTH-($-TRAN5A)
	 ENDIF

	 IF	FLOPPIES GT 1
TRAN4B:	SKEW	10,4,1
	DS	TTLENGTH-($-TRAN4B)
	 ENDIF

	 IF	FLOPPIES GT 2
	 IF	SYSTEM EQ WORK
TRAN5C:	SKEW	10,4,1
	SKEW	10,4,11
	DS	TTLENGTH-($-TRAN5C)
	 ENDIF
	 IF	SYSTEM EQ RCPM
TRAN8C:	SKEW	8,3,1
	DS	TTLENGTH-($-TRAN8C)
	 ENDIF
	 ENDIF

;8" sector skew tables

	 IF	FLOPPIES GT 3
TRAN8D:	SKEW	8,3,1
	DS	TTLENGTH-($-TRAN8D)
	 ENDIF
	END
