;******************************************************************
;***								***
;*** BOOT-ROUTINE FUER PROF-180  				***
;***								***
;*** BOOTET CP/M 2.2 VON ALLEN MIT UPD 765 FORMATIERTEN DISKS	***
;*** DAS BETRIEBSSYSTEM MUSS AB SEKTOR, 2 SPUR 0 FORTLAUFEND	***
;*** AUF DER PLATTE STEHEN.					***
;***								***
;*** LETZTE AENDERUNG AM:  20.08.1985 (JOACHIM)			***
;***								***
;******************************************************************
		;
		MACLIB	HD64180
		;
		MACLIB	PDEF
		;
		MACLIB	PSYS
		;
		MACLIB	PVEC
		;
MSIZE		EQU	61		;CP/M MEMORY SIZE IN K-BYTE
BIAS    	EQU     (MSIZE-20)*1024	;
CCP     	EQU     3400H+BIAS	;
BDOS    	EQU     CCP+806H	;
BIOS    	EQU     CCP+1600H	;
CPMBYTES	EQU	2000H		;LAENGE DES BETRIEBSSYSTEMS
		;
		;
		;
BOOTERR		EQU	MBOOTERR
SETCMDT		EQU	MSETCMDT
READ		EQU	MREAD
TEST		EQU	MTEST
		;
		;
		ORG	SYSPAGE-512
		;
		;INNERHALB DES BOOT-PROGRAMMES WERDEN NUR RELATIVE
		;SPRUENGE VERWANDT, (DIE MONITOR CALLS UND DER SPRUNG
		;ZUM BIOS SIND NATUERLICH ABSOLUTE SPRUNGE)
		;DIESE ROUTINE IST DESHALB UEBERALL AUSERHALB DES MONITOR
		;UND CP/M-BETRIEBSSYSTEM BEREICHES LAUFFAEHIG
		;
		;
				;CMDTAB IST SCHON VOM MONITOR FUER SPUR 0 GESETZT
	LXI	H,CPMBYTES	;ANZAHL DER ZU UEBERTRAGENDEN BYTES
	SHLD	RESTBYTES	;
	LXI	H,CCP		;
	SHLD	NEXTDMA		;DMA-ADRESSE FUER NAECHSTE SPUR
	MVI	A,2		;ANFANGS SECTOR DER SPUR
BOOT0	STA	SECTOR		;
	LDA	SECSZ		;BERECHNE BYTES/SEKTOR
	LXI	H,64		;
	INR	A		;
BOOT1	DAD	H		;
	DCR	A		;
	JRNZ	BOOT1		;
	XCHG			;BYTES/SEKTOR IN DE
	LHLD	NEXTDMA		;NEUE DMA-ADRESSE
	SHLD	DMAADR		;FUER READ SETZEN
				;
	LDA	EOT		;
	MOV	C,A		;
	LDA	SECTOR		;
	MVI	B,1		;SEKTOR ZAEHLER
BOOT3	LHLD	NEXTDMA		;BERRECHNE ANZAHL DER SEKTOREN
	DAD	D		;DIE VON DIESER SPUR GELESEN WERDEN
	SHLD	NEXTDMA		;SOLLEN. SETZE DABEI GLEICHZEITIG NEXTDMA
	LHLD	RESTBYTES	;UND RESTBYTES FUER NAECHSTE SPUR. WERDEN
	DSBC	D		;BEI DIESER SPURR ALLE BYTES GELESEN, DANN
	JRNC	BOOT4		;SETZE RESTBYTES AUF 0
	LXI	H,0		;
	SHLD	RESTBYTES	;
	JR	BOOT5		;
BOOT4	SHLD	RESTBYTES	;
	CMP	C		;LETZTER SEKTOR
	JRZ	BOOT5		;
	INR	A		;
	INR	B		;
	JR	BOOT3		;
				;
BOOT5	MOV	A,B		;LEGE BERRECHNETE SEKTORZAHL AB
	STA	SECTCNT		;
	CALL	READ		;LESE EINE SPUR
	JNZ	BOOTERR		;BEI FEHLER MIT MELDUNG ZUM MONITOR
	LHLD	RESTBYTES	;WENN RESTBYTES GLEICH
	MOV	A,H		;NULL, DANN KANN ZUM BIOS
	ORA	L		;GESPRUNGEN WERDEN
BOOT7	JZ	BIOS		;
				;
	LDA	TEST$TYPE	;LADE MAXIMAL 2 SPUREN BEI MAXI
	ANI	20H		;BZW. 3 SPUREN BEI MINI
	MVI	C,2		;
	JRZ	BOOT6		;
	MVI	C,3		;
BOOT6	LDA	TRACK		;ERHOEHE SPUR UM EINS
	INR	A		;
	CMP	C		;GENUG SPUREN GELESEN
	JRZ	BOOT7		;DANN SPRINGE EBENFALLS ZUM BIOS
	STA	TRACK		;
	STA	TEST$TRACK	;TESTE NAECHSTE SPUR
	CALL	TEST		;
	CALL	SETCMDT		;SETZE CMDTAB FUER SPUR > 0
	MVI	A,1		;LESE ALLE ANDEREN SPUREN AB SEKTOR EINS
	JR	BOOT0		;
				;
				;
				;
		ORG	SYSPAGE -4
				;
RESTBYTES	DS	2	;ZELLEN FUER BOOT ROUTINE
NEXTDMA		DS	2	;
				;
				;
	END
