;**************************************************************************
;***									***
;***  BOOT-LOADER FUER OMTI BZW. WESTERN DIGITAL HARDDISK CONTROLLER	***
;***									***
;***  Version fuer PROF-180X						***
;***									***
;***  LETZTE AENDERUNG AM : 03.11.1987  (C) CONITEC, J. HANST		***
;***									***
;**************************************************************************
;
	MACLIB	HD64180
;
; DIE DATEN WERDEN AB DEM NACHFOLGEND ANGEGEBENEN SEKTOR GELADEN

LSECT	EQU	1		; SEKTOR NUMMER
LTRK	EQU	0		; SPUR NUMMER
LHEAD	EQU	0		; KOPF NUMMER
LCNT	EQU	16		; ANZAHL DER SEKTOREN DIE GELADEN WERDEN
;
; LADE ADRESSE DER DATEN

LADDR	EQU	04900H		; FUER CPMLDR.COM
;
; STARTADRESSE DIESES PROGRAMMS

;
HBADDR		EQU	0FC00H	; FUER PROF-180X UND PROF-80

HDINITDATA	EQU	HBADDR+492	; HARDDISKDATEN BEFINDEN
HDCNTLBYTE	EQU	HBADDR+500	; SICH IM BOOTSEKTOR
;
; PORTADRESSEN DES CONTROLLERS AUF ECB-BUS (MIT ECPC VON CONITEC)

ODATA	EQU	0E0H
OSTATUS	EQU	0E1H
OCONFIG	EQU	0E2H
OMASK	EQU	0E3H
ORESET	EQU	0E1H
OSELECT	EQU	0E2H

				;
	ORG	HBADDR		;
				;
START:				;
	CALL	HDREAD		; SEKTOR ADRESSE IST SCHON GESETZT
	JNZ	FAILURE		; FEHLER, AUFGETRETEN
	JMP	LADDR		; NEIN, ZUM CPMLDR SPRINGEN


SELECT:				; SELECT OMTI CONTROLLER
	OUT	OSELECT		;
SELECT1	IN	OSTATUS		; WAIT FOR CONTROLLER SELECTED
	ANI	00111111B
	CPI	00001101B	; WAIT UNTIL COMMANDTRANSFER IS READY
	JRNZ	SELECT1		;
	RET			; END OF PROCEDURE


SENDCMD:			; SEND COMMAND (6 BYTE) FROM CMDFIELD 
				; TO OMTI CONTROLLER
	CALL	SELECT		; FIRST SELECT CONTROLLER
	LXI	H,HDCMDTAB	; POINT TO CMDFIELD
SCMD2:	MVI	B,6		; BYTE COUNTER
	MVI	C,ODATA		; POINTER TO OMTI DATAPORT
SCMD1:	IN	OSTATUS		; READ STATUSBYTE
	ANI	00111111B
	CPI	00001101B	; READY FOR WRITE COMMAND BYTE ?
	JRNZ	SCMD1		; NO, WAIT UNTIL READY
	OUTI			; WRITE COMMANDBYTE TO OMTI
	JRNZ	SCMD1		; UNTIL ALL DONE
	RET			; END OF PROCEDURE


READSTATUS:			; READ STATUSBYTE AND RESET ZEROFLAG
				; ANY ERROR
	IN	OSTATUS		; READ CONTOLLER STATUSBYTE
	ANI	00111111B
	CPI	00001111B	; READY FOR STATUS READ ?
	JRNZ	READSTATUS	; NO, WAIT UNTIL READY
	IN	ODATA		; OK, READ STATUSBYTE
	ORA	A		; 
	RET			; END OF PROCEDURE


READBUFFER:			; READ OMTI DATABUFFER TO (HL)
	LDA	HDCMDTAB+4	; LADE BLOCKANZAHL IN REGISTER E
	MOV	E,A		;
READBUFF1:			;
	IN	OSTATUS		; WAIT FOR DATA READ TRANSFER
	ANI	00111111B	;
	CPI	00001111B	; 
	RZ			; NO TRANSFER IN ERROR CASE
	CPI	00001011B	;
	JRNZ	READBUFF1	;
	LXI	B,ODATA		; CLEAR B AND SET C TO DATAPORT
	INIR			; READ 256 BYTE
	INIR			; READ THE NEXT 256 BYTE
	DCR	E		; LESE ALLE BLOECKE
	JRNZ	READBUFF1	;
	RET			; END OF PROCEDURE


SETADDR:			; SET ADDRESS
	LHLD	HDTRACK		; LOAD CYLINDER IN HL REGISTER
	MOV	A,L		; COPY LOWER BYTE
	STA	HDCMDTAB+3	; IN HDCMDTAB
	LDA	HDSECTOR	; LOAD SECTOR
	ANI	00111111B	; MASK SECTOR BITS
	MOV	B,A		; SAVE SEKTOR IN B
	LDA	HDHEAD		; LOAD HEAD
	ANI	00011111B	; MASK HEAD BITS
	MOV	C,A		; SAVE HEAD IN B
	RRCR	H		; ROTATE H
	RRCR	H		;
	MOV	A,H		;
	ANI	11000000B	; MASK UPPER 2 BITS
	ORA	B		; OR SECTOR
	STA	HDCMDTAB+2	; SAVE IN HDCMDTAB
	RRCR	H		; ROTATE H AGAIN
	MOV	A,H		;
	ANI	10000000B	; MASKE UPPER BIT
	ORA	C		; OR HEAD
	STA	HDCMDTAB+1	; AND SAVE IN HDCMDTAB
	RET			; END OF PROCEDURE

HDREAD:				; READ ONE SECTOR
	MVI	A,008H		; SET READ COMMAND
	STA	HDCMDTAB	; AND SAVE IN CMDFIELD
	CALL	SETADDR		; COMPUTE ADDRESS FOR CMDFIELD
	LDA	SECTCNT		; SETZE BLOCKZAEHLER
	STA	HDCMDTAB+4	;
	LDA	HDCNTLBYTE	; SETZE CONTROLL-BYTE
	STA	HDCMDTAB+5	;
	CALL	SENDCMD		; SEND COMMAND
	LHLD	DMAADR		; LOAD DMA ADDRESS
	CALL	READBUFFER	;
	CALL	READSTATUS	;
	RZ			; END OF IF NO ERROR PROCEDURE
				;
HDERR:	LXI	H,HDERRTXT	; GEBE FEHLERTEXT AUS
	CALL	SOUT		;
	MVI	A,0FFH		;
	ORA	A		;
	RET			;

HDERRTXT:
	DB	0DH,0AH,007H
	DB	' Harddisk error'
	DB	0DH,0AH,24H
;
;
SOUT:				; GEBE STRING AUS BIS $
	MOV	A,M		;
	CPI	'$'		;
	RZ			;
	MOV	C,A		;
	CALL	CO		;
	INX	H		;
	JR	SOUT		;
;
CO:	JMP	9
;	
FAILURE:
	RST	7
;
HDTRACK:	DW	LTRK
HDSECTOR:	DB	LSECT
HDHEAD:		DB	LHEAD
SECTCNT:	DB	LCNT
DMAADR:		DW	LADDR
;
HDCMDTAB:
	DB	0,0,0,0,0,0

	END
