;******************************************************************
;***								***
;*** LADER-BOOT-ROUTINE FUER PROF-80 				***
;***								***
;*** ASSEMBLIERUNG ERFOLGT MIT RMAC				***
;*** LINKEN MIT LINK URBOOT[LFD80]=URBOOT			***
;***								***
;*** LAEDT CPMLDR VON RAM-DISK DISI.				***
;*** CPMLDR MUSS AB DEM ZWEITEN SEKTOR DER SPUR 0 FORTLAUFEND,	***
;*** AUF DER PLATTE STEHEN.					***
;***								***
;*** CPMLDR MUSS C00H LANG SEIN					***
;***								***
;*** DER LADER STELLT FOLGENDE ANFORDERUNGEN AN DAS FORMAT:	***
;*** 								***
;*** 1)	DURCHGEHENDE NUMMERIERUNG DER SEKTOREN			***
;***								***
;*** LETZTE AENDERUNG AM:  21.01.1986 (JOACHIM)			***
;***								***
;******************************************************************
		;
		MACLIB	Z80
		;
		MACLIB	MONVEC
		;
		MACLIB	SYSPAGE
		;
CPMLDR     	EQU     4900H		;STARTADRESSE DES CPMLDR
					;
					;
	CSEG				;MONITOR LAEDT BOOTSTRAPLOADER
					;NACH FD80H
					;
	JR	BOOT$START		;
					;
STRACKS	DB	1			;IN DIESEM BYTE STEHT DIE ANZAHL DER
					;SPUREN, DIE GELESEN WERDEN SOLLEN.
					;
SIGN	DB	'PROF-80 '		;KENNUNG DES BOOTSTRAP LOADERS
	DB	'(C) CONITEC 1985'	;
					;
					;
BOOT$START:				;BEGIN DES PROGRAMCODES
					;
	XRA	A			;TRACK 0
	STA	TRACK			;
	MVI	A,2			;
	STA	SECTOR			;SEKTOR 2
	MVI	A,24			;
	STA	ZAEHLER			;ANZAHL DER SEKTOREN
	LXI	H,CPMLDR		;
	SHLD	DMAADR			;DMA ADRESSE
WRLOOP:	CALL	MDREAD			;
	LDA	SECTOR			;
	INR	A			;
	STA	SECTOR			;
	LXI	D,128			;
	LHLD	DMAADR			;
	DAD	D			;
	SHLD	DMAADR			;
	LDA	ZAEHLER			;
	DCR	A			;
	STA	ZAEHLER			;
	JRNZ	WRLOOP			;
	LXI	H,0			;CHECKSUM TEST
	MVI	D,0			;
	LXI	B,CPMLDR		;
CHKSUM:	LDAX	B			;
	MOV	E,A			;
	DAD	D			;
	INX	B			;
	MOV	A,B			;
	CPI	55H			;
	JRNZ	CHKSUM			;
	ORA	A			;
	LXI	D,0D4A0H		;
	DSBC	DE			;
	JNZ	MBOOTERR		;
	JMP	CPMLDR			;
					;
ZAEHLER:
	DS	1

	END				;
