(************************************************************)
(*                                                          *)
(* Dieses Programm bringt die CP/Mlader auf die Systemspur  *)
(* der RAM-DISK DISI. Das Laderfile ist ein Immage der      *)
(* Systemspur.                                              *)
(*                                                          *)
(*                                     (c) Conitec JH 1986  *)
(*                                                          *)
(************************************************************)

const

valid_lw = 'G';    (* Geben Sie hier den Buchstaben des Operations- *)
                   (* laufwerks ein                                 *)

var

source      : file;
sourcename  : string[12];
sector      : integer;
track       : integer;
drive       : integer;
dmabuffer   : array[1..128] of byte;
i,recsread  : integer;



procedure dbc(no:integer;areg:integer;bc,de,hl:integer);

type

pbarec      = record

            no      : byte;
            areg    : byte;
            bc      : integer;
            de      : integer;
            hl      : integer;

            end;

var

pba         : pbarec;


begin
  pba.no:=no;
  pba.areg:=areg;
  pba.bc:=bc;
  pba.de:=de;
  pba.hl:=hl;
  bdos(50,addr(pba));
end;

procedure setsec(sec:integer);
begin
  dbc(11,0,sec,0,0);
end;

procedure settrk(trk:integer);
begin
  dbc(10,0,trk,0,0);
end;

procedure setdma(dma:integer);
begin
  dbc(12,0,dma,0,0);
end;

procedure writesec;
begin
  dbc(14,0,0,0,0);
end;

function right_lw:boolean;

var

ch      : char;
flag    : boolean;

begin
  write('Floppy to operate with : ');
  read(kbd,ch);
  ch:=upcase(ch);
  writeln(ch);
  drive:=(ord(ch)-65);
  flag:=true;
  if drive <> (ord(valid_lw)-65) then
  begin
    flag:=false;
    writeln('error, wrong drive name');
    writeln;
  end;
  right_lw:=flag;
end;





begin (* Hauptprogramm *)
 for i:=1 to 16 do writeln;
 if right_lw then
  begin
  (* waehle laufwerk  aus                *);
  bdos(14,drive);
  writeln;
  write('Loaderfile = ');
  readln(sourcename);
  assign(source,sourcename);
  {$I-} reset(source) {I+};
  if ioresult <> 0 then
  begin
   writeln;
   writeln('Read Error on G:');
   writeln;
   halt
  end;
  track:=0;
  sector:=1;
  i:=0;
  setdma(addr(dmabuffer));
  repeat
    if (i mod 4) = 0 then writeln;
    write('sec',sector:3,' trk',track:3,'    ');
    blockread(source,dmabuffer,1,recsread);
    setsec(sector);
    settrk(track);
    writesec;
    i:=i+1;
    sector:=sector+1
  until sector = 64;
  close(source);
  bdos(13);
  writeln;
  writeln;
  writeln('RAM-Disk is bootable now');
  writeln
 end
end.