	title 'bank & move module for CP/M3 linked BIOS'

	; letzte Aenderung am:
	; 06.08.1985 (Joachim)	

	cseg

	public ?move,?xmove,?bank
	extrn @cbnk

	maclib z80

	maclib cdef

	maclib syspage

?xmove:
	sbcd	sbank		; lege source und dest. bank ab
	mvi	a,0ffh		; setze flag fuer xmove
	sta	x$flg		;
	ret

sbank	db	0		; source bank fuer xmove
dbank	db	0		; destination bank fuer xmove
x$flg	db	0		; flag fuer xmove aktiv
sadrs	dw	0		; zwischenspeicher fuer xmove
dadrs	dw	0		;
length	dw	0		;

?move:
	xchg			; we are passed source in DE and dest in HL
	lda	x$flg		; xmove aktiv?
	inr	a		;
	jrz	xmv		; sprung wenn ja
	ldir			; use Z80 block move instruction
	xchg			; need next addresses in same regs
	ret

xmv:	sded	dadrs		; save destination
	sbcd	length		; save length
	lda	sbank		; switch to source bank
	call	?bank		;
	lxi	d,xmv$buff	; ziel ist buffer
	ldir			; uebertrage
	shld	sadrs		;
	lda	dbank		; switch to dest. bank
	call	?bank		;
	lded	dadrs		;
	lbcd	length		;
	lxi	h,xmv$buff	;
	ldir			;
	lda	@cbnk		; orginal bank ein
	call	?bank		;
	xchg			;
	lded	sadrs		;
	xra	a		;
	sta	x$flg		;
	ret

xmv$buff:	ds	128

?bank:
	push	d		;
	push	b		;
	sta	current$bank	; wichtig fuer cinit u. csysgen
	if	tram		; falls Turbo-RAM installiert
	cpi	2		; dann alle Banks ueber 2 auf
	jnc	tbank		; Turbo-RAM
	endif			;
	lxi	b,p$ram$table	; schalte angewaehlte
	mvi	d,16		; bank bis zur commongrenze ein
	ani	00000111b	; (nur bank 0 bis bank 5 moeglich)
	adi	2		; Offset fuer PROF-80 RAM Dekodierung
	mov	e,a		; ausgewaehlte bank in e
bank1	outp	e		; setze eine kachel
	mov	a,b		; erhoehe kachel adresse
	add	d		;
	mov	b,a		;
	cpi	80h		; gleich 80 hex?
	jrnz	bank2		;
	mov	a,e		; dann oberer 32k block anwaehlen
	ori	00001000b	;
	mov	e,a		;
bank2	mov	a,b		;
	cpi	com$page	; commengrenze erreicht?
	jrnz	bank1		;
bank3	pop	b		;
	pop	d		;
	ret

	if	tram
tbank:
	sui	2		; bank weniger 2
	if	chip64		; richte bank falls 64K chips
	mov	c,a
	ani	1		;
	mov	b,a		;
	mov	a,c		;
	rlc			;
	rlc			;
	ani	78h		;
	ora	b		;
	else			;
	ani	7fh		;
	endif			;
	push	psw		; rette bank
	lxi	b,4000h+tram$mem	; schalte RAM-Bank ein
	ani	0fh		;
	mov	e,a		;
	call	tbank3		;
	pop	psw		;
	rrc ! rrc ! rrc ! rrc	;
	ani	7		;
	mov	e,a		;
	mvi	d,0		;
	push	h		;
	lxi	h,blockt	;
	dad	d		;
	mov	e,m		;
	pop	h		;
	lxi	b,4000h+p$ram$table
	call	tbank3		;
	pop	b		;
	pop	d		;
	ret			;
				;
tbank3	mvi	d,16		;
tbank1	outp	e		;
	mov	a,b		;
	add	d		;
	mov	b,a		;
	cpi	0c0h		;
	jrnz	tbank1		;
	ret			;
	
blockt	db	0eh,0fh,0ch,0dh,06h,07h,04h,05h
	
	endif

	end
