
	title	'Turbo-RAM floppy handler for PROF-80'

; CP/M-80 Version 3.0

; letzte Aenderung am 27.08.1985 (Joachim)
;
; Dieser Treiber ist nur wichtig, wenn Turbo-RAM benutzt wird
; und noch Platz fuer die Ramfloppy da ist.
;

	dseg

	public	fdtram

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk

	extrn	@ermde

	extrn	?xmove
	extrn	?move
	extrn	?bank

	extrn	ciecho,?pmsg

	maclib	cpm3

	maclib	z80

	maclib	cdef

	if	tram and (ram$floppy$bank le (tspace/32+1))


; berechne Kapazitaet der RAM-Floppy in K-Byte

rspace	equ	tspace-((ram$floppy$bank-2)*32)

; berechne daraus die restlichen Parameter der RAM-Floppy

block	set	1024
dirs	set	32
	if	rspace gt 96
dirs	set	64
	endif
	if	rspace gt 256
block	set	2048
dirs	set	128
	endif
	if	rspace gt 512
dirs	set	256
	endif
	if	rspace gt 1024
dirs	set	512
	endif
	if	rspace gt 2048
block	set	4096
dirs	set	1024
	endif

; Extended Disk Parameter Header (XDPH)

	dw	r$write
	dw	r$read
	dw	r$login
	dw	r$init
	db	0,0
fdtram	dph	0,dpbr,0,rspace/(block/1024)/4

	cseg

dpbr	dpb	128,128,rspace/16,block,dirs,0,8000h

	dseg

r$read:
	call	getadr		;berechne adresse und bank des ram sektors
	lda	@dbnk		;zielbank
	mov	b,a		;nach b
	lda	rbnk		;quellbank
	mov	c,a		;nach c
	call	?xmove		;
	lhld	@dma		;zieladresse
	lded	rdma		;quelladresse
	lxi	b,128		;
	call	?move		;
	xra	a		;keine fehler
	ret			;


r$write:
	call	getadr		;berechne adresse und bank des ram sektors
	lda	@dbnk		;quellbank
	mov	c,a		;nach c
	lda	rbnk		;zielbank
	mov	b,a		;nach b
	call	?xmove		;
	lded	@dma		;quelladresse
	lhld	rdma		;zieladresse
	lxi	b,128		;
	call	?move		;
	xra	a		;keine fehler
	ret			;


getadr:
	lda	@trk		;lade spur
	rrc			;
	mov	c,a		;rette in c
	ani	7fh		;maskiere relevante bits
	adi	ram$floppy$bank	;addiere anfangsbank dazu
	sta	rbnk		;
	mov	a,c		;
	ani	80h		;
	sta	rdma		;
	lda	@sect		;lade sektor
	adi	40h		;bank anfang
	sta	rdma+1		;
	ret			;

rbnk	ds	1		;
rdma	ds	2		;

r$login:
	ret

r$init:
	lxi	h,eraqtxt	;
	call	?pmsg		;
	call	ciecho		;
	cpi	'Y'		; soll nicht geloscht werden ?
	rnz			; dann return.

	mvi	a,ram$floppy$bank	;loesche RAM-Floppy
	call	?bank		;Directory
	mvi	a,0e5h		;
	sta	4000h		;
	lxi	h,4000h		;
	lxi	d,4001h		;
	lxi	b,7fffh		;
	ldir			;
	xra	a		;wieder bank0
	call	?bank		;
	ret

eraqtxt:
	db	0dh,0ah
	db	'erase RAM-Floppy (Y/N) ?',0

	endif
	end

	