	title 'PROF-80 Multi density diskette handler with manuell LOGIN'

;    CP/M-80 Version 3     --  Modular BIOS

;	Disk I/O Module for PROF-80

	;		Letzte Aenderung am 24.11.1984 (Joachim)


	maclib cdef
;
	maclib cpm3
;
	maclib z80
;
	maclib monvec
;
	maclib syspage


	dseg


    ; Disk drive dispatching tables for linked BIOS

	public	fdt40

    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk

    ; System Control Block variables

	extrn	@ermde		; BDOS error mode

    ; Utility routines in standard BIOS

	extrn	?wboot	; warm boot vector
	extrn	?pmsg	; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec	; print binary number in <A> from 0 to 99.
	extrn	?pderr	; print BIOS disk error header
	extrn	ciecho	; con in and echo
	extrn	?const	; get console status
	extrn	?bank

    ; Utility routines in PROF-80 BIOS

	extrn	monon,monoff
	extrn	setmem,roderw,bank0


    ; common control characters

cr	equ 13
lf	equ 10
bell	equ 7

dummy	equ 9999h

invers	equ nein

    ; Extended Disk Parameter Headers (XPDHs)

	dw	fd$write
	dw	fd$read
	dw	fd$login0
	dw	fd$init
	db	0,0		;relative drive zero
fdt80:	dph     dummy,dpb0,128,180

	dw	fd$write
	dw	fd$read
	dw	fd$login1
	dw	fd$init
	db	0,0		;relative drive one
fdt40:	dph     dummy,dpb0,128,180

	cseg	; DPB must be resident

dpb0:	dpb 1024,9,160,2048,512,4
dpbvrt:	dpb 512,9,160,4096,128,2
dpbkyp: dpb 512,10,40,1024,64,1
dpbmsd: dpb 512,18,40,2048,64,0
dpbbon: dpb 256,18,80,2048,128,2
dpbosc: dpb 1024,5,40,1024,64,3


	if invers

comp$dat:			;DIESE ROUTINE MUSS IM COMMON-BEREICH
				;LIEGEN. SIE WIRD LEDIGLICH BEIM LESEN
				;UND SCHREIBEN VON DISKETTEN MIT INVERTIERTEN
				;DATEN BENOETIGT.
				;
	push	psw		;
	lhld	@dma		;LOAD DMA - ADDRESS
	push	h		;
	lda	@dbnk		;SWITCH TO DMA-BANK
	call	?bank		;
	lxi	h,040h		;CALCULATE SECTOR - SIZE
	lda	secsz		;
	inr	a		;
	mov	b,a		;
calc:	dad	h		;SECTORSIZE = (2^(SECSZ+1))*040H
	djnz	calc		;
	pop	d		;SECTORSIZE IN HL, DMA IN DE
compl:	ldax	d		;COMPLEMENT (HL) BYTES STARTING AT (DE)
	cma			;
	stax	d		;
	dcx	h		;
	inx	d		;
	mov	a,h		;
	ora	l		;
	jrnz	compl		;
	call	?bank		;SCHALTE ZURUECK AUF BANK 0
	pop	psw
	ret

	endif
;
;

	dseg

skew18:	skew	18,1,0

skew5:	skew	5,1,1

skew9:	skew	9,1,1

skew9a:	skew	9,1,1
	skew1	9,1,1

skew10:	skew	10,1,0


    ; Disk I/O routines for standardized BIOS interface

; Initialization entry point.

;		called for first time initialization.


fd$init:
	ret



fd$login0:
		; This entry is called when a logical drive is about to
		; be logged into for the purpose of density determination.

		; It may adjust the parameters contained in the disk
		; parameter header pointed at by <DE>

	push	d		;
login1:
	lxi	h,form80info	;
	call	?pmsg		;
	call	ciecho		;
	sui	31h		;
	cpi	1		; hoechste Formatnummer
	jrnc	login1		;
	pop	d		;
	jr	login3		;

fd$login1:
	push	d		;
login2:
	lxi	h,form40info	;
	call	?pmsg		;
	call	ciecho		;
	sui	31h		;
	cpi	4		; hoechste Formatnummer
	jrnc	login2		;
	pop	d		;
	adi	1		; Offset fuer Typtabelle nach 80 Spur Formaten
login3:
	lxi	h,-1		; zeiger auf drive typ
	dad	d		;
	mov	m,a		; setze drive type in xdph
	mov	l,a		; setze dph
	mvi	h,0		;
	dad	h		;
	dad	h		;
	dad	h		;
	dad	h		;
	lxi	b,disk$type$list+4
	dad	b		; hl zeigt auf dpb adr
	push	h		;
	exx			; zweitregistersatz
	pop	h		;
	mov	c,m		;
	inx	h		;
	mov	b,m		;
	inx	h		;
	mov	e,m		;
	inx	h		;
	mov	d,m		;
	exx			;
	push	d		; dph adr. in zweitregister
	exx			;
	pop	h		;
	mov	m,e		;
	inx	h		;
	mov	m,d		;
	lxi	d,11		;
	dad	d		;
	mov	m,c		;
	inx	h		;
	mov	m,b		;
	exx			;
	lda	@rdrv		;
	ani	03h		;
	sta	unit		;
	mvi	b,3		;
	mvi	a,1		;
	sta	test$track	;
test:	push	b		;
	call	monon		;
	call	mtest		;
	call	monoff		;
	pop	b		;
	ora	a		;
	rz			;
	djnz	test		;
	ret			;


; disk READ and WRITE entry points.

		; these entries are called with the following arguments:

			; relative drive number in @rdrv (8 bits)
			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)
			; pointer to XDPH in <DE>

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>
fd$write:
	mvi	a,0ffh
	jr	rwcom


fd$read:
	xra	a
rwcom:
	sta	roderw		; read oder write
	xchg			; save dph adress
	shld	current$dph
more$retries:
	mvi	a,0ffh		; unterdruecke fehlermeldung
	sta	dermsg
	mvi	a,5		; fuenf versuche
	sta	rwretry

	if invers

	call	rwcom4

	else
	
	call	rwcom1		; lesen und schreiben von common

	endif

	ora	a		; fehler?
	jrz	rwcom3		; sprung wenn nein
	lda	rest+1		; write protect?
	ani	2		;
	jrnz	rwcom3		; ja, fehlercode 2 (zufall)
	lda	@ermde		; fehlermeldung zugelassen?
	sta	dermsg

	if invers

	call	rwcom4

	else

	call	rwcom1		; zweiter lese-schreib-versuch

	endif

	ora	a
	jrz	rwcom3
	lda	@ermde
	ora	a
	jrnz	rwcom6
	lxi	h,retrymsg
	call	?pmsg
	call	ciecho
	cpi	'Y'
	jrz	more$retries
rwcom6	mvi	a,1
rwcom3	ret

	if invers

rwcom4:
	lda	roderw
	ora	a
	cnz	comp$dat
	call	rwcom1
	jmp	comp$dat

	endif

retrymsg:
	db	10,13,' Retry (Y/N) ?',0


setup:
	; setze alle parameter in CMDTAB
	; setze 9229 auf mini/maxi betrieb

	lhld	current$dph	; zeiger auf plattentyp setzen
	xchg			;
	lxi	h,-1		;
	dad	d		;
	mov	l,m		; zeiger auf disk$type$list eintrag
	mvi	h,0		;
	dad	h		;
	dad	h		;
	dad	h		;
	dad	h		;
	lxi	b,disk$type$list;
	dad	b		;
	push	h		;
	popix			;
	call	miniset		;
	ldx	a,0		; setze diskformat in cmdtab
	mov	c,a		;
	ani	40h		; setze mfm bit
	sta	cmdtab		;
	mov	a,c		; setze sektorgrroesse
	ani	00000011b	;
	sta	secsz		;
	ora	a		; setze dtl
	mvi	a,0ffh		;
	jrnz	setup3		;
	mvi	a,80h		;
setup3	sta	dtll		;
	ldx	a,1		;
	sta	eot		;
	ldx	a,2		; setze gap laenge
	sta	gapll		;
	ldx	a,3		; setze write precompensation
	sta	write$precom	;
	lda	@rdrv		; laufwerk
	ani	00000011b	;
	sta	unit		;
	lda	@trk		; lade spur nach
	mov	c,a		; register c
	lda	@sect		; lade sektor nach
	mov	b,a		; register b
	ldx	a,10		; welche track reihenfolge (VERFAHREN) ?
	ani	00000111b	; 
	jrz	ttrans0		; VERFAHREN 1
	cpi	1		;
	jrz	ttrans1		; VERFAHREN 2
	cpi	2		;
	jrz	ttrans2		; VERFAHREN 3
	cpi	3		;
	jrz	ttrans3		; VERFAHREN 4
				; wenn Bit2 gesetzt, dann
	jr	ttrans4		; VERFAHREN 5
				;
ttrans0:			; VERFAHREN 1 spur umwandlung, es gilt:
				; eine spur besteht aus vorder- und
				; rueckseite. das oberste bit der sektor-
				; angabe gibt die seite an. dieses verfahren
				; wurde bei prof-80 ausschliesslich verwendet.
				; einseitige prof-80 formate lassen sich
				; gleichwertig mit VERFAHREN 1, 3
				; oder 4 verwirklichen. fuer zweiseitige
				; prof-80 formate sind VERFAHREN 1 und 2
				; moeglich, VERFAHREN 2 ist jedoch guenstiger,
				; da sektran-tabelle um faktor 2 kleiner wird.
				; mit VERFAHREN 1 lassen sich exotische
				; formate mit beliebig wechselnden sektoren
				; auf vorder- und rueckseite verwirklichen.
				;
	mov	d,b		; sektor nach reg. d
	mov	a,b		; und akku kopieren.
	ani	01111111b	; blende oberstes bit aus
	mov	b,a		; ergibt richtiger sektor.
	mov	a,d		; oberstes bit gibt seite an
	rlc			; also schiebe oberstes bit in unterstes
	ani	00000001b	; und maskiere es.
	jr	setup4		;
				;
ttrans1:			; VERFAHREN 2 spur umwandlung, es gilt:
				; v0,r0,v1,r1,........,vn,rn
				;
	mov	d,c		; kopiere spur in reg. c
	mov	a,c		; und in akku.
	rrc			; teile spur durch 2
	ani	01111111b	; und lege neue spur
	mov	c,a		; wieder in c ab.
	mov	a,d		; head gleich
	ani	00000001b	; unterstem altspur bit.
	jr	setup4		; weiter bei setup4
				;
ttrans2:			; VERFAHREN 3 spur umwandlung, es gilt:
				; v0,v1,........vn,r0,r1,......rn
				;
	ldx	a,11		; lade anzahl der spuren einer seite nach a.
	mov	d,a		; kopiere anzahl der spuren nach reg. d
	dcr	a		; spuren beginnen mit null, 1 weniger
	cmp	c		; ist aktuelle spur groesser als letzte spur ?
	mvi	a,0		; nein, dann seite 0
	jrnc	setup4		; und weiter.
	mov	a,c		; sonst rueckseite
	sub	d		; bei spur 0 weiter
	mov	c,a		;
	mvi	a,1		; und seite eins anwaehlen.
	jr	setup4		;
				;
ttrans3:			; VERFAHREN 4 spur umwandlung, es gilt:
				; v0,v1,......,vn,rn,rn-1,.......,r0
				;
	ldx	a,11		; lade anzahl der spuren einer seite nach a.
	mov	d,a		; kopiere anzahl nach reg d.
	dcr	a		; eins weniger.
	cmp	c		; ist aktuelle spur groesser als letzte spur ?
	mvi	a,0		; nein, dann seite 0
	jrnc	setup4		; und weiter.
	mov	a,d		; anzahl der spuren nach a
	add	d		; verdoppeln
	dcr	a		; und weniger eins.
	sub	c		; ziehe aktuelle spur ab
	mov	c,a		; ergibt spurnr. auf rueckseite.
	mvi	a,1		; setzte rueckseite.
	jr	setup4		;
				;
ttrans4:			; VERFAHREN 5 spur umwandlung. 
				; Es wird kein fester Algorithmus verwendet,
				; sondern eine Trackuebersetzungstabelle
				; herangezogen. Byte 8 und 9 des
				; Disktypelisteintrags zeigen auf die gueltige
				; Uebersetzungstabelle. Ist Bit8 eines Eintrages
				; in der Trackuebersetzungstabelle gesetzt,
				; dann wird die Rueckseitenspur verwendet.
				;
	ldx	l,8		; lade zeiger auf trackuebersetungstabelle
	ldx	h,9		; nach hl.
	mov	e,c		; setze zeiger auf relativen eintrag
	mvi	d,0		; zur gewuenschten spur.
	dad	d		; ok, hl zeigt auf richtige spur.
	mov	a,m		; lade nach a
	ani	01111111b	; und blende rueckseitenbit aus.
	mov	c,a		; spur nach c.
	mov	a,m		; rueckseitenbit in akku.
	rlc			;
	ani	00000001b	;
	jr	setup4		;
				;
setup4:				; trage die aus dem jeweiligen VERFAHREN
				; gewonnenen Werte in die CMDTAB ein.
				;
	ora	a		; 
	jrz	setup5		;
				;
	bitx	4,10		; headbit auf rueckseite
	jrnz	setup6		;
	mvi	a,00000010b	;
	jr	setup6		;
				;
setup5:	bitx	4,0		; headbit auf vorderseite
	jrz	setup6		;
	mvi	a,00000011b	;
				;
setup6:	sta	head		;
	mov	a,c		;
	sta	track		;
	mov	a,b		;
	sta	sector		;
	ret			;

miniset:
	push	psw
	mvi	a,pad$mini or 1
	out	p$ls259
	pop	psw
	ret

	cseg


rwcom1:
	call	setup		; lese-schreib-kern
	call	setmem		; muss in common liegen
	call	monon
	lda	roderw
	ora	a
	jrz	rwcom2
	call	mwrite
	jr	rwcom5
rwcom2	call	mread
rwcom5	call	monoff
	push	psw
	call	bank0
	pop	psw
	ret


	dseg			; rest is banked



;********************************************************************
;
;HIER WERDEN DIE MOEGLICHEN DISK-FORMATE VEREINBART
;
;
;
DISK$TYPE$LIST:
	;
	;DIESE LISTE DEFINIERT DIE VOM BETRIEBSSYSTEM LESBAREN
	;PLATTEN-TYPEN
	;DIE LISTE BESTEHT AUS BELIEBIG VIELEN EINTRAEGEN VON
	;JE ELF BYTE, DIE WIE NACHFOLGEND BESCHREIBEN AUFGEBAUT
	;SIND:
	;	BYTE 1	  :DISK-TYP
	;	BYTE 2	  :SEKTOR-ANZAHL
	;	BYTE 3	  :GAP-LAENGE DIE DER UPD 765 VERWENDEN SOLL
	;	BYTE 4	  :WRITE PRECOMPENSATION
	;	BYTE 5-6  :ADRESSE DES DPB FUER DIESES FORMAT
	;	BYTE 7-8  :ADRESSE DER SEKTOR SKEW-TABLE
	;	BYTE 9-10 :ADRESSE DER TRACK UEBERSETZUNGSTABELLE
	;	BYTE 11   :BYTE FUER LOGISCHE DISK VERWALTUNG
	;	BYTE 12	  :ANZAHL DER ZYLINDER
	;	BYTE 13-16:RESERVIERT
	;
	;TEST$FORMAT VERGLEICHT DIE BEIDEN ERSTEN BYTES MIT
	;TEST$TYPE UND TEST$MSEK DIE DAS UNTERPROGRAM MONTEST
	;LIEFERTT.
	;
	SSIDE	EQU	000H	;EQUATES FUER TYPE
	DSIDE	EQU	080H	;
	SDENS	EQU	000H	;
	DDENS	EQU	040H	;
	VHB0	EQU	000H	;
	VHB1	EQU	010H	;
	S0128	EQU	000H	;
	S0256	EQU	001H	;
	S0512	EQU	002H	;
	S1024	EQU	003H	;
	;
	TUV1	EQU	000H	;EQUATES FUER LOGISCHE DISK VERWALTUNG
	TUV2	EQU	001H	;
	TUV3	EQU	002H	;
	TUV4	EQU	003H	;
	TUV5	EQU	004H	;
	RHB0	EQU	000H	;
	RHB1	EQU	010H	;
	;
	;
	;	Vortex DSDD
	;
	DB	DSIDE OR DDENS OR VHB0 OR S0512
	DB	9
	DB	0EH,2
	DW	DPBVRT
	DW	SKEW9
	DW	0
	DB	RHB1 OR TUV2
	DB	80
	DB	0,0,0,0
	;
	;
	;	KayPro II
	;
	DB	SSIDE OR DDENS OR VHB0 OR S0512
	DB	9
	DB	1BH,2
	DW	DPBKYP
	DW	SKEW10
	DW	0
	DB	RHB1 OR TUV1
	DB	40
	DB	0,0,0,0
	;
	;	MSDOS 360k
	;
	DB	DSIDE OR DDENS OR VHB0 OR S0512
	DB	9
	DB	1BH,2
	DW	DPBMSD
	DW	SKEW9A
	DW	0
	DB	RHB1 OR	TUV1
	DB	40
	DB	0,0,0,0
	;
	;	BONDWELL-14
	;
	DB	DSIDE OR DDENS OR VHB0 OR S0256
	DB	17
	DB	0EH,2
	DW	DPBBON
	DW	SKEW18
	DW	0
	DB	RHB1 OR TUV3
	DB	40
	DB	0,0,0,0
	;
	;	OSBORNE C128
	;
	DB	SSIDE OR DDENS OR VHB0 OR S1024
	DB	5
	DB	35H,2
	DW	DPBOSC
	DW	SKEW5
	DW	0
	DB	RHB1 OR TUV1
	DB	40
	DB	0,0,0,0
	;
	;
form80info:
	db	cr,lf,lf
	db	'Login fuer 80 Spur Format'
	db	cr,lf
	db	'Moegliche Formate:'
	db	cr,lf,lf
	db	'(1) Vortex DSDD'
	db	cr,lf,lf
	db	'Format: ',0
	;
form40info:
	db	cr,lf,lf
	db	'Login fuer 40 Spur Format'
	db	cr,lf
	db	'Moegliche Formate:'
	db	cr,lf,lf
	db	'(1) KayPro II'
	db	cr,lf
	db	'(2) MSDOS 360k'
	db	cr,lf
	db	'(3) Bondwell-14'
	db	cr,lf
	db	'(4) Osborne C128'
	db	cr,lf,lf
	db	'Format: ',0


current$dph	ds	2	

	end
