	title	'CMOS floppy handler for PROF-80'

; CP/M-80 Version 3.0		--    Modular BIOS

	dseg

	public	fdcmos

	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk

	extrn	?bank

	maclib	cpm3

	maclib	z80

	maclib	cdef

; Extended Disk Parameter Header (XDPH)

	dw	c$write
	dw	c$read
	dw	c$login
	dw	c$init
	db	0,0
fdcmos	dph	0,dpbr,0,16

	cseg

; Disk Parameter Block im Common-Bereich

dpbr	dpb	128,32,16,1024,64,0,8000h

	dseg

c$read:
	call	stdrv
	call	cmove1
	xra	a
	ret

c$write:
	call	stdrv
	call	cmove2
	xra	a
	ret

stdrv:				; Selektiert Spur und Sektor
	lda	@trk
	mov	d,a
	lda	@sect
	mov	e,a
	mvi	c,cport
	slar	e		; verschiebt drei
	slar	e		; Bits aus dem
	slar	e		; Tackregister
	srlr	d		; ins
	rarr	e		; Sektorregister
	srlr	d
	rarr	e
	srlr	d
	rarr	e
	outp	e
	inr	c
	outp	d
	ret

c$login:
	ret

c$init:
	ret

	cseg		; Datenuebertragungsroutinen muessen
			; im Common-Bereich liegen
cmove1:
	lhld	@dma
	lda	@dbnk
	call	?bank
	mvi	b,128
	mvi	c,cport
	inir
	jr	cmove3

cmove2:
	lhld	@dma
	lda	@dbnk
	call	?bank
	mvi	b,128
	mvi	c,cport+2
	outir

cmove3:
	lda	@cbnk
	call	?bank
	ret

	end
