
	title	'CT RAM floppy handler for PROF-80'

; CP/M-80 Version 3.0

; letzte Aenderung am 11.06.1992 (Gerhard)
;
; Dieser Treiber ist nur wichtig, wenn CT RAM benutzt wird
; und noch Platz fuer die Ramfloppy da ist.
;

	dseg

	public	fdtram

	extrn	@dma,@trk,@sect

	extrn	ciecho,?pmsg

	maclib	cpm3

	maclib	z80

	maclib	cdef

	if	tram and (ram$floppy$bank le (tspace/32+1))


; berechne Kapazitaet der RAM-Floppy in K-Byte

rspace	equ	tspace-((ram$floppy$bank-2)*32)

; berechne daraus die restlichen Parameter der RAM-Floppy

block	set	1024
dirs	set	32
	if	rspace gt 96
dirs	set	64
	endif
	if	rspace gt 256
block	set	2048
dirs	set	128
	endif
	if	rspace gt 512
dirs	set	256
	endif
	if	rspace gt 1024
dirs	set	512
	endif
	if	rspace gt 2048
block	set	4096
dirs	set	1024
	endif

; Extended Disk Parameter Header (XDPH)

	dw	r$write
	dw	r$read
	dw	r$login
	dw	r$init
	db	0,0
fdtram	dph	0,dpbr,0,rspace/(block/1024)/4

	cseg

dpbr	dpb	128,32,rspace/4,block,dirs,0,8000h

	dseg

rdbasis equ	0a0h

rddaten equ	rdbasis
rdsekt  equ	rdbasis+1
rdspur  equ	rdbasis+2
rdstat  equ	rdbasis+3

r$read:
	call	setrdc
	rnz
	inir
	ret


r$write:
	call	setrdc
	rnz
	outir
	ret


setrdc:
	in	rdstat
	bit	1,a
	jrnz	rdschutz
	lda	@trk		;lade spur
	out	rdspur
	lda	@sect		;lade sektor
	out	rdsekt
	lhld	@dma
	mvi	c,rddaten
	mvi	b,128
	xra	a
	ret

rdschutz:
	lxi	h,rdschml
	call	?pmsg
	call	ciecho
	cpi	3
	jrnz	setrdc
	mvi	a,1
	ora	a
	ret

rdschml:
	db	0dh,0ah,'RAM-Disk geschuetzt. ^C'
	db	' -> BDOS-Fehler; sonst Retry ',0


r$login:
	ret


r$init:
	lxi	h,eraqtxt	;
	call	?pmsg		;
	call	ciecho		;
	cpi	'Y'		; soll nicht geloscht werden ?
	rnz			; dann return.

	mvi	c,4		;loesche RAM-Floppy
rera3:	mvi	e,32		;Directory
rera2:	mov	a,c		;
	out	rdspur		;
	mov	a,e		;
	out	rdsekt		;
	mvi	b,128		;
rera1:	mvi	a,0e5h		;
	out	rddaten		;
	dcr	b		;
	jrnz	rera1		;
	dcr	e		;
	jrnz	rera2		;
	dcr	c		;
	jrnz	rera3		;
	ret

eraqtxt:
	db	0dh,0ah
	db	'erase RAM-Floppy (Y/N) ?',0

	endif
	end

