; ?int65 now sets 6551 baud rate based on baudrate byte set in devtbl.
; 
; user assumes all liability for the use of this module
;
; original copyright maintained by Commodore
;-------------------------------------------------------------------------
; CHANGES by Randy Winchester, 6 May 89
;
; Drive D: returned to active duty.
;
; RAM disk set back to drive M:
;
; Table entry made for Drive E:, used by Quick Brown Box.
;-------------------------------------------------------------------------

	title	'C128 external Disk drive support   6 May   89'

	maclib	cpm3

	maclib	z80

	maclib	cxequ


	extrn	X6551$baud
	public	?int65,?in65,?ins65,?out65

; Utility routines in standard BIOS
	extrn	?pmsg		; print message @<HL> up to 00
				; saves <BC> & <DE>
	extrn	?pdec		; print binary number in <A> from 0 to 99.
	extrn	?pderr		; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status
;
;	drive table
;
	public	@dtbl
	extrn	cmdsk0,cmdsk1,cmdsk2,cmdsk3,cmdsk4,RMdsk


	page
;
;	DRVTBL.ASM		
;
	CSEG		; place code in common memory

;**************************************
; Drives A: - D: are 1541/71
; Drive E: for QBB, Drive M: is REU
;****************************************

@dtbl:

	dw	cmdsk0			;* drive A 1541/1571 
	dw	cmdsk1			;* drive B 1541/1571
	dw	cmdsk2			;* drive C 1541/1571
	dw	cmdsk3			;* drive D 1571
	dw	cmdsk4			;* drive E QBB
	dw	0			;* drive F
	dw	0			;* drive G
	dw	0			;* drive H
	dw	0			;* drive I
	dw	0			;* drive J
	dw	0			;* drive K
	dw	0			;* drive L
	dw	RMdsk			;* drive M REU
	dw	0			;* drive N
	dw	0			;* drive O
	dw	0			;* drive P

	page

;==========================================================
;		CHARACTER INITIALIZATION ROUTINES
;==========================================================
;
;
;
	dseg
;
;	set com rate to 9600 baud
;
?int65:
init$ext:
	lxi	b,command$6551		; (02)
	mvi	a,cmd$init
	outp	a
	inx	b
	mvi	a,10h                   ; baud rate equ 9600
	lxi	h,X6551$baud
	add	m
	outp	a
	dcx	b			; (02)
	dcx	b			; (01)
	inp	a
	dcx	b			; (00)
	inp	a
	ret


	page
;==========================================================
;		CHARACTER INPUT ROUTINES
;==========================================================

;
;
;
	dseg
?in65:			; character input
	call	?ins65
	jrz	?in65
	lxi	b,rxd$6551
	inp	a
	ret

;==========================================================
;	CHARACTER DEVICE INPUT STATUS
;==========================================================
;
;
;
	dseg
?ins65:			; character input status
	lxi	b,status$6551
	inp	a
	ani	rxrdy
	rz
	ori	-1
	ret


;==========================================================
;	CHARACTER DEVICE OUTPUT
;==========================================================
;
; the character to be output is in the C register
;
	dseg
?out65:				; character output
	mov	a,c
	push	psw
	lxi	b,status$6551
send$wait:
	inp	a
	ani	txrdy
	jrz	send$wait
	pop	psw
	lxi	b,txd$6551
	outp	a
	ret

	end
