	title	'Terminal Emulation (ADM-31 with K-Pro support)   26 April 87'


	maclib	z80

	maclib	cxequ

lines	equ	24

	public	?out80,ADM31

;  Changes to this module were to remove all 40 column code.  Original
;  Copyright is still maintained by Commodore
;
;
;
;
;
;
;
;	ADM3A
;
;
;	ESC = row col		cursor position
;	ESC ESC ESC color	set color		; added for C128 CP/M
;	^H			cursor left
;	^L			cursor right
;	^J			cursor down
;	^K			cursor up
;	^Z			home and clear screen
;	^M			carrage return
;	^G			bell

;
;	ADM31
;
;
;	ESC = row col	cursor position
;	ESC ESC ESC color	set color		; added for C128 CP/M
;	ESC T		clear to end of line
;	ESC t		clear to end of line
;	ESC Y		clear to end of screen
;	ESC y		clear to end of screen
;	ESC :		home & clear screen
;	ESC *		home & clear screen
;	ESC )		Half intensity on
;	ESC (		Half intensity off
;	ESC G 4		Reverse video on
;	ESC G 2		Blinking on
;	ESC G 0		Rev. video and blinking off
;	ESC E		Insert line
;	ESC Q		Insert Character
;	ESC R		Delete Line
;	ESC W		Delete Character
;	^H		cursor left
;	^L		cursor right
;	^J		cursor down
;	^K		cursor up
;	^Z		home and clear screen
;	^M		carriage return
;	^G		bell
;
	page
;
;	KPRO II Terminal control sequences (not supported yet)
;
;
; Cursor Control
;
;	^H	cursor left (bs)
;	^L	cursor right
;	^J	cursor down
;	^K	cursor up
;	^^	home cursor
;	^Z	home cursor & clear screen
;	^M	carriage return
;
; Cursor Positioning
;
;	ESC = R C	(R & C =' '+position)
;
; Line Insert/Delete
;
;	ESC E	Line Insert
;	ESC R	Line Delete
;
; Clear to End of Screen/Line
;
;	^X	Clear to End of Line
;	^W	Clear to End of Screen
;
; Set Greek or ASCII (not supported)
;
;	ESC A	Set ASCII
;	ESC G	Set Greek	(lower case letters print as Greek Alphabet)
;
	page

	dseg
;
;
;
;
;
;
?out$80:
	xra	a			; 80 column offset is 0
	lxi	h,parm$area$80
out$cont:
	sta	fun$offset
	mvi	a,7fh
	ana	c
	mov	c,a
	shld	parm$base
	lhld	emulation$adr
	pchl

	page
;
;	ADM-31 terminal emulation
;
ADM31:
	lhld	parm$base		; 1st parm is exec adr (2 bytes)
	mov	a,m
	inx	h
	mov	h,m
	mov	l,a

	ora	h			; L is in A already, test HL=0
	mov	a,c			; C is char to output
	jrz	start$checking 
	pchl

;
;
;
start$checking:
	lxi	h,control$table
	lxi	b,cnt$tbl$lng
	ccir
	lxi	h,control$exec$adr
	jrz	find$exec$adr

	cpi	20h
	rc

do$direct:
	mov	d,a
	TJMP	FR$wr$char

	page
;
;
;
char$esc:				; ESC
	call	cont$later
;
;	ESC char	look for char in the ESC table
;
	call	remove$exec$adr
	lxi	h,esc$table
	lxi	b,esc$tbl$lng
	ccir
	rnz				; bad esc sequence
	lxi	h,esc$exec$adr

find$exec$adr:
	dad	b
	dad	b
	mov	a,m
	inx	h
	mov	h,m
	mov	l,a
	pchl



	page
;
;
;
cont$later:
	pop	h		; get address to cont at in H
	jr	save$exec$adr	; save it
;
;
;
remove$exec$adr:
	lxi	h,0
save$exec$adr:
	xchg
	lhld	parm$base
	mov	m,e
	inx	h
	mov	m,d
	ret


;
;
;
esc$esc:
	call	cont$later
;
;	check for ESC ESC ESC
;
	cpi	esc			; check if 3rd char is an ESC
	jrnz	remove$exec$adr
	call	cont$later
;
;	set current character as the attr
;
	mov	b,a
	TCALL	FR$color
	jr	remove$exec$adr

	page
;
;
;
esc$equ:
	call	cont$later
;
;	ESC = R
;
	lhld	parm$base
	inx	h
	inx	h
	sui	' '			; remove ascii bias
	mov	m,a
	cpi	'8'-' '			; test for line 25 (A=24?)
	jrnz	not$status$line		; no, jmp
	inr	a			; yes, A=25
	sta	paint$size		; set 40 column repaint to 25 lines
not$status$line:
	call	cont$later
;
;	ESC = R C	(go do it)
;
	sui	' '
	mov	e,a			; column # to E

	lhld	parm$base
	inx	h
	inx	h
	mov	d,m			; row # to D
	TCALL	FR$cursor$pos
	jr	remove$exec$adr

	page
;
;
;
char$cnt$z:				; ^Z	home and clear screen
	lxi	d,lines*256+0		; B=24(row) C=0(col)
	TCALL	FR$cursor$pos
	call	esc$t			; clear the status line 
	lxi	d,0
	TCALL	FR$cursor$pos
esc$y:
	TJMP	FR$CES			; clear to end of screen 

home$cursor:
	lxi	d,0
	TJMP	FR$cursor$pos
	
esc$t:
	TJMP	FR$CEL			; clear to end of line 

;
;
;
do$cr:
	TJMP	FR$do$cr

;
;
;
cursor$rt:
	TJMP	FR$cursor$rt

;
;
;
cursor$up:
	TJMP	FR$cursor$up

;
;
;
cursor$down:
	TJMP	FR$cursor$down

;
;
;
cursor$left:
	TJMP	FR$cursor$left

	page

;
;	placed in common so that link and gencpm will not
;	cause this code to show up at address 0D000h to 0DFFFh
;
char$cnt$g:				; ^G	bell
	RJMP	FR$bell

;
;	delete character
;
esc$W:
	TJMP	FR$char$del

;
;	delete line
;
esc$R:
	TJMP	FR$line$del

;
;	insert character
;
esc$Q:
	TJMP	FR$char$ins

;
;	insert line
;
esc$E:
	TJMP	FR$line$ins

	page
;
;	Half Intensity Off
;
esc$lfp:
	mvi	c,00000001b		; turn intensity up
	jr	set$FR$atr$c
;
;	Half Intensity On
;
esc$rtp:
	mvi	c,00000000b		; turn intensity down
parn$cont:
	mvi	b,00000001b		; attribute bit to change
	jr	set$FR$attr

;
;	Set Attribute sequence
;
esc$G:
	call	cont$later
;
;	ESC G char
;
	call	remove$exec$adr
	sui	'4'			; '4' reverse video on
	jrz	esc$G$4
	inr	a			; '3' underline attr on
	jrz	esc$G$3
	inr	a			; '2' blink attr on
	jrz	esc$G$2
	inr	a			; '1' alt char set
	jrz	esc$G$1
	inr	a			; '0' clear attributes
	rnz
;
;	Rev. Video, blink, atl char set, and underline  off
;
esc$G$0:
	mvi	c,10000000b		; turn attributes off
	mvi	b,11110000b		; attribute bit to change
	jr	set$FR$attr

;
;	Select alt character set
;
esc$G$1:
	mvi	c,00000000b		; select alt character set
	mvi	b,10000000b
	jr	set$FR$attr

;
;	Blinking On
;
esc$G$2:	
	mvi	c,00010000b		; turn on blink attr
	jr	set$FR$atr$c

;
;	Under line
;
esc$G$3:
	mvi	c,00100000b		; turn on underline bit
	jr	set$FR$atr$c

;
;	Reverse Video On
;
esc$G$4:
	mvi	c,01000000b		; turn attributes on

set$FR$atr$c:
	mov	b,c			; reverse attr
set$FR$attr:
	TJMP	FR$attr

	page
;
;	table scanned top to bottom
;
control$table:
	db	07h	; ^G		bell
	db	bs	; ^H		cursor left
	db	lf	; ^J		cursor down
	db	0Bh	; ^K		cursor up
	db	0Ch	; ^L		cursor right
	db	cr	; ^M		carrage return
	db	1Ah	; ^Z		home and clear screen
	db	esc	; ESC
	db	18h	; ^X		Clear to End of Line (K-Pro)
	db	17h	; ^W		Clear to End of Screen (K-Pro)
	db	1Eh	; ^^		home cursor (K-Pro)

cnt$tbl$lng	equ	$-control$table

;
;	table scanned bottom to top
;
control$exec$adr:
	dw	home$cursor	; ^^	home cursor	(K-Pro)
	dw	esc$y		; ^W	CES		(K-Pro)
	dw	esc$t		; ^X	CEL		(K-Pro)
	dw	char$esc	; ESC
	dw	char$cnt$z	; ^Z	home and clear screen
	dw	do$cr		; ^M	carriage return
	dw	cursor$rt	; ^L	cursor right
	dw	cursor$up	; ^K	cursor up
	dw	cursor$down	; ^J	cursor down
	dw	cursor$left	; ^H	cursor left
	dw	char$cnt$g	; ^G	bell


	page
;
;	table scanned top to bottom
;
esc$table:
	db	'='		; ESC = R C	

	db	'T'		; ESC T	  clear to end of line
	db	't'		; ESC t   clear to end of line
	db	'Y'		; ESC Y   clear to end of screen
	db	'y'		; ESC y   clear to end of screen
	db	':'		; ESC :   home & clear screen
	db	'*'		; ESC *   home & clear screen

	db	'E'		; ESC E   Insert line
	db	'Q'		; ESC Q   Insert Character
	db	'R'		; ESC R   Delete Line
	db	'W'		; ESC W   Delete Character

	db	')'		; ESC )   Half intensity on
	db	'('		; ESC (   Half intensity off
	db	'G'		; ESC G 4 Reverse video on
				; ESC G 2 Blinking on
				; ESC G 0 Rev. video and blinking off

	db	esc		; ESC ESC

esc$tbl$lng	equ	$-esc$table


;
;	table scanned bottom to top
;
esc$exec$adr:
	dw	esc$esc		; ESC ESC ESC color

	dw	esc$G		; ESC G 4 Reverse video on
				; ESC G 2 Blinking on
				; ESC G 0 Rev. video and blinking off
	dw	esc$lfp		; ESC (   Half intensity off
	dw	esc$rtp		; ESC )   Half intensity on

	dw	esc$W		; ESC W   Delete Character
	dw	esc$R		; ESC R   Delete Line
	dw	esc$Q		; ESC Q   Insert Character
	dw	esc$E		; ESC E   Insert line

	dw	char$cnt$z	; ESC *   home & clear screen
	dw	char$cnt$z	; ESC :   home & clear screen
	dw	esc$y		; ESC y   clear to end of screen
	dw	esc$y		; ESC Y   clear to end of screen
	dw	esc$t		; ESC t   clear to end of line
	dw	esc$t		; ESC T	  clear to end of line

	dw	esc$equ		; ESC = RC

 of screen
	dw	esc$t		; ESC t   clear