

	title	'CX40 & CX80   80 column drivers    26 Apr 87'

	maclib	cxequ

	maclib	z80


lines	equ	24

;	public	?fundir			; function direct

	public	?int80
	public	?stat,?save,?recov

	extrn	ADM31

	page
;
;  This module has been modified by James Waltrip, you the user assume ;
;  _All_ liability for its use.  Original copyright is still maintained
;  Commodore.
;
;
;   The modifications to this module were to remove the 40 column driver
;   code.
;
;
;
;
;
;**
;**	This is the entry point to get to the function module
;** 
;
;
;	This code will perform the functions that the emulation
;	code will need to do to complete function.
;
;
;
;
;	enable  cursor,  then set foreground and background colors  
;
	DSEG
?int80:
	lxi	h,ADM31
	shld	emulation$adr
	lhld	key$tbl			; logical color assignments at end of
	lxi	d,11*4*8		; ..key$table, (key$tbl size=11*4*8)
	dad	d
	shld	color$tbl$ptr		; setup color table ptr

	mvi	a,80h
	sta	current$atr

;
;	program the 8563 for full flashing cursor
;
	mvi	a,10			; point to cursor start line#
	call	R$wait			;  and mode register
	mvi	a,40h			; start at line zero, cursor 1/16
	outp	a
	mvi	a,11			; point to cursor end line#
	call	R$wait
	mvi	a,7
	outp	a
	ret

	page
;
;

;**
;**	The following code is used to maintain the status line on
;**	both the 80 and 40 column displays
;**
;
;	save characters on the status line (80 column only) to buffer
;	reverse video the data area cleared (40 and 80 column screens)
;
;	C=start column #	B=number of characters to save
;
	DSEG
?save:

do$save$80:
	mov	a,b
	lxi	h,lines*80		; point to status line
	lxi	d,buffer$80$col		; point to save buffer
	mvi	b,0			; zero MSB
	dad	b			; point to char position to save

save$loop:
	push	psw			; save count
	push	d			; save buffer address
	call	R$read$memory		; read char(B) and attribute(A)
	pop	d			; recover buffer pointer
	stax	d			; save character
	inx	d			; advance buffer
	mov	a,b			; get atrb to A
	stax	d			; save atrb
	inx	d			; advance buffer
	push	d

	mvi	a,01000000b		; reverse video only
	call	get$atr$color		; returned in A
	mvi	d,' '			; get character
	call	R$write$memory

	pop	d
	pop	psw			; recover count
	inx	h
	dcr	a			; adjust count
	jrnz	save$loop		; loop if not done
	ret

	page
;
;	recover characters to the status line (80 column only)
;	for the 40 column screen just clear status line (with spaces)
;
;	C=start column #	B=number of characters to restore
;
	DSEG
?recov:
recove$80:
	mov	a,b
	lxi	h,lines*80		; point to status line
	lxi	d,buffer$80$col		; point to save buffer
	mvi	b,0			; zero MSB
	dad	b			; point to char position to save

recov$80$loop:
	push	psw			; save count
	ldax	d			; get attribute
	inx	d			; advance pointer
	mov	b,a			; save attribute in B
	ldax	d			; get character in A
	inx	d			; advance pointer
	push	d			; save buffer address
	mov	d,a			; move character to D
	mov	a,b			; move attribute to A
	call	R$write$memory		; write char(D) and attribute(A)
	pop	d			; recover buffer pointer
	pop	psw			; recover count
	inx	h
	dcr	a			; adjust count
	jrnz	recov$80$loop		; loop if not done
	ret

	page
;
;	Places data on the system status line
;
;	for the 80 column screen a number of character attributes
;	are available: flash, underline, reverse video
;
;	for the 40 column screen only reverse video is available
;
;	INPUT:
;		A=attribute  (7654 3210)
;			6-reverse video
;			5-underline
;			4-blink
;		B=character to write (ASCII)
;		C=column number to write
;			(>40 does nothing to 40 column screen)
;
	DSEG
?stat:
	push	psw
	push	b			; save for 80 column display
	mov	e,a			; save attribute in E
;
;	display on 80 column display now
;
not$40$col$wr:
	pop	d			; D=character  E=position
	pop	psw			; get new attribute
	call	get$atr$color

	mov	b,d			; save character to write in B
	lxi	h,lines*80
	mvi	d,0
	dad	d			; point to character location
	mov	d,b			; place character to write in D
	jmp	R$write$memory


;
;	using attribute in A add color to it and return in A
;
;	destroys BC
;
	DSEG
get$atr$color:
	push	h
	push	psw
	lda	bg$color$80
	mov	c,a
	mvi	b,0
	lxi	h,status$color$tbl
	dad	b			; point to status color 
	pop	psw
	ani	01110000b		; limit good attr
	mov	b,a			; save in E
	mov	a,m			; get status color
	ani	0fh			; only want 80 column status color
	ora	b			; merge with new attr
	ori	80h			; select alternate character set
	pop	h
	ret

;
;
;
;
;
;
	CSEG
;
;
;
;
;	MSB is 40 column status color, LSB is 80 column status color
;
status$color$tbl:
	db	05eh			; status color #1
	db	0f6h			; status color #2
	db	0a6h			; status color #3
	db	0b7h			; status color #4
	db	0d7h			; status color #5
 	db	0d4h			; status color #6
	db	0e7h			; status color #7
	db	083h			; status color #8
	db	097h			; status color #9
	db	0a8h			; status color #10
	db	09eh			; status color #11
	db	0ffh			; status color #12
	db	0bdh			; status color #13
	db	058h			; status color #14
	db	06fh			; status color #15
	db	0ceh			; status color #16


db	0bdh			; status color #13
	db	058h			; status color #14
	db	06fh			; status color #15
	db	0ceh		