	title 'Character I/O handler for PROF-181X'

; Character I/O for the Modular PROF-181 CP/M 3 BIOS
;
; letzte Aenderung am: 05.11.1986 (Joachim)

	cseg

	extrn	@cbnk

	public	?cinit,?ci,?co,?cist,?cost
	public	@ctbl
	public	monon,monoff

	maclib	hd64180

	maclib	pdef

	maclib	psys

	maclib	modebaud

	maclib	pvec

	maclib	pkonfig


max$devices	equ	6	; anzahl der phys. treiber minus 1
;in der Version gerhard Wolf equ 11 - da die UNIO verbaut war.

	cseg

?cinit:
	mov	b,c		; device nummer in b
	mov	l,c		; lade baudrate der device
	mvi	h,0		; nach c
	dad	h		;
	dad	h		;
	dad	h		;
	lxi	d,@ctbl+7	;
	dad	d		;
	mov	a,m		;
	mov	c,a		;
	lxi	d,cinit$list	; zeige auf liste
	jr	verteiler	; verzweige auf entsprechende routine

?ci:
	lxi	d,ci$list ! mvi h,1ah
	jr	verteiler

?co:
	lxi	d,co$list
	jr	verteiler

?cist:
	lxi	d,cist$list ! mvi h,0
	jr	verteiler

?cost:
	lxi	d,cost$list ! mvi h,0

verteiler:
	mvi	a,max$devices	; unzulaessiger treiber?
	cmp	b		; dann return
	mov	a,h		; in a steht returncode
	rc			;
				; treiber vorhanden => weiter
	call	monon		; schalte EPROM ein ( die meisten Treiber
	mov	l,b		; befinden sich im EPROM)
	mvi	h,0		;
	dad	h		;
	dad	d		; hl zeigt auf treiber adresse
	lxi	d,callr+1	; trage adresse in call ein
	mov	a,m ! stax d	;
	inx 	h ! inx d	;
	mov	a,m ! stax d	;
callr	call	0		;
	call	monoff		; EPROM wieder aus
	ret			; alles ok return zum BDOS



@ctbl:
	db 'V-24-A'	; Haupt V-24 auf PROF-181X
	db mb$in$out+mb$serial+mb$softbaud
	db baud$none	; Baudrate haengt von Monitor ab

	db 'V-24-B'	; zweite V-24 auf PROF-181X
	db mb$in$out+mb$serial+mb$softbaud
	db baud$none	; Baudrate haengt von Monitor ab

	db 'CENT  '	; Centronix-Schnittstelle auf PROF-181X
	db mb$output+mb$softbaud
	db baud$none

	db 'RESERV'	; grade im EPROM
	db mb$in$out
	db baud$none

	db 'USER  '	; user im EPROM
	db mb$in$out
	db baud$none

	db 'GRIP  '	; Grafik-Karte
	db mb$in$out
	db baud$none

	db 'SPOLER'	; GRIP-Spooler
	db mb$output
	db baud$none
;UNIO
;	db 'SIOA  '	; UNIO SIO A
;	db mb$in$out+mb$serial+mb$softbaud
;	db baud$9600
;
;	db 'SIOB  '	; UNIO SIO B
;	db mb$in$out+mb$serial+mb$softbaud
;	db baud$9600
;
;	db 'TTY   '	; 20 mA Stromschleife auf UNIO
;	db mb$in$out+mb$serial+mb$softbaud
;	db baud$110
;
;	db 'CENT1 '	; Centronics 1 auf UNIO
;	db mb$output
;	db baud$none
;
;	db 'CENT2 '	; Centronics 2 auf UNIO
;	db mb$output
;	db baud$none
;-----------------------------------------------

	db 0			; table terminator

;
; Hilfsroutinen, die im Common-Bereich liegen muessen
;

monon:		; schalte Monitor-EPROM ein und Stack um

	push	psw		; rette akku
	lda	epromz		; ist EPROM schon eingeschaltet?
	ora	a		; wenn ja Sprung
	jrnz	monon1		;
	inr	a		; 
	sta	epromz		; neue EPROM-Einschalttiefe
	pop	psw		;
	shld	temp2		;
	pop	h		;
	sspd	userstack	; rette userstack
	lxi	sp,monstack	;
	push	h		;
	lhld	temp2		;
				;
	push	psw		; schalte jetzt EPROM ein
	xra	a		;
	out0	bbr,a		;
	pop	psw		;
	ret			;

monon1	inr	a		;
	sta	epromz		;
	pop	psw		;
	ret			;



monoff:		; schalte Monitor-EPROM aus

	push	psw		;
	lda	epromz		; 
	dcr	a		;
	sta	epromz		;
	jrnz	monoff1		;

	lda	@cbnk		; setze selektiete Bank
	rrc ! rrc		; ****  ACHTUNG ****
	ani	40h		;
	out0	bbr,a		;
	pop	psw		;

	shld	temp2		;
	pop	h		;
	lspd	userstack	;
	push	h		;
	lhld	temp2		;
	ret			;

monoff1	pop	psw		;
	ret			;


userstack	ds	2	;
temp2		ds	2	;
		ds	64	;
monstack:

	dseg

	; charcter treiber koennen im
	; gebankten teil liegen, da mit
	; verteiler umgeschalten wurde

cinit$list:
	dw	ser1init
	dw	ser2init
	dw	null$init
	dw	null$init
	dw	null$init
	dw	null$init
	dw	null$init
; UNIO
;	dw	sainit
;	dw	sbinit
;	dw	stinit
;	dw	null$init
;	dw	null$init
;--------------------
ci$list:
	dw	mduplxin
	dw	ser2in
	dw	null$in
	dw	mgradein
	dw	muserin
	if	ginmask
	dw	grafin
	else
	dw	mgrafin
	endif
	dw	null$in
; UNIO
;	dw	sain
;	dw	sbin
;	dw	stin
;	dw	null$in
;	dw	null$in
;----------------
co$list
	dw	mduplxout
	dw	ser2out
	dw	centout
	dw	mgradeout
	dw	muserout
	if	goutmask
	dw	grafout
	else
	dw	mgrafout
	endif
	dw	spoolerout
; UNIO
;	dw	saout
;	dw	sbout
;	dw	stout
;	dw	c1out
;	dw	c2out
;---------------	

cist$list:
	dw	mduplxist
	dw	ser2ist
	dw	null$status
	dw	mgradeist
	dw	muserist
	dw	mgrafist
	dw	null$status
; UNIO
;	dw	saout
;	dw	sbout
;	dw	stout
;	dw	c1out
;	dw	c2out
;	

cost$list:
	dw	mduplxost
	dw	ser2ost
	dw	centost
	dw	mgradeost
	dw	muserost
	dw	mgrafost
	dw	mgrafost
; UNIO
;	dw	saost
;	dw	sbost
;	dw	stost
;	dw	c1ost
;	dw	c2ost
;


		if	ginmask
grafin:		call	mgrafin
		ani	07fh
		ret
		endif

		if	goutmask
grafout:	mov	a,c
		ani	07fh
		mov	c,a
		jmp	mgrafout
		endif

ser1init	mov	a,c ! jmp mser1init
ser2init	mov	a,c ! jmp mser2init



; UNIO
;sain	call	saist
;	jrz	sain
;	in	sioad
;	ret
;
;sbin	call	sbist
;	jrz	sbin
;	in	siobd
;	ret
;
;saout	call	saost
;	jrz	saout
;	mov	a,c
;	out	sioad
;	ret
;
;sbout	call	sbost
;	jrz	sbout
;	mov	a,c
;	out	siobd
;	ret
;
;saist	in	sioac
;	ani	00000001b
;	rz
;	ori	0ffh
;	ret
;
;sbist	in	siobc
;	ani	00000001b
;	rz
;	ori	0ffh
;	ret
;
;saost	in	sioac
;	ani	00000100b
;	rz
;	ori	0ffh
;	ret
;
;sbost	in	siobc
;	ani	00000100b
;	rz
;	ori	0ffh
;	ret
;
;c1out	call	c1ost
;	jrz	c1out
;	mov	a,c
;	out	cent1
;	mvi	a,4
;	out	contr
;	mvi	a,5
;	out	contr
;	mov	a,c
;	ret
;
;c1ost	in	stat
;	cma
;	ani	01000000b
;	rz
;	ori	0ffh
;	ret
;
;c2out	call	c2ost
;	jrz	c2out
;	mov	a,c
;	out	cent2
;	mvi	a,6
;	out	contr
;	mvi	a,7
;	out	contr
;	mov	a,c
;	ret
;
;c2ost	in	stat
;	cma
;
;
;	ani	10000000b
;	rz
;	ori	0ffh
;	ret
;
;stin	call	stist
;	jrz	stin
;	in	stif
;	ret
;
;stout	call	stost
;	jrz	stout
;	mov	a,c
;	out	stif
;	ret
;
;stist	in	stid
;	ani	10000000b
;	rz
;	ori	0ffh
;	ret
;
;stost	in	stie
;	ani	10000000b
;	rz
;	ori	0ffh
;	ret
;
;stinit:
;	mov	a,c
;	push	psw
;	ani	0fh
;	call	stitinit
;	pop	psw
;	mov	b,a
;	ani	0f0h
;	jrz	stinit1
;	mov	a,b
;	ani	0fh
;	jrz	stinit2
;	mov	a,b
;	rar
;	rar
;	rar
;	rar
;stinit3	ani	0fh
;	call	stirinit
;	ret
;stinit1	mov	a,b
;	jr	stinit3
;stinit2	xra	a
;	jr	stinit3
;
;stitinit:
;	lxi	h,sertab
;	mov	c,a
;	mvi	b,0
;	dad	b
;	dad	b
;	mvi	a,2
;	out	sti8
;	mov	a,m
;	out	sti0
;	inx	h
;	mvi	a,7
;	out	sti8
;	mov	a,m
;	ani	0f0h
;	mov	b,a
;	in	sti0
;	ani	0fh
;	ora	b
;	out	sti0
;	ret
;
;stirinit:
;	lxi	h,sertab
;	mov	c,a
;	mvi	b,0
;	dad	b
;	dad	b
;	mvi	a,1
;	out	sti8
;	mov	a,m
;	out	sti0
;	inx	h
;	mvi	a,7
;	out	sti8
;	mov	a,m
;	ani	0fh
;	mov	b,a
;	in	sti0
;	ani	0f0h
;	ora	b
;	out	sti0
;	mov	a,c
;	ora	a
;	mvi	a,10001000b
;	jrnz	stinit4
;	ani	01111111b
;stinit4	out	stic
;	mvi	a,1
;	out	stid
;	mvi	a,95h
;	out	stie
;	ret
;
;sainit:
;	mov	a,c
;	lxi	h,sertab
;	mov	e,a
;	mvi	d,0
;	dad	d
;	dad	d
;	mov	a,m
;	out	stia
;	inx	h
;	mov	a,m
;	ani	0fh
;	mov	b,a
;	in	sti9
;	ani	0f0h
;	ora	b
;	out	sti9
;	lxi	h,siotab
;	mov	b,m
;	inx	h
;	mvi	c,sioac
;	outir
;	mov	a,e
;	ora	a
;	mvi	a,01000100b
;	jrnz	sainit1
;	ani	10111111b
;sainit1	out	sioac
;	ret
;
;sbinit:
;	mov	a,c
;	lxi	h,sertab
;	mov	e,a
;	mvi	d,0
;	dad	d
;	dad	d
;	mov	a,m
;	out	stib
;	inx	h
;	mov	a,m
;	ani	0f0h
;	mov	b,a
;	in	sti9
;	ani	0fh
;	ora	b
;	out	sti9
;	lxi	h,siotab
;	mov	b,m
;	inx	h
;	mvi	c,siobc
;	outir
;	mov	a,e
;	ora	a
;	mvi	a,01000100b
;	jrnz	sbinit1
;	ani	10111111b
;sbinit1	out	siobc
;	ret
;
;sertab:
;	db	8,11h
;	db	96,33h
;	db	64,33h
;	db	175,11h
;	db	143,11h
;	db	128,11h
;	db	64,11h
;	db	32,11h
;	db	16,11h
;	db	11,11h
;	db	8,11h
;	db	5,11h
;	db	4,11h
;	db	3,11h
;	db	2,11h
;	db	1,11h
;
;siotab:
;	db	siotal-siotab-1
;	db	0,00011000b
;	db	3,11000001b
;	db	5,11101010b
;	db	4
;siotal	equ	$
;
;;-- unioende---

spoolerout	mov	a,c ! ori 80h ! mov c,a ! jmp mgrafout


null$init	ret
null$status	xra a ! ret
null$in		mvi a,1ah ! ret


ser2in:		in0	a,stat1
		ani	80h
		jrz	ser2in
		in0	a,rdr1
		ret

ser2ist:	in0	a,stat1
		ani	80h
		rz
		ori	0ffh
		ret

ser2out:	in0	a,stat1
		ani	02h
		jrz	ser2out
		mov	a,c
		out0	tdr1,a
		ret

ser2ost:	in0	a,stat1
		ani	02h
		rz
		ori	0ffh
		ret

centout:	xra	a
		in	p$in$ls258
		ani	01h
		jrz	centout
		mov	a,c
		out	centronics
		ret

centost:	xra	a
		in	p$in$ls258
		ani	01h
		rz
		ori	0ffh
		ret

	end
