;******************************************************************
;***								***
;*** LADER-BOOT-ROUTINE FUER PROF-181X 				***
;***								***
;*** ASSEMBLIERUNG ERFOLGT MIT RMAC				***
;*** LINKEN MIT LINK PB[LFD80]=PB				***
;***								***
;*** LAEDT CPMLDR VON ALLEN MIT UPD 765 FORMATIERTEN DISKS.	***
;*** CPMLDR MUSS AB DEM ZWEITEN SEKTOR DER  SPUR 0 FORTLAUFEND,	***
;*** AUF DER PLATTE STEHEN.					***
;***								***
;*** DER LADER STELLT FOLGENDE ANFORDERUNGEN AN DAS FORMAT:	***
;*** 								***
;*** 1)	DURCHGEHENDE NUMMERIERUNG DER SEKTOREN			***
;*** 2) FORMAT UND SEKTOR NUMERIERUNG AUF VORDERSEITEN- UND 	***
;***	ZUGEHOERIGER RUECKSEITENSPUR MUSS GLEICH SEIN		***
;***	(NUR WENN BYTE IN SYSTEMSIDES = 01H)			***
;*** 3) HEAD-BIT IN ID AUF VORDERSEITE = 0, AUF RUECKSEITE = 1	***
;***								***
;***								***
;*** LETZTE AENDERUNG AM:  21.01.1986 (JOACHIM)			***
;***								***
;******************************************************************
		;
		MACLIB	HD64180
		;
		MACLIB	PDEF
		;
		MACLIB	PSYS
		;
		MACLIB	PVEC
		;
CPMLDR     	EQU     4900H		;STARTADRESSE DES CPMLDR
					;
					;
					;
	CSEG				;MONITOR LAEDT BOOTSTRAPLOADER
					;NACH FD80H
					;
	JR	BOOT$START		;
					;
SSIDES	DB	0			;IST DIESE BYTE GLEICH 0, DANN
					;WERDEN NUR DIE SPUREN AUF DER VORDER-
					;SEITE GELESEN. IST DIESES BYTE GLEICH
					;1, DANN WERDEN DIE SPUREN
					;ABECHSELND VON VORDER- UND RUECKSEITE
					;GELESEN. EINE ERNEUTE FORMATANPASSUNG
					;ERFOLGT ERST BEIM WECHSEL AUF DEN
					;NAECHSTEN ZYLINDER.
					;
STRACKS	DB	2			;IN DIESEM BYTE STEHT DIE ANZAHL DER
					;SPUREN, DIE GELESEN WERDEN SOLLEN.
					;VORDER- UND RUECKSEITE GELTEN ALS
					;GETRENNTE SPUREN.
					;
					;ACHTUNG: BEIM SCHREIBEN DER SYSTEM-
					;SPUREN MIT PSYSGEN WERDEN DIE BYTES
					;SSIDE UND STRACK AUTOMATISCH GEPATCHT.
					;
NEXTDMA	DW	CPMLDR			;STARTADRESSE DES CPMLDR
					;IST GLEICH ERSTE DMA ADRESSE.
					;
SIGN	DB	'PROF-181X '		;KENNUNG DES BOOTSTRAP LOADERS
	DB	'(C) CONITEC 1985'	;
					;
					;
BOOT$START:				;BEGIN DES PROGRAMCODES
					;
	LDA	TEST$LSEK		;LADE NUMMER DES ERSTEN SEKTORS
	INR	A			;EINEN SEKTOR SPAETER BEGINT CPMLDR
BOOT0:	STA	SECTOR			;
	LDA	SECSZ			;LADE SEKTOR GROESSE UM
	LXI	H,64			;DMA ADRESSE DER NAECHSTEN SPUR
	INR	A			;ZU BERRECHNEN.
	MOV	B,A			;
BOOT1	DAD	H			;BERRECHNE ZUERST SEKTORGROESSE
	DJNZ	BOOT1			;IN BYTES.
	XCHG				;ERGEBNIS NACH DE.
	LHLD	NEXTDMA			;SETZE ZUERST DMAADRESSE DIESER SPUR.
	SHLD	DMAADR			;
	LDA	SECTOR			;BERRECHNE JETZT DIE DAMAADRESSE DER
	MOV	B,A			;NAECHSTEN SPUR
	LDA	EOT			;
	SUB	B			;
	INR	A			;
	MOV	B,A			;
	STA	SECTCNT			;SETZE SEKTOR ZAEHLER
BOOT2	DAD	D			;
	DJNZ	BOOT2			;
	SHLD	NEXTDMA			;OK, NAECHSTE DMA ADRESSE ABSPEICHERN.
	CALL	MREAD			;JETZT KANN SPUR GELESEN WERDEN.
	JNZ	MBOOTERR		;WENN FEHLER, ZUM MONITOR.
	LXI	H,STRACKS		;SIND ALLE SPUREN GELESEN ?
	DCR	M			;
	JZ	CPMLDR			;DANN SPRINGE ZUM CPMLDR, SONST NEUE
					;SPUR LADEN.
	LXI	H,ZAEHLER		;ZAEHLER EINS ERHOEHEN, FALLS VON
	INR	M			;BEIDEN SEITEN GELESEN WIRD.
	LDA	SSIDES			;SIND DIE SYSTEMSPUREN AUF BEIDEN
	ANA	M			;SEITEN UND IST DIE NAECHSTE SPUR
	ANI	00000001B		;EINE UNGERADE SPUR?
	STA	HEAD			;WENN JA, DANN LESE GLEICHE SPUR AUF
	JRNZ	BOOT3			;DER RUECKSEITE.
	LXI	H,TEST$TRACK		;ANSONSTEN SCHALTE AUF NAECHSTEN
	INR	M			;ZYLINDER UND
	CALL	MTEST			;TESTE HIER DAS FORMAT.
	CALL	MSETCMDT		;SETZE CMDTAB NACH NEUEM FORMAT.
BOOT3	LDA	TEST$LSEK		;LESE AB ERSTEM SEKTOR AUF NEUER SPUR
	JR	BOOT0			;
					;
ZAEHLER	DB	000H			;MIT NULL VORDEFINIERT
					;
	END				;
