	title 'bank & move module for PROF-181 CP/M 3 linked BIOS'

	; letzte Aenderung am:
	; 23.11.1985 (Joachim)
	; 16.10.1990 Aenderung auf PROF-181 	

	cseg

	public	?move,?xmove,?bank
	public	dmatrans,adrtab,ibtab
	extrn	@cbnk

	maclib	hd64180

	maclib	pdef

	maclib	psys

	maclib	pkonfig

?xmove:
	sbcd	sbank		; lege source und dest. bank ab
	mvi	a,0ffh		; setze flag fuer xmove
	sta	x$flg		;
	ret

sbank	db	0		; source bank fuer xmove
dbank	db	0		; destination bank fuer xmove
x$flg	db	0		; flag fuer xmove aktiv
sadrs	dw	0		; zwischenspeicher fuer xmove
dadrs	dw	0		;
length	dw	0		;

?move:
	xchg			; we are passed source in DE and dest in HL
	lda	x$flg		; xmove aktiv?
	inr	a		;
	jrz	xmv		; sprung wenn ja
	ldir			; use Z80 block move instruction
	xchg			; need next addresses in same regs
	ret

xmv:	sded	dadrs		; save destination
	sbcd	length		; save length
	lda	sbank		; switch to source bank
	call	?bank		;
	lxi	d,xmv$buff	; ziel ist buffer
	ldir			; uebertrage
	shld	sadrs		;
	lda	dbank		; switch to dest. bank
	call	?bank		;
	lded	dadrs		;
	lbcd	length		;
	lxi	h,xmv$buff	;
	ldir			;
	lda	@cbnk		; orginal bank ein
	call	?bank		;
	xchg			;
	lded	sadrs		;
	xra	a		;
	sta	x$flg		;
	ret

xmv$buff:	ds	128

?bank:
	sta	current$bank	;
	push	h		; rette hl
	push	d		; rette de
	mov	e,a		; lade basisadresse der bank in akku
	mvi	d,0		;
	lxi	h,ibtab		;
	dad	d		;
	mov	a,m		;
	pop	d		; alter inhalt von hl und de 
	pop	h		;
	out0	bbr,a		; setze mmu
	ret			;
				;

ibtab:				; ibtab gibt die Basisadressen der
				; internen Banks an. Die physikalische
				; Anfangsadresse der internen Bank
				; ergibt sich, wenn man den ibtab
				; Eintrag mit 1000h multipliziert.
				;
	db	000h,040h,010h,020h	
	db	030h,038h,050h,058h	
	db	060h,068h,070h,078h	
	db	080h,088h,090h,098h	
	db	0a0h,0a8h,0b0h,0b8h
	db	0c0h,0c8h,0d0h,0d8h
	db	0e0h,0e8h,0f0h,0f8h

ibno:	equ	$-ibtab		; anzahl der internen banks

dmatrans:			; dma transfer, source und destination
				; daten stehen in @adrtab.
	lxi	h,adrtab	; zeiger auf datenliste.
	lxi	b,sar0l+(8*256)	; port und laenge angeben.
	otimr			; spezial ausgabe hd64180
	mov	a,m		; dcntl byte in akku
	out0	dmode,a		; und ausgeben.
	mvi	a,01100000b	; starte dma transfer
	out0	dstat,a		;
	ret			;
				;
adrtab:				;
	db	0,0,0,0,0,0,0,0	; datenliste
	db	000000010b	;

	end
