(************************************************************)
(*                                                          *)
(* Dieses Programm testet die DISI (512k)                   *)
(* mit einem sektorgrossen Array beliebigen Inhalts.        *)
(*                                                          *)
(*                                     (c) Conitec JH 1986  *)
(*                                                          *)
(************************************************************)
program DISI_Check;
const
  disi_lw = 'E';
  checkbuffer :array[0..127] of byte = 
    ($0ff,$0fe,$0fd,$0fc,$0fb,$0fa,$0f9,$0f8,
     $0f7,$0f6,$0f5,$0f4,$0f3,$0f2,$0f1,$0f0,
     $0ef,$0ee,$0ed,$0ec,$0eb,$0ea,$0e9,$0e8,
     $0e7,$0e6,$0e5,$0e4,$0e3,$0e2,$0e1,$0e0,
     $0df,$0de,$0dd,$0dc,$0db,$0da,$0d9,$0d8,
     $0d7,$0d6,$0d5,$0d4,$0d3,$0d2,$0d1,$0d0,
     $0cf,$0ce,$0cd,$0cc,$0cb,$0ca,$0c9,$0c8,
     $0c7,$0c6,$0c5,$0c4,$0c3,$0c2,$0c1,$0c0,
     $0bf,$0be,$0bd,$0bc,$0bb,$0ba,$0b9,$0b8,
     $0b7,$0b6,$0b5,$0b4,$0b3,$0b2,$0b1,$0b0,
     $0af,$0ae,$0ad,$0ac,$0ab,$0aa,$0a9,$0a8,
     $0a7,$0a6,$0a5,$0a4,$0a3,$0a2,$0a1,$0a0,
     $09f,$09e,$09d,$09c,$09b,$09a,$099,$098,
     $097,$096,$095,$094,$093,$092,$091,$090,
     $08f,$08e,$08d,$08c,$08b,$08a,$089,$088,
     $087,$086,$085,$084,$083,$082,$081,$080);
var
  sector,i    :integer;
  track       :integer;
  drive       :integer;
  ErrorFound  :boolean;
  readbuffer  :array[0..127] of byte; 

procedure dbc(no:integer;areg:integer;bc,de,hl:integer);
type
  pbarec = record
    no   :byte;
    areg :byte;
    bc   :integer;
    de   :integer;
    hl   :integer
  end;
var
  pba :pbarec;
begin
  pba.no:=no;
  pba.areg:=areg;
  pba.bc:=bc;
  pba.de:=de;
  pba.hl:=hl;
  bdos(50,addr(pba))
end;

procedure setsec(sec:integer);
begin
  dbc(11,0,sec,0,0)
end;

procedure settrk(trk:integer);
begin
  dbc(10,0,trk,0,0)
end;

procedure setdma(dma:integer);
begin
  dbc(12,0,dma,0,0)
end;

procedure readsec;
begin
  dbc(13,0,0,0,0)
end;

begin (* Hauptprogramm *)
  writeln;
  drive:=ord(disi_lw)-65;
  bdos(14,drive);
  ErrorFound:=false;
  setdma(addr(readbuffer));
  for track:=0 to 15 do
  begin
    sector:=0;
    while (not ErrorFound) and (sector < 256) do
    begin
      i:=0;
      setsec(sector);
      settrk(track);
      readsec;
      while (not ErrorFound) and (i < 128) do
      begin 
        if checkbuffer[i] <> readbuffer[i] then ErrorFound:=true;
        i:=i+1
      end;
      sector:=sector+1
    end;
    if ErrorFound then
    begin
      writeln('Datenverlust in Baustein Z',track+1:2);
      ErrorFound:=false
    end
  end;
  bdos(13);
  writeln;
  writeln;
  writeln('DISI checked!');
  writeln
end.
