;******************************************************************
;***                                                            ***
;***  PROF-181X Monitor Version: 1.5                            ***
;***                                                            ***
;***  letzte Aenderung am: 09.12.1992      (c) Joachim Hanst    ***
;***                                                            ***
;******************************************************************
;
		TITLE	'PROF-181X MONITOR VERSION 1.5'
;
;
;
		MACLIB	HD64180	;MACROS FUER Z80 UND HD64180 BEFEHLE
				;
		MACLIB	PDEF	;BENUTZE PDEF.LIB FUER ALLE P-SYSTEM MODULE
				;
		MACLIB	PSYS	;SYSTEMPAGE EQUATES
;
BELL		EQU	07H
CNGPRMT		EQU	'-'
CLRSCREEN	EQU	0CH	;ZEICHEN FUER BILDSCHIRM LOESCHEN
EPROML		EQU	4000H	;LAENGE DES EPROMS
RCR$BYTE	EQU	083H	;NUMBER OF REFRESH CYCLES, SEE HD64180 MANUAL
;
MK3835		EQU	NEIN	;WENN JA, WERDEN TREIBER FUER MK3835 AUSGEWAEHLT
				;WENN NEIN, WERDEN TREIBER FUER PCF8583 AUSGEWAEHLT
				;ACHTUNG MK3835 NOCH NICHT GETESTET.
;
		ORG     EPROM
MONITOR:
		;SPRUNGVEKTOR FUER MONITOR SERVICE-ROUTINEN
		;
		JMP	INIT		;MONITOR-EINGANG NACH RESET
CS		JMP	CONST		;CONSOLEN STATUS, ACHTUNG BIOS LENKT UM
CI		JMP	CONIN		;CONSOLEN EINGABE,---------- " --------
CO		JMP	CONOUT		;CONSOLEN AUSGABE,---------- " --------
		JMP	BOOTERR		;DRUCKE FEHLERMELDUNG
		JMP	SETCMDT		;SETZE CMDTAB ENTSPRECHEND TEST
		JMP	RECAL		;SETZE AUSGEWAEHLETES DRIVE AUF TRACK 0
		JMP	READ		;LESE DISK
		JMP	WRITE		;SCHREIBE DISK
		JMP	TEST		;TESTE DISK-FORMAT
		JMP	MOTO		;WARTE AUF READY UND GEBE DISK-BEFEHL
		JMP	CMFD		;SENDE DISK-BEFEHL OHNE READY
		JMP	RESULT		;ERGEBNISPHASE DES UPD 765
		JMP	SEEK		;POSITIONIERE AUF SPUR
		JMP	NEXT		;LESE EIN RESULT-BYTE AUS UPD 765
					;
MGRAFIN:	JMP	GRAFIN		;VIDEO KARTE EINGABE
MGRAFOUT:	JMP	GRAFOUT		;VIDEO KARTE AUSGABE
MGRAFIST:	JMP	GRAFIST		;VIDEO KARTE EIN STATUS
		DW	DEFTAB		;ZEIGER AUF VORDEFINITIONEN
		JMP	START		;RST 38 EINSPRUNG
MGRAFOST:	JMP	GRAFOST		;VIDEO KARTE AUS STATUS
					;
MSER1IN:	JMP	SER1IN		; SER1-SCHNITTSTELLE EINGABE
MSER1OUT:	JMP	SER1OUT		; SER1-SCHNITTSTELLE AUSGABE
MSER1IST:	JMP	SER1IST		; SER1-SCHNITTSTELLE EIN STATUS
MSER1OST:	JMP	SER1OST		; SER1-SCHNITTSTELLE AUS STATUS
					;
MGRADEIN:	JMP	SER1IN		; FREIHALTEN FUER GERADE X
MGRADEOUT:	JMP	SER1OUT		;
MGRADEIST:	JMP	SER1IST		;
MGRADEOST:	JMP	SER1OST		;
					;
MUSERIN		JMP	SER1IN		; BENUTZER EINGABE
MUSEROUT	JMP	SER1OUT		; BENUTZER AUSGABE
MUSERIST	JMP	SER1IST		; BENUTZER EIN STATUS
MUSEROST	JMP	SER1OST		; BENUTZER AUS STATUS
					;
USERINIT	NOP ! NOP !RET		;BENUTZER INITIALISIERUNG
VERSIONNR	DB	15H		;VERSIONSNUMMER
		JMP	START		;NMI EINSPRUNG
		JMP	DISKERR		;FLOPPY-FEHLERMELDUNG
		NOP ! NOP ! RET		;DIESE BEIDEN RETURNS
		MVI A,0 ! RET		;SIND NOCH FREI
		JMP	WRITE$TIME	;SETZE ZEIT
		JMP	READ$TIME	;LESE ZEIT
		JMP	SER1INIT	;SETZE BAUDRATE SER1
		JMP	SER2INIT	;SETZE BAUDRATE SER2
		JMP	SPECD		;SETZE DISKPARAMETER
		JMP	DRIVE$TRANS	;LOG. LW <=> PHYS. LW
		JMP	WRITE$CLK$DATA	;SCHREIBE DATEN IN UHR RAM
		JMP	MAXI$SET	;SCHALTE FDC AUF MAXI GESCHWINDIGKEIT
		JMP	MINI$SET	;SCHALTE FDC AUF MINI GESCHWINDIGKEIT
		JMP	DIREAD		;LESE DISI
					;
					;DIE FOLGENDEN 7 BYTES WERDEN VON
					;GENBOOT AUF DIE RICHTIGEN WERTE
					;GEPATCHT. SIE SIND NUR FUER EPROM-
					;BOOT WICHTIG.
					;
BIOS$START:	DW	NOPATCH		;BIOS EINSPRUNG BEI EPROM-BOOT
BOOT$DIR:	DW	00000H		;DIR-ZEIGER DER BOOTDATEIEN, WIRD NACH
					;BOOT$NAME DER SYS-PAGE KOPIERT.
BOOT$TEXT:	DW	BOOT$TEXT+2	;ZEIGER AUF TEXT, DER BEI EPROM-BOOT
		DB	'$'		;AUSGEGEBEN WIRD.
					;
CLK$STAT:	DB	01101100B	;UHR LAEUFT MIT 2 MHZ, KEINE BEDEUTUNG
					;WENN PCF8583 VERWENDET WIRD
					;
					;
;----------------------------------------------------EIN-AUSGABEROUTINEN-----
;
;
;
GRAFIST:
		;TERMINAL EINGABE STATUS
		;AKKU 0 UND Z WENN KEIN ZEICHEN
		;AKKU FF UN NZ WENN ZEICHEN
	IN	GRIPC
	ANI	GRIPIN$MASK
	RZ
	MVI	A,0FFH
	ORA	A	;RESET ZERROFLAG
	RET
;
;
;
GRAFOST:
		;TERMINAL AUSGABE STATUS
	IN	GRIPC
	ANI	GRIPOUT$MASK
	RZ
	MVI	A,0FFH
	ORA	A
	RET
;
;
;
GRAFIN: 
		;TERMINAL EINGABE
	IN	GRIPC
	ANI	GRIPIN$MASK	;ZEICHEN DA ?
        JRZ	GRAFIN   	;WARTE AUF ZEICHEN
        IN      GRIPD
	RET
;
;
GRAFOUT: 
 		;TERMINAL AUSGABE
	IN	GRIPC
	ANI	GRIPOUT$MASK
        JRZ     GRAFOUT	;WARTE BIS BUFFER LEER
        MOV     A,C     ;AUSGABE ZEICHEN NACH A
        OUT     GRIPD
	RET
;
;
;
SER1IN:
	IN0	A,STAT0
	ANI	80H
	JRZ	SER1IN
	IN0	A,RDR0
	RET
;
;
;
SER1OUT:
	IN0	A,STAT0
	ANI	02H
	JRZ	SER1OUT
	MOV	A,C
	OUT0	TDR0,A
	RET
;
;
;
SER1IST:
	IN0	A,STAT0
	ANI	80H
	RZ
	ORI	0FFH
	RET
;
;
;
SER1OST:
	IN0	A,STAT0
	ANI	02H
	RZ
	ORI	0FFH
	RET
;
;
;
SER1INIT:			;SETZE BAUDRATE SER1 NEU.
				;ACHTUNG ES WIRD NUR DIE BAUDRATE
				;VERAENDERT.
	CALL	GET$BAUD$BYTE	;BERECHNE TEILER BITS
	IN0	A,CNTLB0	;LESE CONTROLBYTE B0
	ANI	11010000B	;MASKIERE NICHT TEILER BITS
	ORA	C		;
	OUT0	CNTLB0,A	;SCHREIBE CONTROLBYTE B0 NEU
	RET			;
				;
SER2INIT:			;SETZE BAUDRATE SER2 NEU
				;SONST WIE SER1INIT.
	CALL	GET$BAUD$BYTE	;
	IN0	A,CNTLB1	;
	ANI	11010000B	;
	ORA	C		;
	OUT0	CNTLB1,A	;
	RET			;
				;
GET$BAUD$BYTE:			;
	ANI	0FH		;MASKIERE OBERE BITS
	MOV	L,A		;
	MVI	H,0		;
	LXI	D,BAUD$TAB	;
	DAD	D		;
	MOV	A,M		;
	ANI	00101111B	;MASKIERE TEILER BITS
	MOV	C,A		;
	RET			;
;
BAUD$TAB:			;WIRD VON INIT GESETZT
	DB	0,0,0,0,0,0,0,0	;
	DB	0,0,0,0,0,0,0,0	;
;
;
;
;
;-----------------------------------------ZEICHEN EIN/AUSGABE-ROUTINEN ENDE---
;
;
SOUT:				;GEBE STRING AUS
				;ANFANG IN HL, ENDE DURCH 24HEX
	MOV	A,M		;LESE ZEICHEN
	CPI	'$'		;STRING ENDE
	RZ			;RETURN WENN $
	MOV	C,A		;IN C FUER AUSGABE
	CALL	CO		;GEBE ZEICHEN AUF CONSOLE
	INX	H		;ZEIGER AUF NAECHSTES ZEICHEN
	JR	SOUT		;WIEDERHOLE
				;
;
;
CROUT: 
	PUSH	B		;
	MVI	C,0DH		;
	CALL	ECHO		;
	POP	B		;
	RET
;
;
;
ECHO: 
	PUSH	B		;
	MOV	B,C		;
	MVI	A,1BH		;
	CMP	B		;
	JRNZ	ECH05		;
	MVI	C,'$'		;
ECH05:	CALL	CO		;
	MVI	A,0DH		;
	CMP	B		;
	JRNZ	ECH10		;
	MVI	C,0AH		;
	CALL	CO		;
ECH10:	POP	B		;
	MOV	A,C		;
	RET
;
;
;
;
GETCH1:	;LESE EIN ZEICHEN VON KONSOLE, UND WANDLE IN GROSSBUCHSTABEN
	CALL	GETCH
	CPI	'a'
	RC
	SUI	'a'-'A'
	MOV	C,A
	RET
;
;
;
GETCH: 
	CALL	CI
	ANI	7FH
	MOV	C,A
	RET
;
;
;
DEZOUT:			;WANDLE AKKU IN DEZIMALZAHL UND GEBE AKKU AUS
	ORA	A	;AKKU NULL
	JRZ	DEZOUT2	;DANN IST SCHON ALLES OK
	MOV	B,A
	XRA	A
DEZOUT1	INR	A
	DAA
	DJNZ	DEZOUT1
DEZOUT2	CALL	NMOUT
	RET
;
;
HLNMOUT:		;GEBE HL ALS VIERSTELLIGE HEXADEZIMALZAHL AUS
			;RETTE ALLE REGISTER AUSSER AKKU
	MOV	A,H	;
	CALL	NMOUT	;
	MOV	A,L	;
;
NMOUT: 			;GEBE AKKUA ALS HEXADEZIMALZAHL AUF DEM CRT AUS
			;RETTE ALLE REGISTER
	PUSH	H
	PUSH	B
	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	ANI	0FH
	MOV	C,A
	CALL	PRVAL
	CALL	ECHO
	POP	PSW
	ANI	0FH
	MOV	C,A
	CALL	PRVAL
	CALL	ECHO
	POP	B
	POP	H
	RET
;
;
;
PRVAL: 
	PUSH	PSW
	MOV	A,C
	ORI	0F0H
	DAA
	ADI	0A0H
	ACI	040H
	MOV	C,A
	POP	PSW
	RET
;
;
;
PRINT$DRIVE:
				;GIBT DEN LAUFWERK BUCHSTABEN UND EIN BLANK
				;AUF DER KONSOLE AUS
	LDA	UNIT		;WELCHES LAUFWERK?
	CALL	DRIVE$TRANS	;
	ADI	'A'		;WANDLE IN ASCII
	MOV	C,A		;
	CALL	CO		;
	MVI	C,' '		;
	CALL	CO		;
	RET			;
;
;
;
DRIVE$TRANS:			;WANDLE PHYSIKALISCHE LAUFWERKS BEZEICHNUNG
				;IN LOGISCHE LAUFWERKS BEZEICHNUNG UND
				;UMGEKEHRT.
				;VERAENDERE NUR AKKU UND FLAGS.
				;
	ANI	03H		;MASKIERE OBERE 6 BITS
	JRNZ	TPL1		;SPRUNG WENN UNGLEICH NULL
	LDA	TEMP$LOG$DRIVE	;WENN NULL DIREKTER AUSTAUSCH
	ANI	03H		;UND ENDE.
	RET			;
TPL1:	PUSH	B		;
	MOV	C,A		;WENN GLEICH LOG$DRIVE, DANN
	LDA	TEMP$LOG$DRIVE	;AUF  NULL SETZEN
	ANI	03H		;SONST KEINE AENDERUNG
	CMP	C		;
	JRNZ	TPL2		;
	MVI	C,0		;
TPL2:	MOV	A,C		;
	POP	B		;
	RET			;
;
;
;
SETCMDT:
	;NEHME WERTE AUS TEST$TYPE UND TEST$MSEK
	;UND TRAGE SIE IN CMDTAB EIN
	;
	LDA	TEST$MSEK	;ANZAHL DER SEKTOREN/SPUR
	STA	EOT		;
	LDA	TEST$TYPE	;LADE TEST$TYPE
	MOV	C,A		;UND RETTE IN C
	ANI	40H		;MASKIERE UND
	STA	CMDTAB		;SETZE MFM BIT IN CMDTAB
	MOV	A,C		;
	ANI	03H		;SETZE SEKTORGROESSE
	STA	SECSZ		;
	ORA	A		;
	MVI	A,0FFH		;SETZE DTL AUF 80 BEI 128 BYTES/SEKTOR
	JRNZ	CMDS1		;SONST AUF 0FFH
	MVI	A,80H		;
CMDS1	STA	DTLL		;
	MOV	A,C		;SETZE GAP-LAENGE IN ABHAENGIGKEIT
	ANI	03H		;VON DER SEKTORGROESSE
	MOV	C,A		;
	MVI	B,0		;
	LXI	H,GAPTAB	;
	DAD	B		;
	MOV	A,M		;
	STA	GAPLL		;
	RET			;
				;
GAPTAB:				;DIESE TABELLE GIBT DIE GAPLAENGE FUER JEDE
				;SEKTORGROESE AN
	DB	007H		; GAPLAENGE FUER  128 BYTES/SEKTOR
	DB	00EH		; GAPLAENGE FUER  256 BYTES/SEKTOR
	DB	01BH		; GAPLAENGE FUER  512 BYTES/SEKTOR
	DB	035H		; GAPLAENGE FUER 1024 BYTES/SEKTOR
;
;
;
DELAY100US:			;VERZOEGERUNGSSCHLEIFE
				;WEITGEHEND FREQUENZUNABHAENIG, DA DURCH
				;SPEED BYTE KOPMPENSIERT
				;EINGANG HL: VERZOEGERUNGSZEIT IN 100 US
				;
	MOV	A,L		;IST HL NULL, DANN RETURN
	ORA	H		;
	RZ			;
	PUSH	H		;RETTE ZAHELER WERT
	LDA	SPEED		;LADE SPEED ZUM KOMPENSIEREN DER
	MOV	L,A		;INNEREN SCHLEIFE
	MVI	H,7		;
	MULT	H		;IN HL INNERE SCHLEIFENDAUER
D100US	DCX	H		;
	MOV	A,L		;
	ORA	H		;
	JRNZ	D100US		;
	POP	H		;
	DCX	H		;ZAEHLE AEUSERE SCHLEIFE UM EINS HERUNTER
	JR	DELAY100US	;
;
;
;
;******************************************************************
;***								***
;***    ES FOLGEN NUN DISK ROUTINEN FUER FDC 9268 [SMC]		***
;***								***
;******************************************************************
;
;
;
SPECD:

				;SETZT DISK PARAMETER FUER DMA BETRIEB
				;
	LHLD	UNIT		;
	PUSH	H		;RETTE CMDTAB
	MOV	A,L		;UNIT IN A
	ANI	00000011B	;WAEHLE RICHTIGE PARAMETER AUS
	MOV	L,A		;
	MVI	H,0		;
	DAD	H		;MAL ZWEI
	LXI	D,SPECD$WORD	;ZEIGER AUF PARAMETER TABELLE
	DAD	D		;
	MOV	A,M		;
	INX	H		;
	MOV	H,M		;
	MOV	L,A		;OK, DISKTIMING IN HL
				;AENDERUNG: AUSGLEICH MINI/MAX SPEED (23.11.1987)
	LDA	LAST$FDC$SPEED	;TESTE OB MINI ODER MAXI SPEED
	ORA	A		;
	JRNZ	SPECD1		;MAXI-LAUFWERK, WERTE STIMMEN
				;
	SRLR	H		;TEILE HLT DURCH ZWEI
	INR	H		;UND RUNDE AUF NAECHSTEN GERADEN WERT
	STC			;
	RARR	L		;TEILE SRT UND HUT DURCH ZWEI (SRT WIRD GLEICH GERUNDET)
	RES	3,L		;
	MVI	A,0		;RUNDE HUT AUF NAECHSTEN GERADEN WERT
	ADC	L		;
	MOV	L,A		;ENDE DER AENDERUNG VOM 23.11.1987
				;
SPECD1:				;
	RES	0,H		;SETZTE DMA BIT AUF AKTIV
	LXI	B,0303H		;SPECD BEFEHL
	SHLD	UNIT		;
	CALL	CMFD		;
	POP	H		;STELLE ALTE CMDTAB
	SHLD	UNIT		;WIEDER HER
	RET			;
;
;
;
INIFDC:
				;SOFT RESET DES FDC 9268
				;FALLS KEIN FLOPPY CONTROLLER VORHANDEN IST,
				;WIRD DISKFLG AUF 00H GESETZT, SONST AUF FFH
	MVI	A,0FFH		;DEFAULT FUER FLOPPY-C DA
	STA	DISKFLG
	LXI	H,0000H		;SETZE ZAEHLER
INIFDC1	DCR	H		;ERNIEDRIGE ZAEHLER
	IN	FDC		;
	CPI	80H		;REQUEST FOR MASTER
	RZ			;OK CONTROLLER DA
	IN	FDD		;LESE DATEN
	MOV	A,H		;IST ZAEHLER NULL
	ORA	L
	JRNZ	INIFDC1		;NEIN, NEUER VERSUCH
	STA	DISKFLG		;KEIN FLOPPYCONTROLLER DA, DISKFLG=00H
	RET
;
;
;
RECAL:
	CALL	START$MOTOR
	CALL	SPECD		;SETZE DISK-PARAMETER NEU
	XRA	A		;AKKU=0
	STA	ALT$TRACK	;VORSICHTSHALBER SPUR AUF NULL
	LDA	UNIT		;ALTE UNIT NEU SETZTEN
	STA	ALT$UNIT	;
	MVI	B,4		;VIER VERSUCHE
RECAL2:	PUSH	B		;
	CALL	RECAL1		;
	CALL	SENSD		;
	ANI	10H		;TRACK NULL ERREICHT?
	POP	B		;
	RNZ			;RUECKSPRUNG WENN EREICHT
	DJNZ	RECAL2		;
	RET
;
;
;
RECAL1:
	LXI	B,0207H
        CALL    MOTO 
        JMP	SENS
;
;
;
READY$MASK:
	;HOLT AUS READY$BYTE DIE WERTE FUER LW
	;KANN READY LIEFERN ODER NICHT LIEFERN
	;
	CALL	UNIT$MASK	;HOLE MASKE FUER EINGELOGGTES LW
	LDA	READY$BYTE	;UND MASKIERE READY$BYTE
	ANA	B		;
	RET
;
;
;
UNIT$MASK:
				;ERZEUGE AUS EINGELOGGTEM LW MASKE FUER
				;OBER UND UNTERE 4 BIT
	LDA	UNIT		;
DRIVE$MASK:			;
	ANI	00000011B	;
	INR	A		;
	MOV	B,A		;
	MVI	A,88H		;
UNIMASK	RLC			;
	DJNZ	UNIMASK		;
	MOV	B,A		;
	RET			;
;
;
;
SEEK:
	CALL	START$MOTOR
	LHLD	UNIT		;LADE NEUES LAUFWERK UND NEUER TRACK
	LBCD	ALT$UNIT	;LADE ALTES LAUFWERK UND ALTER TRACK
	MOV	A,C		;VERGLEICHE UNIT
	CMP	L		;
	JRZ	SEEK8		;SPRUNG WENN GLEICH
	CALL	SPECD		;UNIT HAT SICH GEANDERT, DESHALB
	JR	SEEK4		;NEUE DISK ZEITEN.
SEEK8	MOV	A,B		;HAT SICH LEDIGLICH TRACK GEANDERT?
	CMP	H		;AUCH ALTER TRACK ? DANN IST NICHTS
	RZ			;ZU TUN.
SEEK4:	LHLD	UNIT		;
	SHLD	ALT$UNIT	;ALTES:=NEUES
	XRA	A		;DAMIT ADRESSBIT 8 = 0 BEI EINLESEN
	IN	P$IN$LS258	;
	ANI	MASK$MOT	;
	JRZ	SEEK5		;WENN MOTOR SCHON LIEF, DANN KEIN WARTEN
	LDA	STEP$WAIT	;LADE WARTEZEIT (EPSON FEHLER)
	ORA	A		;WENN EPSON WARTEZEIT NULL, DANN WEITER
	JRZ	SEEK5		;
	PUSH	PSW		;
	IN	FDC		;DIENT NUR ZUM MOTOR EINSCHALTEN
	CALL	START$MOTOR	;
	POP	PSW		;
	MOV	L,A		;
	MVI	H,100		;MAL 100 UM 10 MS SCHRITTE
	MULT	H		;ZU ERREICHEN
	CALL	DELAY100US	;VERZOEGERUNG
SEEK5:	LDA	RWCMD		;WAR VORHER SCHREIBBEFEHL
	CPI	06H		;
	JRZ	SEEK6		;WENN NEIN WEITER
	LDA	TE$TIME		;VERZOEGERUNG GLEICH NULL
	ORA	A		;
	JRZ	SEEK6		;WENN JA WEITER
	MOV	L,A		;IN HL
	MVI	H,0		;
	CALL	DELAY100US	;VERZOEGERUNG
SEEK6:	CALL	SEEK3		;EIN ODER ZWEI STEP IMPULSE PRO SPUR
	JRZ	SEEK1		;SPRUNG WENN EIN STEP IMPULS
	LDA	TRACK		;SONST VERDOPPLE SPUR NR.
	PUSH	PSW		;RETTE JEDOCH ALTE SPUR NR.
	ADD	A		;
	STA	TRACK		;
SEEK1:				;
	LXI	B,030FH		;SEEK TRACK
        CALL    MOTO 		;
	CALL	SEEK3		;TESTE, OB ES ZWEI STEP IMPULSE WAREN
	JRZ	SEEK2		;SPRUNG, WENN NEIN
	POP	PSW		;SONST LADE ALTE SPUR NR.
	STA	TRACK		;ZURUECK
SEEK2:				;
                     		;SEEK FINISHD ?
SENS:	LXI     B,0108H 	;SENS DRIVE
        CALL    CMFD		;
        CALL    NEXT		;
	PUSH	PSW		;SAVE RESULT
        CPI     080H    	;INVALID COMMAND ?
        CNZ     NEXT    	;NO => NEXT RESULT
        POP     PSW     	;FIRST RESULT
	ANI	020H		;ISOLIERE BIT 5
        JZ      SENS		;
        RET
;
SEEK3:
	CALL	UNIT$MASK	;TESTE OB ZWEI STEPIMPULSE
	LDA	SEEKNR		;AUSGEFUEHRT WERDEN SOLLEN
	ANA	B		;
	ANI	0FH		;
	RET			;
;
;
;
RESULT:		;FETCH RESULT OF READ WRITE OPERATION
		;AND CHECK THEM FOR R/W ERRORS
                ;Z+A=00 IF NO ERRORS
                ;NZ,A=? IF ERRORS
	MVI	B,006H		;7RESULTS
        CALL    NEXT		;
        LXI     H,REST		;RESULT TABLE
        MOV     M,A     	;STORE RESULT
        ANI     0C0H    	;ERROR ?
	MOV	C,A		;SAVE
RESLOP  CALL    NEXT		;
	INX	H		;
        MOV     M,A     	;STORE RESULT
	DJNZ	RESLOP		;
				;
        MOV     A,C		;RESTORE RESULT 0
        ORA     A		;IN AKKU
        RET
;
;
;
SPEED$CONST:
	;WARTE BIS DREHZAHL KONSTANT, DANN RETURN MIT ZERO-FLAG=0
	;WENN DREHZAHL NICHT KONSTANT WIRD DANN ZERO-FLAG=1
	;
TOLERANZ	EQU	64	;TOLERANZ FUER DREHZAHL KONSTANT
	
	CALL	START$MOTOR			;
	LXI	B,0204H		;SELEKTIERE LAUFWERK
	CALL	CMFD		;
	LXI	D,0		;BESETZE VOR
	MVI	B,10		;ZEHN VERSUCHE
SPEEDC1	XCHG			;ADDIERE ZU DE TOLERANZ
	LXI	D,TOLERANZ	;
	DAD	D		;
	XCHG			;
	CALL	CDRIVE$SPEED	;MESSE DREHZAHL
	JRZ	SPEEDC3		;ZURUECK WENN LAUFWERK STEHT
	XCHG			;BILDE DIVERENZ ZU VORHER
	DSBC	D		;
	MOV	A,H		;
	CPI	0		;IM TOLERANZBEREICH?
	JRNZ	SPEEDC2		;SPRUNG WENN NEIN
	MOV	A,L		;
	CPI	TOLERANZ*2	;
	JRNC	SPEEDC2		;SPRUNG WENN DREHZAHL NOCH NICHT KONSTANT
	CALL	CDRIVE$SPEED	;WARTE NOCH ZWEI UMDREHUNGEN
	CALL	CDRIVE$SPEED	;
				;
	CALL	NEXT		;DESELEKTIERE LAUFWERK
	MVI	A,0FFH		;ZURUECK MIT ZERO = 0
	ORA	A		;
	RET			;
				;
SPEEDC2	DJNZ	SPEEDC1		;MAXIMAL 10 VERSUCHE
SPEEDC3	CALL	NEXT		;DESELEKTIERE LAUFWERK
	XRA	A		;SONST ZURUECK MIT ZERO=1
	RET			;
;
;
;
CDRIVE$SPEED:
	;MESSE GESCHWINDIGKEIT DES LAUFWERKS
	;WENN SICH DISKETTE NICHT DREHT IST DAS ZERO-FLAG GESETZT
	;SONST ZERO-FLAG=0 UND GESCHWINDIGKEIT IN HL
	;
	XRA	A		;
	IN	P$IN$LS258	;LESE INDEX-SIGNAL
	ANI	MASK$IDX	;UND MASKIERE
	JRZ	DSPEED1		;WENN INDEX DA, ERSTE SCHLEIFE
				;UEBERSPRINGEN
				;
	LXI	H,0		;WARTE BIS INDEX KOMMT
DSPEED2	INX	H		;ERHOEHE HL
	MOV	A,H		;OUT OF TIME?
	ORA	L		;
	RZ			;DANN RETURN
	XRA	A		;
	IN	P$IN$LS258	;LESE INDEX-SIGNAL
	ANI	MASK$IDX	;UND MASKIERE
	JRNZ	DSPEED2		;WARTE BIS LOW
				;
DSPEED1	LXI	H,0		;WARTE BIS INDEX WEGGEHT
DSPEED3	INX	H		;ERHOEHE HL
	MOV	A,H		;OUT OF TIME?
	ORA	L		;
	RZ			;DANN RETURN
	XRA	A		;
	IN	P$IN$LS258	;LESE INDEX-SIGNAL
	ANI	MASK$IDX	;UND MASKIERE
	JRZ	DSPEED3		;WARTE BIS HIGH
				;
	LXI	H,0		;EIGENTLICHER ZAEHLER
DSPEED4	INX	H		;ERHOEHE HL
	MOV	A,H		;OUT OF TIME?
	ORA	L		;
	RZ			;
	XRA	A		;
	IN	P$IN$LS258	;LESE INDEX UND WARTE
	ANI	MASK$IDX	;BIS WIEDER LOW
	JRNZ	DSPEED4		;
	MVI	A,0FFH		;RESET ZERO-FLAG
	ORA	A		;
				;
	RET			;ZURUECK MIT DRIVE-SPEED
;
;
;
NOREADY$MOTO:
	XRA	A		;
	IN	P$IN$LS258	;LAEUFT MOTOR SCHON ?
	ANI	MASK$MOT	;
	JRZ	NREDY1		;SPRUNG WENN MOTOR SCHON LAEUFT
NREDY2	CALL	SPEED$CONST	;WARTE BIS LW AUF TOUREN
	JRNZ	NREDY1		;SPRUNG WENN DREHZAHL KONSTANT
	CALL	NRDYERR		;GEBE ERROR-TEXT AUS
	JRNZ	NREDY2		;WIEDERHOLUNG
	JMP	UMLEIT$GETCM	;
NREDY1	
	JMP	MOTO1
;
;
;
MOTO:				;WAITS UNTIL DISK READY AND THEN
                		;TRANSMITS COMMAND TO FDC
				;
	PUSH	B		;SAVE COMMAND
	CALL	READY$MASK	;KANN READY GELIEFERT WERDEN?
	ANI	0FH		;STEHT IN DEN UNTEREN 4 BITS
	JNZ	NOREADY$MOTO	;WENN NICHT SPRUNG
				;SONST WEITER WIE GEHABT
				;
MOTO2	LXI	H,SPEED		;SETZE TIME OUT ZAEHLER IN ABHAENGIGKEIT
	MOV	L,M		;VON DER TAKTFREQUENZ
	MVI	H,6		;HIER ZAHL ZWISCHEN 1 UND E
	MULT	H		;
	MVI	H,0F0H		;
	MULT	H		;
MOTO3	PUSH	H		;SAVE TIMER
	LXI	B,0204H		;SENSE DRIVE
	CALL	CMFD
	CALL	NEXT		;FETCH RESULT
	POP	H		;GET TIMER VALUE
	ANI	20H		;DISK READY ?
	JRNZ	MOTO1		;OK, READY
	DCX	H		;TIMER=TIMER-1
	MOV	A,H		;= ZERO?
	ORA	L		;
	JRNZ	MOTO3		;NO, TRY AGAIN
	CALL	NRDYERR		;DRIVE NOT READY TEXT
	JRNZ	MOTO2		;NO, AGAIN
	JMP	UMLEIT$GETCM	;ENTWEDER MONITOR ODER WARM-BOOT
				;
				;
NRDYERR:
	;GEBE FEHLERMELDUNG FUER DRIVE NOT READY AUS
	;UND VERGLEICHE EINGEGEBENES ZEICHEN MIT N
	;
	LXI	H,NREADY1	;PRINT ERROR TEXT
	CALL	SOUT		;
	CALL	PRINT$DRIVE	;GEBE LW BUCHSTABE AUS
	LXI	H,NREADY2	;GEBE REST TEXT AUS
	CALL	SOUT		;
	CALL	GETCH1		;AGAIN?
	MOV	C,A		;ECHO
	CALL	ECHO		;
	CALL	CROUT		;LINE FEED
	MOV	A,C		;
	CPI	'N'		;
	RET			;
	;
NREADY1	DB	0DH,0AH,BELL,' Drive $'
NREADY2	DB	'not ready, retry (Y/N) ? $'
;
;
MOTO1:	POP	B
;
;
CMFD:		;TRANSMIT COMMAND TO FDC
		;IN B STEHT ANZAHL DER BYTES
		;IN C STEHT BEFEHL
                ;
	LXI     H,CMDTAB	;
CMFD1	MVI	A,30		;WAIT FOR MASTER
CMFD2	DCR	A		;
	JRNZ	CMFD2		;
	IN      FDC		;REQUEST FOR MASTER
        ANI     0C0H		;
        CPI     080H		;
        JRNZ	CMFD1		;NO => WAIT
        MOV     A,C     	;YES =>
        OUT     FDD     	;SEND BYTE
        INX     H       	;POINT TO NEXT BYTE
        MOV     C,M		;
        DJNZ	CMFD1		;SEND NEXT BYTE
        RET             	;ALL BYTES TRANSFERRED
;
;
;
NEXT:		;READ NEXT RESULT FROM FDC
                ;
	MVI	A,6	;WAIT FOR MASTER READY
NEXT1	DCR	A	;
	JRNZ	NEXT1	;
	IN	FDC	;REQUEST FOR MASTER
        ANI     0C0H    ;TRANSFER TO MASTER
        CPI     0C0H	;
        JNZ     NEXT    ;NO =>WAIT
	IN	FDD	;YES => FETCH RESULT
        RET  
;
;
;
WRITE:
	MVI	A,5			;WRITE COMMANDO
	LXI	H,TXTWR			;WRITE ERROR TEXT
	JMP	RWCOM
;
;
;
READ:
	MVI	A,06H			;READ COMMANDO
	LXI	H,TXTRD			;READ ERROR TEXT
	JMP	RWCOM
	;
	;
	;
RWCOM:
	;VOR EINTRITT IN DIESE ROUTINE MUESSEN CMDTAB
	;SECTCNT UND DMAADR GESETZT SEIN.
	;IN A MUSS READ ODER WRITE COMMANDO STEHEN,
	;IN HL MUSS DIE ADRESSE DER ERROR MSSG. STEHEN.
	;ES WERDEN DIE ANGEGEBENE ANZAHL SECTCNT
	;VON/NACH DMAADR UEBERTRAGEN.
	;HD BIT WIRD ENTSPRECHEND DEM H BIT GESETZT.
	;DAS IN CMDTAB STEHENDE MFM BIT WIRD UEBERNOMMEN.
	;ES WIRD DIE PRECOMPENSATION ZEIT AUS WRITE$PRECOM
	;UEBERNOMMEN.
	;
	CALL	START$MOTOR
	;
	STA	RWCMD		;LEGE COMMANDO AB
	SHLD	ERMSG		;LEGE ADR FUR ERR.TEXT AB
	LDA	SECTCNT		;SOLLEN NULL SEKTOREN UEBERTRAGEN
	ORA	A		;WERDEN, DANN
	RZ			;RETURN
	CALL	SEEK		;POSITIONIERE
	CALL	SETHEAD		;TRAGE HEAD BIT IN UNIT EIN
	CALL	SEND$PRECOM	;SETZE PRECOMPENSATION
	LDA	RWRETRY		;LADE
	MOV	B,A		;ANZAHL DER VERSUCHE NACH B
RW4	PUSH	B		;SAVE RETRY
				;PROGRAMMIER DMA KONTROLLER
	LHLD	DMAADR		;LADE DMA ADRESSE
	OUT0	MAR1L,L		;
	OUT0	MAR1H,H		;
	LDA	DMABANK		;
	OUT0	MAR1B,A		;
	MVI	A,DAK		;DMA PORT DES UPD765
	OUT0	IAR1L,A		;
	XRA	A		;
	OUT0	IAR1H,A		;
	LDA	SECSZ		;BERRECHNE ANZAHL DER BYTES
	MOV	B,A		;AUS SEKTORGROESSE
	INR	B		;UND SEKTOR ANZAHL
	XRA	A		;
	STC			;
RW5	RAL			;
	DJNZ	RW5		;
	MOV	L,A		;
	LDA	SECTCNT		;ANZAHL DER SEKTOREN
	MOV	H,A		;
	MULT	H		;
	MVI	B,7		;DAS GANZE MAL 128
RW8	DAD	H		;
	DJNZ	RW8		;
	OUT0	BCR1L,L		;
	OUT0	BCR1H,H		;
	IN0	A,DCNTL		;
	ANI	0F0H		;
	MOV	C,A		;
	LDA	RWCMD		;
	CPI	6		;LEGE UEBERTRAGUNGSRICHTUNG FEST
	MVI	A,00001010B	;
	JRZ	RW1		;
	MVI	A,00001000B	;
RW1	ORA	C		;
	OUT0	DCNTL,A		;
	MVI	A,10010000B	;AKTIVIERE DMA
	OUT0	DSTAT,A		;
				;PROGRAMMIERE UPD 765
	MVI	B,9		;9 BYTES ZU UEBERTRAGEN
	LDA	RWCMD		;LADE COMMANDO
	MOV	C,A		;NACH C
	LDA	CMDTAB		;TRAGE MFM BIT EIN
	ANI	040H		;ISOLIERE MFM BIT
	ORA	C		;COMMAND DAZU
	MOV	C,A		;ZURUECK INC
	CALL	MOTO		;SEND COMMAND TO UPD 765
				;
	CALL	RESULT		;HOLE ERGEBNIS
	LDA	REST+1		;
	MOV	C,A		;
	LDA	REST+2		;
	ORA	C		;SONSTIGES FEHLER BIT GESETZT
	POP	B		;RESTORE RETRY COUNTER
	JRZ	RW7		;KEINE FEHLER
	DJNZ	RW4		;NOCH VERSUCHE FREI?
RW7:				;
	ORA	A		;SET ZERO FLAG
	PUSH	PSW		;RETTE FLAGS UND AKKU FUER FEHLERMELDUNG
	CNZ	DISKERR		;DRUCKE FEHLER
	POP	PSW		;LADE AKKU FUER FEHLERMELDUNG
	RET
;
;
;
SETHEAD:
	;SETZE HEAD BYTE AUF 00H ODER 01H
	;SETZE HEAD BIT IN UNIT BYTE
	;
	;FOLGENDE KOMBINATIONEN SIND MOEGLICH:
	;X BEDEUTET UNBESTIMMT, - BEDEUTET KEINE AENDERUNG ZU VORHER
	;
	; HEAD VORHER=>	UNIT NACHHER,	HEAD NACHHER
	; XXXXXX00	000000--	00000000
	; XXXXXX01	000001--	00000001
	; XXXXXX10	000001--	00000000
	; XXXXXX11	000000--	00000001
	;
	LDA	HEAD	;LADE HEAD BIT
	MOV	C,A	;RETTE IN C
	ANI	1	;
	STA	HEAD	;
	MOV	A,C	;
	RLC		;EIN BIT NACH LINKS
	MOV	C,A	;
	RLC		;ZWEI BIT NACH LINKS
	XRA	C	;ERZEUGE UNIT BIT
	ANI	04H	;BLENDE ANDERE BITS AUS
	MOV	C,A	;SAVE
	LDA	UNIT	;LADE DRIVE NR.
	ANI	03H	;BLENDE OBERE BITS AUS
	ORA	C	;HEAD DAZU
	STA	UNIT	;ZURUECK
	RET
;
;
;
TEST:
	;DIESE ROUTINE ERMITTELT DIE DATEN DER PLATTE, DIE SICH IM VON
	;UNIT SPEZIFIZIERTEN LAUFWERK BEFINDET (BIT 2 GIBT KOPF AN).
	;GETESTET WIRD DIE SPUR, DIE IN TEST$TRACK STEHT.
	;ALS ERGEBNIS WERDEN TEST$TYPE TEST$LSEK UND TEST$MSEK GESETZT
	;KANN DER PLATTEN-TYP NICHT ERMITTELT WERDEN IST DER AKKU AUF FFH
	;WENN PLATTEN-TYP ERKANNT WURDE IST AKKU=00H
	;
	CALL	RECAL		;RECALIBRIERE
        LDA     UNIT    	;SEITE 0 WAEHLEN
        ANI     07H		;
        STA     UNIT		;
	LDA	TEST$TRACK	;POSITIONIERE AUF DIE SPUR
	STA	TRACK		;DEREN FORMAT ERKANNT WERDEN SOLL
	CALL	SEEK		;
				;
	MVI	A,60H		;TESTE OB DD,MINI
	STA	TEST$TYPE	;
	CALL	MINI$SET	;
	CALL	READID		;
	JRZ	TEST1		;SPRUNG WENN DD,MINI
				;
	MVI	A,40H		;TESTE OB DD,MAXI
	STA	TEST$TYPE	;
	CALL	MAXI$SET	;
	CALL	READID		;
	JRZ	TEST1		;SPRUNG WENN DD,MAXI
				;
	MVI	A,00		;TESTE OB SD,MAXI
	STA	TEST$TYPE	;
	CALL	MAXI$SET	;
	CALL	READID		;VERSUCHE ID-FELD ZU LESEN
	JRZ	TEST1		;SPRUNG WENN SD,MAXI
				;
	MVI	A,20H		;TESTE OB SD,MINI
	STA	TEST$TYPE	;
	CALL	MINI$SET	;
	CALL	READID		;
	JRZ	TEST1		;SPRUNG WENN SD,MINI
				;

TEST2:	MVI	A,0FFH		;BLEIBT NICHTS MEHR  UEBRIG
	RET			;RUECKSPRUNG MIT FEHLER
				;
TEST1:				;OK, MINI ODER MAXI, FM ODER MFM
				;ERKANNT
	CALL	SPECD		;SETZE DISKTIMING NEU, DA MINI/MAXI VERAENDERT
				;
				;ZAEHLE JETZT DIE ANZAHL DER SEKTOREN
				;AUF DER SPUR
	LDA	REST+5		;LADE SEKTORNUMMER VON ERSTEM READ$ID
	MOV	D,A		;NACH D UM EINE UMDREHUNG ABZUWARTEN
	MOV	C,A		;NACH C UM GROESSTEN SEKTOR ZU ERMITTELN
	MOV	E,A		;NACH E UM KLEINSTEN SEKTOR ZU ERMITTELN
	MVI	B,52		;MAXIMAL 52 LESEVERSUCHE, DANN FEHLER
TEST3:	PUSH	B		;RETTE REGISTER
	PUSH	D		;
	CALL	READ$ID		;LESE NAECHSTES ID-FELD
	POP	D		;RESTORE REGISTER
	POP	B		;
	JRNZ	TEST2		;SPRUNG WENN FEHLER
	LDA	REST+5		;LADE SEKTORNUMMER
	CMP	D		;EINE UMDREHUNG ?
	JRZ	TEST4		;DANN ENDE (MAX-SEKTOR IN C)
	CMP	C		;NEUE SEKTORNUMMER GROESSER ALS ALLE ANDEREN?
	JRC	TEST5		;SPRUNG WENN NEIN
	MOV	C,A		;SONST NEUER SEKTOR DER GROESSTE
TEST5:	CMP	E		;NEUE  SEKTORNUMMER KLEINER ALS ALLE ANDEREN?
	JRNC	TEST9		;SPRUNG WENN NEIN
	MOV	E,A		;SONST NEUER SEKTOR DER KLEINSTE
TEST9:	DJNZ	TEST3		;LESE NEUEN SEKTOR EIN
	JR	TEST2		;WENN ZAEHLER ABLAEUFT, DANN FEHLER
				;
TEST4:	MOV	A,C		;LEGE GROSSTE SEKTORNUMMER AB
	STA	TEST$MSEK	;
	MOV	A,E		;LEGE KLEINSTE SEKTORUMMER AB
	STA	TEST$LSEK	;
				;
	LDA	REST+6		;PACKE SEKTORGROESSE ZU TEST$TYPE
	ANI	07H		;
	MOV	C,A		;
	LDA	TEST$TYPE	;
	ORA	C		;
	MOV	C,A		;PACKE HEAD BIT ZU TEST$TYPE
	LDA	REST+4		;
	RLC			;
	RLC			;
	RLC			;
	RLC			;
	ANI	00010000B	;
	ORA	C		;
	STA	TEST$TYPE	;
				;
	LDA	UNIT		;SOLL TWO-SIDED-BIT IMMER AUF HIGH SEIN?
	CMA			;(NAEMLICH DANN, WENN ENTSPRECHENDES
	ANI	00000011B	;BIT IM OBEREN NIPPLE VON SEEKNR AUF HIGH)
	MOV	B,A		;
	ORA	A		;
	LDA	SEEKNR		;
	JRZ	TEST6		;KEIN SCHIEBEN NOTWENDIG
TEST7:	RLC			;
	DJNZ	TEST7		;
TEST6:	ANI	80H		;WENN OBERSTES BIT 1, DANN TS-BIT AUCH EINS
	JRNZ	TEST8		;SONST TS-BIT WIE TS-LEITUNG
	CALL	SENSD		;LESE TWO-SIDED SIGNAL EIN
	RLC			;VERSCHIEBE IN OBEERSTES BIT
	RLC			;
	RLC			;
	RLC			;
	ANI	80H		;BLENDE REST AUS
TEST8:	MOV	C,A		;PACKE ZU TEST$TYPE
	LDA	TEST$TYPE	;
	ORA	C		;
	STA	TEST$TYPE	;
				;OK, ALLES GEPRUEFT
	MVI	A,0		;FEHLERFREIE RUECKKEHR
	RET			;
;
;
;
READID:
	;LESE NAECHSTES ID FELD
	;IN TEST$TYPE BIT 6 SEHT OB FM ODER MFM
	;KONNTE KEIN ID-FELD GELESEN WERDEN, DANN IST AKKU<>0
	;UND ZERO-FLAG NICHT GESETZT
	;
	LXI	B,020AH		;READ ID KOMMANDO
	LDA	TEST$TYPE	;PACKE MFM BIT DAZU
	ANI	040H		;
	ORA	C		;
	MOV	C,A		;
	CALL	MOTO		;LESE ID-FELD
	CALL	RESULT		;WAR LESEVERSUCH ERFOLGREICH?
	ORA	A		;
	RET
;
;
;
MAXI$SET:
	;SETZT FLOPPY KONTROLER AUF MAXI-LAUFWERKE
	PUSH	PSW		;
	MVI	A,PAD$MINI	;
	OUT	P$LS259		;
	LDA	SWITCH$DELAY	;WARTEZEIT EINGESTELLT
	ORA	A		;
	MVI	A,0FFH		;
	CNZ	DELAYS1		;JA, DANN VERZOEGERUNG
	STA	LAST$FDC$SPEED	;
	POP	PSW		;
	RET
;
;
;
MINI$SET:
	;SETZT FLOPPY-KONTROLER AUF MINI-LAUFWERKE
	PUSH	PSW		;
	MVI	A,PAD$MINI OR 1	;
	OUT	P$LS259		;
	LDA	SWITCH$DELAY	;WARTEZEIT EINGESTELLT
	ORA	A		;
	MVI	A,0		;
	CNZ	DELAYS1		;JA, DANN VERZOEGERUNG
	STA	LAST$FDC$SPEED	;
	POP	PSW		;
	RET			
;
;
;
DELAYS1:			;VERZOEGERE WENN AENDERUNG BEI
				;MINI/MAXI EINSTELLUNG. VERZOEGERUNGSZEIT
				;STEHT IN SWITCH$DELAY.
				;
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
	PUSH	PSW		;
	MOV	C,A		;WAR AENDERUNG IN FDC TAKT
	LDA	LAST$FDC$SPEED	;
	CMP	C		;
	JRZ	DELAYS2		;DANN KEINE VERZOEGERUNG
	LDA	SWITCH$DELAY	;LADE VERZOEGERUNGSZEIT
	MOV	L,A		;ZEIT MAL 100 UM 10MS ZU ERREICHEN
	MVI	H,100		;
	MULT	H		;
	CALL	DELAY100US	;AUFRUF VERZOEGERUNGSSCHLEIFE
DELAYS2	POP	PSW		;
	POP	H		;
	POP	D		;
	POP	B		;
	RET			;
;
;
SENSD	LXI	B,0204H
	CALL	CMFD
	CALL	NEXT
	RET
;
;
;
SEND$PRECOM:			;SETZE PRECOMPENSATION WIE WRITE$PRECOM
				;WENN PRECOM$BEGINER ALS TRACK IST
				;ANSONSTEN SETZE DIE PRECOMPENSATION AUF NULL.
				;
	LDA	PRECOM$BEGIN	;SPUR KLEINER?
	MOV	C,A		;
	LDA	TRACK		;
	CMP	C		;
	MVI	A,0		;WENN SPUR KLEINER, DANN PRECOM=0
	JRC	BASIC$PRECOM	;
	LDA	WRITE$PRECOM	;SONST PRECOM WIE IN WRITE$PRECOM
				;CALL AUF BASIC$PRECOM KANN MAN SICH SPAREN
BASIC$PRECOM:
				;SENDE GEBE DIE UNTEREN 3 BITS DES AKKU
				;AUF DATA, M0 UND M1 AUS.
				;SETZT DISK PRECOMPENSATION.
				;
	MOV	C,A		;RETTE AKKU IN C
	ANI	01H		;MASKIERE BIT 0
	ORI	PAD$M0		;
	OUT	P$LS259		;UND SETZE BIT 0
	MOV	A,C		;
	RRC			;
	ANI	01H		;MASKIERE BIT 1
	ORI	PAD$M1		;
	OUT	P$LS259		;UND SETZE BIT 1
	MOV	A,C		;
	RRC			;
	RRC			;
	ANI	01H		;MASKIERE BIT 2
	ORI	PAD$DATA	;
	OUT	P$LS259		;UND SETZE BIT 2
	RET			;
;
;
;
DISKERR:
	;GIBT DISK FEHLERMELDUNG AUS
	;BENUTZT DAZU DIE RESULT TABELLE
	;UND DIE ERMSG EINTRAGUNG
	;
	LDA	DERMSG		;SOLL FEHLERMELDUNG
	INR	A		;UNTERDRUECKT WERDEN ?
	RZ			;WENN JA, RUECKSPRUNG
	LHLD	ERMSG		;LADE READ BZW WRITE TEXT
	CALL	SOUT		;UND GEBE IHN AUS
	LDA	REST		;LADE LAUFWERK NUMMER
	CALL	DRIVE$TRANS	;WANDLE IN LOGISCHES LAUFWERK
	ADI	41H		;WANDLE IN ASCCI
	MOV	C,A		;GEBE LAUFWERK BUCHSTABE AUS
	CALL	ECHO		;
				;
	LXI	H,TXT1		;GEBE TRACK AUS
	CALL	SOUT		;
	LDA	REST+3		;
	CALL	DEZOUT		;
				;
	LXI	H,TXT2		;GEBE HEAD AUS
	CALL	SOUT		;
	LDA	REST+4		;
	ADI	30H		;WANDLE IN ASCII
	MOV	C,A		;
	CALL	ECHO		;
				;
	LXI	H,TXT3		;GEBE SECTOR AUS
	CALL	SOUT		;
	LDA	REST+5		;
	CALL	DEZOUT		;
				;
				;GEBE FEHLER IM KLARTEXT AUS
				;
	LXI	D,ERROR$TABLE	;
	LDA	REST+1		;LESE STATUS1
	MOV	H,A		;
	LDA	REST+2		;LESE STATUS2
	MOV	L,A		;
ERRLOP:
	DAD	H		;TESTE OB FEHLERBIT GESETZT
	PUSH	H		;
	LDAX	D		;
	MOV	L,A		;
	INX	D		;
	LDAX	D		;
	MOV	H,A		;
	CC	SOUT		;WENN JA GEBE TEXT AUS
	POP	H		;
	INX	D		;ZEIGE AUF NAECHSTE MELDUNG
	MOV	A,H		;KEIN FEHLER MEHR DA?
	ORA	L		;
	JRNZ	ERRLOP		;
				;
	CALL	CROUT		;
				;
	RET			;OK, ENDE
;
;
;
TXT1	DB	', track #'
	DB	24H
TXT2	DB	', head #'
	DB	24H
TXT3	DB	', sector #'
	DB	24H
;
ERROR$TABLE:	DW	B15MSG	;FEHLERMELDUNGEN FUER ST1
		DW	NOBMSG
		DW	B13MSG
		DW	B12MSG
		DW	NOBMSG
		DW	B10MSG
		DW	B9MSG
		DW	B8MSG
;
		DW	NOBMSG	;FEHLERMELDUNGEN FUER ST2
		DW	B6MSG
		DW	B5MSG
		DW	B4MSG
		DW	NOBMSG
		DW	NOBMSG
		DW	B1MSG
		DW	B0MSG
;
NOBMSG	DB	24H
B15MSG	DB	10,13,' end of cylinder',24H
B13MSG	DB	10,13,' data error',24H
B12MSG	DB	10,13,' over run',24H
B10MSG	DB	10,13,' no data',24H
B9MSG	DB	10,13,' not writable',24H
B8MSG	DB	10,13,' missing address mark',24H
B6MSG	DB	10,13,' control mark',24H
B5MSG	DB	10,13,' data error in data field',24H
B4MSG	DB	10,13,' wrong cylinder',24H
B1MSG	DB	10,13,' bad cylinder',24H
B0MSG	DB	10,13,' missing address mark in data field',24H
;
TXTRD:
	DB	BELL,0DH,0AH,' Read error on $'
TXTWR:
	DB	BELL,0DH,0AH,' Write error on $'
;
;
;
;
;**********************************************************
;***							***
;***  ROUTINEN ZUM EIN UND AUSLESEN DER UHRZEIT		***
;***							***
;**********************************************************
;
;
;
	IF	MK3835
;
;
CLK$ENABLE:
	MVI	A,PAD$M0	;SETZE VOR AKTIVERUNG DES
	OUT	P$LS259		;MK3835 TAKT AUF LOW.
	MVI	A,PAD$CE OR 1	;CHIP ENABLE DES MK3835
	OUT	P$LS259		;
	RET			;
;
;
;
CLK$DISABLE:
	MVI	A,PAD$CE	;DEAKTIVIERE MK3835
	OUT	P$LS259		;
	RET			;
;
;
;
SCLK:
	MVI	A,PAD$M0 OR 1	;GEBE EINEN HIGHT TAKT
	OUT	P$LS259		;ZUR MK3835 AUS
	MVI	A,PAD$M0	;
	OUT	P$LS259		;
	RET			;
;
;
;
WRITE$CLK$BYTE:			;SCHREIBE EIN BYTE IN MK3835
	MVI	B,8		;EIN BYTE HAT 8 BIT
W$CLK:	MOV	A,C		;BYTE STEHT IN C
	ANI	1		;MASKIERE BYTE
	ORI	PAD$DATA	;
	OUT	P$LS259		;
	CALL	SCLK		;
	RRCR	C		;SCHIEBE C UM EIN BIT NACH RECHTS
	DJNZ	W$CLK		;BIS 8 BIT AUSGEGEBEN WURDEN
	RET			;
;
;
;
READ$CLK$BYTE:			;LESE EIN BYTE AUS MK3835
	MVI	B,8		;EIN BYTE HAT 8 BIT
R$CLK:	MVI	A,1		;EINS IN AKKU, DAMIT BEI IN A8=1
	IN	P$IN$LS258	;
	RLC			;BIT 7 INS CARRY
	RARR	C		;CARRY VON LINKS IN AKKU
	CALL	SCLK		;TAKT IMPULS
	DJNZ	R$CLK		;BIS 8 BIT AUSGEGEBENN WURDEN
	MOV	A,C		;
	CMA			;DATEN MUESSEN NEGIERT WERDEN
	MOV	C,A		;
	RET			;
;
;
;
CLK$PROTECT:			;SCHREIBSCHUTZ FUER MK3835
	CALL	CLK$ENABLE	;
	MVI	C,10001110B	;
	CALL	WRITE$CLK$BYTE	;
	LDA	CLK$STAT	;DURCH UMPATCHEN VON
	ORI	10000000B	;CLK$STAT KANN DIE QUARZ-
	MOV	C,A		;FREQUENZ GEAENDERT WERDEN.
	CALL	WRITE$CLK$BYTE	;
	JMP	CLK$DISABLE	;
;
;
;
CLK$NO$PROTECT:			;SCHREIBSCHUTZ FUER MK3835 AUFHEBEN
	CALL	CLK$ENABLE	;
	MVI	C,10001110B	;
	CALL	WRITE$CLK$BYTE	;
	LDA	CLK$STAT	;DURCH UMPATCHEN VON
	ANI	01111111B	;CLK$STAT KANN DIE QUARZ-
	MOV	C,A		;FREQUENZ GEAENDERT WERDEN.
	CALL	WRITE$CLK$BYTE	;
	JMP	CLK$DISABLE	;
;
;
;
READ$TIME:
	PUSH	PSW		;RETTE REGISTER
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
	CALL	CLK$ENABLE	;AKTIVIERE UHR
	MVI	C,10111111B	;BEFEHL FUER LESE UHR IM BURST MODE
	CALL	WRITE$CLK$BYTE	;
	MVI	D,7		;LESE 7 BYTE AUS MK3835
	LXI	H,TIME$FIELD	;IN RAM
R$TIME:	CALL	READ$CLK$BYTE	;
	MOV	M,A		;DATEN NACH HL
	INX	H		;HL ZEIGT EINS WEITER
	DCR	D		;
	JRNZ	R$TIME		;
	CALL	CLK$DISABLE	;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	RET			;
;
;
;
WRITE$TIME:
	CALL	CLK$NO$PROTECT	;SCHREIBSCHUTZ AUFHEBEN
	CALL	CLK$ENABLE	;AKTIVIERE UHR
	MVI	C,10111110B	;LESE UHR IM BURST  MODE
	CALL	WRITE$CLK$BYTE	;
	MVI	D,7		;SCHREIBE 7 BYTE AUS RAM
	LXI	H,TIME$FIELD	;IN MK3835
W$TIME:	MOV	C,M		;
	CALL	WRITE$CLK$BYTE	;
	INX	H		;
	DCR	D		;
	JRNZ	W$TIME		;
	CALL	CLK$DISABLE	;
	JMP	CLK$PROTECT	;SCHREIBSCHUTZ AKTIVIEREN
;
;
;
READ$CLK$DATA:
	CALL	CLK$ENABLE	;AKTIVIERE UHR
	MVI	C,11111111B	;LESE RAM IM BURST MODE
	CALL	WRITE$CLK$BYTE	;
	MVI	D,24		;
	LXI	H,SYSPAGE	;
R$DATA	CALL	READ$CLK$BYTE	;
	MOV	M,A		;
	INX	H		;
	DCR	D		;
	JRNZ	R$DATA		;
	JMP	CLK$DISABLE	;
;
;
;
WRITE$CLK$DATA:
	CALL	CLK$NO$PROTECT	;SCHREIBSCHUTZ AUFHEBEN
	CALL	CLK$ENABLE	;AKTIVIERE UHR
	MVI	C,11111110B	;LESE DATEN IM BURST  MODE
	CALL	WRITE$CLK$BYTE	;
	MVI	D,24		;SCHREIBE 24 BYTE AUS RAM
	LXI	H,SYSPAGE	;IN MK3835
W$DATA	MOV	C,M		;
	CALL	WRITE$CLK$BYTE	;
	INX	H		;
	DCR	D		;
	JRNZ	W$DATA		;
	CALL	CLK$DISABLE	;
	JMP	CLK$PROTECT	;SCHREIBSCHUTZ AKTIVIEREN
;
;
;
	ELSE

HIGHSDA:			; DATENLEITUNG DES PCF8583 AUF HIGH LEGEN
	MVI	A,PAD$DATA OR 1	; GEBE HIGH AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

LOWSDA:				; DATENLEITUNG DES PCF8583 AUF LOW LEGEN
	MVI	A, PAD$DATA	; GEBE LOW AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

HIGHSLC:			; CLOCKLEITUNG DES PCF8583 AUF HIGH LEGEN
	MVI	A,PAD$CE OR 1	; GEBE HIGH AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

LOWSLC:				; CLOCKLEITUNG DES PCF8583 AUF LOW LEGEN
	MVI	A, PAD$CE	; GEBE LOW AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

WAIT4US:			; VERZOEGERUNG VON CA. 4 US BEI 9,2 MHZ TAKT
	MVI	A,3		;
WAIT4L:	DCR	A		;
	JZ	WAIT4L		;
	RET			;

SLCPULS:			; SENDE EINEN TAKTIMPULS ZU PCF8583
				; LESE DABEI DIE DATENLEITUNG DES PCF8583
				; DATENPEGEL WIRD IN CARRY UEBERGEBEN.
				;
	CALL	HIGHSLC		; SETZE SCL AUF HIGH
	CALL	WAIT4US		; WARTE 4 US
	MVI	A,1		; EINS IN AKKU, DAMIT A8 = 0
	IN	P$IN$LS258	; LESE DATEN EIN
	CMA			; INVERTIEREN, DA LS258 INVERTIERT
	RLC			; UND BIT 7 INS CARRY FLAG
	CALL	LOWSLC		; SLC WIEDER LOW
	RET			; UND RETURN


	

START8583:			; Sende Startsequenz fuer Daten und Clock
				;
	CALL	HIGHSDA		; SETZE DATENLEITUNG VORSICHTSHALBER AUF HIGH
	CALL	WAIT4US		; WARTE 4 US
	CALL	LOWSDA		; SETZE DATENLEITUNG AUF LOW
	CALL	WAIT4US		; WARTE NOCHMAL 4 US
	CALL	LOWSLC		; SETZE TAKT LOW
	RET

STOP8583:			; Sende Stopsequenz fuer Daten und Clock
	CALL	LOWSDA		; SETZE DATEN AUF LOW
	CALL	WAIT4US		; WARTE 4 US
	CALL	HIGHSDA		; SETZE DATEN AUF HIGH
	CALL	WAIT4US		; WARTE NOCHMAL 4 US
	CALL	HIGHSLC		; SETZE CLOCK HIGH
	RET			;

RWPCF:				; LESE ODER SCHREIBE 8 BIT <=> ZU PCF8583
				; EINGANG = AKKU, ENTHAELT DIE DATEN FUER
				; SCHREIBEN IN PCF8583
				; AUSGANG = AKKU, ENHAELT DIE GELESENEN DATEN.
				; OB GELESEN ODER GESCHRIEBEN WIRD HAENGT
				; VOM INTERNEN ZUSTAND DES PCF8583 AB.
				; ACHTUNG BEIM LESEN MUSS AKKU GLEICH FF SEIN.
				; BEIM SCHREIBEN ENTHAELT DER AKKU DIE
				; GESENDETEN DATEN.
				;
	PUSH	B		; RETTE BC REGISTER
	MOV	C,A		; KOPIERE AKKU IN REGISTER C
	MVI	B,8		; 8 BIT ZAEHLER IN REGISTER B
RWPCFL:	MOV	A,C		; KOPIERE REGISTER C IN AKKU
	RLC			; UND SCHIEBE BIT 7 INS CARRY
	CC	HIGHSDA		; WENN CARRY HIGH, DANN DATEN HIGH
	CNC	LOWSDA		; SONST DATEN LOW
	CALL	SLCPULS		; SENDE EINEN TAKTIMPULS
	MOV	A,C		; SCHIEBE GELESENES BIT IN REGISTER C
	RAL			;
	MOV	C,A		;
	DCR	B		; SPAETERU DURCH DJNZ ERSETZEN
	JNZ	RWPCFL		; WIEDERHOLE BIS 8 BIT BEARBEITET
	MOV	A,C		; KOPIERE GELESENE DATEN IN AKKU
	POP	B		; REGISTER BC ZURUECKLADEN
	RET			; UND RETURN


PCFADR:				; SENDE WORTADRESSE ZUM PCF8583
				; ADRESSE STEHT IM AKKU
	PUSH	A		; RETTE AKKU
	CALL	START8583	; SENDE START-KONDITION
	MVI	A,0A2H		; SENDE SLAVEADRESSE FUER SCHREIBEN
	CALL	RWPCF		;
	CALL	HIGHSDA		; DATENLEITUNG AUF HIGH
	CALL	SLCPULS		; LESE ACKNOWLEGE VOM SLAVE
				; HIER MOEGL. PRUEFEN OB OK
	POP	A		; LADE WORTADRESSE VOM STACK ZURUECK
	CALL	RWPCF		; UND SENDE DIE ADRESSE ZUM PCF8583
	CALL	HIGHSDA		; DATENLEITUNG FUER
	CALL	SLCPULS		; ACKNOWLEGE AUF HIGH
				; HIER MOEGL. PRUEFEN OB OK
	RET			; UND RETURN



READPCF:			; LESE DATEN AUS PCF8583
				; EINGANGSWERTE =>
				; AKKU    = STARTADRESSE IN PCF8583
				; REG. B  = ANZAHL DER BYTES
				; REG. HL = ZIELADRESSE DER DATEN IM RECHNER
				;
	CALL	PCFADR		; SENDE DIE WORTADRESSE ZU PCF8583
	CALL	HIGHSLC		; CLOCK HIGH FUER ERNEUTE START-KONDITION
				;
	CALL	START8583	; SENDE START-KONDITION
	MVI	A,0A3H		; SENDE SLAVEADRESSE FUER LESEN
	CALL	RWPCF		;
	CALL	HIGHSDA		; DATENLEITUNG AUF HIGH
	CALL	SLCPULS		; LESE ACKNOWLEGE VOM SLAVE
				; HIER MOEGL. PRUEFUNG OB OK
READ102:			; REG. B ENTHAELT ANZAHL DER BYTES
				; REG. HL ZEIGT AUF MEMORY-ADRESSE
	MVI	A,0FFH		; AKKU AUF FF FUER DATEN LESEN
	CALL	RWPCF		; LESE EIN BYTE
	MOV	M,A		; KOPIERE IN SPEICHER
	INX	H		; ERHOEHE ZEIGER AUF SPEICHERADRESSE
	DCR	B		; ERNIEDRIGE BYTEZAEHLER
	JNZ	READ103		; SPRUNG WENN WEITER
	CALL	HIGHSDA		; ENDE DER UEBERTRAGUNG, DESHALB
	CALL	SLCPULS		; ACKNOWLEGE MIT DATEN=HIGH
	JMP	RENDE		; 
READ103	CALL	LOWSDA		; SENDE ACKNOWLEGE
	CALL	SLCPULS		;
	JMP	READ102		; UND WEITER

RENDE	CALL	STOP8583	; STOP BEDINGUNG SENDEN
	RET


WRITEPCF:			; SCHREIBE DATEN IN PCF8583
				; EINGANGSWERTE =>
				; AKKU    = STARTADRESSE IN PCF8583
				; REG. B  = ANZAHL DER BYTES
				; REG. HL = QUELLADRESSE DER DATEN IM RECHNER
				;
	CALL	PCFADR		; SENDE DIE WORTADRESSE ZU PCF8583
WRITE01	MOV	A,M		; LADE BYTE VON QUELLADRESSE
	CALL	RWPCF		; SENDE DATEN-BYTE ZU PCF8583
	CALL	HIGHSDA		; LESE ACKNOWLEGE VOM SLAVE
	CALL	SLCPULS		;
				; HIER MOEGL. PRUEFUNG OB OK
	INX	HL		; ERHOEHE ZEIGER AUF QUELLADRESSE
	DCR	B		; WIEDERHOLE BIS ALLE DATEN
	JNZ	WRITE01		; GESENDET SIND
				;
	CALL	STOP8583	; STOP BEDINGUNG SENDEN
	RET

; DIE NAECHSTEN 4 ROUTINEN SIMULIEREN DEN ALTEN UHRENCHIP MK3538
; DIE ROUTINEN HABEN DIE GLEICHE FUNKTION WIE IN DEN VORANGEGANGENEN
; MONITOR-VERSIONEN
;
; HINWEIS: IM GEGENSATZ ZUM MK3538 BESITZT PCF8583 NUR ZWEI BIT
; FUER DIE JAHRES-ZAHL. WIR HABEN DESHALB EINEN WEITEREN (BCD-)
; JAHRESZAEHLER WIE FOLGT REALISIERT: DAS ALARMREGISTER WIRD AUF
; EINEN DATED-ALARM FUER DEN 1. JANUAR 00:00:00 GESETZT.
; DIE BCD-JAHRESZAHL WIRD IM NICHT BENUTZTEN TIMER-REGISTER GESPEICHERT.
; WIRD NUN BEIM LESEN DER UHR FESTGESTELLT, DASS EIN ALARM AUFGETRETEN
; IST, DANN WIRD DIE JAHRES-ZAHL UM EINS ERHOEHT UND DIE UHR MIT
; DER NEUEN JAHRESZAHL NEU GESETZT.

READ$TIME:			; LESE UHRZEIT IM FORMAT DES MK3835
				;
	PUSH	PSW		; RETTE ALLE REGISTER
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
				;
	MVI	A,0		; LESE UHRDATEN
	MVI	B,16		; 16 BYTE
	LXI	H,PCFBUF	; IN ZWISCHENSPEICHER
	CALL	READPCF		;
				; KOPIERE DATEN AUS PCF8583 IN TIME$FIELD
				; (MK3835 KOMPATIBEL)
	LXI	HL,PCFSEC	;
	LXI	DE,TIME$FIELD	;
	LXI	B,5		;
	LDIR			;
	LDA	ALRTIM		;
	STA	TIME$FIELD+6	;
				;
				; JETZT ERFOLGT DIE ERHOEHEUNG DER JAHRES ZAHL
				; FALLS ALRMFLAG GESETZT IST. ACHTUNG: DIE UHR 
				; DARF NICHT UM 00:00:00 DES 1. JANUAR AUSGELESEN
				; WERDEN, DA SONST DIE JAHRESZAHL UM ZWEI ERHOEHT
				; WIRD. (SOFTWARE WIRD DADURCH EINFACHER).
				;
	LDA	PCFCON		; PRUEFE OB NEUES JAHR
	ANI	00000010B	;
	JZ	OLDYEAR		; WENN BIT 2 = 1 NEUES JAHR SONST ALLES OK
	LDA	TIME$FIELD+6	; ERHOEHE JAHR UM EINS
	INR	A		;
	DAA			; DEZIMAL KORREKTUR
	STA	TIME$FIELD+6	;
	CALL	WRITE$TIME	; SCHREIBE NEUES JAHR IN PCF8583
OLDYEAR:			;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	RET			;


WRITE$TIME:			;
	PUSH	PSW		;
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
				;
	LXI	H,PCFDAT	; KOPIERE ERST EINMAL ALLE UNVERAENDERLICHEN
	LXI	D,PCFBUF	; DATEN IN DEN BUFFER
	LXI	B,15		;
	LDIR			;
				;
	LXI	H,TIME$FIELD	; UBERSCHREIBE JETZT DEN BUFFER 
	LXI	D,PCFSEC	; ZEIT UND DATUM
	LXI	B,5		;
	LDIR			;
				;
	LDA	PCFDAY		; DATE WIRD IN REGISTER C FUER DIE NACHFOLGENDE
	ANI	00111111B	; SCHALTJAHR ERZEUGUNG ZWISCHENGESPEICHERT
	MOV	C,A		;
				;
	LDA	TIME$FIELD+6	; LEGE BCD-JAHRESZAHL IM ALS RAM MISSBRAUCHTEN
	STA	ALRTIM		; ALARM TIMER REGISTER AB.
	
	RRC			; ERZEUGE AUS DER BCD JAHRESZAHL 2 BIT
	RRC			; FUER SCHALTJAHRZAEHLER IN PCF8583
	MOV	B,A		;
	RRC			;
	RRC			;
	RRC			;
	ANI	10000000B	;
	ADD	B		;
	ANI	11000000B	; ZWEI BIT FUER SCHALTJAHR ERZEUGT
	ORA	C		; PACKE DATE DAZU
	STA	PCFDAY		; UND ZURUECK IN BUFFER
	
				;
	MVI	A,0		; SCHREIBE DIE DATEN IN PCF8583
	MVI	B,16		;
	LXI	H,PCFBUF	;
	CALL	WRITEPCF	;
				;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	RET			;

PCFDAT	DB	0CH,00H,00H,00H,00H,00H,00H,90H
	DB	3AH,00H,00H,00H,00H,01H,01H


READ$CLK$DATA:
	MVI	A,16		;
	MVI	B,24		;
	LXI	H,SYSPAGE	;
	CALL	READPCF		;
	RET
;
;
;
WRITE$CLK$DATA:
	MVI	A,16		;
	MVI	B,24		;
	LXI	H,SYSPAGE	;
	CALL	WRITEPCF	;
	RET
;
;
START$MOTOR:			; STARTE FLOPPY MOTOR 
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H

	MVI	A,7
	MVI	B,2
	LXI	H,PCFDAT+7
	CALL	WRITEPCF

	MVI	A,0
	MVI	B,1
	LXI	H,PCFDAT
	CALL	WRITEPCF

	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
;
;	
	ENDIF
;
;
;
FBANK0	EQU	$		;AB HIER KANN EPROMTEIL VON CP/M
				;BENUTZT WERDEN
;
;
;
;**************************************************************************
;***									***
;***  ALLE NACHFOLGENDEN PROGRAMMTEILE WERDEN AUSSCHLIESSLICH VOM	***
;***  VOM MONITOR BENUTZT UND KOENNEN DAHER VOM CP/M UEBERSCHREIBEN	***
;***  WERDEN.								***
;***									***
;**************************************************************************
;
;
;
;**************************************************************************
;***									***
;***  ES FOLGEN BOOT-ROUTINEN FUER DIE DISI-CRAM-FLOPPY (512K)          ***
;***									***
;**************************************************************************
;
;
;
DITEST:	CALL	DITEST1		;
	INP	A		;ERSTES BYTE LESEN
	STA	DIBYTE		;UND SICHERN
	CALL	DITEST2		;
	CALL	DITEST1		;
	MVI	A,0AAH		;TESTBYTE SCHREIBEN
	OUTP	A		;
	CALL	DITEST2		;
	CALL	DITEST1		;
	INP	A		;TESTBYTE LESEN
	CPI	0AAH		;
	JZ	DIOK		;
	XRA	A		;DISI FEHLT
	STA	DIFLAG		;
	RET			;
DIOK:	CALL	DITEST2		;
	CALL	DITEST1		;
	LDA	DIBYTE		;SCHREIBE ERSTES BYTE
	OUTP	A		;ZURUECK
	CALL	DITEST2		;
	MVI	A,0FFH		;DISI VORHANDEN
	STA	DIFLAG		;
	RET
;
;
DITEST1:
	XRA	A		;SELEKTIERE
	MVI	C,0B9H		;SPUR 0
	OUTP	A		;SEKTOR 1
	INR	A		;
	DCR	C		;
	OUTP	A		;
	MVI	C,0BAH		;
	RET
;
;
DITEST2:
	XRA	A		;LESE- U.
	MVI	C,0B8H		;SCHREIBEENDE
	OUTP	A		;
	RET			;
;
;
DICHKSUM:
	LXI	H,0		;
	MVI	D,0		;
	LXI	B,DIBOOTADR	;
DICHKS1:
	LDAX	B		;
	MOV	E,A		;
	DAD	D		;
	INX	B		;
	MOV	A,C		;
	CPI	80H		;
	JRNZ	DICHKS1		;
	RET			;
;
;
;
DIREAD:
	PUSHIX			;
	CALL	SETADR		;BERRECHNE ADRESSE IN DISI-FLOPPY
	INIR			;
	XRA	A		;
	LDX	C,0		;
	OUTP	A		;
	POPIX			;
	RET			;
;
;
;
SETADR:
	LDA	TRACK		;LADE SPUR NUMMER
	MOV	E,A		;RETTE BAUSTEINNUMMER NACH E
	LXIX	PORTLIST	;SETZE IX AUF PORTLISTE
	LDX	C,1		;WAEHLE BAUSTEIN AUS (EINER VON ACHT)
	OUTP	E		;
	MOV	A,E		;ERMITTLE PORT FUER DATENUEBERTRAGUNG
	ANI	00001000B	;
	LDX	A,2		;
	JRZ	SETAD1		;
	LDX	A,3		;
SETAD1:	MOV	C,A		;
	PUSH	B		;RETTE PORTADRESSE
	LDX	C,0		;SETZE IMPLIZIT BYTECOUNTER AUF 0
	LDA	SECTOR		;
	ORI	00H		;SETZE UNGUELTIGE ADRESSLEITUNGEN (43256)
	OUTP	A		;
	POP	B		;LADE DATENPORTADRESSE
	MVI	B,128		;SEKTORGROESSE LADEN
	LHLD	DMAADR		;
	RET			;
;
;
;
PORTLIST:
	DB	0B8H		;PORTADRESSEN DER DISI KARTE
	DB	0B9H		;
	DB	0BAH		;
	DB	0BBH		;
;
;
;
;**************************************************************************
;***									***
;***  ENDE DER ROUTINEN FUER DIE DISI-CRAM-FLOPPY                       ***
;***                                                                    ***
;**************************************************************************
;
;
BOOTERR:
	;GEBE FEHLERMELDUNG BEI BOOT AUS
	;UND GEHE ZUM MONITOR ZURUECK
	LXI	H,BERMSG
	CALL	SOUT
	JMP	GETCM
;
BERMSG	DB	0DH,0AH,BELL,' Can not boot',0DH,0AH,24H
;
;
;
GET$JUMPER:			;LESE JUMPER J18 UND J19 EIN.
				;
	LXI	H,PATAB		;
	LXI	B,PDTAB		;
	MVI	E,P$LS259	;
	MVI	D,P$IN$LS258	;
	CALL	JUMPIN		;
	STA	BAUD$JUMPERBYTE	;
	MOV	A,D		;
	STA	IO$JUMPERBYTE	;LEGE IO$JUMPERBYTE AB
	LDA	BAUD$JUMPERBYTE	;WANDLE 0-4 IN RICHTIGE
	MOV	E,A		;BAUDRATEN ZAHLEN
	MVI	D,0		;
	LXI	H,PBTAB		;
	DAD	D		;
	MOV	A,M		;
	STA	BAUD$JUMPERBYTE	;
	RET			;
;
;
;
JUMPIN:				;DIESES PROGRAMM LIEST DIE BEIDEN
				;JUMPER AUF DER UNIO- BZW PROF-KARTE
				;EIN. FOLGENDE REGISTER MUESSEN BELEGT SEIN
				;E=PORTADRESSE DES 74 LS259
				;D=PORTADRESSE DES EINGANGS PORTS
				;BC=ADRESSE DER DECODER TABELLE
				;HL=ADRESSE DER AUSGANGS BITS
				;AUSGABE
				;AKKU=JUMPER 1, D=JUMPER2
				;
	PUSH	B		;RETTE DECODER TABELLE
	MOV	C,E		;
	MVI	B,3		;ERSTES BITMUSTER AUSGEBEN
	OUTIR			;
	MOV	A,C		;TAUSCHE PORTADRESSE
	MOV	C,D		;
	MOV	D,A		;
	MVI	B,0FFH		;
	INP	A		;LESE ERSTES BITPAAR EIN
	RAR			;SCHIEBE BITS NACH RECHTS
	RAR			;
	RAR			;
	RAR			;
	ANI	00000011B	;MASKIERE
	MOV	E,A		;UND NACH E
				;
	MOV	A,C		;TAUSCHE PORTADRESSE
	MOV	C,D		;
	MOV	D,A		;
	MVI	B,2		;ZWEITES BITMUSTER AUSGEBEN
	OUTIR			;
	MOV	A,C		;TAUSCHE PORTADRESE
	MOV	C,D		;
	MOV	D,A		;
	MVI	B,0FFH		;
	INP	A		;LESE ZWEITES BITPAAR EIN EIN
	RAR			;EINMAL NACH RECHTS SCHIEBEN
	RAR			;
	ANI	00001100B	;MASKIEREN
	ORA	E		;UND ZU E PACKEN
	MOV	E,A		;
				;
	MOV	A,C		;TAUSCHE PORTADRESSE
	MOV	C,D		;
	MOV	D,A		;
	MVI	B,2		;DRITTES BITMUSTER AUSGEBEN
	OUTIR			;
	MOV	A,C		;TAUSCHE PORTADRESSE
	MOV	C,D		;
	MOV	D,A		;
	MVI	B,0FFH		;
	INP	A		;LESE DRITTES BITPAAR EIN
	ANI	00110000B	;MASKIEREN UND ZU E PACKEN
	ORA	E		;
	MVI	B,3		;TRENNE BEIDE JUMPERFELDER
JUMPI1	RAR			;
	RALR	D		;
	RAR			;
	RALR	E		;
	DJNZ	JUMPI1		;
	POP	H		;HOLE DECODER TABELLE
	PUSH	H		;
	MVI	B,0		;
	MOV	A,D		;
	ANI	00000111B	;
	MOV	C,A		;
	DAD	B		;
	MOV	D,M		;
	POP	H		;HOLE DECODER TABELLE
	MOV	A,E		;
	ANI	00000111B	;
	MOV	C,A		;
	DAD	B		;
	MOV	A,M		;
	RET			;
;
;
;
PDTAB:	DB	0,0,0,2		;DECODIER TABELLE FUER PROF JUMPER
	DB	0,3,4,1		;
				;			
PATAB:	DB	1,2,4		;TABELLE DER 74LS259 AUSGABE BYTES
	DB	0,3		;
	DB	2,5		;
				;
				;ZWEITE DECODIERUNG FUER BAUDRATE.
				;HIER WIRD DIE BAUDRATEN BEDEUTUNG
				;VON J19 BESTIMMT.
PBTAB:	DB	00FH		;19200 BAUD
	DB	00EH		; 9600 BAUD
	DB	00AH		; 2400 BAUD
	DB	008H		; 1200 BAUD
	DB	006H		;  300 BAUD
;
;
;
SERINIT:			;INITIALISIERE BEIDE SERIELLE SCHNITTSTELLEN
	MVI	A,0		;STATUS0 INIT
	OUT0	STAT0,A		;
	LDA	SERBAUD0	;LESE MODUS BITS SER0
	RRC			;SCHIEBE VIER BITS NACH RECHTS
	RRC			;
	RRC			;
	MOV	B,A		;RETTE PEO BIT
	RRC			;
	ANI	00000111B	;MASKIERE
	ORI	01100000B	;AKTIVIERE RE,TE, SETZE RTS
	OUT0	CNTLA0,A	;
	MOV	A,B		;HOLE PEO BIT
	ANI	00010000B	;
	OUT0	CNTLB0,A	;
	LDA	SERBAUD0	;SETZE BAUDRATE
	CALL	SER1INIT	;
				;
	LDA	LOG$DRIVE	;INIT STATUS1
	ANI	00000100B	;
	OUT0	STAT1,A		;
	LDA	SERBAUD1	;LESE MODUS BITS SER1
	RRC			;
	RRC			;
	RRC			;
	MOV	B,A		;
	RRC			;
	ANI	00000111B	;MASKIERE
	MOV	C,A		;RETTE IN C
	LDA	LOG$DRIVE	;LESE CKA1D BIT
	RLC			;
	ANI	00010000B	;
	ORI	01100000B	;
	ORA	C		;
	OUT0	CNTLA1,A	;
	MOV	A,B		;
	ANI	00010000B	;
	OUT0	CNTLB1,A	;
	LDA	SERBAUD1	;
	CALL	SER2INIT	;
	RER			;
;
;
;
CONST:
	;VERTEILER FUER CONSOLEN STATUS
	;DIE ROUTINEN MUESSEN A=FF UND KEIN ZERO-FLAG SETZEN
	;FALLS EIN ZEICHEN DA IST SONST AKKU= 0 UND ZERO-FLAG
	;
	LDA	IO$JUMPERBYTE		;LESE JUMPERBYTE EIN
	CALL	VERTEILER		;
	DW	MGRAFIST		;
	DW	MSER1IST		;
	DW	MGRADEIST		;
	DW	MUSERIST		;
	DW	DUMMYIST		;
;
;
;
CONIN:
	;VERTEILER FUER CONSOLEN EINGABE
	;DIE ROUTINE MUSSEN AUF EIN ZEICHEN VON DER KONSOLE WARTEN
	;UND DIESES IM AKKU UEBERGEBEN
	;ALLE ANDEREN REGISTER BLEIBEN UNVERAENDERT
	;
	LDA	IO$JUMPERBYTE		;
	CALL	VERTEILER		;
	DW	MGRAFIN			;
	DW	MSER1IN			;
	DW	MGRADEIN		;
	DW	MUSERIN			;
	DW	DUMMYIN			;
;
;
;
CONOUT:
	;VERTEILER FUER CONSOLEN AUSGABE
	;DAS ZEICHEN IN REG C. WIRD VON DEN ROUTINEN AUSGEGEBEN
	;UND IN AKKU KOPIERT, ALLE ANDEREN REGISTER BLEIBEN UNVERAENDERT
	;
	LDA	IO$JUMPERBYTE		;
	CALL	VERTEILER		;
	DW	MGRAFOUT		;
	DW	MSER1OUT		;
	DW	MGRADEOUT		;
	DW	MUSEROUT		;
	DW	DUMMYOUT		;
;
;
;
VERTEILER:
	;VERZEIGT AUF EINE DER ADRESSEN DIE DER RETURNADRESSE FOLGEN
	;
	XTHL			;LEGE RETURNADRESSE IN HL
VERTEILER1:
	DCR	A		;WAR AKKU NULL?
	JM	VERTEILER2	;DANN ZEIGT HL AUF DIE RICHTIGE RETURN ADR.
	INX	H		;ANSONSTEN EINE ADRESSE WEITER
	INX	H		;
	JR	VERTEILER1	;
VERTEILER2:
	MOV	A,M		;LADE ADRESSE DER ROUTINE IN HL
	INX	H		;
	MOV	H,M		;
	MOV	L,A		;
	XTHL			; LADE ALTES HL UND LEGE ADRESSE DER ROUTINE
				; AUF DEN STACK
	RET			; SPRINGE IN DIE RICHTIGE ROUTINE
;
;
;
DUMMYIST:
	MVI	A,0FFH
	ORA	A
	RET
;
;
;
DUMMYIN:
	MVI	A,'Y'
	RET
;
;
;
DUMMYOUT:
	MOV	A,C
	RET
;
;
;
BREAK:
	;PRUEFT OB EIN ZEICHEN EINGELESEN WURDE
	;
	CALL	CS		;
	JZ	FRET		;
	CALL	CI		;LESE ZEICHEN
	ANI	7FH		;
	CPI	1BH		;GLEICH ESCAPE
	JZ	SRET		;JA ENDE
BREAK1	CALL	CS		;WARTE AUF NEUES ZEICHEN
	JRZ	BREAK1		;
	CALL	CI		;LESE NEUES ZEICHEN
	ANI	7FH		;
	CPI	1BH		;
	JZ	SRET		;WAR BREAK
	JMP	FRET		;WAR ETWAS ANDERES
;
;
;
CNVBN: 
	MOV	A,C		;
	SUI	'0'		;
	CPI	0AH		;
	RM			;
	SUI	7		;
	RET			;
;
;
GETHX: 
	PUSH	H
	LXI	H,0
	MVI	E,0
L0228: 
	CALL	GETCH1
	MOV	C,A
	CALL	VALDL
	JNC	L0241
	CALL	ECHO
	MOV	D,C
	PUSH	H
	POP	B
	POP	H
	MOV	A,E
	ORA	A
	JNZ	SRET
	JZ	FRET
L0241: 
	CALL	VALDG
	JNC	L0228
	CALL	ECHO
	CALL	CNVBN
	MVI	E,0FFH
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	MVI	B,0
	MOV	C,A
	DAD	B
	JMP	L0228
;
;
;
GETDEZ:
	;LESE DEZIMALZAHLEN NACH HL
	;ALS TRENNZEICHEN WERDEN '/',':' UND <CR> ERKANNT
	;TRENNZEICHEN WIRD IN AKKU UEBERGEBEN
	;
	MVI	B,0
	LXI	H,0	;LOESCHE AKKU
GETDEZ1	CALL	GETCH1	;LESE ZEICHEN
	CPI	'/'
	JRZ	GETDEZ2
	CPI	':'
	JRZ	GETDEZ2
	CPI	0DH
	JRZ	GETDEZ2
	SUI	'0'	;ZAHL ?
	JRC	GETDEZ1
	CPI	0AH
	JRNC	GETDEZ1
	MOV	C,A
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	B
	MVI	A,'0'	;GEBE ZAHL AUS
	ADD	C
	MOV	C,A
	CALL	ECHO
	JR	GETDEZ1
GETDEZ2	MOV	C,A
	CALL	ECHO
	MOV	A,C
	RET
;
;
;
ENTER$WORD:			;EINGANG: HL
				;AUSGANG: HL
				;ZEIGT WORD IN HL ALS HEXZAHL AN UND LIEST
				;ANSCHLIESSEND HEXZAHL EIN. FALLS KEINE ZAHL
				;EINGEGEBEN WURDE, BLEIBT HL UNVERAENDERT.
				;FALLS TRENNZEICHEN = CR, DANN ZERO BIT = 1.
				;
	PUSH	H		;RETTE HL
	CALL	HLNMOUT		;
	MVI	C,CNGPRMT	;
	CALL	ECHO		;
	CALL	GETHX		;LESE HEXZAHL EIN
	JRNC	ENTW1		;SPRUNG WENN NICHTS EINGEGEBEN
	POP	PSW		;
	PUSH	B		;
ENTW1	POP	H		;
	MOV	A,D		;
	CPI	0DH		;
	RET			;
;
;
;
;
;
;
ENTER$BYTE:
				;EINGANG: AKKU
				;AUSGANG: AKKU
				;ZEIGT BYTE IN AKKU ALS HEXZAHL AN UND LIEST
				;ANSCHLIESSEND HEXZAHL EIN. FALLS KEINE ZAHL
				;EINGEGEBEN WURDE, BLEIBT AKKU UNVERAENDERT.
				;FALLS TRENNZEICHEN = CR, DANN ZERO BIT = 1.
				;
	PUSH	PSW		;RETTE AKKU
	CALL	NMOUT		;ZEIGE AKKU INHALT AN
	MVI	C,CNGPRMT	;
	CALL	ECHO		;
	CALL	GETHX		;LESE HEXZAHL EIN
	JRNC	ENTB1		;SPRUNG WENN NICHTS EINGEGEBEN
	POP	PSW		;
	MOV	A,C		;
	PUSH	PSW		;
ENTB1	POP	B		;
	MOV	A,D		;
	CPI	0DH		;
	MOV	A,B		;
	RET			;
;
;
;
ENTER$YES$NO:
				;EINGANG AKKU=00 FUER NO
				;EINGANG AKKU<>00 FUER YES
				;AUSGANG AKKU=00 FUER NO
				;AUSGANG AKKU=FF FUER YES
				;SONST WIE ENTER$BYTE
				;
	ORA	A		;SETZE FUER UNGLEICH NULL FF
	JRZ	EYN2		;
	MVI	A,0FFH		;
EYN2	PUSH	PSW		;RETTE AKKU
	LXI	H,YESTXT	;ZEIGE INHALT AN (ZERO FLAG STIMMT NOCH)
	JRNZ	EYN1		;
	LXI	H,NOTXT		;
EYN1	CALL	SOUT		;
EYN3	CALL	GETCH1		;LESE ZEICHEN EIN
	CPI	'Y'		;GLEICH YES ?
	MVI	C,0FFH		;
	JRZ	EYN4		;
	CPI	'N'		;GLEICH NO ?
	MVI	C,000H		;
	JRZ	EYN4		;NEIN DANN WARTE BIS GUELTIGES ZEICHEN
	MOV	C,A		;
	CALL	VALDL		;TRENNZEICHEN ?
	JRNC	EYN3		;SPRUNG WENN NEIN
	CALL	ECHO		;
	POP	PSW		;
	MOV	B,A		;
	MVI	A,0DH		;
	CMP	C		;
	MOV	A,B		;
	RET			;
EYN4	PUSH	B		;RETTE NEUES YES/NO
	MOV	C,A		;
	CALL	ECHO		;
	POP	B		;
	POP	PSW		;
	MOV	A,C		;
	PUSH	PSW		;
	JR	EYN3		;
				;
ENTER$NO$YES:			;WIE ENTER$YES$NO, AKKU JEDOCH
				;INVERTIERT
	ORA	A		;
	JRZ	ENY1		;
	MVI	A,0FFH		;
ENY1:	CMA			;
	CALL	ENTER$YES$NO	;
	CMA			;
	RET			;
				;
YESTXT:	DB	' Y',CNGPRMT,24H
NOTXT:	DB	' N',CNGPRMT,24H
;
;
;
DISKDA:
	;GIBT MELDUNG AUS, WENN DISKZUGRIF OHNE KONTROLLER VERSUCHT WIRD
	;UND KEHRT AUF DIE EINGABEEBENE ZURUECK
	LDA	DISKFLG		;LADE FLAG
	LXI	H,NODISK	;
	ORA	A		;=NULL?
	RNZ			;ZURUECK ZUM RUFENDEN PROGRAMM
	CALL	CBSOUT		;
	LXI	H,FDNODSK	;
	CALL	SOUT		;
	JMP	CRGETCM		;AUF KOMMANDOEBENE ZURUECK
;
NODISK:	
	DB	1,'Floppy$'
;
FDNODSK:
	DB	' access not possible',BELL,'$'
;
;
;
REGDS: 
	LXI	H,RTAB
L02E9:
	MOV	C,M
	MOV	A,C
	ORA	A
	JNZ	L02F3
	CALL	CROUT
	RET
L02F3: 
	CPI	'a'	;SOLL NEUE ZEILE ANFANGEN?
	JRNZ	REGDS1	;SPRUNG WENN NEIN
	PUSH	PSW
	PUSH	B
	CALL	CROUT
	POP	B
	POP	PSW
REGDS1:
	CALL	ECHO
	MVI	C,'='
	CALL	ECHO
	INX	H
	MOV	E,M
	MVI	D,(REGS AND 0FF00H) SHR 8
	INX	H
	LDAX	D
	CALL	NMOUT
	MOV	A,M
	ORA	A
	JZ	L030E
	DCX	D
	LDAX	D
	CALL	NMOUT
L030E: 
	MVI	C,' '
	CALL	ECHO
	INX	H
	JMP	L02E9
;
;
;
RGADR: 
	LXI	H,RTAB
	LXI	D,3	;LAENGE DER TABELLEN EINTRAEGE
L031D: 
	MOV	A,M
	ORA	A
	JZ	ERROR
	CMP	C
	JZ	L032A
	DAD	D
	JMP	L031D
L032A: 
	INX	H
	MOV	B,H
	MOV	C,L
	RET
; 
;
;
RSTTF:
	DI
	LXI	SP,MSTAK
	POP	B	;LADE I UND R REGISTER
	MOV	A,C
	STAR
	MOV	A,B
	STAI
	EXX
	EXAF	;ERST ZWEITREGISTERSATZ LADEN
	POP	H
	POP	D
	POP	B
	POP	PSW
	EXAF
	EXX	;JETZT NORMALER REGISTERSATZ
	POPIY
	POPIX
	POP	D
	POP	B
	POP	PSW
	LSPD	SSAVE
	LHLD	PSAVE
	PUSH	H
	LHLD	LSAVE
	EI
	RET
;
;
;
ERROR:
	LXI	H,SYNERRTXT
	CALL	SOUT
JMP	GETCM
;
SYNERRTXT	DB	' What?',BELL,0DH,0AH,'$'
;
;
;
FRET: 
	STC
	CMC
	RET
;
;
;
SRET: 
	STC
	RET
;
;
;
VALDG: 
	MOV	A,C
	CPI	'0'
	JM	FRET
	CPI	'9'
	JM	SRET
	JZ	SRET
	CPI	'A'
	JM	FRET
	CPI	'G'
	JP	FRET
	JMP	SRET
;
;
;
VALDL: 
	MOV	A,C
	CPI	','
	JZ	SRET
	CPI	0DH
	JZ	SRET
	CPI	' '
	JZ	SRET
	JMP	FRET
;
;
;
DISP$TIME:
	;GEBE UHRZEIT UND DATUM AUF DEN BILDSCHIRM
	CALL	READ$TIME	;LESE UHRZEIT AUS
	LXI	H,TIMTXT1	;DATUM TEXT AUS
	CALL	CBSOUT		;
	LDA	TIME$FIELD+4	;MONAT
	CALL	NMOUT		;
	MVI	C,'/'		;
	CALL	ECHO		;
	LDA	TIME$FIELD+3	;TAG
	CALL	NMOUT		;
	MVI	C,'/'		;
	CALL	ECHO		;
	LDA	TIME$FIELD+6	;JAHRESZAHL
	CALL	NMOUT		;
				;
	LXI	H,TIMTXT2	;GEBE TIME AUS
	CALL	CBSOUT		;
	LDA	TIME$FIELD+2	;STUNDE
	CALL	NMOUT		;
	MVI	C,':'		;
	CALL	ECHO		;
	LDA	TIME$FIELD+1	;MINUTE
	CALL	NMOUT		;
	MVI	C,':'		;
	CALL	ECHO		;
	LDA	TIME$FIELD	;SEKUNDE
	CALL	NMOUT		;
	CALL	CROUT		;
	LDA	IO$JUMPERBYTE	;IST GRIP ALS KONSOLE DEFINIERT?
	ORA	A		;
	RNZ			;RETURN WENN NICHT
	LXI	H,SETTT		;SONST, SETZE GRIP-UHR
	CALL	SOUT		;	
	LDA	TIME$FIELD+2	;
	ADI	20H		;
	MOV	C,A		;
	CALL	ECHO		;
	LDA	TIME$FIELD+1	;
	ADI	20H		;
	MOV	C,A		;
	CALL	ECHO		;
	LDA	TIME$FIELD	;
	ADI	20H		;
	MOV	C,A		;
	CALL	ECHO 		;
	RET			;
				;
SETTT	DB	27,27,'U$'
TIMTXT1	DB	22
	IF	MK3835
	DB	' MK3835 '
	ELSE
	DB	'PCF8583 '
	ENDIF
	DB	'Date : $'
TIMTXT2	DB	30,'Time : $'
;
;
;
DEZHEX:
	;WANDELT DEZIMAL ZAHL IM AKKU IN HEXWERT UM
	PUSH	B
	CPI	0	;IST SCHON 0?
	JRZ	DEZHEX1
	MVI	B,0
DEZHEX2 INR	B
	DCR	A
	DAA
	JNZ	DEZHEX2
	MOV	A,B
DEZHEX1	POP	B
	RET
;
;
;
GETNM:
	MVI	L,3
	MOV	A,C
	ANI	3
	RZ
	MOV	H,A
L025E: 
	CALL	GETHX
	JNC	ERROR
	PUSH	B
	DCR	L
	DCR	H
	JZ	L0273
	MOV	A,D
	CPI	0DH
	JZ	ERROR
	JMP	L025E
L0273: 
	MOV	A,D
	CPI	0DH
	JNZ	ERROR
	LXI	B,0FFFFH
	MOV	A,L
	ORA	A
	JZ	L0286
L0281: 
	PUSH	B
	DCR	L
	JNZ	L0281
L0286: 
	POP	B
	POP	D
	POP	H
	CALL	HILO
	JNC	L0291
	MOV	D,H
	MOV	E,L
L0291: 
	XTHL
	PUSH	D
	PUSH	B
	PUSH	H
L0295: 
	DCR	A
	RM
	POP	H
	XTHL
	JMP	L0295
HILO : 
	PUSH	B
	MOV	B,A
	PUSH	H
	MOV	A,D
	ORA	E
	JZ	L02BD
	INX	H
	MOV	A,H
	ORA	L
	JZ	L02BD	;02BDH
	POP	H
	PUSH	D
	MVI	A,0FFH
	XRA	D
	MOV	D,A
	MVI	A,0FFH
	XRA	E
	MOV	E,A
	INX	D
	MOV	A,L
	ADD	E
	MOV	A,H
	ADC	D
	POP	D
	MOV	A,B
	POP	B
	RET
L02BD: 
	POP	H
	MOV	A,B
	POP	B
	JMP	SRET
;
;
;
PDEC:
	;GEBE HL REGISTER AL DEZIMALZAHL AUS
	LXI	B,TABLE10
	LXI	D,-10000
PNEXT:	MVI	A,'0'-1
PDECL:	PUSH	H
	INR	A
	DAD	D
	JRNC	STOPLOOP
	INX	SP
	INX	SP
	JR	PDECL
STOPLOOP:
	PUSH	D
	PUSH	B
	MOV	C,A
	CALL	ECHO
	POP	B
	POP	D
NEXTDIGIT:
	POP	H
	LDAX	B
	MOV	E,A
	INX	B
	LDAX	B
	MOV	D,A
	INX	B
	MOV	A,E
	ORA	D
	JRNZ	PNEXT
	RET
;
TABLE10:
	DW	-1000,-100,-10,-1,0
;
;
;
RWINP:
		;LIEST DMA ADRESSE UND ANZAHL DER SEKTOREN EIN
		;
	CALL	GETHX	;LESE DMA ADRESSE
	JNC	ERROR
	MOV	A,D	;KEIN CR
	CPI	0DH
	JZ	ERROR	;SPRUNG WENN DOCH
	SBCD	DMAADR	;ABSPEICHERN
	CALL	GETHX	;LESE ANZAHL DER SEKTOREN
	JNC	ERROR	;
	MOV	A,D	;
	CPI	0DH	;MUSS CR SEIN
	JNZ	ERROR	;
	MOV	A,C	;ABSPEICHERN
	STA	SECTCNT	;
	RET
;
;
;
START:			;MONITOR EINSPRUNGPUNKT
			;
	SHLD	LSAVE
	POP	H
	SHLD	PSAVE
	SSPD	SSAVE	;RETTE STACKPOINTER
	LXI	SP,LSAVE;JETZT RETTEN DURCH PUSHBEFEHLE MOEGLICH
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSHIX	;ZUSAETZLICH Z80 REGISTER
	PUSHIY
	EXAF
	EXX	;SCHALTE REGISTER  UM
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	EXX	;REGISTER ZURUECK SCHALTEN
	EXAF
	LDAI	;SAVE I UND R REGISTER
	MOV	B,A
	LDAR
	MOV	C,A
	PUSH	B
;--------------------------------------------------ENDE REGISTER RETTEN----
;
;
	LXI	H,SGNON		;GEBE MONITOR-MELDUNG AUS
	CALL	SOUT		;
CRGETCM:			;
	CALL	CROUT		;
GETCM: 				;
	LXI	H,MSTAK		;
	SPHL			;
	MVI	C,':'		;
	CALL	ECHO		;
GTC03: 				;
	CALL	GETCH1		;
	CALL	ECHO		;
	MOV	D,C		;SAVE COMMAND
	LXI	H,CMDMSG	;ZEIGE AUF TEXT
GTC01	MOV	A,D		;
	CMP	M		;GLEICH
	JRZ	GTC04		;
GTC02	INX	H		;
	MOV	A,M		;GLEICH 00H
	CPI	0		;
	JZ	ERROR		;DANN FEHLER
	CPI	'$'		;
	JRNZ	GTC02		;SUCHE $
	INX	H		;VERGLEICHE NAECHSTES KOMMANDO
	JR	GTC01		;
GTC04	INX	H		;GEFUNDEN GEBE AUS
	CALL	SOUT		;
	MOV	A,D		;
	MOV	C,D		;
	LXI 	B,NCMDS		;C ENTHAELT SCHL.U.INDEXZAEHLER
	LXI	H,CTAB		;
GTC05:				;
	CMP	M		;
	JZ	GTC10		;
	INX	H		;
	DCR	C		;
	JNZ	GTC05		;
	JMP	ERROR		;
GTC10:				;
	LXI	H,CADR		;
	DAD	B		;
	DAD	B		;
	MOV	A,M		;
	INX	H		;
	MOV	H,M		;
	MOV	L,A		;
	PCHL			;
;
;
;
DCMD:
	CALL	GETHX		;LESE STARTADRESSE
	MOV	H,B		;
	MOV	L,C		;
	MOV	A,D		;
	JRC	DCM30		;
	CPI	0DH		;
	LHLD	DISPADR		;
	JRNZ	DCM33		;SPRUNG WENN NOCH ENDADRESSE KOMMT
DCM31	LXI	D,00FFH		;KEINE ENDADRESSE, 100H WEITER
	PUSH	H		;SAVE ANFAANG
	DAD	D		;
	XCHG			;
	POP	H		;
	JR	DCM05		;AUSGABE KANN BEGINNEN
DCM30	CPI	0DH		;
	JRZ	DCM31		;KEINE ENDADRESSE
DCM33	CALL	GETHX		;LESE ZWEITE ADRESSE
	MOV	A,D		;
	CPI	0DH		;
	JNZ	ERROR		;
	MOV	D,B		;
	MOV	E,C		;
	CALL	HILO		;
	JRNC	DCM05		;HL>DE
	MOV	D,H		;
	MOV	E,L		;
DCM05:				;
	CALL	CROUT		;
	CALL	HLNMOUT		;
	MVI	B,000H		;ZAEHLER FUER ASCII AUSGABE
DCM10:				;
	INR	B		;EIN ZEICHEN WEITER
	MVI	C,' '		;
	CALL	ECHO		;
	MOV	A,M		;
	CALL	NMOUT		;
	CALL	BREAK		;
	JC	DCM12		;
	CALL	HILO		;
	JNC	DCM15		;
DCM12: 				;
	INX	H		;
	CALL	DCM20		;
	CALL	CROUT		;
	SHLD	DISPADR		;
	JMP	GETCM		;
DCM15: 				;
	INX	H		;
	MOV	A,L		;
	ANI	0FH		;
	JNZ	DCM10		;
	CALL	DCM20		;
	JR	DCM05		;
				;
DCM20	PUSH	D		;SAVE D
	PUSH	H		;SAVE H
	MVI	C,' '		;
	CALL	CO		;
	MVI	C,'>'		;
	CALL	CO		;
	MOV	C,B		;
DCM23	DCX	H		;
	DJNZ	DCM23		;
	MOV	B,C		;
DCM21	MOV	A,M		;
	CPI	20H		;
	JRC	DCM22		;
	CPI	07FH		;
	JRNC	DCM22		;
	JR	DCM24		;
DCM22	MVI	A,'.'		;DEFAULT FOR NON ASCII
DCM24	MOV	C,A		;
	CALL	CO		;
	INX	H		;
	DJNZ	DCM21		;
	POP	H		;
	POP	D		;
	RET			;
;
;
;
GCMD: 
	CALL	GETHX
	JNC	GCM05
	MOV	A,D
	CPI	0DH
	JNZ	ERROR
	LXI	H,PSAVE
	MOV	M,C
	INX	H
	MOV	M,B
	JMP	GCM10
GCM05: 
	MOV	A,D
	CPI	0DH
	JNZ	ERROR
GCM10: 
	JMP	RSTTF
;
;
;
MCMD: 
	MVI	C,3
	CALL	GETNM
	POP	B
	POP	H
	POP	D
MCM05:
	PUSH	H
	MOV	H,D
	MOV	L,E
	MOV	A,M
	MOV	H,B
	MOV	L,C
	MOV	M,A
	INX	B
	MOV	A,B
	ORA	C
	JZ	GETCM
	INX	D
	POP	H
	CALL	HILO
	JNC	GETCM
	JMP	MCM05
;
;
;
SCMD: 
	CALL	GETHX
	PUSH	B
	POP	H
SCM05: 
	MOV	A,D
	CPI	' '
	JZ	SCM10
	CPI	','
	JNZ	GETCM
SCM10:
	MOV	A,M
	CALL	NMOUT
	MVI	C,CNGPRMT
	CALL	ECHO
	CALL	GETHX
	JNC	SCM15
	MOV	M,C
SCM15:
	INX	H
	JMP	SCM05
;
;
;
XCMD: 
	CALL	GETCH
	MOV	C,A
	CALL	ECHO
	MOV	A,C
	CPI	0DH
	JNZ	XCM05
	CALL	REGDS
	JMP	GETCM
XCM05: 
	MOV	C,A
	CALL	RGADR
	PUSH	B
	POP	H
	MVI	C,' '
	CALL	ECHO
	MOV	A,C
	STA	TEMP
XCM10:
	LDA	TEMP
	CPI	' '
	JZ	XCM15
	CPI	','
	JNZ	GETCM
XCM15: 
	MOV	A,M
	ORA	A
	JNZ	XCM18
	JMP	CRGETCM
XCM18:
	PUSH	H
	MOV	E,M
	MVI	D,(REGS AND 0FF00H) SHR 8	;SAVE ADRESSE
	INX	H
	MOV	B,M
	PUSH	D
	PUSH	D
	POP	H
	PUSH	B
	MOV	A,M
	CALL	NMOUT
	POP	PSW
	PUSH	PSW
	ORA	A
	JZ	XCM20
	DCX	H
	MOV	A,M
	CALL	NMOUT
XCM20:
	MVI	C,CNGPRMT
	CALL	ECHO
	CALL	GETHX
	JNC	XCM30
	MOV	A,D
	STA	TEMP
	POP	PSW
	POP	H
	ORA	A
	JZ	XCM25
	MOV	M,B
	DCX	H
XCM25: 
	MOV	M,C
XCM27: 
	LXI	D,3
	POP	H
	DAD	D
	JMP	XCM10
XCM30:
	MOV	A,D
	STA	TEMP
	POP	D
	POP	D
        JMP	XCM27
;
;
;
CCMD:			
	;TESTET PLATTE IM ANGEGEBENEN LAUFWERK
	;UND GIBT ERGEBNISSE AUF DEM BILDSCHIRM AUS
	;LAUFWERKE a,b,c,d ENTSPRECHEN A,B,C,D ES WIRD JEDOCH
	;DIE RUECKSEITE GETESTET
	;
	CALL	GETCH		;LESE LAUFWERKSBEZEICHNER EIN
	CALL	ECHO		;GEBE ZEICHEN AUF CONSOLE
	MOV	A,C		;ZEICHEN IN AKKU
	PUSH	PSW		;RETTE ZEICHEN
	CALL	DISKDA		;TESTE OB FLOPPY CONTROLLER VORHANDEN
	POP	PSW		;LADE ZEICHEN WIEDER IN AKKU
	SUI	'A'		;WANDLE LW. CHR. IN NUMMER
	JC	ERROR		;WENN KLEINER, FEHLER
	MVI	B,0		;HEAD BIT=0
	CPI	4		;GROESSER 'D'
	JRC	CCMD7		;SPRUNG WENN NEIN
	SUI	' '		;TESTE OB KLEINBUCHSTABE (a-d)
	JC	ERROR		;FEHLER WENN ZEICHEN 44H BIS 60H
	MVI	B,04H		;HEAD BIT=1
	CPI	4		;GROESSER d
	JNC	ERROR		;
CCMD7:	MOV	C,A		;RETTE ALTE UNIT
	LDA	UNIT		;
	PUSH	PSW		;
	MOV	A,C		;
	CALL	DRIVE$TRANS	;WANDLE IN PHYS. LAUFWERK
	ORA	B		;HEAD BIT DAZU
	STA	UNIT		;ZU TESTENDES LAUFWERK
	MVI	B,5		;ANZAHL DER VERSUCHE
CCMD1	PUSH	B		;
	LHLD	UNIT		;RETTE UNIT UND TRACK
	PUSH	H		;
	CALL	TEST		;
	POP	H		;
	SHLD	UNIT		;
	POP	B		;GET ZAEHLER
	ORA	A		;FEHLER AUFGETRETEN?
	JRZ	CCMD2		;SPRUNG, WENN OK
	DJNZ	CCMD1		;NOCH EIN VERSUCH?
				;
	POP	PSW		;HOLE ALTE UNIT
	STA	UNIT		;
CCMD5:				;HIER AUCH EINSPRUNG FUER BOOT ERROR
	LXI	H,CHKERR	;DRUCKE FEHLERMELDUNG
	CALL	SOUT		;
	JMP	GETCM		;NEUE EINGABE
				;
CHKERR	DB	0DH,0AH,BELL
	DB	' Disk not correct'
	DB	0DH,0AH,24H
				;
CCMD2:				;
				;GEBE ART DER PLATTE AUS
	POP	PSW		;SETZE STACK RICHTIG
	LXI	H,CTXT1		;
	CALL	CBSOUT		;
	LDA	TEST$TYPE	;
	ANI	20H		;MINI ODER MAXI
	LXI	H,CTXT11	;
	JRZ	CCMD3		;
	LXI	H,CTXT12	;
CCMD3	CALL	SOUT		;
				;
	LXI	H,CTXT2		;
	CALL	CBSOUT		;
	LDA	TEST$TYPE	;NUMBER OF SURFACES
	RLC			;
	ANI	01H		;
	LXI	H,CTXT22	;
	JRZ	CCMD31		;
	LXI	H,CTXT21	;
CCMD31	CALL	SOUT		;
				;
	LXI	H,CTXT3		;
	CALL	CBSOUT		;
	LDA	TEST$TYPE	;
	LXI	H,CTXT31	;
	ANI	040H		;
	JRZ	CCMD4		;
	LXI	H,CTXT32	;
CCMD4	CALL	SOUT		;
				;
	LXI	H,CTXT4		;GEBE SEKTORGROESSE AUS
	CALL	CBSOUT		;
	LDA	TEST$TYPE	;
	ANI	00000011B	;
	MVI	H,0		;
	MOV	L,A		;
	DAD	H		;
	DAD	H		;
	DAD	H		;
	LXI	D,SEKTXT	;
	DAD	D		;
	CALL	SOUT		;
				;
	LXI	H,CTXT7		;GEBE ERSTEN SEKTOR DER SPUR AUS
	CALL	CBSOUT		;
	LDA	TEST$LSEK	;
	CALL	DEZOUT		;
				;
	LXI	H,CTXT5		;GEBE LETZTEN SEKTOR DER SPUR AUS
	CALL	CBSOUT		;
	LDA	TEST$MSEK	;
	CALL	DEZOUT		;
				;
	LXI	H,CTXT8		;GEBE ID HEAD BYTE AUS. ES WUERDE EIGENTLICH
	CALL	CBSOUT		;REICHEN NUR DAS UNTERSTE BIT AUSZUGEBEN (BIT 4
	LDA	REST+4		;VON TEST$TYPE), DIE AUSGABE DES GESAMMTEN
	CALL	NMOUT		;BYTES DIENT NUR DAZU, EXOTISCHE FORMATE ZU
				;ERKENNEN.
				;
	LXI	H,CTXT6		;GEBE AUS OB DAS LAUFWERK
	CALL	CBSOUT		;DAS READY SIGNAL LIEFERT
	CALL	READY$MASK	;
	ANI	0FH		;
	LXI	H,CTXT62	;
	JRNZ	CCMD6		;
	LXI	H,CTXT61	;
CCMD6	CALL	SOUT		;
				;
	LDA	LOGIN		;SETZE LOGIN-BIT FUER FLOPPY
	ANI	11111001B	;RICHTIG EINGELOGGT
	ORI	00000010B	;
	STA	LOGIN		;
				;
	CALL	SETCMDT		;SETZE CMDTAB
				;
	JMP	CRGETCM		;
;
CTXT1	DB	1,'disk format...: $'
CTXT2	DB	1,'two sided bit.: $'
CTXT3	DB	1,'density.......: $'
CTXT4	DB	1,'sector size...: #$'
CTXT7	DB	1,'first sector..: #$'
CTXT5	DB	1,'last sector...: #$'
CTXT8	DB	1,'head byte ID..: $'
CTXT6	DB	1,'ready signal..: $'
CTXT21	DB	'low$'
CTXT22	DB	'high$'
CTXT31	DB	'single$'
CTXT32	DB	'double$'
SEKTXT	DB	'128    $'
	DB	'256    $'
	DB	'512    $'
	DB	'1024   $'
CTXT11	DB	'maxi$'
CTXT12	DB	'mini$'
CTXT61	DB	'yes$'
CTXT62	DB	'simulated by index$'
;
;
;
OCMD:
	CALL	GETHX	;LESE PORTADRESSE
	MOV	A,D	;WAR TRENNZEICHEN CR?
	CPI	0DH
	JZ	ERROR	;FEHLER WENN JA
	PUSH	B	;SAVE INTEGER
	CALL	GETHX	;LESE DATA BYTE
	MOV	A,D	;WAR TRENNZEICHEN CR?
	CPI	0DH
	JNZ	ERROR	;FEHLER WENN NEIN
	MOV	L,C
	POP	B	;RESTORE PORTADR.
	OUTP	L	;GEBE AUS
	JMP	GETCM
;
;
RCMD:
		;LIEST AB IN CMDTAB ANGEGEBENEN SEKTOR
	CALL	PRINT$DRIVE
	CALL	RWINP	;SETZE DMA ADRESSE UND LAENGE
	CALL	READ	;LESE
	JMP	GETCM
;
WCMD:
	CALL	PRINT$DRIVE
	CALL	RWINP
	CALL	WRITE
	JMP	GETCM
;
ICMD:
	MVI	C,1
	CALL	GETNM
	POP	B	;IN C STEHT PORT
	INP	A	;LESE NACH A
	MVI	C,' '	;GEBE BLANK AUS
	PUSH	PSW
	CALL	CO
	POP	PSW
	PUSH	PSW
	CALL	NMOUT	;GEBE HEX AUS
	MVI	C,' '	;GEBE BLANK AUS
	CALL	CO
	POP	PSW
	MOV	D,A	;IN D FUER BITOUT
	CALL	BITOUT
	JMP	CRGETCM
;
;
;
ACMD:
	;ZEIGT UND VERAENDERT TRACK, SECTOR UND HEAD
	;DES EINGELOGTEN LAUFWERKS
	CALL	PRINT$DRIVE		;
					;
	LXI	H,ATXT1			;DISPLAY TRACK
	CALL	CBSOUT			;
	LDA	TRACK			;
	CALL	ENTER$BYTE		;
	STA	TRACK			;
	JZ	GETCM			;
					;
	LXI	H,ATXT2			;DISPLAY HEAD
	CALL	CBSOUT			;
	LDA	HEAD			;
	CALL	ENTER$BYTE		;
	STA	HEAD			;
	JZ	GETCM			;
					;
	LXI	H,ATXT3			;DISPLAY SECTOR
	CALL	CBSOUT			;
	LDA	SECTOR			;
	CALL	ENTER$BYTE		;
	STA	SECTOR			;
	JZ	GETCM			;
;
	JMP	CRGETCM
;
ATXT1	DB	1,'Track..: $'
ATXT2	DB	1,'Head...: $'
ATXT3	DB	1,'Sector.: $'
ATXT4	DB	'  $'
;
;
;
;
BCMD:				;EINSPRUNG BOOTROUTINE
				;
	CALL	GETCH1		;LESE ZEICHEN FUER BOOT-LW EIN
	CALL	ECHO		;GEBE ZEICHEN AUF KONSOLE
	CPI	0DH		;WAR RETURN ?
	JRZ	BCMD1		;DANN BOOT WIE IN TEMP$LOG$DRIVE DEFINIERT
	MVI	C,00010000B	;
	CPI	'E'		;BOOT TEMPORAER AUS EPROM
	JRZ	BCMD6		;
	MVI	C,00100000B	;
	CPI	'D'		;BOOT TEMPORAER AUS DISI
	JRZ	BCMD6		;
	CPI	'0'		;ZEICHEN KLEINER NULL
	JC	ERROR		;DANN FEHLERMELDUNG UND ZUM MONITOR
	CPI	'4'		;ZEICHEN GROESSER DREI
	JNC	ERROR		;DANN EBENFALLS FEHLERMELDUNG UND ZUM MONITOR
	ANI	00000011B	;MASKIERE UNTERE ZWEI BIT
	STA	TEMP$LOG$DRIVE	;UND SETZE ALS TEMORAERES LW-A
	JR	BCMD1		;
				;
BCMD6:	LDA	TEMP$LOG$DRIVE	;SETZE TEMP$LOG$DRIVE AUF EPROM- ODER DISI-BOOT
	ANI	00000011B	;FALLS LW A UMDEFINIERT WURDE
	ORA	C		;WIRD DIES BEIBEHALTEN
	STA	TEMP$LOG$DRIVE	;
				;
BCMD1:	LDA	TEMP$LOG$DRIVE	;BOOT VON EPROM ?
	MOV	C,A		;
	ANI	00010000B	;
	JNZ	EBOOT		;SPRUNG WENN JA
	MOV	A,C		;BOOT VON DISI
	ANI	00100000B	;
	JNZ	DIBOOT		;SPRUNG WENN JA
				;
				;SONST VERSUCHE BOOT VON FLOPPY.
	CALL	DISKDA		;FLOPPY BOOT MOEGLICH ?
	XRA	A		;
	STA	TEST$TRACK	;ERSTE TESTSPUR IST 0
	CALL	DRIVE$TRANS	;
	STA	UNIT		;OK, IN CMDTAB
	MVI	B,2		;TESTE PLATTE MAX. 2 MAL
BCMD3:	PUSH	B		;
	CALL	TEST		;SETZT CONTROLLER AUF MINI ODER MAXI
	POP	B		;
	ORA	A		;FEHLER AUFGETRETEN?
	JRZ	BCMD4		;SPRUNG WENN NEIN
	DJNZ	BCMD3		;NOCH EIN VERSUCH?
	JMP	CCMD5		;GEBE FEHLER MELDUNG AUS
BCMD4:				;
	CALL	SETCMDT		;SETZE CMDTABELLE
	XRA	A		;DER BOOTSEKTOR BEFINDET SICH
	STA	TRACK		;AUF SPUR NULL
	STA	HEAD		;SEITE EINS.
	LDA	TEST$LSEK	;LADE DEN SEKTOR MIT DER KLEINSTEN
	STA	SECTOR		;NUMMER ALS BOOTSEKTOR
	LXI	H,BOOTADR	;
	SHLD	DMAADR		;
	MVI	A,01H		;UEBERTRAGE EINEN SECTOR
	STA	SECTCNT		;
				;OK, ALLE WERTE SIND GESETZT
	CALL	READ		;LESE
	ORA	A		;FEHLER AUFGETRETEN?
	JNZ	BOOTERR		;
	LXI	H,BOOTADR	;KOPIERE DIE ERSTEN 128 BYTE
	LXI	D,BOOTADR+380H	;NACH HINTEN
	LXI	B,128		;
	LDIR			;
				;
	LXI	H,BOOTADR+6	;TESTE OB PROF-181X
	LXI	D,PROFTXT	;BOOTSEKTOR GELADEN WURDE
	MVI	B,9		;
BCMD2:	LDAX	D		;
	CMP	M		;
	JRNZ	BCMD5		;FEHLERMELDEUNG, WENN UNGLEICH
	INX	H		;
	INX	D		;
	DJNZ	BCMD2		;
				;
	LXI	H,0		;KENNZEICHEN FUER BOOT VON
	SHLD	BOOT$NAME	;FLOPPY LAUFWERKEN
	JMP	BOOTADR+380H	;ALLES KLAR, SPRINGE ZUM BOOTSEKTOR
				;
				;
BCMD5:	LXI	H,NOBOOTSEKTXT	;
	CALL	SOUT		;
	JMP	CRGETCM		;
				;
NOBOOTSEKTXT:
	DB	0DH,0AH,BELL
	DB	' No '
PROFTXT	DB	'PROF-181X'
	DB	' boot disk',0DH,0AH,24H
;
EBOOT:				;BOOTE CP/M AUS 27512 EPROM
	LHLD	BOOT$DIR	;TESTE OB EPROM GEPATCHT WURDE
	MOV	A,H		;
	ORA	L		;
	JRZ	NOPATCH		;
	LDA	RAMCHIPS	;EPROM BOOT NUR MOEGLICH,
	ORA	A		;WENN 512 K-BYTE RAM BESTUECKT SIND.
	JRZ	NOPATCH		;
	SHLD	BOOT$NAME	;LEGE DIR ADRESSE IN SYSPAGE AB (KENNZEICHEN FUER EPROM BOOT)
	MVI	A,0F0H		;SETZE MAXIMALE ANZAHL WAITZYKLEN
	OUT0	DCNTL,A		;
	MVI	A,PAD$MM0	;SCHALTE EPROM EIN
	OUT	P$LS259		;
				;
	LXI	H,LASTADD	;UEBERTRAGE EPROM AB MONITOR ENDE
	LXI	D,LASTADD	;
	LXI	B,0FF00H-LASTADD;
	LDIR			;
				;
	MVI	A,PAD$MM0 OR 1	;SCHALTE EPROM WIEDER WEG
	OUT	P$LS259		;
	LDA	READY$BYTE	;SETZE WAIT ZYKLEN
	ANI	0F0H		;
	OUT0	DCNTL,A		;
				;
	LHLD	BIOS$START	;LADE BIOS EINSPRUNG
	PCHL			;UND VERZWEIGE ZUM BIOS
	
	
NOPATCH:
	LXI	H,NOPATCHTXT	;
	CALL	SOUT		;
	JMP	CRGETCM		;
;
NOPATCHTXT:
	DB	0DH,0AH,BELL
	DB	'EPROM boot failure',0DH,0AH,24H
;
DIBOOT:				; BOOTE CP/M VON DISI
	LDA	DIFLAG		; DISI VORHANDEN?
	ORA	A		;
	JZ	CRGETCM		;
	LXI	H,0FFFFH	; KENNZEICHNEN FUER BOOT VON
	SHLD	BOOT$NAME	; DISI.
	XRA	A		; SPUR 0
	STA	TRACK		;
	INR	A		; SEKTOR 1
	STA	SECTOR		;
	LXI	H,DIBOOTADR	;
	SHLD	DMAADR		;
	CALL	DIREAD		;
	CALL	DICHKSUM	; CHECKSUMME DES URLADERS
	ORA	A		; LOESCHE CARRY
	LXI	D,24DCH		;
	DSBC	DE		;
	JNZ	BOOTERR		; CHECKSUMME FALSCH
	JMP	DIBOOTADR	;
;
;
;
LCMD:		;ZEIGE DATUM UND ZEIT AN
	CALL	DISP$TIME
	JMP	GETCM
;
;
;
NCMD:				;SETZE UHRZEIT UND DATUM
				;
	LXI	H,CITXT1	;LESE DATUM EIN
	CALL	SOUT		;
	CALL	GETDEZ		;
	CPI	'/'		;
	JNZ	ERROR		;FALSCHES TRENNZEICHEN
	MOV	A,L		;
	CPI	0		;
	JZ	ERROR		;
	CPI	13H		;
	JNC	ERROR		;
	STA	TIME$FIELD+4	;MONAT WEG
	CALL	GETDEZ		;
	CPI	'/'		;
	JNZ	ERROR		;
	MOV	A,L		;
	CPI	0		;
	JZ	ERROR		;
	CPI	32H		;
	JNC	ERROR		;
	STA	TIME$FIELD+3	;TAG WEG
	CALL	GETDEZ		;
	CPI	0DH		;
	JNZ	ERROR		;
	MOV	A,L		;
	STA	TIME$FIELD+6	;JAHR WEG
				;
				;UHRZEIT EINLESEN
	LXI	H, CITXT2	;
	CALL	SOUT		;
	CALL	GETDEZ		;
	CPI	':'		;
	JNZ	ERROR		;
	MOV	A,L		;
	CPI	24H		;
	JNC	ERROR		;
	STA	TIME$FIELD+2	;STUNDE WEG
	CALL	GETDEZ		;
	CPI	':'		;
	JNZ	ERROR		;
	MOV	A,L		;
	CPI	60H		;
	JNC	ERROR		;
	STA	TIME$FIELD+1	;MINUTE WEG
	CALL	GETDEZ		;
	CPI	0DH		;
	JNZ	ERROR		;
	MOV	A,L		;
	CPI	60H		;
	JNC	ERROR		;
	STA	TIME$FIELD	;SEKUNDE WEG
				;
	LXI	H,CITXT3	;SETZTE DIE ZEIT
	CALL	SOUT		;
	CALL	GETCH		;
	CALL	WRITE$TIME	;
	CALL	CROUT		;
	CALL	DISP$TIME	;ZEIGE NEUE ZEIT AN
	JMP	CRGETCM		;
				;
CITXT1:	DB	0DH,0AH,0AH,' Enter today''s date (MM/DD/YY): $'
CITXT2:	DB	' Enter the time (HH:MM:SS):     $'
CITXT3:	DB	' Press any key to set time$'
;
;
;
FCMD:
	MVI	C,3	;HOLE 3 WERTE VON DER CONSOLE
	CALL	GETNM
	POP	B	;FUELL BYTE
	POP	D	;END WERT
	POP	H	;ANFANGSWERT
FCMD1	MOV	M,C	;FUELLE BYTE
	CALL	HILO	;ENDE ERREICHT?
	JC	GETCM
	INX	H
	JMP	FCMD1
;
;
;
VCMD:
	;VERGLEICHT ZWEI SPEICHERBEREICHE MITEINANDER
	MVI	C,3	;LESE DREI ADRESSEN EIN
	CALL	GETNM
	POP	B	;ZWEITER BLOCKANFANG
	POP	D	;ERSTES BLOCKENDE
	POP	H	;ERSTER BLOCKANFANG
VCMD1	LDAX	B	;LESE BYTE AUS BLOCK 2
	CMP	M	;VERGLEICHE MIT ERSTEM BLOCK
	CNZ	VCMD2	;GEBE UNGLEICHE ADDRESSEN AUS
	CALL	HILO	;ENDE ERREICHT ?
	JC	GETCM	;OK, ENDE
	INX	H
	INX	B
	JMP	VCMD1	;VERGL. NAECHSTES BYTE
;
;
;
TCMD	MVI	C,2	;LESE ANFANG UND ENDADDRESSE
	CALL	GETNM
	POP	D
	POP	H
TCMD1	MOV	C,M
	MOV	A,C	;LESE SPEICHERSTELLE
	CMA		;NEGIERE
	MOV	M,A	;SCHREIBE IN ZELLE
	MVI	B,15	;WARTE ETWAS
TCMD2	DJNZ	TCMD2	;
	MOV	A,M	;LESE WIEDER
	MOV	M,C	;ORGINAL BYTE ZURUECK
	CMA		;A SOLL GLEICH C SEIN
	XRA	C	;SETZE ALL UNGLEICHEN BITS
	CNZ	FBYTOUT	;GEBE FEHLERHAFTES BYTE AUS
	CALL	HILO	;ENDE?
	JC	GETCM	;SPRUNG WENN JA
	INX	H	;TESTE NAECHSTES BYTE
	JR	TCMD1	;LOOP
;
;
;
;
;
;
VCMD2	PUSH	H
	PUSH	D
	PUSH	B	;RETTE ALLE ADRESSEN
	CALL	DISPMEM
	MVI	C,' '
	CALL	ECHO
	POP	H
	PUSH	H
	CALL	DISPMEM
	CALL	CROUT
	CALL	BREAK
	JC	GETCM
	POP	B
	POP	D
	POP	H
	RET
;
DISPMEM:
	;INPUT: HL
	;ZEIGT HL UND (HL) AUF DEM BILDSCHIRM AN
	;ZERSROERT A,B,C,FF'S
	CALL	HLNMOUT
	MVI	C,'='
	CALL	ECHO
	MOV	A,M
	CALL	NMOUT
	RET
;
;
;
FBYTOUT	PUSH	H		;
	PUSH	D		;
	MOV	D,A		;RETTE AKKU
	CALL	HLNMOUT		;
	MVI	C,' '		;GEBE NACH ADRRESE TRENNZEICHEN AUS
	CALL	CO		;
	CALL	BITOUT		;GEBE BITFOLGE AUS
	CALL	CROUT		;
	CALL	BREAK		;ABBRUCH
	JC	GETCM		;SPRUNG ZUM MONITOR WENN JA
	POP	D		;
	POP	H		;
	RET			;
;
;
;
BITOUT:
	;GIBT 8 BIT IN REG.D AUS
	;ZERSTOERT A,B,C,D,E
	MVI	B,8	;GEBE 8 BIT AUS
BITOUT1	RLCR	D	;SCHIEBE IN CARRY
	MVI	A,'0'	;ASSCI 0
	MVI	E,0
	ADC	E
	MOV	C,A
	CALL	CO
	DJNZ	BITOUT1
	RET
;
;
;
HCMD:
	;HELP-BEFEHL, GIBT EINE UEBERSICHT UEBER ALLE
	;EINGEBAUTEN BEFEHLE
	;
	LXI	H,HELPTXT	;GEBE KOPF-MELDUNG AUS
	CALL	SOUT		;
				;GEBE LISTE DER
	LXI	H,CMDMSG-1	;EINGEBAUTEN BEFEHLE AUS
HCMD2	INX	H		;ZEIGER AUF NAECHSTEN-BEFEHLSTEXT
	CALL	CROUT		;GEBE ERST RETURN-LINEFEED AUS
	MOV	A,M		;ENDE DER LISTE?
	ORA	A		;
	JZ	GETCM		;DANN WIEDER AUF KOMMANDO-EBENE
	MVI	B,5		;GEBE FUENF BLANKS AUS
	MVI	C,' '		;
HCMD3	CALL	ECHO		;
	DJNZ	HCMD3		;
	CALL	SOUT		;GEBE TEXT AUS
	JRZ	HCMD2		;BIS KEINER MEHR DA IST
				;
HELPTXT	DB	0DH,0AH,0AH
	DB	'following commands are available:',0H,0AH,'$'
;
;
;

ECMD:
	;GIBT DEN WERT DER LETZTEN BENUTZTEN EPROMADRESSE AUS
	;GEBE EPROM-PRUEFSUMME AUS
	;
	LXI	H,ECMDTXT
	CALL	CBSOUT
	MVI	A,LASTADD SHR 8
	CALL	NMOUT
	MVI	A,LASTADD AND 0FFH
	CALL	NMOUT
	LXI	H,ECMDTTT
	CALL	CBSOUT
	MVI	A,(FBANK0 SHR 8)+1
	CALL	NMOUT
	XRA	A
	CALL	NMOUT
	LXI	H,ECMDTXX
	CALL	CBSOUT
	LHLD	TYPELIST		
	CALL	HLNMOUT
	JMP	CRGETCM
;
ECMDTXT	DB	8,'end location..........: $'
ECMDTXX	DB	8,'checksum..............: $'
ECMDTTT	DB	8,'first bank 0 location.: $'
;
;
;
KCMD:
	;GIBT ALLE KONSOLENEINGABEN UNVERAENDERT AUS
	;ESCAPE MIT CONTROL-C
	LXI	H,KCMDTXT
	CALL	SOUT
KCMD1:	CALL	CI		;LESE ZEICHEN
	CPI	3		;CONTROL-C?
	JRZ	KCMD2		;DANN ENDE
	MOV	C,A		;
	CALL	CO		;SONST GEBE ZEICHEN AUS
	JR	KCMD1		;
KCMD2:	JMP	CRGETCM
;
KCMDTXT	DB	' (escape with ^C)',0dh,0ah,0dh,0ah,'$'
;
;
;
UCMD:
	LXI	H,UTXT01	;GEBE ANFANGSTEXT AUS
	CALL	SOUT		;
	CALL	GETCH1		;LESE UNTERKOMMANDO DES UBEFEHLS
	CALL	UCMD6		;GEBE ZEICHEN AUS
	CPI	'0'		;LAUFWERKS NUMMER?
	JC	CRGETCM		;SONST ZURUECK ZUR MONITOR EINGABE
	CPI	'4'		;ZWISCHEN A UND D ?
	JC	UCMD1		;DANN LESE DATEN FUER LAUFWERK EIN
	CPI	'A'		;AB JETZT NUR NOCH BUCHSTABEN M\GLICH
	JC	CRGETCM		;
	CPI	'C'		;
	JC	UCMD7		;WENN A ODER B, EINLESEN DER SIO DATEN
	CPI	'C'		;
	JZ	UCMD9		;SPRUNG WENN UNTERMENUE C
	CPI	'M'		;
	JZ	UCMD10		;SPRUNG WENN UNTERMENUE M
	CPI	'W'		;
	JZ	UCMD11		;SPRUNG WENN UNTERMENUE W
	CPI	'U'		;
	JZ	UCMD12		;SPRUNG WENN UNTERMENUE U
	CPI	'I'		;
	JZ	UCMD13		;SPRUNG WENN UNTERMENUE I
	JMP	CRGETCM		;FALSCHE EINGABE, ZURUECK ZUM MONITOR
				;
UCMD1:				;LESE DISK DATEN EIN
	PUSH	PSW		;
	LXI	H,UTXT02	;
	CALL	SOUT		;
	POP	PSW		;
	CALL	UCMD6		;
	SUI	'0'		;
	STA	TEMP		;
	MOV	L,A		;ZEIGE AUF RICHTIGEN EINTRAG
	MVI	H,0		;
	DAD	H		;
	LXI	D,SPECD$WORD	;
	DAD	D		;
	SHLD	ERMSG		;KANN ALS ZWISCHENSPEICHER BENUTZT WERDEN
				;
	LXI	H,UTXT03	;LESE STEP-RATE EIN
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MOV	A,M		;LADE ALTE STEP-RATE
	RLC			;
	RLC			;
	RLC			;
	RLC			;
	CMA			;
	ANI	0FH		;
	INR	A		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;RETTE FLAGS
	DCR	A		;
	CMA			;
	RRC			;
	RRC			;
	RRC			;
	RRC			;
	ANI	0F0H		;
	MOV	B,A		;
	LHLD	ERMSG		;
	MOV	A,M		;
	ANI	0FH		;
	ORA	B		;
	MOV	M,A		;
	POP	PSW		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT04	;
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MOV	A,M		;LADE HEAD UNLOAD TIME
	RRC			;
	RRC			;
	RRC			;
	RRC			;
	ANI	0F0H		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;
	RLC			;
	RLC			;
	RLC			;
	RLC			;
	ANI	0FH		;
	MOV	B,A		;
	LHLD	ERMSG		;
	MOV	A,M		;
	ANI	0F0H		;
	ORA	B		;
	MOV	M,A		;
	POP	PSW		;
	JZ	UCMD2		;
				;
	INX	H		;ZEIGER EINS WEITER
	SHLD	ERMSG		;
				;
	LXI	H,UTXT05	;
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MOV	A,M		;LADE HEAD LOAD TIME
	ANI	0FEH		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;
	ANI	0FEH		;
	LHLD	ERMSG		;
	MOV	M,A		;
	POP	PSW		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT06	;LESE EIN OB LAUFWERK READY LIEFERT
	CALL	CBSOUT		;
	LDA	TEMP		;
	CALL	DRIVE$MASK	;
	ANI	0FH		;
	MOV	E,A		;
	MVI	D,0FFH		;
	LXI	H,READY$BYTE	;
	CALL	UCMD3		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT07	;LESE OB 80 TRACK LAUFWERK 
	CALL	CBSOUT		;
	LDA	TEMP		;
	CALL	DRIVE$MASK	;
	ANI	0F0H		;
	MOV	E,A		;
	MVI	D,0		;
	LXI	H,SEEKNR	;
	CALL	UCMD3		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT08	;LESE OB ZWEI STEPIMPULSE
	CALL	CBSOUT		;
	LDA	TEMP		;
	CALL	DRIVE$MASK	;
	ANI	0FH		;
	MOV	E,A		;
	MVI	D,0		;
	LXI	H,SEEKNR	;
	CALL	UCMD3		;
	JMP	UCMD2		;
				;
UCMD7:				;LESE SIO DATEN EIN
	LXI	H,FORMAT$SER0	;ZEIGER AUF RICHTIGES BAUDRATEN BYTE
	CPI	'A'		;
	JRZ	UCMD8		;
	LXI	H,FORMAT$SER1	;
UCMD8:	SHLD	ERMSG		;KANN ALS ZWISCHEN SPEICHER BENUTZT WERDEN
	PUSH	PSW		;
	LXI	H,UTXT10	;GEBE UNTERMENUE TEXT AUS
	CALL	SOUT		;
	POP	PSW		;
	CALL	UCMD6		;GEBE SIO BUCHSTABEN AUS
				;
	LXI	H,UTXT11	;LESE BAUDRATE EIN
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MOV	A,M		;
	ANI	0FH		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;
	LHLD	ERMSG		;
	ANI	0FH		;
	MOV	C,A		;
	MOV	A,M		;
	ANI	0F0H		;
	ORA	C		;
	MOV	M,A		;
	POP	PSW		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT12	;LESE EIN OB 7 ODER 8 DATENBITS
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MVI	E,01000000B	;
	MVI	D,0		;
	CALL	UCMD3		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT13	;LESE EIN OB 1 ODER 2 STOPBITS
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MVI	E,00010000B	;
	MVI	D,0		;
	CALL	UCMD3		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT14	;LESE EIN OB PARITY ODER NO PARITY
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MVI	E,00100000B	;
	MVI	D,0		;
	CALL	UCMD3		;
	JZ	UCMD2		;
	LHLD	ERMSG		;WENN NO PARITY DANN UNTERMENUE ENDE
	MOV	A,M		;
	ANI	00100000B	;
	JZ	UCMD2		;
				;
	LXI	H,UTXT15	;LESE EIN OB PARITY EVEN ODER ODD
	CALL	CBSOUT		;
	LHLD	ERMSG		;
	MVI	E,10000000B	;
	MVI	D,0FFH		;
	CALL	UCMD3		;
	JMP	UCMD2		;
				;
UCMD9:	LXI	H,UTXT20	;LESE GEMEINSAME DISK DATEN EIN
	CALL	SOUT		;
				;
	LXI	H,UTXT21	;WELCHES IST LAUFERK A
	CALL	CBSOUT		;
	LDA	LOG$DRIVE	;
	ANI	03H		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;
	ANI	03H		;
	MOV	C,A		;
	LDA	LOG$DRIVE	;
	ANI	0FCH		;
	ORA	C		;
	STA	LOG$DRIVE	;
	STA	TEMP$LOG$DRIVE	;
	POP	PSW		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT22	;LESE DELAY 1 EIN (TUNNEL ERASE TIME)
	CALL	CBSOUT		;
	LDA	TE$TIME		;
	CALL	ENTER$BYTE	;
	STA	TE$TIME		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT23	;LESE DELAY 2 EIN (FUER EPSON LAUFWERKE)
	CALL	CBSOUT		;
	LDA	STEP$WAIT	;
	CALL	ENTER$BYTE	;
	STA	STEP$WAIT	;
	JZ	UCMD2		;
				;
	LXI	H,UTXT24	;LESE SWITCH DELAY EIN
	CALL	CBSOUT		;NOTWENDIG FUER AUTOMATISCHE MINI/MAXI
	LDA	SWITCH$DELAY	;UMSCHALTUNG BEI TEAC FD55G/F
	CALL	ENTER$BYTE	;
	STA	SWITCH$DELAY	;
	JZ	UCMD2		;
				;
	LXI	H,UTXT27	;LESE START DELAY EIN
	CALL	CBSOUT		;ZUSAETZLICHE VERZOEGERUNG VOR DER ERSTEN
	LDA	START$DELAY	;ZEICHENAUSGABE AUF DEN KONSOLENKANAL
	CALL	ENTER$BYTE	;IN 100 MS SCHRITTEN.
	STA	START$DELAY	;NOTWENDIG FUER TERMINALS DIE LANGE
	JZ	UCMD2		;INITIALISIERUNGSZEITEN HABEN.
				;
	LXI	H,UTXT25	;SOLL VON EPROM GEBOOTET WERDEN ?
	CALL	CBSOUT		;
	LXI	H,LOG$DRIVE	;
	MVI	E,00010000B	;
	MVI	D,0		;
	CALL	UCMD3		;
	LDA	LOG$DRIVE	;
	STA	TEMP$LOG$DRIVE	;EBENFALLS UPDATE VON TEMP$LOGDRIVE
	JZ	UCMD2		;
	LDA	LOG$DRIVE	;WURDE EPROM$BOOT GESETZT
	MOV	C,A		;
	ANI	00010000B	;
	JRZ	UCMD16		;SPRUNG WENN NEIN
	MOV	A,C		;WENN JA LOESCHE DISI BOOT
	ANI	11011111B	;
	STA	LOG$DRIVE	;
	STA	TEMP$LOG$DRIVE	;
	CALL	CROUT		;
	JMP	UCMD2		;ZURUECK INS HAUPTMENUE

UCMD16:	LXI	H,UTXT26	;SOLL VON DISI GEBOOTET WERDEN ?
	CALL	CBSOUT		;
	LXI	H,LOG$DRIVE	;
	MVI	E,00100000B	;
	MVI	D,0		;
	CALL	UCMD3		;
	LDA	LOG$DRIVE	;
	STA	TEMP$LOG$DRIVE	;
	JMP	UCMD2		;
				;
UCMD10:	LXI	H,UTXT30	;LESE MULTIPLEXED PINS EIN
	CALL	SOUT		;
				;
	LXI	H,UTXT31	;LESE CTS1 BIT EIN
	CALL	CBSOUT		;
	LXI	H,LOG$DRIVE	;
	MVI	E,00000100B	;
	MVI	D,0		;
	CALL	UCMD3		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT32	;LESE TDEND0 BIT EIN
	CALL	CBSOUT		;
	LXI	H,LOG$DRIVE	;
	MVI	E,00001000B	;
	MVI	D,0		;
	CALL	UCMD3		;
	JMP	UCMD2		;
				;
UCMD11:	LXI	H,UTXT40	;LESE WAITZYKLEN EIN
	CALL	SOUT		;
				;
	LXI	H,UTXT41	;I/O WAIT ZYKLEN
	CALL	CBSOUT		;
	LDA	READY$BYTE	;
	RRC			;
	RRC			;
	RRC			;
	RRC			;
	ANI	03H		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;
	RLC			;
	RLC			;
	RLC			;
	RLC			;
	ANI	30H		;
	MOV	C,A		;
	LDA	READY$BYTE	;
	ANI	0CFH		;
	ORA	C		;
	STA	READY$BYTE	;
	POP	PSW		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT42	;MEMORY WAIT STATES
	CALL	CBSOUT		;
	LDA	READY$BYTE	;
	RLC			;
	RLC			;
	ANI	03H		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;
	RRC			;
	RRC			;
	ANI	0C0H		;
	MOV	C,A		;
	LDA	READY$BYTE	;
	ANI	03FH		;
	ORA	C		;
	STA	READY$BYTE	;
	POP	PSW		;
	JMP	UCMD2		;
				;
UCMD12:	LXI	H,UTXT50	;LESE BENUTZER BYTES EIN
	CALL	SOUT		;
				;
	LXI	H,UTXT51	;
	CALL	CBSOUT		;
	LDA	UDAT1		;
	CALL	ENTER$BYTE	;
	STA	UDAT1		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT52	;
	CALL	CBSOUT		;
	LDA	UDAT2		;
	CALL	ENTER$BYTE	;
	STA	UDAT2		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT53	;
	CALL	CBSOUT		;
	LDA	UDAT3		;
	CALL	ENTER$BYTE	;
	STA	UDAT3		;
	JZ	UCMD2		;
				;
	LXI	H,UTXT54	;
	CALL	CBSOUT		;
	LDA	UDAT4		;
	CALL	ENTER$BYTE	;
	STA	UDAT4		;
	JMP	UCMD2		;
				;
UCMD13:				;
	LXI	H,UTXT60	;TEXT FUER UNTERMENUE I
	CALL	SOUT		;
				;
	LDA	IO$JUMPERBYTE	;SETZE HL AUF INIT-ZEIGER
	ANI	00000011B	;
	MOV	L,A		;
	MVI	H,16		;
	MULT	H		;
	LXI	D,S$INIT$TAB	;
	DAD	D		;
	MVI	B,8		;SETZE ZAEHLER
	MVI	C,10000000B	;SETZE MASKE
UCMD14:	MOV	E,M		;
	INX	H		;
	MOV	D,M		;
	INX	H		;
	INX	D		;STEHT ZEIGER AUF FFFFH
	MOV	A,D		;
	ORA	E		;
	JRZ	UCMD15		;SPRUNG WENN JA
	PUSH	H		;RETTE ZEIGER
	PUSH	B		;RETTE ZAEHLER UND MASKE
	XCHG			;ADRESSE MINUS EINS
	DCX	H		;NACH HL
	CALL	CBSOUT		;GEBE TEXTZEILE AUS
	LXI	H,S$INIT$BYTE	;HL ZEIGT AUF BYTE
	POP	D		;
	PUSH	D		;
	MVI	D,0		;
	CALL	UCMD3		;LESE YES/NO WERT EIN
	POP	B		;
	POP	H		;
	JRNZ	UCMD15		;
	MVI	B,1		;
UCMD15:	RRCR	C		;
	DJNZ	UCMD14		;
	JMP	UCMD2		;
				;
UCMD2:	CALL	SET$DATA	;
	JMP	UCMD		;
				;
UCMD3:				;UNTERPROGRAMM ZUM EINLESEN VON YES/NO WERTEN
				;HL ZEIGT AUF BYTE, E ENTHAELT MASKE, D=0 FUER
				;YES=1, D<>0 FUER YES=0
				;AUSGANG: ZEROFLAG GESETZT WENN TRENNZEICHEN CR
				;
	MOV	A,D		;TESTE AM ANFANG OB YES=1 ODER YES=0
	ORA	A		;
	PUSH	PSW		;RETTE FLAG
	MOV	A,E		;SETZE BIT
	ANA	M		;
	MOV	C,A		;
	POP	PSW		;HOLE ZEROFLAG
	MOV	A,C		;
	PUSH	H		;RETTE ZEIGER
	PUSH	D		;RETTE MASKE
	JRZ	UCMD4		;
	CALL	ENTER$NO$YES	;
	JR	UCMD5		;
UCMD4	CALL	ENTER$YES$NO	;
UCMD5	POP	D		;HOLE MASKE
	POP	H		;HOLE ZEIGER
	PUSH	PSW		;RETTE FLAG
	ANA	E		;BIT NACH B
	MOV	B,A		;
	MOV	C,M		;
	MOV	A,E		;
	CMA			;
	ANA	C		;
	ORA	B		;
	MOV	M,A		;
	POP	PSW		;
	RET			;
				;
UCMD6:	PUSH	PSW		;GEBE ZEICHEN IN AKKU AUS
	MOV	C,A		;
	CALL	ECHO		;
	POP	PSW		;
	RET			;
;
UTXT01:	DB	0DH,0AH,0DH,0AH
	DB	' 0,1,2,3,A,B,C,I,M,U,W select => $'
;
UTXT02:	DB	0DH,0AH,0DH,0AH,' data for drive $'
UTXT03:	DB	1,'step rate ........: $'
UTXT04:	DB	1,'head unload time .: $'
UTXT05:	DB	1,'head load time ...: $'
UTXT06:	DB	1,'ready signal......: $'
UTXT07:	DB	1,'80 track..........: $'
UTXT08:	DB	1,'double step.......: $'
;
UTXT10:	DB	0DH,0AH,0Dh,0Ah,' data for V-24-$'
UTXT11:	DB	1,'baudrate......: $'
UTXT12:	DB	1,'8 data bits...: $'
UTXT13:	DB	1,'2 stop bits...: $'
UTXT14:	DB	1,'parity enable.: $'
UTXT15:	DB	1,'parity even...: $'
;
UTXT20:	DB	0DH,0AH,0DH,0AH,' common data$'
UTXT21:	DB	1,'drive A......: $'
UTXT22:	DB	1,'tunnel erase.: $'
UTXT23:	DB	1,'motor delay..: $'
UTXT24:	DB	1,'switch delay.: $'
UTXT27:	DB	1,'start delay..: $'
UTXT25:	DB	1,'EPROM boot...: $'
UTXT26: DB	1,'DISI boot....: $'
;
UTXT30:	DB	0DH,0AH,0DH,0AH,' multiplexed pins$'
UTXT31:	DB	1,'CTS1...: $'
UTXT32:	DB	1,'TDEND0.: $'
;
UTXT40:	DB	0DH,0AH,0DH,0AH,' wait insertions$'
UTXT41:	DB	1,'I/O....: $'
UTXT42:	DB	1,'memory.: $'
;
UTXT50:	DB	0DH,0AH,0DH,0AH,' user bytes$'
UTXT51:	DB	1,'byte 1 : $'
UTXT52:	DB	1,'byte 2 : $'
UTXT53:	DB	1,'byte 3 : $'
UTXT54:	DB	1,'byte 4 : $'
;
UTXT60:	DB	0DH,0AH,0DH,0AH,' initialisation string(s)$'
;
SET$DATA:			;SETZE DATEN IN DER UHR
	XRA	A		;LOESCHE AKKU
	LXI	H,SYSPAGE	;ZEIGER AUF DATENANFANG
	MVI	B,23		;UND PRUEFSUMME BERRECHNEN
SDATA1	ADD	M		;
	INX	H		;
	DJNZ	SDATA1		;
	CMA			;
	INR	A		;
	MOV	M,A		;
	CALL	WRITE$CLK$DATA	;
	RET			;
;
;
;
YCMD:				;DISKETTEN FORMATIERER
				;
	LXI	H,YTXT00	;LESE LAUFWERK EIN
	CALL	CBSOUT		;
	LDA	YDAT0		;
	CALL	ENTER$BYTE	;
	STA	YDAT0		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT01	;LESE MINI/MAXI EIN
	CALL	CBSOUT		;
	LDA	YDAT1		;
	CALL	ENTER$YES$NO	;
	STA	YDAT1		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT02	;LESE SINGLE/DOUBLE DENSITY EIN
	CALL	CBSOUT		;
	LDA	YDAT2		;
	CALL	ENTER$YES$NO	;
	STA	YDAT2		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT03	;LESE SINGLE/DOUBLE SIDE EIN
	CALL	CBSOUT		;
	LDA	YDAT3		;
	CALL	ENTER$YES$NO	;
	STA	YDAT3		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT04	;LESE SEKTORGROESE EIN
	CALL	CBSOUT		;
	LDA	YDAT4		;
	ANI	03H		;
	CALL	ENTER$BYTE	;
	PUSH	PSW		;
	ANI	03H		;
	STA	YDAT4		;
	POP	PSW		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT05	;LESE ERSTEN SEKTOR EIN
	CALL	CBSOUT		;
	LDA	YDAT5		;
	CALL	ENTER$BYTE	;
	STA	YDAT5		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT06	;LESE LETZTEN SEKTOR EIN
	CALL	CBSOUT		;
	LDA	YDAT6		;
	CALL	ENTER$BYTE	;
	STA	YDAT6		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT07	;LESE ANZAHL DER SPUREN EIN
	CALL	CBSOUT		;
	LDA	YDAT7		;
	CALL	ENTER$BYTE	;
	STA	YDAT7		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT08	;LESE GAPLAENGE EIN
	CALL	CBSOUT		;
	LDA	YDAT8		;
	CALL	ENTER$BYTE	;
	STA	YDAT8		;
	JZ	CRGETCM		;
				;
	LXI	H,YTXT09	;LESE STARTZEICHEN EIN
	CALL	CBSOUT		;
	XRA	A		;
	CALL	ENTER$YES$NO	;
	ORA	A		;WAR NEIN
	JZ	CRGETCM		;DANN WIEDER MONITOR
				;
	LDA	YDAT7		;SIND 0 SPUREN ZU FORMATIEREN
	ORA	A		;
	JZ	CRGETCM		;DANN SOFORT ENDE
				;
	LXI	H,CMDTAB	;RETTE ALTE CMDTAB
	LXI	D,CMDRET	;
	LXI	B,9		;
	LDIR			;
				;
	CALL	START$MOTOR	;
				;
	CALL	CROUT		;LINE FEED
	CALL	CROUT		;
	LDA	YDAT0		;SETZTE UNIT
	ANI	00000011B	;
	STA	UNIT		;
	LXI	B,0204H		;SENSE DRIVE UND TESTE AUF READY
	CALL	MOTO		;
	CALL	NEXT		;
	BIT	6,A		;SCHREIBGESCHUETZT
	JRZ	YCMD1		;SPRUNG WENN NEIN
				;
	LXI	H,YTXT12	;GEBE FEHLERMELDUNG AUS
	CALL	SOUT		;
	JMP	YCMD7		;
				;
YCMD1:	LDA	YDAT1		;SETZE MINI/MAXI
	ORA	A		;
	JRZ	YCMD2		;
	CALL	MAXI$SET	;
	JR	YCMD3		;
YCMD2:	CALL	MINI$SET	;
YCMD3:	XRA	A		;STELLE SPUR 0 EIN
	STA	FORMTAB		;
	STA	TRACK		;
	CALL	RECAL		;
				;
	LXI	H,YTXT13	;TEXT FUER FORMATIEREN ANFANG
	CALL	CBSOUT		;
				;
YCMD4:	LHLD	UNIT		;SETZTE AUF NONDMA BETRIEB
	PUSH	H		;
	LXI	H,0100H		;
	LXI	B,0303H		;
	SHLD	UNIT		;
	CALL	CMFD		;
	POP	H		;
	SHLD	UNIT		;
				;
	LDA	UNIT		;FORMATIERE SEITE 0
	ANI	00000011B	;
	STA	UNIT		;
	XRA	A		;
	STA	FORMTAB+1	;
	CALL	FTRACK		;
				;
	LDA	YDAT3		;ZWEISEITIG
	ORA	A		;
	JRNZ	YCMD5		;SPRUNG WENN NEIN
				;
	LDA	UNIT		;SONST FORMATIERE ZWEITE SEITE
	ORI	00000100B	;
	STA	UNIT		;
	MVI	A,01H		;
	STA	FORMTAB+1	;
	CALL	FTRACK		;
				;
YCMD5:	LDA	YDAT7		;PRUEFE AUF ENDE
	DCR	A		;IN YDAT STEHT ANZAHL, DESHALB EINS WENIGER
	MOV	C,A		;
	LDA	FORMTAB		;
	CMP	C		;
	JRZ	YCMD6		;SPRUNG WENN ENDE
				;
	INR	A		;ERHOEHE SPUR UM EINS
	STA	FORMTAB		;
	STA	TRACK		;
	CALL	SEEK		;
	JR	YCMD4		;UND FORMATIERE NAECHSTE SPUR
				;
YCMD6:	CALL	RECAL		;RECALIBRIERE (UND SETZTE AUF DMA BETRIEB)
				;
YCMD7:	LXI	H,CMDRET	;LADE ALTE CMDTAB ZURUECK
	LXI	D,CMDTAB	;
	LXI	B,9		;
	LDIR			;
	JMP	CRGETCM		;
;
;
;
FTRACK:				;FORMATIERE EINE SPUR
				;BEVOR DIESE ROUTINE AUFGERUFEN WIRD
				;MUSS AUF DIE GEWUENSCHTE SPUR
				;POSITIONIERT SEIN UND DER UPD 765 AUF
				;NON DMA BETRIEB GESCHALTET SEIN.
				;DIE TAKTRATE DES UPD 765 MUSS EINGESTELLT
				;SEIN (MINI/MAXI).
				;
				;FOLGENDE PARAMETER WERDEN BENOETIGT:
				;
				; IN CMDTAB:
				; UNIT		- LW UND PYHS. SEITE
				;
				; SONSTIGE PARAMETER:
				;
				; YDAT2		- SD FFH, DD 00H
				; YDAT4		- SEKTORGROESSE
				; YDAT5		- ERSTER SEKTOR
				; YDAT6		- LETZTER SEKTOR
				; YDAT8		- GAP LAENGE FUER FORMAT
				; FILLBYTE	- FUELLBYTE
				; FORMTAB	- SPUR NUMMER
				; FORMTAB+1	- SEITEN NR. FUER ID-FELD
				; FORMAT$PRECOM - PRECOMPENSTIONS ZEIT
				; BEGIN$FPRECOM	- ANFANGSSPUR PRECOMPENSATION
				;
	CALL	SEND$FPRECOM	;SETZE PRECOMPENSATIONSZEIT
	LXI	H,YTXT10	;GEBE SPUR UND KOPF TEXT AUS
	CALL	SOUT		;
	LDA	FORMTAB		;
	CALL	DEZOUT		;
	LXI	H,YTXT11	;
	CALL	SOUT		;
	LDA	UNIT		;
	RRC			;
	RRC			;
	ANI	01H		;
	ADI	'0'		;
	MOV	C,A		;
	CALL	ECHO		;
				;
	LDA	YDAT5		;
	STA	FORMTAB+2	;LEGE ERSTEN SEKTOR IN FORMTAB AB
	MOV	C,A		;
	LDA	YDAT6		;
	SUB	C		;BERECHNE SEKTOREN/SPUR.
	INR	A		;
	STA	HEAD		;LEGE SEKTOREN/SPUR IN CMDTAB AB.
	LDA	FILLBYTE	;LEGE FILLBYTE
	STA	SECSZ		;IN CMDTAB AB.
	LDA	YDAT4		;LEGE SEKTORGROESSE
	STA	TRACK		;IN CMDTAB
	STA	FORMTAB+3	;UND FORMTAB AB.
	LDA	YDAT8		;SETZE GAP LAENGE
	STA	SECTOR		;IN CMDTAB.
				;ALLE TABELLEN VORBEREITET
	LDA	YDAT2		;SINGLE ODER DOUBLE DENSITY
	CMA			;INVERTIERE
	ANI	040H		;MASKIERE
	ORI	0DH		;PLUS GRUNGBEFEHL
	MOV	C,A		;FORMATIERBEFEHL IN C
	MVI	B,6		;LAENGE DES BEFEHLS IN B
	CALL	MOTO		;SENDE FORMATIERBEFEHL ZUM UPD 765
	LDA	HEAD		;LADE ANZAHL DER SEKTOREN
	MOV	D,A		;NACH D
	LXI	H,FORMTAB	;ZEIGER AUF FORMAT TABELLE
FTRK1:	PUSH	H		;RETTE ZEIGER AUF STACK
	MVI	B,4		;ZAEHLER FUER DATEN EINES SEKTORS
FTRK2:	IN	FDC		;REQUEST FOR MASTER
	RLC			;
	JRNC	FTRK2		;
	MOV	A,M		;GEBE BYTE AUS FORMTAB
	OUT	FDD		;AN UPD 765
	INX	H		;ERHOEHE ZEIGER
	DJNZ	FTRK2		;BIS ALLE VIER DATEN AUSGEGEBEN
	DCR	D		;ALLE SEKTOREN FORMATIERT ?
	JRZ	FTRK3		;SPRUNG ZUM ENDE WENN JA
	DCX	H		;ERHOEHE SEKTOR NUMMER
	DCX	H		;UM
	INR	M		;EINS
	POP	H		;ALTER ZEIGER AUF FORMTAB
	JR	FTRK1		;
FTRK3:	POP	H		;RICHTE STACK
	CALL	RESULT		;RESULT PHASE
	RET			;ENDE
;
SEND$FPRECOM:			;SETZE PRECOMPENSATION GLEICH
				;FORMAT$PRECOM, WENN SPUR IN FPRECOM$BEGIN
				;KLEINER ALS SPUR IN FORMTAB.
	LDA	FPRECOM$BEGIN	;SPUR KLEINER?
	MOV	C,A		;
	LDA	FORMTAB		;
	CMP	C		;
	MVI	A,0		;WENN SPUR KLEINER, DANN PRECOM=0
	JRC	SFPRCM		;
	LDA	FORMAT$PRECOM	;SONST PRECOM WIE IN FORMAT$PRECOM
SFPRCM	CALL	BASIC$PRECOM	;
	RET			;
;
;
;
YTXT00:	DB	1,'drive..........: $'
YTXT01: DB	1,'maxi disk......: $'
YTXT02:	DB	1,'single density.: $'
YTXT03:	DB	1,'single side....: $'
YTXT04:	DB	1,'sector size....: $'
YTXT05:	DB	1,'first sector...: $'
YTXT06:	DB	1,'last sector....: $'
YTXT07:	DB	1,'track number...: $'
YTXT08:	DB	1,'format gap.....: $'
YTXT09:	DB	1,'start format...: $'
;
YTXT10:	DB	0DH,' track #$'
YTXT11:	DB	' head #$'
YTXT12:	DB	' Write protect',07H,24H
YTXT13:	DB	1,'start formatting:',0AH,24H
;
;
;
;
;-------------------------------------------------------INITIALISIERUNG------
;

INIT:

	LXI	H,2000		;WARTEZEIT ZUM WARM WERDEN
INIT1:	DCX	H		;
	MOV	A,H		;
	ORA	L		;
	JRNZ	INIT1		;
				;
	MVI	A,0F0H		;
	OUT0	DCNTL,A		;
				;
;	JMP	LABEL		; NUR FUER TEST

	MVI	A,0F0H		;SETZE LOG. ADR. F000H BIS FFFFH
	OUT0	CBAR,A		;AUF PHYS. ADR. 4F000H BIS 4FFFFH
	MVI	A,040H		;WIRD SPAETER RUECKGAENGIG GEMACHT
	OUT0	CBR,A		;
				;TESTE RAM
	LXI	H,0F000H	;
	LXI	B,01000H	;
	MVI	E,53H		;SCHREIBE FORTLAUFENDE  ZAHLEN INS RAM
INIT17:	MOV	M,E		;
	INR	E		;
	INX	H		;
	DCX	B		;
	MOV	A,B		;
	ORA	C		;
	JRNZ	INIT17		;
				;
	LXI	H,2000		;WARTE UM REFRESH ZU TESTEN
INIT18:	DCX	H		;
	MOV	A,H		;
	ORA	L		;
	JRNZ	INIT18		;
				;
	LXI	H,0F000H	;TESTE OB DATEN NOCH IM RAM STEHEN
	LXI	B,01000H	;
	MVI	E,53H		;
INIT19:	MOV	A,M		;
	CMP	E		;VERGLEICHE
	JNZ	INIT20		;WENN UNGLEICH, DANN BLINKSCHLEIFE
	INR	E		;
	INX	H		;
	DCX	B		;
	MOV	A,B		;
	ORA	C		;
	JRNZ	INIT19		;
;***
				;ES KANN DAVON AUSGEGANGEN WERDEN, DASS DAS
				;RAM IN ORDNUNG IST.
	LXI	H,0		;KOPIERE EPROM IN RAM
	LXI	D,0		;
	LXI	B,EPROML	;
	LDIR			;
	MVI	A,PAD$MM0 OR 1	;SCHALTE EPROM WEG
	OUT	P$LS259		;
	MVI	A,RCR$BYTE	;LEGE REFRESH ZYKLEN FEST
	OUT0	RCR,A		;
;***
;
	LXI	H,0		;BERRECHNE EPROM PRUEFSUMME
	LXI	D,0		;
	LXI	B,0		;
INIT12:	LDAX	B		;
	MOV	E,A		;
	DAD	D		;
	INX	B		;
	CPI	EPROML SHR 8	;
	JRNZ	INIT12		;
	SHLD	TAB$TYPELIST	;PRUEFSUMME STEHT IN TYPELIST
;
;***
	XRA	A		;
	OUT0	CBR,A		;
	OUT0	CBAR,A		;
;***
LABEL:

	LXI	SP,MSTAK	;SETZE STACKPOINTER
	CALL	HIGHSLC		;UHRENTAKT INAKTIV SETZEN
;***
	IF	MK3835
				;STEHT UHR ? NUR FUER MK3835 NOTWENDIG
	CALL	READ$TIME	;
	LDA	TIME$FIELD	;BEIM EINSTECKEN DER UHR IN DEN
	ANI	80H		;SOCKEL IST BIT 8 GESETZT, UHR STEHT
	JRZ	INIT4		;SPRUNG WENN UHR  LAEUFT
	XRA	A		;
	STA	TIME$FIELD	;SONST STARTE UHR (ERSTER START)
	CALL	WRITE$TIME	;UND SETZE GLEICHZEITG UHR TAKTFREQUENZ
	MVI	A,0FFH		;FLAG FUER BATTERIE LEER
	JR	INIT6		;DATEN IN UHR SIND AUCH NICH BRAUCHBAR
	ENDIF			;

INIT4:	
;***
	CALL	READ$CLK$DATA	;LESE DATEN AUS UHR
	LXI	H,SYSPAGE	;TESTE OB PRUEFSUMME
	MVI	B,24		;DER 24 BYTE STIMMT
	XRA	A		;
INIT2:	ADD	M		;
	INX	H		;
	DJNZ	INIT2		;
INIT6:	LXI	H,DEFTAB	;BESETZE SYSTEMPAGE
	LXI	D,SYSPAGE	;
	LXI	B,DEFTAL	;
	ORA	A		;
	PUSH	PSW		;RETTE FUER TEXT AUSGABE
	JRNZ	INIT3		;
	LXI	H,DEFTAB+24	;
	LXI	D,SYSPAGE+24	;
	LXI	B,DEFTAL-24	;
INIT3:	LDIR			;
				;
;***
	CALL	READ$TIME	;MESSE SYSTEMTAKT MIT 3 WAITZYKLEN
	LXI	H,4000		;
	LDA	TIME$FIELD	;
	MOV	C,A		;
INIT7:	DCX	H		;TIMMER ABGELAUFEN ?
	MOV	A,H		;
	ORA	L		;
	JRZ	INIT8		;SPRUNG WENN JA DANN TAKT=0 FUER UHR FEHLER
	CALL	READ$TIME	;
	LDA	TIME$FIELD	;WARTE BIS SEKUNDE UMSPRINGT
	CMP	C		;
	JRZ	INIT7		;
	
	IF	MK3835		;SETZE HL AUF ANFANGSWERT
	LXI	H,20H		;20H FUER MK3835
	ELSE			;
	LXI	H,08H		;08H FUER PCF8583
	ENDIF			;

	MOV	C,A		;
INIT9:	CALL	READ$TIME	;

	IF	MK3835		;
	LXI	D,301		;ANPASSUNG 301 FUER MK3835
	ELSE			;
	LXI	D,192		;ANPASSUNG 192 FUER PCF8583
	ENDIF			;

				;DIESE SCHLEIFE DIENT  ZUR
INIT10:	DCX	D		;ANPASSUNG DER GESAMTMESSUNG
	MOV	A,D		;
	ORA	E		;
	JRNZ	INIT10		;
	LDA	TIME$FIELD	;
	INX	H		;
	CMP	C		;
	JRZ	INIT9		;

	IF	NOT MK3835	;WENN PCF8583 MUESSEN DIE DATEN
	DAD	H		;IN HL INSGESAMT MIT 16 MULTIPLIZIERT
	DAD	H		;WERDEN
	ENDIF			;

	DAD	H		;
	DAD	H		;IN H BEFINDET SICH TAKT/1,536 MHZ
INIT8:	MOV	A,H		;LEGE IN SPEED AB
	STA	SPEED		;

				;
;***
				;
	LDA	READY$BYTE	;SETZTE WAIT-ZYKLEN
	ANI	0F0H		;
	OUT0	DCNTL,A		;
;***
	LDA	START$DELAY	;VERZOEGERUNGSSCHLEIFE 100MS MAL
	MOV	L,A		;DEM IN START$DELAY ANGEGEBENEN WERT
	MVI	H,100		;
	MULT	H		;
	MVI	B,10		;DELAY 10 MAL AUFRUFEN, DA SONST
INIT65:	PUSH	B		;NUR MAL 10 US
	PUSH	H		;
	CALL	DELAY100US	;
	POP	H		;
	POP	B		;
	DJNZ	INIT65		;

;***				;
	LDA	VERSIONNR	;SETZE MONITOR VERSIONSNUMMER
	STA	MON$VERS	;IM RAM
				;
;***
	CALL	GET$JUMPER	;SETZE BEIDE JUMPERBYTE
;***
	LDA	LOG$DRIVE	;KOPIERE LOG$DRIVE IN
	STA	TEMP$LOG$DRIVE	;TEMP$LOG$DRIVE
				;
	LDA	BAUD$JUMPERBYTE	;SETZE SERBAUD0
	MOV	C,A		;
	LDA	FORMAT$SER0	;
	MOV	B,A		;
	ANI	00FH		;
	JRNZ	INIT14		;WENN 0, DANN BAUDRATE
	MOV	A,C		;WIE J19
INIT14	MOV	C,A		;
	MOV	A,B		;
	ANI	0F0H		;
	ORA	C		;
	STA	SERBAUD0	;
				;
	LDA	BAUD$JUMPERBYTE	;SETZE SERBAUD1
	MOV	C,A		;
	LDA	FORMAT$SER1	;
	MOV	B,A		;
	ANI	00FH		;
	JRNZ	INIT15		;WENN 0, DANN BAUDRATE
	MOV	A,C		;WIE J19
INIT15	MOV	C,A		;
	MOV	A,B		;
	ANI	0F0H		;
	ORA	C		;
	STA	SERBAUD1	;
				;
;***
	LDA	SPEED		;KOPIERE RICHTIGE BAUDTABELLE
	CALL	SPEEDCON	;NACH BAUD$TAB
	MOV	C,A		;
	ANI	0F0H		;WENN SYSTEMFREQUENZ FALSCH
	JRZ	INIT16		;DANN NEHME TABELLE 0
	MVI	C,0		;
INIT16	MOV	L,C		;
	MVI	H,0		;
	DAD	H		;
	DAD	H		;
	DAD	H		;
	DAD	H		;
	LXI	D,SPEED$BAUD$TAB;
	DAD	D		;
	LXI	D,BAUD$TAB	;
	LXI	B,16		;
	LDIR			;
;***
				;INITIALISIERE BEIDE SERIELLE SCHNITTSTELLEN
	CALL	SERINIT		;
;***
	CALL	USERINIT	;
;***
	LXI	H,FITAB		;SETZE VORDEFINITONEN FUER Y-BEFEHL
	LXI	D,YDAT0		;
	LXI	B,FITABL	;
	LDIR			;
;***
				;GEBE DIE INITIALISIERUNGSSTRINGS AUS
	LDA	IO$JUMPERBYTE	;SETZE HL AUF ERSTEN ZEIGER
	ANI	00000011B	;(ABHAENGIG VOM KONSOLENKANAL).
	MOV	L,A		;
	MVI	H,16		;
	MULT	H		;
	LXI	D,S$INIT$TAB	;
	DAD	D		;
	LDA	S$INIT$BYTE	;
INIT29:	ORA	A		;KEIN INITIALISIERUNGSSTRING ZU SENDEN
	JRZ	INIT30		;DANN WEITER.
	ADD	A		;SONST SCHIEBE OBERSTES BIT IN CARRY.
	PUSH	PSW		;
	PUSH	H		;
	CC	INIT31		;
	POP	H		;
	INX	H		;
	INX	H		;
	POP	PSW		;
	JR	INIT29		;
				;
				;SENDE INITIALISERUNGSSTRING ZUM
				;KONSOLENKANAL. HL ZEIGT AUF ZEIGER
				;ZUM INITIALISERUNGSSTRING.
				;WENN ZEIGER GLEICH FFFFH, DANN
				;SOFORT RETURN.
				;
INIT31:	MOV	E,M		;TESTE OB (HL)=FFFFH
	INX	H		;
	MOV	D,M		;
	INX	D		;
	MOV	A,E		;
	ORA	D		;
	RZ			;RETURN WENN GLEICH FFFFH
	DCX	D		;
	XCHG			;HL ZEIGT AUF INITSTRING
	DCX	H		;
INIT32:	INX	H		;ERHOEHE HL BIS DOLLAR-ZEICHEN
	MOV	A,M		;KOMMT
	CPI	'$'		;
	JRNZ	INIT32		;
	INX	H		;HL ZEIGT AUF LAENGE DES EIGENTLICHEN
	MOV	B,M		;INITIALISIERUNGSSTRINGS.
INIT33:	INX	H		;GEBE EIGENLICHEN INITIALISIERUNGSTRING
	MOV	C,M		;AUF KONSOLENKANAL AUS
	CALL	CO		;
	DJNZ	INIT33		;
	RET			;
	
				;
INIT30:
;***
				;GEBE KOPFTEXT AUS
	MVI	C,CLRSCREEN	;GEBE ZEICHEN FUER BILDSCHIRM LOESCHEN AUS
	CALL	ECHO		;
	CALL	STRICH		;
	CALL	STRICHEIN	;
	LXI	H,INITXT0	;
	CALL	SOUT		;
	CALL	STRICHAUS	;
	LXI	H,INITXTK	;
	CALL	BSOUT		;
	LDA	VERSIONNR	;GEBE VERSIONS NUMMER AUS
	RLC			;ERSTE ZIFFER
	RLC			;
	RLC			;
	RLC			;
	ANI	0FH		;
	ADI	30H		;
	MOV	C,A		;
	CALL	ECHO		;
	MVI	C,'.'		;GEBE PUNKT AUS
	CALL	ECHO		;
	LDA	VERSIONNR	;ZWEITE ZIFFER
	ANI	0FH		;
	ADI	30H		;
	MOV	C,A		;
	CALL	ECHO		;
	CALL	STRICH		;
	CALL	CROUT		;
				;
;***
;
				;GEBE UHRZEIT ODER
	CALL	SPEEDCON	;ECHTZEITUHR FEHLER AUS
	LXI	H,INITXT1	;
	CPI	0FFH		;
	PUSH	PSW		;
	CZ	CBSOUT		;
	POP	PSW		;
	JRZ	INIT57		;
	CALL	DISP$TIME	;
INIT57:				;
	LXI	H,INITXT6	;
	CALL	CBSOUT		;
	CALL	SPEEDCON	;GEBE TAKTFREQUENZ ODER
	LXI	H,INITXTE	;FEHLER AUS
	ANI	0F0H		;
	JRNZ	INIT11		;
	CALL	SPEEDCON	;
	MOV	L,A		;
	MVI	H,0		;
	LXI	D,SPEEDTAB2	;
	DAD	H		;
	DAD	H		;
	DAD	H		;
	DAD	D		;
	CALL	SOUT		;
	LXI	H,INITXT7	;
INIT11:	CALL	SOUT		;

;***
	LXI	H,INITXT2	;AUSGABE OB BACKUP DATEN OK SIND
	CALL	CBSOUT		;
	POP	PSW		;
	LXI	H,INITXTD	;
	JRZ	INIT56		;
	LXI	H,INITXTE	;
INIT56:	CALL	SOUT		;
;***
				;GEBE RAMGROESSE AUS
	LXI	H,INITXTA	;BEI PROF 181 IMMER 1024 K BYTE 	
	CALL	CBSOUT		;
				;
				;
INIT28:				;
	CALL	INIFDC		;TEST UND SOFTRESET DES FLOPPYCONTROLLERS
	CALL	DITEST		;TEST DER DISI
				;
	LXI	H,INITXT5	;GEBE FLOPPY-CONTROLLER TEST AUS
	CALL	CBSOUT		;
	LDA	DISKFLG		;GEBE OK ODER FAILED AUS
	ORA	A		;
	LXI	H,INITXTE	;
	JRZ	INIT5		;
	LXI	H,INITXTD	;
INIT5:	CALL	SOUT		;
				;
	LXI	H,INITXTB	;GEBE DISI TEST AUS
	CALL	CBSOUT		;
	LDA	DIFLAG		;GEBE OK ODER FAILED AUS
	ORA	A		;
	LXI	H,INITXTE	;
	JRZ	INIT51		;
	LXI	H,INITXTD	;
INIT51:	CALL	SOUT		;
				;
	LXI	H,INITXTC	;GEBE EPROM BOOT PATCH AUS
	CALL	CBSOUT		;
	LHLD	BOOT$DIR	;
	MOV	A,H		;
	ORA	L		;
	LXI	H,INITXTG	;
	CZ	SOUT		;
	LXI	H,INITXTF	;
	CALL	SOUT		;
				;
	LXI	H,INITXT4	;GEBE DEFAULT BOOT DEVICE AN
	CALL	CBSOUT		;
	LDA	LOG$DRIVE	;
	ANI	00110000B	;
	LXI	H,INITXTH	;
	JRZ	INIT58		;
	LXI	H,INITXTI	;
	CPI	00100000B	;
	JRZ	INIT58		;
	LXI	H,INITXTJ	;
	CPI	00010000B	;
	JRNZ	INIT59		;
INIT58:				;GEBE BEI FLOPPY BOOT DIE
	CALL	SOUT		;LAUFWERKS NUMMER AN
	LDA	LOG$DRIVE	;
	MOV	C,A		;
	ANI	00110000B	;
	JRNZ	INIT59		;
	MOV	A,C		;
	ANI	00000011B	;
	ADI	30H		;
	MOV	C,A		;
	CALL	ECHO		;
	
INIT59:
				;
	CALL	CROUT		;EINE LEERZEILE
	CALL	STRICH		;
				;
	LDA	LOG$DRIVE	;IST BOOT VON DEFAULT BOOT DEVICE MOEGLICH
	ANI	00110000B	;
	JRZ	INIT52		;
	CPI	00010000B	;
	JRZ	INIT53		;
	CPI	00100000B	;
	JRZ	INIT54		;
	JMP	START		;DEFAULT BOOT DEVICE IST NICHT RICHTIG DEFINIERT
INIT52:	LDA	DISKFLG		;
	ORA	A		;
	JZ	START		;
	JR	INIT55		;
INIT53:	LHLD	BOOT$DIR	;
	MOV	A,H		;
	ORA	L		;
	JZ	START		;
	JR	INIT55		;
INIT54:	LDA	DIFLAG		;
	ORA	A		;
	JZ	START		;	
INIT55:				;
	LDA	SERBAUD0	;LESE MODUS BITS SER0
	CPI	46H		;BEI 300 BAUD VON PROF181-V24A
	JZ	BCMD1		;AUTOBOOT VON DEF-BOOT-DEVICE
	LXI	H,INITXT3	;
	CALL	CBSOUT		;
				;
INIT60:	CALL	GETCH1		;MONITOR ODER BOOT ?
	CPI	20H		;BOOT?
	JZ	INIT61		;
	CPI	0DH		;MONITOR?
	JZ	INIT62		;
	JMP	INIT60		;NOCHMAL!
INIT61:	CALL	CROUT		;GEBE AUF JEDEN FALL CR LF AUS
	JMP	BCMD1		;BOOT!
INIT62:	CALL	CROUT		;GEBE AUF JEDEN FALL CR LF AUS
	JMP	START		;MONITOR!
;***
;
CBSOUT:				;WIE SOUT, SENDET JEDOCH VOR DEM STRING
				;EIN CARIAGE RETURN AUS. DAS ERSTE BYTE
				;DES STRINGS GIBT DIE ANZAHL DER BLANKS
				;AN, DIE EBENFALLS VOR DEM STRING GESENDET
				;WERDEN. BSOUT SENDET NUR BLANKS VORHER.
	CALL	CROUT		;
BSOUT:	MOV	A,M		;GEBE BLANKS AUS
	INX	H		;
	ORA	A		;
	JZ	SOUT		;
	MOV	B,A		;
BSOUT1:	MVI	C,' '		;
	CALL	ECHO		;
	DJNZ	BSOUT1		;
	JMP	SOUT		;

STRICH:				; GEBE 61 ZEICHEN STRICH AUS
	CALL	CROUT		;
	MVI	B,71		;
STRICH1:			;
	CALL	STRICHEIN	;
	LDA	IO$JUMPERBYTE	;
	ORA	A		;
	MVI	C,'K'		;
	JRZ	STRICH2		;
	MVI	C,'='		;
STRICH2:
	CALL	ECHO		;
	DJNZ	STRICH2		;
	CALL	STRICHAUS	;
	RET			;

STRICHEIN:			;SCHALTE STRICHGRAFIK EIN WENN
				;GRIP KONSOLE IST
	LDA	IO$JUMPERBYTE	;
	ORA	A		;
	RNZ			;RETURN WENN NEIN
	MVI	C,27		;
	CALL	CO		;
	MVI	C,'$'		;
	JMP	CO		;

STRICHAUS:
	LDA	IO$JUMPERBYTE	;
	ORA	A		;
	RNZ			;
	MVI	C,27		;
	CALL	CO		;
	MVI	C,'%'		;
	JMP	CO		;


	
;***
;
INIT20:				;FALLS EIN RAMFEHLER ENDECKT WURDE
				;WIRD DIESE BLINKSCHLEIFE ANGESPRUNGEN.
				;
	LDA	0F000H		;LADE BYTE VON RAMBANK 1
	STA	0F000H		;SCHREIBE BYTE IN RAMBANK 1
	STA	04000H		;SCHREIBE BYTE IN RAMBANK 0
	MOV	A,H		;BIT VON HL GIBT AN OB LED AN ODER AUS
	RLC			;
	ANI	01H		;
	ORI	PAD$CE		;
	OUT	P$LS259		;LASSE LED BLINKEN
	INX	H		;
	JR	INIT20		;
;
;***
				;
SPEEDCON:			;WANDLE SPEED ZAHL UM
	PUSH	H		;
	PUSH	D		;
	LDA	SPEED		;
	LXI	D,SPEEDTAB	;
	MVI	H,0		;
	MOV	L,A		;
	DAD	D		;
	MOV	A,M		;
	POP	D		;
	POP	H		;
	RET			;
				;
SPEEDTAB:
	DB	0FFH,0FEH,0FEH,000H
	DB	001H,0FEH,002H,0FEH
	DB	003H,0FEH,0FEH,0FEH
	DB	004H,0FEH,0FEH,0FEH
	DB	005H
;
;***
;
FITAB:			;VORDEFINITIONEN FUER Y-BEFEHL
			;
	DB	000H	;LAUFWERK
	DB	000H	;MINI/MAXI
	DB	000H	;SD/DD
	DB	000H	;SS/DS
	DB	002H	;SEKTORGROESSE
	DB	001H	;ERSTER SEKTOR
	DB	00AH	;LETZTER SEKTOR
	DB	050H	;ANZAHL DER SPUREN
	DB	01BH	;GAP
	DB	0E5H	;FILL BYTE
	DB	000H	;FORMAT PRECOMPENSATION
	DB	0FFH	;FORMAT PRECOMPENSATIONS BEGIN SPUR
FITABL	EQU	$-FITAB	;
;
;***
;
SPEEDTAB2:
	DB	'4.608 $$'
	DB	'6.144 $$'
	DB	'9.216 $$'
	DB	'12.288 $'
	DB	'18.432 $'
	DB	'24.576 $'
;
;***
				;VOREINSTELLUNG DER SYSTEMPAGE
DEFTAB:				;
	DW	002D0H		;DISKTIMING LAUFWERK A
	DW	002D0H		;DISKTIMING LAUFWERK B
	DW	002D0H		;DISKTIMING LAUFWERK C
	DW	002D0H		;DISKTIMING LAUFWERK D
				;
	DB	030H		;READY BYTE
	DB	000H		;TE TIME
	DB	000H		;STEP WAIT TIME
	DB	0F0H		;SEEKNR
	DB	040H		;FORMAT$SER0
	DB	04EH		;FORMAT$SER1
	DB	00CH		;LOG$DRIVE
	DB	000H		;SWITCH$DELAY
	DB	000H		;S$INIT$BYTE
				;
	DB	0,0		;NOCH FREI VON BACKUP BYTES
	DB	0,0,0,0		;VIER USER BACKUP BYTES
				;
	DB	000H		;HIER KOMMT PRUEFSUMME REIN
				;
	DB	000H		;CMDTAB
	DB	000H		;UNIT
	DB	001H		;TRACK
	DB	000H		;HEAD
	DB	001H		;SECTOR
	DB	000H		;SECTOR SIZE
	DB	01AH		;EOT
	DB	007H		;GAPL
	DB	080H		;DTLL
				;
	DB	0,0,0,0,0,0,0	;REST
				;
	DW	00000H		;DISPADR
	JMP	GETCM		;UMLEIT GETCM
	DB	000H		;DERMSG
	DB	00AH		;RWRETRY
	DB	000H		;WRITE PRECOM
	DB	0FFH		;ALT$UNIT
	DB	0FFH		;ALT$TRACK
				;
	DB	000H		;IO$JUMPERBYTE
	DB	000H		;BAUD$JUMPERBYTE
	DB	000H		;RWCMD
	DW	00000H		;ERMSG
	DB	000H		;DISK$FLAG
	DB	0,0,0,0,0,0,0,0	;TIME$FIELD
	DB	000H		;TEST$MSEK
	DB	000H		;TESTL$SEK
				;
	DB	001H		;TEST TRACK
				;
	DB	000H		;DMABANK
	DW	00000H		;DMAADR
	DB	000H		;SECTCNT
	DB	0FFH		;LAST$FDC$SPEED
	DB	000H		;MON$VERS WIRD VON INIT GESETZT
	DB	000H		;TEMP
	DB	000H		;COMMON$PAGE
	DB	000H		;CURRENT$BANK
	DB	000H		;EPROMZ

TAB$TYPELIST:			;
	DW	00000H		;TYPELIST
	DB	000H		;SPEED
	DB	000H		;TEMP$LOG$DRIVE
	DB	000H		;SERBAUD0
	DB	000H		;SERBAUD1
	DW	00000H		;DTYL
	DB	0FFH		;PRECOM$BEGIN
				;
	DB	0FFH		;RAMCHIPS 512K UND MEHR
	DB	0		;NOCH FREI
				;
	DW	0,0,0,0		;NOCH FREI
	DW	0,0,0,0,0,0,0,0	;
	DW	0,0,0,0,0,0,0,0	;
				;
	DW	0,0,0,0,0,0,0,0	;FREIHALTEN FUER
	DW	0,0,0,0,0,0,0,0	;INTERRUPT VEKTOREN
	DW	0,0,0,0,0,0,0,0	;
	DW	0,0,0,0,0,0,0,0	;
	DW	0,0,0,0,0,0,0,0	;
	DW	0,0,0,0,0,0,0,0	;
	DW	0,0,0,0,0,0,0,0	;
	DW	0,0,0,0,0,0,0,0	;
				;
DEFTAL	EQU	$-DEFTAB	;LAENGE DER TABELLE
				;
				;
				;
S$INIT$TAB:			;ZEIGER TABELL AUF
				;INITIALISERUNGSSTRINGS.
				;
	DW	GRIPINIT1	;TABELLE FUER GRIP-KANAL
	DW	GRIPINIT2	;
	DW	GRIPINIT3	;
	DW	GRIPINIT4	;
	DW	GRIPINIT5	;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
				;
	DW	0FFFFH		;TABELLE FUER HAUPT-V24-KANAL
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
				;
	DW	0FFFFH		;TABELLE FUER RESERVE-KANAL
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
				;
	DW	0FFFFH		;TABELLE FUER USER-KANAL
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
				;
				;HIER BEREITS VORDEFINIERTE STRINGS
				;EINTRAGEN, NEUE STRINGS ANS EPROM
				;ENDE PATCHEN.

GRIPINIT1:
	DB	1,'spooler on.......: $'
	DB	4,1BH,1BH,'50'

GRIPINIT2:
	DB	1,'status line off..: $'
	DB	4,1BH,1BH,'S0'

GRIPINIT3:
	DB	1,'max. screen 8*8..: $'
	DB	5,1BH,1BH,'8',32+20H,95+20H

GRIPINIT4:
	DB	1,'max. screen 8*10.: $'
	DB	9,1BH,1BH,'6:',1BH,1BH,'8',25+20H,95+20H

GRIPINIT5:
	DB	1,'non ASCII........: $'
	DB	4,1BH,1BH,'72'

				;
				;
SPEED$BAUD$TAB:			;DIESE TABELLE ENTHAELT 6 TABELLEN
				;ZUR EINSTELLUNG DER BAUDRATE BEI
				;6 VERSCHIEDENEN TAKTFREQUENZEN.
				;DIE INIT-ROUTINE KOPIERT DIE RICHTIGE
				;TABELLE NACH BAUD$TAB.
				;
PS0	EQU	00000000B	;
PS1	EQU	00100000B	;
DR0	EQU	00000000B	;
DR1	EQU	00001000B	;
TL1	EQU	00000000B	;
TL2	EQU	00000001B	;
TL4	EQU	00000010B	;
TL8	EQU	00000011B	;
TL16	EQU	00000100B	;
TL32	EQU	00000101B	;
TL64	EQU	00000110B	;
				;
	DB	0		;TABELLENANFAG 4,608 MHZ, DUMMY BYTE
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL32	;
	DB	PS0+DR1+TL64	;
	DB	PS0+DR1+TL64	;
	DB	PS1+DR1+TL16	;
	DB	PS1+DR1+TL8	;
	DB	PS1+DR1+TL4	;
	DB	PS1+DR1+TL2	;
	DB	PS0+DR0+TL16	;
	DB	PS1+DR1+TL1	;
	DB	PS0+DR0+TL8	;
	DB	PS1+DR0+TL2	;
	DB	PS0+DR0+TL4	;
	DB	PS1+DR0+TL1	;
	DB	PS1+DR0+TL1	;
				;
	DB	0		;TABELLENANFANG 6,144 MHZ, DUMMY BYTE
	DB	PS1+DR1+TL64	;
	DB	PS0+DR0+TL1	;
	DB	PS1+DR1+TL32	;
	DB	PS0+DR1+TL64	;
	DB	PS0+DR1+TL64	;
	DB	PS0+DR1+TL32	;
	DB	PS0+DR1+TL16	;
	DB	PS0+DR1+TL8	;
	DB	PS1+DR1+TL2	;
	DB	PS0+DR1+TL4	;
	DB	PS1+DR1+TL1	;
	DB	PS0+DR1+TL2	;
	DB	PS1+DR0+TL2	;
	DB	PS0+DR1+TL1	;
	DB	PS0+DR0+TL2	;
				;
	DB	0		;TABELLENANFANG 9,216 MHZ, DUMMY BYTE
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL32	;
	DB	PS1+DR1+TL32	;
	DB	PS1+DR1+TL32	;
	DB	PS1+DR1+TL16	;
	DB	PS1+DR1+TL8	;
	DB	PS1+DR1+TL4	;
	DB	PS0+DR1+TL8	;
	DB	PS1+DR1+TL2	;
	DB	PS0+DR1+TL4	;
	DB	PS1+DR1+TL1	;
	DB	PS0+DR1+TL2	;
	DB	PS1+DR0+TL2	;
	DB	PS1+DR0+TL1	;
				;
	DB	0		;TABELLENANFANG 12,288 MHZ, DUMMY BYTE
	DB	PS0+DR0+TL2	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS0+DR1+TL64	;
	DB	PS0+DR1+TL32	;
	DB	PS0+DR1+TL16	;
	DB	PS1+DR0+TL16	;
	DB	PS0+DR1+TL8	;
	DB	PS1+DR0+TL8	;
	DB	PS0+DR1+TL4	;
	DB	PS1+DR0+TL4	;
	DB	PS0+DR1+TL2	;
	DB	PS0+DR1+TL1	;
				;
	DB	0		;TABELLENANFANG 18,432 MHZ, DUMMY BYTE
	DB	PS1+DR0+TL1	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL32	;
	DB	PS1+DR1+TL16	;
	DB	PS1+DR1+TL8	;
	DB	PS0+DR1+TL16	;
	DB	PS1+DR1+TL4	;
	DB	PS0+DR1+TL8	;
	DB	PS1+DR1+TL2	;
	DB	PS0+DR1+TL4	;
	DB	PS1+DR1+TL1	;
	DB	PS1+DR0+TL2	;
				;
	DB	0		;TABELLENANFANG 24,576 MHZ, DUMMY BYTE
	DB	PS0+DR0+TL4	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL64	;
	DB	PS1+DR1+TL32	;
	DB	PS0+DR1+TL64	;
	DB	PS0+DR1+TL32	;
	DB	PS1+DR0+TL32	;
	DB	PS0+DR1+TL16	;
	DB	PS1+DR0+TL16	;
	DB	PS0+DR1+TL8	;
	DB	PS1+DR0+TL8	;
	DB	PS0+DR1+TL4	;
	DB	PS0+DR1+TL2	;
				;
;***
				;
INITXT0:
	DB	0DH,0AH,' TTTT  TTTT   TTT  TTTT     TT  TTT   TT T   T'
	DB	0DH,0AH,' T   T T   T T   T T       TTT T   T TTT T   T'
	DB	0DH,0AH,' T   T T   T T   T T         T T   T   T  T T'
	DB	0DH,0AH,' TTTT  TTTT  T   T TTT  TTT  T  TTT    T   T'
	DB	0DH,0AH,' T     T T   T   T T         T T   T   T  T T'
	DB	0DH,0AH,' T     T  T  T   T T         T T   T   T T   T'
	DB	0DH,0AH,' T     T   T  TTT  T         T  TTT    T T   T'
	DB	24H

INITXTK	DB	4,'Monitor Version $'

INITXT1	DB	19,'real time clock : failed$'
INITXT2	DB	16,'system data backup : $'
INITXT3	DB	4,'press the <RETURN> key for Monitor or '
	DB	'the <SPACE> key for boot => $'
INITXT4	DB	15,'default boot device : $'
INITXT5	DB	17,'floppy controller : $'
INITXTB	DB	25,'DISI test : $'
INITXTC DB	24,'EPROM boot : $'
INITXTD	DB	'ok$'
INITXTE	DB	'failed$'
INITXTF	DB	'patched$'
INITXTG	DB	'not $'
INITXT6	DB	22,'system speed : $'
INITXT7	DB	'MHz$'
INITXTA	DB	19,'memory on board : 1024K byte',0DH,0AH,'$'
INITXTH	DB	'floppy drive $'
INITXTI	DB	'DISI$'
INITXTJ	DB	'EPROM$'
;
;----------------------------------------------------ENDE INITIALISIERUNG----
;
;
;
;
;
SGNON: 
	DB	0DH,0AH
	DB	'Monitor'
	DB	'$'
;
;
;
CMDMSG:		;NACH EINGABE EINES ZEICHENS WIRD TEXT AUSGEGEBEN
		;
	DB	'Address for read (write) from (to) drive $'
	DB	'Boot CP/M $'
	DB	'Check drive $'
	DB	'Display memory $'
	DB	'EPROM test$'
	DB	'Fill memory $'
	DB	'Go to $'
	DB	'Help$'
	DB	'Keyboard mode$'
	DB	'In port $'
	DB	'List time$'
	DB	'Move memory $'
	DB	'New date and time set$'
	DB	'Out port $'
	DB	'Read from drive $'
	DB	'Substitute memory $'
	DB	'Test memory $'
	DB	'User set up$'
	DB	'Verify memory $'
	DB	'Write to drive $'
	DB	'X Register $'
	DB	'Y format disk$'
	DB	0		;ENDE DER COMMAND TEXTE
;
CADR: 
	DW	0
	DW	YCMD
	DW	UCMD
	DW	KCMD
	DW	LCMD
	DW	HCMD
	DW	GCMD
	DW	WCMD
	DW	ACMD
	DW	RCMD
	DW	OCMD
	DW	CCMD
	DW	TCMD
	DW	VCMD
	DW	FCMD
        DW      BCMD
	DW	XCMD
	DW	SCMD
	DW	MCMD
	DW	ICMD
	DW	ECMD
	DW	DCMD
	DW	NCMD
;
;
;
CTAB: 
	DB	'N'
	DB	'D'
        DB      'E'
        DB      'I'
        DB      'M'
        DB      'S'
        DB      'X'
        DB      'B'
	DB	'F'
	DB	'V'
	DB	'T'
	DB	'C'
	DB	'O'
	DB	'R'
	DB	'A'
	DB	'W'
	DB	'G'
	DB	'H'
	DB	'L'
	DB	'K'
	DB	'U'
	DB	'Y'
NCMDS	EQU	$-CTAB
;
;
;
RTAB: 
	DB	'A'
	DB	ASAVE AND 0FFH
        DB      0
        DB      'B'
        DB      BSAVE AND 0FFH
        DB      0
        DB      'C'
        DB      CSAVE AND 0FFH
        DB      0
        DB      'D'
        DB      DSAVE AND 0FFH
        DB      0
        DB      'E'
        DB      ESAVE AND 0FFH
        DB      0
        DB      'F'
        DB      FSAVE AND 0FFH
        DB      0
        DB      'H'
        DB      HSAVE AND 0FFH
        DB      0
        DB      'L'
        DB      LSAVE AND 0FFH
        DB      0
        DB      'M'
        DB      HSAVE AND 0FFH
        DB      1
        DB      'P'
        DB      PSAVE+1 AND 0FFH
        DB      1
        DB      'S'
        DB      SSAVE+1 AND 0FFH
        DB      1
	DB	'a'
	DB	AASAVE AND 0FFH
	DB	0
	DB	'b'
	DB	BBSAVE AND 0FFH
	DB	0
	DB	'c'
	DB	CCSAVE AND 0FFH
	DB	0
	DB	'd'
	DB	DDSAVE AND 0FFH
	DB	0
	DB	'e'
	DB	EESAVE AND 0FFH
	DB	0
	DB	'f'
	DB	FFSAVE AND 0FFH
	DB	0
	DB	'h'
	DB	HHSAVE AND 0FFH
	DB	0
	DB	'l'
	DB	LLSAVE AND 0FFH
	DB	0
	DB	'm'
	DB	HHSAVE AND 0FFH
	DB	1
	DB	'X'
	DB	XSAVE+1 AND 0FFH
	DB	1
	DB	'Y'
	DB	YSAVE+1 AND 0FFH
	DB	1
	DB	'I'
	DB	ISAVE AND 0FFH
	DB	0
	DB	'R'
	DB	RSAVE AND 0FFH
	DB	0
	DB	0,0	;ENDE KENNUNG DER TABELLE
;
;
;
LASTADD	EQU	$-1	;LETZTE BENUTZTE ADRESSE IM EPROM
;
;
;
;************************************* BEGINN DES RAM-BEREICHES ******
;
;
;
		ORG	SYSPAGE-1024-256
		;
BOOTADR		EQU	$	;HIERHER WIRD BOOTSEKTOR 
		DS	512	;VON DER FLOPPY GELADEN
DIBOOTADR	EQU	$	;HIERHER WIRD BOOTSEKTOR
				;DER DISI GELADEN
				;
		DS	512	;PLATZ FUER BOOTSEKTOR
				;
		DS	256-68	;PLATZ FUER STACK
				;
REGS:		EQU	$
MSTAK:		EQU	$
		;
		; REGISTER INHALTE
		;
RSAVE:		DS	1
ISAVE:		DS	1
LLSAVE		DS	1
HHSAVE		DS	1
EESAVE		DS	1
DDSAVE		DS	1
CCSAVE		DS	1
BBSAVE		DS	1
FFSAVE		DS	1
AASAVE		DS	1
YSAVE:		DS	2
XSAVE:		DS	2
ESAVE:		DS	1
DSAVE:  	DS	1
CSAVE:  	DS	1
BSAVE:  	DS	1
FSAVE:  	DS	1
ASAVE:  	DS	1
LSAVE:  	DS	1
HSAVE:  	DS	1
PSAVE:  	DS      2
SSAVE:  	DS      2
				;
				;
PCFBUF:				; BUFFER FUER UHR-DATEN AUS PCF8583
PCFCON		DS	1	; CONTROL /STATUS
PCFHUN		DS	1	; HUNDERSTELSEKUNDEN
PCFSEC		DS	1	; SEKUNDEN
PCFMIN		DS	1	; MINUTEN
PCFHRS		DS	1	; STUNDEN
PCFDAY		DS	1	; TAG
PCFMON		DS	1	; MONAT
PCFTIM		DS	1	; TIMER
ALRCON		DS	1	; ALARM CONTROL 
ALRHUN		DS	1	; ALARM HUNDERSTELSEKUNDEN
ALRSEC		DS	1	; ALARM SEKUNDEN
ALRMIN		DS	1	; ALARM MINUTEN
ALRHRS		DS	1	; ALARM STUNDEN
ALRDAY		DS	1	; ALARM TAG
ALRMON		DS	1	; ALARM MONAT
ALRTIM		DS	1	; ALARM TIMER
				;		
				;
DIBYTE		DS	1	;ERSTES BYTE DER DISI
				;
   				;DATEN FUER FORMATIERPROGRAMM
				;DIE FOLGENDEN DATEN WERDEN VOM Y-BEFEHL
				;GESETZT.
YDAT0		DS	1	;LAUFWERK ZUM FORMATIEREN
YDAT1		DS	1	;MAXI FFH, MINI 00H
YDAT2		DS	1	;SD FFH, DD 00H
YDAT3		DS	1	;SS FFH, DS 00H
YDAT4		DS	1	;SECTORGROESSE 0,1,2,3
YDAT5		DS	1	;ERSTER SEKTOR
YDAT6		DS	1	;LETZTER SEKTOR
YDAT7		DS	1	;ANZAHL DER SPUREN
YDAT8		DS	1	;FORMAT GAP
				;
FILLBYTE	DS	1	;DIESES BYTE WIRD BEIM FORMATIEREN
				;IN DIE SEKTOREN GESCHRIEBEN
				;
FORMAT$PRECOM	DS	1	;PRECOMPENSATION WAEHREND FORMATIEREN
				;
FPRECOM$BEGIN	DS	1	;BEGIN SPUR DER FORMAT PRECOMPENSATION
				;
FORMTAB		DS	4	;HIER STEHEN DIE VIER BYTES DIE
				;BEIM FORMATIEREN UEBERTRAGEN WERDEN
				;
CMDRET		DS	9	;SAVE BEREICH FUER CMDTAB WAEHREND
				;DES FORMATIERENS
		END
