

;**************************************************
; DRIVE 9 Layout  NCR F3 format 2x40 Tracks reverse
;**************************************************

sect9		equ	512	; sector Size
mxsc9		equ	8	; sectors per track
mxtr9		equ	40	; tracks per surface
side9		equ	2	; number of surfaces
xtrk9		equ	mxtr9*side9
blk9		equ	1024*2	; number of 1024k Blocksizes
dir9		equ	128	; number of directory entries
skew9		equ	1	; skew faktor
off9		equ	3	; offset for system tracks

Xdpb9:	db	2		; NUM
	db	mxsc9
	db	2Ah		; Gap 3
	db	-1		; DTL
	dw	specb
	db	tymfm+ty5zoll+tyreverse; Type
	dw	xlt9
DPB9:	dpb	sect9,mxsc9,xtrk9,blk9,dir9,off9


;**********************************************
; DRIVE 10 Layout 8" MFM Format 14x512x2x80
;**********************************************

sect10		equ	512	; sector Size
mxsc10		equ	14	; sectors per track
mxtr10		equ	80	; tracks per surface
side10		equ	2	; number of surfaces
xtrk10		equ	mxtr10*side10
blk10		equ	1024*4	; number of 1024k Blocksizes
dir10		equ	128	; number of directory entries
skew10		equ	3	; skew faktor
off10		equ	4	; offset for system tracks

Xdpb10:	db	2		; NUM
	db	mxsc10
	db	25h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; type
	dw	xlt10
DPB10:	dpb	sect10,mxsc10,xtrk10,blk10,dir10,off10



;	dseg

  if banked
	
	dseg	; this part can be banked
  else

	cseg	; ungebanked	
  endif



           ;******* SECTOR TRANSLATE TABLES **********
           ;******************************************


xlt1:	db 	1,4,7,2,5,8,3,6,9	; Standard FD-55 F

xlt2:	skew	mxsc2,skew2,1		; 16x512x2x80

xlt3:	skew	mxsc3,skew3,1		; 5x1024x2x80

xlt4:	skew	mxsc4,skew4,1		; 9x1024x2x80

xlt5:	skew	mxsc5,skew5,1 		; Standard FD-55G/8" 512x15x2x77

xlt6:	db	1,4,7,10,3,6,9,2,5,8 	; Standard FD-55 B 10x512x2x40

xlt7:	skew	mxsc7,skew7,1		; Ecmac 70

xlt8:	skew	mxsc8,skew8,1		; FD-55G/8" std ibm 3740

xlt9:	skew	mxsc9,skew9,1		; NCR F3

xlt10: 	skew	mxsc10,skew10,1		; 14x512x2x80
	

	end


                                                                                                                                                                                                                                                                                               trk3		equ	mxtr3*side3
blk3		equ	1024*4	; number of 1024k Blocksizes
dir3		equ	128	; number of directory entries
off3		equ	4	; offset for system tracks
skew3		equ	1	; skew faktor
type3		equ	tymfm + ty5zoll

Xdpb3:	db	3		; NUM
	db	mxsc3
	db	25h		; Gap 3
	db	-1		; DTL
	dw	specf		; Specify Parameter
	db	type3		; type-byte
	dw	xlt3

DPB3:	dpb	sect3,mxsc3,xtrk3,blk3,dir3,off3


;**********************************************
; DRIVE 4 Layout  FD55-G 9x1024, 2x80
;**********************************************

sect4		equ	1024	; sector Size
mxsc4		equ	9	; sectors per track
mxtr4		equ	80	; tracks per surface
side4		equ	2	; number of surfaces
xtrk4		equ	mxtr4*side4
blk4		equ	1024*2	; number of 1024k Blocksizes
dir4		equ	256	; number of directory entries
skew4		equ	5	; skew faktor
off4		equ	4	; offset for system tracks

Xdpb4:	db	03		; NUM
	db	mxsc4
	db	07h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; Type
	dw	xlt4
DPB4:	dpb	sect4,mxsc4,xtrk4,blk4,dir4,off4


;**********************************************
; DRIVE 5 Layout  FD55-G 15x512, 2x77
;**********************************************

sect5		equ	512	; sector Size
mxsc5		equ	15	; sectors per track
mxtr5		equ	77	; tracks per surface
side5		equ	2	; number of surfaces
xtrk5		equ	mxtr5*side5
blk5		equ	1024*2	; number of 1024k Blocksizes
dir5		equ	128	; number of directory entries
skew5		equ	5	; skew faktor
off5		equ	4	; reserved tracks

Xdpb5:	db	2		; NUM: ld (sect/128)
	db	mxsc5
	db	1Bh		;0000 BANKED	0800 BLK1	1000 BLK10	0800 BLK2	1000 BLK3
0800 BLK4	0800 BLK5	0800 BLK6	0400 BLK7	0400 BLK8
0800 BLK9	0080 DIR1	0080 DIR10	0100 DIR2	0080 DIR3
0100 DIR4	0080 DIR5	0040 DIR6	0040 DIR7	0040 DIR8
0080 DIR9	00BF DPB1	01A9 DPB10	00D9 DPB2	00F3 DPB3
010D DPB4	0127 DPB5	0141 DPB6	015B DPB7	0175 DPB8
018F DPB9	00B4 DPBNR	000C DPHA	0031 DPHB	0056 DPHC
007B DPHD	0000 DPHR	0000 FALSE	0010 HLTB	0010 HLTF
0020 HLTG	00F0 HUTB	00F0 HUTF	00F0 HUTG	0009 LHDDPB
001A LXDPB	0025 LXDPH	0009 MXSC1	000E MXSC10	0010 MXSC2
0005 MXSC3	0009 MXSC4	000F MXSC5	000A MXSC6	0010 MXSC7
001A MXSC8	0008 MXSC9	0050 MXTR1	0050 MXTR10	0050 MXTR2
0050 MXTR3	0050 MXTR4	004D MXTR5	0028 MXTR6	0028 MXTR7
004D MXTR8	0028 MXTR9	0004 OFF1	0004 OFF10	0004 OFF2
0004 OFF3	0004 OFF4	0004 OFF5	0004 OFF6	0004 OFF7
0002 OFF8	0003 OFF9	00B5 REVTRK	0200 SECT1	0200 SECT10
0200 SECT2	0400 SECT3	0400 SECT4	0200 SECT5	0200 SECT6
0100 SECT7	0080 SECT8	0200 SECT9	0002 SIDE1	0002 SIDE10
0002 SIDE2	0002 SIDE3	0002 SIDE4	0002 SIDE5	0002 SIDE6
0001 SIDE7	0001 SIDE8	0002 SIDE9	0003 SKEW10	0003 SKEW2
0001 SKEW3	0005 SKEW4	0005 SKEW5	0001 SKEW7	0006 SKEW8
0001 SKEW9	10DF SPECB	10EF SPECF	20DF SPECG	0003 SRTB
0002 SRTF	0003 SRTG	FFFF TRUE	0002 TY5ZOLL	0001 TYFM
0000 TYMFM	0002 TYPE1	0002 TYPE3	0004 TYREVERSE	0020 TYSINGLE
0040 TYSKIP	00B6 XDPB1	01A0 XDPB10	00D0 XDPB2	00EA XDPB3
0104 XDPB4	011E XDPB5	0138 XDPB6	0152 XDPB7	016C XDPB8
0186 XDPB9	0000 XDPHA	0025 XDPHB	004A XDPHC	006F XDPHD
01BA XLT1	022C XLT10	01C3 XLT2	01D3 XLT3	01D8 XLT4
01E1 XLT5	01F0 XLT6	01FA XLT7	020A XLT8	0224 XLT9
00A0 XTRK1	00A0 XTRK10	00A0 XTRK2	00A0 XTRK3	00A0 XTRK4
009A XTRK5	0050 XTRK6	0028 XTRK7	004D XTRK8	0050 XTRK9
0094 @DTBL
es  can  reference  modules  in library
  files.   LINK  searches  the  library  files  and  includes   the
  referenced    modules   in  the  output  file.  See  the  CP/M  3
  Programmer's Utilities Guide for a complete description of  LINK-
  80.

ӑ ddEu$HIFDLOGIUSSTdU4!MQ@SEKDSR`d4TE(M-6@SEKBNJMA@%         ;JyCY^2"  t  ۢ-pf+u7NXL ;W2;ts'd@	e &[wYo0B[ [:q!2ӻ^2 [ 2ӻћ U-(`&?ZPY|fQCح[ 3OfP0uA{7tr2݅  {0`@"L4: uAÀ	݂ai`_ %`C@ @X4xX7AP!  .7S hpe yhpan @ DJ [J@@A` X+XtuA"@wiH2~s0 vYL sd#3A7@ @`6n hpa9:Ѐ̲{
X@       xf@֊dZ(C@ v@ #?-`7A=h  :?FP       "_3,3@ !2   !  A*eX
^2 BK FP .:` \ -e CKn@L(:@v E G 2 :@v  ZH h  :@nߎWX 
haGV`@?T  Z(ҀL2@̖nf0u@@=ET D ~+@g   4D~
o#   d "Y'%W/n
GZ(nha!* u@gFOV  D~ݕxT
CQe]0|AA" C#A@n_d3q( fP0 YPa~`2YY> XeAW:?	'w@+5pfpf  dw<3@ qFng fn0Vnf 7eaIxFVޮuD&K4  [`4  = 
Of 2GZPnf5٠b |{?,!r* ?  3wf6H3p  cI=
DyL@E9!  AECkt7Ѐl2NfQo9DCe
 , 4 
#I
 ai7A@	1.`lM	wX&@p] "y@C< a:DSr  )M o'C  '΂t0Q` @N7&CsL'#X  !C &NF` @i7@F4MA` @W9ql  !M`  

FS G gb{7$@&ni0eD9maF#;Yiexa!  7L `#8 ;
 (r8=2
p 2 {fP< `P,>ZwY2`@A@111o;  	A۠  @xU-&   {~	NVjـY@{7mgI0Y#{nyfg3=,܈#'nNs0݊:	#{dGBg=x`@fn2 cT	d#;'&\
.y=Kπis4] 
.AKРpit@4$] FK  it4P]*
ȊI*  ȉ1P,Ɋi c
hhql
hjQ l
hhIр 
 F1   F1\ IQJI*ʪI*\JIih1 ~	hJ~i)ѡJ~ij*~|Ѥ0<H(H18    +SDM*!V*!VM"V͟:!V! Uw:,Q/Ҳ:V2V*V& U	
:T2T*T& !
 S!0 *V&  U	q*T& !
 S0 *V& !U	q:V2V *T& +S"!U$-U
RUW
!T6 #6 #6 :.Q2U:/Q2UTqT
TyT
Uͧ	pT	!T6Uͧ	pT	pT	:;Rһ!;R6 :%V2.Q:4Q/24QTT
TT
L!U6N!Vr+s+p+q*V6 *V#6 *V|O !	*V##
w*V|O !	 *V	w*V}O !	 *V	w*V}O !	 *V	w!T:TO `iPSW	 "V *V	:0Qw *V	:2Qw *V	:1Qw. *V	:3Qw*V	:4QwX *V	 
:+Q/ҼW *V	>*V	w:<R/:-Q/HW *V	>@*V	wW *V	>*V	w^ *V	:/Qw!)X"V*VN#F!W	"V*V"V*V͕S(!$V6-!$V6 *VSD*VWR!"&V!V6&VS!V6 >!Vڷ*V& )*&V> ͒Sʭ*V& )*&VWR"(V *(V	͕Sʭ!V6 :V<2Vf:-Q/!V!$V6!$V6 V>X
W*V"V*V~> >!Vs+p+q+p+q%N*VDMN 7*VDM$ 7*VME:,QҨ*V& U	*VDM
:V2V*V& U	DM*V:V2V*V& U	*V&  +S:V2V*V& U	)
:V2V!Vp+q*V"TͣN ,ͧ*VDM	!Vr+s+p+q*V^#V"T*V##^#V"T *V	^#V"T*V#DMT
	 *VDMT
 *TZSU͊S@?ͧ*T+ZS}<2V!V6 !V:V҆ *V& +SW	"TDMͧ	*VDM>	:V<2VS*TDMO
W*T"T!Vr+s+q:V GTqT
TyT
*Vn}2T*V#~2TpT	WTS} pS}TR+s#r*V& )+!Vs+6 :V!V4>T͇S+s#rBKͧ	pT^	:V<2VpT	*VT
:-Q/k)Tw
T
z!LT"V!U"V͙!T"V!U"V͙!(T"V!U"V͙*V#DMT
	 *VDMT
*VDMeͧWͧ	*VDM>	*V*Ws#r*V##*Ws#r *V                                                                                                                                                                                                                                                                   '"y27 !  ":2:=7 ! ~7 #* {2!  "z"9"1 !dy3\ K! n ҂b&&!R_ ^#V* 
!p		^#Vͦ:ü!"( COPR. '82 DRI 151282^dj+5(.7@U&%*gy&&%2GP+QB4    ``l!*^#V#^#Vw# ͒ ͒ ͒ ͒͙:sA<w#s .;!?	 	 ;!?͙s!  
! 	?+> 	ws 
X*]w#6?#]
	 .,:;[]=<>| !eʃ45#xa{ҏ_p#
 ʙ	ʙ:A2'!%"  !  9"1!>%:25:!=go    :O*7 * /*"*"[<:g:!,*}D!~6 	!S͌rO͠ͨbbb
	 :G:xͨ:ͨ:	!6 	:<!G:
>xw>ɯw%:7!>wɯ:=x:r:G:=Ľ9xr:y!4 5~y5
6 y͌Ҡ^I@O:=ʯ:Iy	I I:µ #I:! I
I
I!
O͠*}S~#!  ""Sz-*"##">2:2*N#G2H
W
W|:<ʈ:W:H2xy:<exH~+8¨x22J¸ůH:!-5þ-#2x#NzW:܏:J!2!5Jx4J#wO͏:K~xTHp!  "
Iy<ʃ<z<ʈ͛&͛S69MD:!:	2Ͱ2z>z<*"!z<~s^#V#N#FxN:o͠#    CP/M Error On  : $Disk I/O$Invalid Drive$Read/Only File$Read/Only Disk$File Exists$? in Filename$  ÍÍ>2a."z:2:<:^^d{_zW{_zW
)	4#4#4	#

w#J|^#V#"##"##"###"#"##"!
*!*|!6J6 7*w#w*w#w#w>2'q2*O͂yڍÍ<*
p:0!:®:Í2*i
" !s#r#p*N#F*^#V#F*:O}|y*Ͱ+*͹}|y	#*Ͱ*DM"*s#r*s#r#pyoxg[	DM*0MD" !*MD$:Oi
!N:
i	G>O:
ʀ	w	* ͂		:ʘ	n`	~#fob	2O ͊	"}:O*"2":O:G2!w* ~zWw+
	z	#~*! * * 
! 
~2~+
-O~2
>2	:2
:w:P
4~:w	r##rp#
b

|g}oj
*  #
G
|
	*ġ
:*w**=ҵ
*
>

)ý
:O! ͼ
*:Oi
}

Á	 ~
|*:o$* ~	6 	~w	w**{#z'r+s{ozg**|g=v
**ʄʏ
 >22ͦ
w*>ww:
*#*s#r*

:!:G~#<*#~!d!ͼʷ
!ͼ&!~6 ̀!  "2*N	q***}<6
 ^#Vͳ>F
D>!  "**[+"** K!z~<:w ##>w#w͂	×̈́>	!~#<!"ͪ**#"=ڝ:26:F:6y<_W`ii
DM*	~
w:͆
DM*T]	KKN
:@͆
*"N
"
 
:k
N q

N#Fyʀ
*}|
#X
*i
#6 ͆
DM*6 #x£
*w**s#rL*6#6 ͝*"ͤ͔
*|< >!
>
> 
>N
4
 ~*w::/GyO
A
+B
8y2:xOo& :W>Oi
E:5	N/*"y2>2Ís͝ͳL2  ͤ͔ *' 
:O ~Sy?x
-NG:<D2x#
22zG?S͝>Gx~:ʙ2##~[*$a*"	͋ʄ
*!~Ê͙l͋
6> -
Ͷ ͙ÇPY*{zBKyʢâ<
yº!  
>~Gw# *	#~$
+
*!>	#>?
#*~ 	w0"*y͐}0͋
Ͷ ͙^	2͋ :@ʕ
~#w>͙{> _++V
* -Os++r ! x>w~6 :6~#+w#w+ ~wɯ2z
	̈́ʹOFqy3	Np͆ ͯ:Z~MwS~¹o¹#¹
#
?	-Ϳw 		ʠʡڠ¡w
 ~w 2
>y&!"*>o+"1͗*!"s͙"
 r#~?w#>r#
=J̧
4   wͶ  	~Oʙ:z<>w##~2_4~?ʈ>x:<ʈʈ{ͥ
2	:w++~=w4-Oҫ5:<4{͊>2
:!3:z͞	Ͱ	@
R_@
!  ">@
:G:O:=27)yy/W!:#?>F6:_/G:^:_|OfKyp!VuWy/2&:ʌͺRg[	|OE	w	@~@w> 2
:>*
͊
:3:z͞	!>2 Ob	2  O͊	DM͠}>""2:2* 	::EsMO 		s#rͰ	:(±y==±*!^W*=2wXկw#|W|*"j*: "R:W>R:! jx!w4

͚͡̚@
*!! ~~#~O~#G~.|!  w:cʇ̈́w! x?w! ~ʽw-llqOý.:z<! Vq##~_@w͡:z<¸..r##s} ̴  ̭N ! ~态O> G~G! ~G~o> _yW#x#W{s+p+q	r#r#r͋S
 "͙> 2z4  !! q#p#w2wW*
_҆-!s:!f͐
*~wĦ
ɯ2* #~2~w!  "2=2*~2=22̀:*wͳ66 *L͝ ͪ!~+6 :0'"!~6 *>=)X!f_CÀ*}< ~*~ {ͧ> N
	Ä:G*` ~!x_<_*y
<:/G	~##~? 	@	F6 ##N6 ͆y2zp##q:!2! "R|:2ͥ:N>2<2͡|!w:>2*6 s͙ͤ|͔
~<w:ҧ*
 ~§2&@t
ͬ͖
:z<ô~?̀ 	~?ͥ*>o"6"!_ʍ:OsÙ*"8cͬ͌
ôͬ͌
íͥ͡͔`-}͔Pͬ yá>O2{&Ó8:*:"R̀**8q̀*"z::2ͬ͌
ͬ͌
ͬ(}/_|/*W}_*"}o|g">2{&&2{2|*͆
  D<8+}7*#}o|g:O*s#r#w!~w~@w6Hq*>=)ү_|:0ʠ
êͺ:<­Hq:>~c!o#~^#VG#~#~!##N#F#^#V#~#fo~o! o#~*ͥ &
 	&&
>͋͹d -
j
6Ͷ >͙F
b	-w
~<: ͯ~w#w#6 ##-
a
	*	 ͯ~?G++N<!45͂	O 	>p#|mͥZ
͆͂	 b
 ͧ b
!B6 N N!B!  z<*"!"z:{*:w :w**z}D                                                                                            #cdfg !"()         *:_2{2"+"~<j5ʖB~j6 *:!:i>̀~!:҈6>Ë<w6 :< != *´"* KK6:G/O* *=j_##: