	title	'Boot loader module for PROF-181 CP/M 3.0'

	; Letzte Aenderung am:
	; 03.10.1987 (Joachim)
	;  9.12.1986  JCL  Bootfile-Attribute eingebaut

	public	?init,?ldccp,?rlccp,binit
	extrn	?pmsg,ciecho,?conin,?cono,?const,?wboot
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn 	@cbnk,?bnksl,?pmsg,?bank,@ctbl
	extrn	monon,monoff,dmatrans,adrtab
	extrn	signon,scb$base

	maclib	pdef
;
	maclib	pvec
;
	maclib	hd64180
;
	maclib	psys
;
	maclib	modebaud
;
	maclib	pkonfig

bdos		equ 	5
def$fcb		equ	80h

tpa$bank	equ 	1

	dseg	; init done from banked memory


binit:
	lda	serbaud0		;setze die baudraten
	ani	0fh			;der beiden V-24 Schnittstellen
	sta	@ctbl+7			;wie im monitor definiert
	lda	serbaud1		;
	ani	0fh			;
	sta	@ctbl+7+8		;
	ret				;


?init:
	xra	a					; setze mmu
	out0	cbr,a					;
	out0	bbr,a					;
	sta 	epromz					;
	mvi	a,com$page and 0f0h			;
	out0	cbar,a					;

	lxi	h,0181h					; setze kennung
	shld	dispadr					; in dispadr

	mvi	a,12h					; setze biosversion
	sta	temp					; in temp
	
	if	loginmsg				; defaulteinstellung
	mvi	a,001h					; fuer anzeige des
	else						; formatnamens
	mvi	a,000h					;
	endif						;
	sta	login					;

	lxi h,xwboot ! shld umleit$getcm + 1		; setze umleit
	lxi h,xconst ! shld mcs + 1			; vektoren
	lxi h,xconin ! shld mci + 1			;
	lxi h,xcono ! shld mco + 1			;

	lda	io$jumperbyte		; waehle richtige Voreinstellung
	cpi	4 ! jrz io0		; der Geraetetreiber
	cpi	3 ! jrz io3		; in Abhaengigkeit des IO Jumpers
	cpi	2 ! jrz io2		;
	cpi	1 ! jrz io1		;

io0:	lxi h,00400h
	if griplist
	lxi d,00200h
	else
	lxi d,02000h
	endif
	lxi b,04000h ! jr ioset				      ; j4 kein jumper 
io1:	lxi h,08000h ! lxi d,02000h ! lxi b,04000h ! jr ioset ; j4/1-3
io2:	lxi h,01000h ! lxi d,02000h ! lxi b,04000h ! jr ioset ; j4/2-4
io3:	lxi h,00800h ! lxi d,02000h ! lxi b,04000h ! jr ioset ; j4/3-5

ioset:	shld @civec ! shld @covec
	sded @lovec
	sbcd @aivec
	sbcd @aovec

	lhld	boot$name	; wurde von EPROM Floppy gebootet?
	mov	a,h		;
	ora	l		;
	jrz	no$eboot	; Sprung wenn nein
	lxi	h,filedt	; wenn ja: kopiere per dma
	lxi	d,adrtab	; den Bereich 00100h bis 0efffh
	lxi	b,8		; nach 40000h bis 4efffh
	ldir			;
	call	dmatrans	;

no$eboot:
	call	signon		; Drucke Startmeldung, die Rotine befindet
	ret			; sich im Modul PS.ASM

filedt:	dw	100h
	db	0
	dw	100h
	db	4
	dw	0ef00h
	
			; diese Routinen werden von Monitor UP's benutzt

xwboot:
	mvi a,1 ! sta epromz
	call monoff ! jmp ?wboot

xconst:
	push b ! push d ! push h
	call ?const
	pop h ! pop d ! pop b ! ret

xconin:
	push b ! push d ! push h
	call ?conin
	pop h ! pop d ! pop b ! ret

xcono:
	push b ! push d ! push h
	call ?cono
	pop h ! pop d ! pop b ! ret

	cseg

	; Laden des CCP.COM oder ZCCP.COM (bei DISI) von default drive

?ldccp:
	mvi c,13 ! call bdos		; reset disk system

	; pruefe ob vom EPROM gebootet wurde, wenn ja kopiere
	; Dateien aus der TPA in die RAM-Floppy (ist dann default drive)

	lhld	boot$name		; lade den Zeiger auf die EPROM Dateien
	mov	a,h			; wenn Null, dann war weder EPROM-Boot
	ora	l			; noch DISI-Boot
	mvi	a,5			; setze Defaultlaufwerk auf F
	jrz	diboot			;
	inx	h			; Pruefe jetzt, ob EPROM- oder
	mov	a,h			; DISI-Boot
	ora	l			; boot$name = 0FFFFh ?
	mvi	a,0			; setze Defaultlaufwerk auf A
	jrz	diboot			; wenn von der DISI gebootet wurde
					;
	mvi	a,4			; Wenn EPROM-Boot dann Defaultlaufwerk E
diboot:	sta	scb$base+13h		; setze Akku als
	sta	scb$base+3eh		; Defaultlaufwerk
	jrz	ldccp1			; Boot von DISI, lade sofort CCP
					;
	dcx	h			; hl wieder auf EPROM-Dateiname richten
eprl:	lxi	d,def$fcb+1		; kopiere Namen in
	lxi	b,11			; default FCB
	ldir				;
	push	h			; rette hl
	xra	a			;
	sta	def$fcb+12		; ex := 0
	sta	def$fcb+32		; cr := 0
	lxi	d,def$fcb		;
	stax	d			; default drive
	mvi	c,22			; make file
	call	bdos			;

	LXI	H,DEF$FCB+9		;->R/O-Flag
	if BOOTRO
	  SETB	7,M
	endif
	INX	H			;->SYS-Flag
	if BOOTSYS
	  SETB	7,M
	endif
	INX	H			;->ARCHIVE-Flag
	SETB	7,M
	LXI	D,DEF$F differnt formats will be detected. Each XDPB's with 4 different
; Options. 4 x 10 = max. 40 different disk formats.

; .... If now after 50 retries still failled an login error message occures .


; You must not create two XDPB's with identical physical but different logical
; parameters. With a given disk drive by the type flag (5 Zoll / 8 Zoll), 
; recording density (MFM/FM) the Sectors per track (MXSC) and Sectorlength (DTL,NUM)
; together must be unique, even if different GAP's, SPEC, XLT's, DIR's ... for
; another format are defined.

; For example a format with 256 Bytes per Sector and 16 Sectors per Track on an 
; 5 1/4 Zoll Drive with MFM may exist only once, even if the same format on another 
; DPB with different directory entries or block size exists. Choose for this
; new format lower or greater MXSC Parameter (15 or 17 Sectors per Track).


;**********************************************
; DRIVE 1 Layout FD-55 F 9x512 2x80
;**********************************************

sect1		equ	512	; sector Size
mxsc1		equ	9	; sectors per track
mxtr1		equ	80	; tracks per surface
side1		equ	2	; number of surfaces
xtrk1		equ	mxtr1*side1
blk1		equ	1024*2	; number of 1024k Blocksizes
dir1		equ	128	; number of directory entries
off1		equ	4	; offset for system tracks
type1		equ	tymfm + ty5zoll

Xdpb1:	db	2		; NUM
	db	mxsc1
	db	1Ah		; Gap 3
	db	-1		; DTL
	dw	specf		; Specify Parameter
	db	type1		; type-byte
	dw	xlt1

l$hd$dpb	equ	$-xdpb1

DPB1:	dpb	sect1,mxsc1,xtrk1,blk1,dir1,off1

; Note: Do note move the first dpb1 .

lxdpb	equ $-xdpb1


; next drive format to search ...



;**********************************************
; DRIVE 2 Layout  FD55-G 16x512, 2x80
;**********************************************

sect2		equ	512	; sector Size
mxsc2		equ	16	; sectors per track
mxtr2		equ	80	; tracks per surface
side2		equ	2	; number of surfaces
xtrk2		equ	mxtr2*side2
blk2		equ	1024*2	; number of 1024k Blocksizes
dir2		equ	256	; number of directory entries
skew2		equ	3	; skew faktor
off2		equ	4	; offset for system tracks

Xdpb2:	db	02		; NUM
	db	mxsc2
	db	07h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; Type
	dw	xlt2
DPB2:	dpb	sect2,mxsc2,xtrk2,blk2,dir2,off2


;**********************************************
; DRIVE 3 Layout FD-55 F 5x1024 2x80
;**********************************************

sect3		equ	1024	; sector Size
mxsc3		equ	5	; sectors per track
mxtr3		equ	80	; tracks per surface
side3		equ	2	; number of surfaces
xtrk3		equ	mxtr3*side3
blk3		equ	1024*4	; number of 1024k Blocksizes
dir3		equ	128	; number of directory entries
off3		equ	4	; offset for system tracks
skew3		equ	1	; skew faktor
type3		equ	tymfm + ty5zoll

Xdpb3:	db	3		; NUM
	db	mxsc3
	db	25h		; Gap 3
	db	-1		; DTL
	dw	specf		; Specify Parameter
	db	type3		; type-byte
	dw	xlt3

DPB3:	dpb	sect3,mxsc3,xtrk3,blk3,dir3,off3


;**********************************************
; DRIVE 4 Layout  FD55-G 9x1024, 2x80
;**********************************************

sect4		equ	1024	; sector Size
mxsc4		equ	9	; sectors per track
mxtr4		equ	80	; tracks per surface
side4		equ	2	; number of surfaces
xtrk4		equ	mxtr4*side4
blk4		equ	1024*2	; number of 1024k Blocksizes
dir4		equ	256	; number of directory entries
skew4		equ	5	; skew faktor
off4		equ	4	; offset for system tracks

Xdpb4:	db	03		; NUM
	db	mxsc4
	db	07h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; Type
	dw	xlt4
DPB4:	dpb	sect4,mxsc4,xtrk4,blk4,dir4,off4


;**********************************************
; DRIVE 5 Layout  FD55-G 15x512, 2x77
;**********************************************

sect5		equ	512	; sector Size
mxsc5		equ	15	; sectors per track
mxtr5		equ	77	; tracks per surface
side5		equ	2