
  B>REN A:PRINTS.NEW = PRINCE.NEW

       The file PRINCE.NEW on drive  A  changes  to  PRINTS.NEW  on
       drive A.

  A>RENAME S*.TEX=A*.TEX

       The  above  command   renames   all   the   files   matching
       A*.TEX to files with filenames S*.TEX.

  A>REN B:NEWLIST=B:OLDLIST

       The file OLDLIST changes to NEWLIST on drive B.   Since  the
       second  drive specifier, B:  is implied by the first one, it
       is unnecessary in this example.  The command line above  has
       the same effect as the following:

          A>REN B:NEWLIST=OLDLIST
                     or
          A>REN NEWLIST=B:OLDLIST

  ///1RMAC

  Syntax:

       RMAC filespec {$Rd | $Sd | $Pd}

  Explanation:

  RMAC, a relocatable macro  assembler,  assembles .ASM  files   of
  into .REL files that you can link to create .COM files.

  ///2options

  RMAC options specify the   destination  of  the   output   files.
  Replace d with the destination drive letter for the output files.

                    Option         d=output option

            R- drive for REL file  (A-O, Z)
            S- drive for SYM file  (A-O, X, P, Z)
            P- drive for PRN file  (A-O, X, P, Z)

            A-O specifies drive A-O.
            X means output to the console.
            P means output to the printer.
            Z means zero output.

  ///2Example

  A>RMAC TEST $PX SB RB

       Assembles the file TEST.ASM from drive A, sends the  listing
       file  (TEST.PRN)  to  the  console,  puts  the  symbol  file
       (TEST.SYM) on drive B  and  puts   the   relocatable  object
       file (TEST.REL) on drive B.

  ///1SAVE

  Syntax:

       SAVE

  Explanation:

  SAVE copies the contents of memory to  a  file.  To   use   SAVE,
  first issue the SAVE command, then run your program which reads a
  file into memory.  Your  program exits to the SAVE utility  which
  prompts  you  for  a filespec to which it copies the  contents of
  memory, and  the beginning and ending address of the memory to be
  SAVEd.

  ///2Example

       A>SAVE

  Activates the SAVE utility.  Now enter the name  of  the  program
  which loads a file into memory.

       A>SID dump.com

  Next, execute the program.

       #g0

  When the program exits, SAVE intercepts the return to the  system
  and prompts the user for the filespec and the bounds of memory to
  be SAVEd.

       SAVE Ver 3.0
       Enter file (type RETURN to exit):dump2.com

  If file DUMP2.COM exists already, the system asks:

       Delete dump2.com? Y

  Then the system asks for the bounds of memory to be saved:

       Beginning hex address: 100
       Ending hex address: 400

  The contents of memory from 100H (Hexadecimal) to 400H is  copied
  to file DUMP2.COM.

  ///1SET

  Syntax:

          SET [options]
          SET d: [options]
          SET filespec [options]

  Explanation:

  SET  initiates  password   protection   and   time  stamping   of
  files.  It  also  sets  the file and drive attributes Read-Write,
  Read-Only, DIR and SYS.  It  lets  you  label a disk and password
  protect  the  label.  To  enable  time  stamping  of  files,  you
  must  first  run INITDIR to format the disk directory.

  ///2Label

  Syntax:

          SET {d:} [NAME=labelname.typ]
          SET [PASSWORD=password]
          SET [PASSWORD=<cr>

  ///3Examples

  A>SET [NAME=DISK100]

       Labels the disk on the default drive as DISK100.

  A>SET [PASSWORD=SECRET]

       Assigns SECRET to the  disk  label.

  A>SET [PASSWORD=<cr>

       Nullifies the existing password.

  ///2Passwords

          SET [PROTECT=ON]
          SET [PROTECT=OFF]
          SET filespec [PASSWORD=password]
          SET filespec [PROTECT=READ]
          SET filespec [PROTECT=WRITE]
          SET filespec [PROTECT=DELETE]
          SET filespec [PROTECT=NONE]
          SET filespec [attribute-options]

  ///3Modes

              Password Protection Modes

  Mode                        Protection

  READ           The password  is  required  for  reading,  copying
                 writing, deleting or renaming the file.

  WRITE          The password is required for writing, deleting  or
                 renaming  the file.  You do not need a password to
                 read the file.

  DELETE         The password is  only  required  for  deleting  or
                 renaming  the file.  You do not need a password to
                 read or modify the file.

  NONE           No password exists for the file.   If  a  password
                 password  exists,  this  modifier  can  be used to
                 delete the password.

  ///2Attributes

  RO             sets the file attribute to Read-Only.

  RW             sets the file attribute to Read-Write.

  SYS            sets the file attribute to SYS.

  DIR            sets the file attribute to DIR.

  ARCHIVE=OFF    means  that  the  file  has  not  been  backed  up
                 (archived).

  ARCHIVE=ON     means that the file has been backed up (archived).
                 The  Archive  attribute can be turned on by SET or
                 by PIP when copying a group of files with the  PIP
                 [A]  option.  SHOW  and  DIR  display  the Archive
                 option.

  F1=ON|OFF      turns on or off the user-definable file  attribute
                 F1.

  F2=ON|OFF      turns on or off the user-definable file  attribute
                 F2.

  F3=ON|OFF      turns on or off the user-definable file  attribute
                 F3.

  F4=ON|OFF      turns on or off the user-definable file  attribute
                 F4.

  ///3Examples

  SET [PROTECT=ON]

       Turns on password protection for all the files on the  disk.
       You  must  turn on password protection before you can assign
       passwords to files.

  SET [PROTECT=OFF]

       Disables password protection for the files on your disk.

  A>SET MYFILE.TEX [PASSWORD=MYFIL]

       MYFIL is the password assigned to file MYFILE.TEX.

  B>SET *.TEX [PASSWORD=SECRET, PROTECT=WRITE]

       Assigns the password SECRET to all the TEX files on drive B.
       Each  TEX  file  is  given  a  WRITE protect mode to prevent
       