attribute.  DIR  accepts the * and ? wildcards in the file
  specification.

  ///3Examples

  A>DIR

       Displays all files in user  0  on  drive  A  that  have  the
       Directory attribute.

  A>DIR B:

       Displays all DIR files in user 0 on drive B.


  2A>DIR C:ZIPPY.DAT

       Displays the name ZIPPY.DAT if the file  is  in  user  2  on
       drive C.

  4A>DIR *.BAS

       Displays all DIR files with filetype BAS in user 4 on  drive
       A.

  B3>DIR X*.C?D

       Displays all DIR files in user 3 on drive B  whose  filename
       begins with the letter X, and whose three character filetype
       contains the first character C and last character D.

  A>DIRS

       Displays all files for user 0 on  drive  A  that  have   the
       system (SYS) attribute.

  A>DIRS *.COM

       Displays all SYS files with filetype COM on drive A in  user
       0.  A  command  (.COM)  file  in  user  0  with  the  system
       attribute can be accessed  from  any  user  number  on  that
       drive,  and from any drive in the search chain (see SETDEF).

  ///2withOptions

  Syntax:

          DIR {d:} [options]
          DIR {filespec} {filespec} ... [options]

  Explanation:

  The DIR command with options is an enhanced version of   the  DIR
  built-in  command  and  displays your files in a variety of ways.
  DIR can search for files on any or all  drives, for  any  or  all
  user  numbers.  One  or  two letters is sufficient to identify an
  option. You need not type the right hand square bracket.

  ///3Options

  Option                     Function

  ATT        displays the file attributes.

  DATE       displays date and time stamps of files.

  DIR        displays only files that have the DIR attribute.

  DRIVE=ALL  displays files on all on-line drives.

  DRIVE=(A,B,C,...,P)
             displays files on the drives specified.

  DRIVE=d    displays files on the drive specified by d.

  EXCLUDE    displays  files  that   DO   NOT   MATCH   the   files
             specified in the command line.

  FF         sends an initial form feed to the  printer  device  if
             the printer has been activated by CTRL-P.

  FULL       shows the name, size, number of 128-byte records,  and
             attributes  of  the  files.  If  there  is a directory
             label   on   the   drive,  DIR  shows   the   password
             protection mode and the time stamps.  If  there  is no
             directory  label,  DIR displays  two file entries on a
             line,  omitting  the  password and time stamp columns.
             The display is alphabetically sorted. (See  SET for  a
             description  of   file   attributes, directory labels,
             passwords and protection modes.)

  LENGTH=n   displays n lines of printer output  before   inserting
             a table heading.  n is a number between 5 and 65536.

  MESSAGE    displays the names of drives and user numbers  DIR  is
             searching.

  NOSORT     displays files in the order it finds them on the disk.

  RO         displays  only  the  files  that  have  the  Read-Only
             attribute.

  RW         displays only the files that are set to Read-Write.

  SIZE       displays the filename  and  size  in  kilobytes  (1024
             bytes).

  SYS        displays only the files that have the SYS attribute.

  USER=ALL   displays all files in all user numbers for the default
             or specified drive.

  USER=n     displays the files in the user number specified by  n.

  USER=(0,1,...,15)
             displays files under the user numbers specified.

  ///3Examples

  A>DIR C: [FULL]

       Displays full set of characteristics for all files in user 0
       on drive C.

  A>DIR C: [DATE]

       Lists the files on drive C and their dates.

  A>DIR D: [RW,SYS]

       Displays all files in user 0 on  drive  D   with  Read-Write
       and System attributes.

  3A>DIR [USER=ALL, DRIVE=ALL]

       Displays all the files in all user numbers (0-15) in all on-
       line drives.

  B6>DIR [exclude] *.DAT

       Lists all the files on drive B in user 6 that do not have  a
       filetype of .DAT.

  3B>DIR [SIZE] *.PLI *.COM *.ASM

       Displays all the files  of  type  PLI,  COM, and ASM in user
       3 on drive B in size display format.

  A>DIR [drive=all user=all] TESTFILE.BOB

       DIR  displays  the  filename TESTFILE.BOB if it is found  on
       any drive in any user number.

  A>DIR [size,rw] D:

       DIR lists  each  Read-Write file  that  resides on Drive  D,
       with  its  size in kilobytes.  Note that D: is equivalent to
       D:*.*.

  ///1DUMP

  Syntax:

      DUMP filespec

  Explanation:

  DUMP displays the contents of a  file  in  hexadecimal and  ASCII
  format.

  Example:

      A>DUMP ABC.TEX

  ///1ed

  Format:

       ED input-filespec {d:|output-filespec}

  Explanation:

  Character file editor.  To redirect or rename the new version  of
  the file specify the destination drive or destination filespec.

  ///2commands

                         ED Command Summary


  Command              Action

  nA
        append n lines from original file to memory buffer

  0A
        append file until buffer is one half full

  #A
        append file until buffer is full (or end of file)

  B, -B
        move CP to the beginning (B) or bottom (-B) of buffer

  nC, -nC
        move CP n characters forward (C) or back (-C) through buffer

  nD, -nD
        delete n characters before (-D) or from (D) the CP

  E
        save new file and return to CP/M-86

  Fstring{^Z}
        find character string

  H
        save new file, reedit, use new file as original file

  I<cr>
        enter insert mode

  Istring{^Z}
        insert string at CP

  Jsearch_str^Zins_str^Zdel_to_str
        juxtapose strings

  nK, -nK
        delete (kill) n lines from the CP

  nL, -nL, 0L
        move CP n lines

  nMcommands
        execute commands n times

  n, -n
        move CP n lines and display that line

  n:
        move to line n

  :ncommand
        execute command through line n

  Nstring{^Z}
        extended find string

  O
        return to original file

  nP, -nP
        move CP 23 lines forward and display 23 lines at console

  Q
        abandon new file, return to CP/M-86

  R{^Z}
        read X$$$$$$$.LIB file into buffer

  Rfilespec{^Z}
        read filespec into buffer

  Sdelete string^Zinsert string
        substitute string

  nT, -nT, 0T
        type n lines

  U, -U
        upper-case translation
  V, -V
        line numbering on/off
  0V
        display free buffer space
  nW
        write n lines to new file
  0W
        write until buffer is half empty
  nX
        write or append n lines to X$$$$$$$.LIB

  nXfilespec{^Z}
        write n lines to filespec;
        append if previous xcommand applied to same file

  0x{^Z}
        delete file X$$$$$$$.LIB

  0xfilespec{^Z}
        delete filespec
  nZ
        wait n seconds

  Note:  CP points to the current character being referenced in
         the edit buffer.  Use {^Z} to separate multiple commands
         on the same line.

  ///2Examples

       A>ED TEST.DAT
       A>ED TEST.DAT B:
       A>ED TEST.DAT TEST2.DAT
       A>ED TEST.DAT B:TEST2.DAT

  ///1erase

  Syntax:

       ERASE {filespec} {[CONFIRM]}

  Explanation:

  The ERASE command  removes   one   or   more   files   from   the
  directory  of  a  disk.  Wildcard  characters are accepted in the
  filespec.  Directory and data space are  automatically  reclaimed
  for  later  use  by  another  file.  The  ERASE  command  can  be
  abbreviated to ERA.

  ///2Option

     [CONFIRM]  option  informs  the  system   to   prompt   for
                verification   before  erasing  each  file  that
                matches   the   filespec.    CONFIRM   can   be
                abbreviated to C.

  ///2Examples

  A>ERASE X.PAS

       Removes the file X.PAS from the disk in  drive A.

  A>ERA *.PRN
  Confirm (Y/N)?Y

       All files with the filetype PRN are removed from  the   disk
       in drive A.

  B>ERA A:MY*.* [CONFIRM]

       Each file on drive A with a filename that begins with MY  is
       displayed  with a question mark for confirmation.  Type Y to
       erase the file displayed, N to keep the file.

  A>ERA B:*.*
  Confirm (Y/N)?Y

       All files on drive B are removed from the disk.

  ///1filespec

                           FILESPEC FORMAT

  CP/M 3 identifies every file by its  unique  file  specification,
  which  can  consist  of  four parts: the drive specification, the
  filename, the filetype and the  password.   The  term  "filespec"
  indicates  any  valid  combination  of  the  four parts of a file
  specification, all separated  by  their appropriate   delimiters.
  A   colon  must  follow  a drive letter.  A period must precede a
  filetype. A  semicolon must precede a password.

  The   symbols   and  rules  for  the   parts    of     a     file
  specification follow:

  d:          drivespec  optional    single alpha character (A-P)
  filename    filename               1-8 letters and/or numbers
  typ         filetype   optional    0-3 letters and/or numbers
  password    password   optional    0-8 letters and/or numbers

  Valid combinations of the elements of a CP/M 3 file specification
  are:

                filename
                d:filename
                filename.typ
                d:filename.typ
                filename;password
                d:filename;password
                filename.typ;password
                d:filename.typ;password

  If you do not include a drive  specifier,  CP/M  3  automatically
  uses the default drive.

  Some CP/M 3 commands accept wildcard (* and ?) characters in  the
  filename   and/or filetype parts of the command tail.  A wildcard
  in the command line can in one command  reference  many  matching
  files  on  the  default  or specified user number and drive. (See
  Commands).

  ///1FORMATN

  Syntax: FORMATN

  Explanation:

  The  FORMATN command formats a new disk with an user-defined
  disk format. You can select between some pre-defined formats
  or create your own format.  If you say  <N> to the questions
  '8 Zoll ? ' and '5.25 Zoll ? ' you  select this  free-format
  option.

  ///2QUESTIONS

  The FORMATN command asks you for some questions to get infor-
  mations about the disk format you wish.

  <ESC>		If you enter the <ESC> key you can redefine your
		input in case of errors.

  Double Sided: Enter <N> if only one side of your disk should
		be formated. Usually you enter <Y> or <CR> for
		double sided formating.

  8 Zoll:	Enter <Y> if 8 Zoll compatible disk drive.

  5 Zoll:	Enter <Y> if 5.25 Zoll compatible disk drive, 
		else you select the free-format-option.

  Tracks:	Say <Y> if correct tracknumbers (40-77-80) of
		your disk drive is displayed.


  ///2STANDARD


  5 1/4 Zoll:

		If you have an 80 Track, double sided  disk drive
		(Teac FD55-F, Teac FD35-F, BASF 6138 ...) use the 
		5 x 1024 Bytes format (menue number 3). Or  enter 
		<Y>  to  'Double Sided', '5 Zoll' and  '80 Track' 
		questions.

		DS, 5 ZOLL, 80 TRACKS, 5 X 1024 BYTES

  8 Zoll:

		On 8 Zoll - compatible mini-drives (FD55-G) you
		should  use  the  9 x 1024 Bytes  format (menue 
		number 6).  Or  enter  <Y>  to 'Double  Sided', 
		'8 Zoll' and '80 Tracks'.

		DS, 8 ZOLL, 80 TRACKS, 9 X 1024 BYTES

  ///1GENCOM

  Syntax:

          GENCOM {COM-filespec} {RSX-filespec} ...
                     {[LOADER | NULL | SCB=(offset,value)]}

  Explanation:

  The GENCOM command creates a special COM file with  attached  RSX
  files.   The  GENCOM  command  can  also  restore  a   previously
  GENCOMed file to the original COM file  without  the  header  and
  RSX's.  GENCOM can also attach header records to COM files.

  ///2Options

  LOADER      sets a flag to keep the program loader active.

  NULL        indicates that only RSX files are specified.   GENCOM
              creates   a   dummy  COM file for the RSX files.  The
              output COM filename is taken from the filename of the
              first RSX-filespec.

  SCB=(offset,value)
              sets the System Control Block  from  the  program  by
              using the hex values specified by (offset,value).

  ///2Examples

  A>GENCOM MYPROG PROG1 PROG2

       Generates a new COM file  MYPROG.COM   with  attached  RSX's
       PROG1 and PROG2.

  A>GENCOM PROG1 PROG2 [NULL]

       Creates a COM file PROG1.COM  with  RSX's PROG1 and PROG2.

  A>GENCOM MYPROG

       GENCOM takes  MYPROG.COM,   strips   off  the   header   and
       deletes all attached RSX's to restore it to its original COM
       format.

  A>GENCOM MYPROG PROG1 PROG2

       GENCOM looks at the  already-GENCOMed file MYPROG.COM to see
       if PROG1.RSX and PROG2.RSX are already attached RSX files in
       the module.  If  either  one  is  already  attached,  GENCOM
       replaces  it  with  the  new  RSX module.  Otherwise, GENCOM
       appends the specified RSX files to the COM file.

  ///1GET

  Syntax:

  GET {CONSOLE INPUT FROM} FILE filespec{[{ECHO|NO ECHO} | SYSTEM]}
  GET {CONSOLE INPUT FROM} CONSOLE

  Explanation:

  GET  directs the system to take console input from a file for the
  next system  command  or  user  program entered at the console.

  Console input  is  taken  from   a   file   until   the   program
  terminates.  If  the  file  is  exhausted before program input is
  terminated, the program  looks  for  subsequent  input  from  the
  console.  If  the  program  terminates  before exhausting all its
  input, the system reverts back to the console for console  input.

  With  the  SYSTEM  option,  the  system  immediately  goes to the
  specified file for console input.  The  system  reverts  to   the
  console   for  input  when it reaches the end of file.  Re-direct
  the system to the  console  for   console   input  with  the  GET
  CONSOLE INPUT FROM CONSOLE command as a command line in the input
  file.

  ///2Options

  ECHO      specifies that input is echoed to  the  console.   This
            is the default option.

  NO ECHO   specifies that  file   input   is  not  echoed  to  the
            console.  The program output and the system prompts are
            not affected by this option and are still   echoed   to
            the console.

  SYSTEM    specifies that all  system  input  is immediately taken
            from  the disk file specified in the command line.  GET
            takes system and program input from the file until  the
            file  is  exhausted  or  until  GET reads a GET console
            command from the file.

  ///2Examples

  A>GET FILE XINPUT
  A>MYPROG

       Tells the system to  activate the GET utility.  Since SYSTEM
       is  not specified, the system reads the next input line from
       the console and   executes   MYPROG.    If  MYPROG   program
       requires  console  input,  it is taken from the file XINPUT.
       When MYPROG terminates,  the  system  reverts  back  to  the
       console for console input.

  A>GET FILE XIN2 [SYSTEM]

       Immediately  directs   the   system    to    get  subsequent
       console  input from file XIN2 because it includes the SYSTEM
       option.  The system reverts  back   to   the   console   for
       console  input  when it reaches the end of file in XIN2.  Or
       XIN2 may redirect the system  back  to  the  console  if  it
       contains a  GET CONSOLE command.

  A>GET CONSOLE

       Tells the system to get console   input  from  the  console.
       This  command may be used in a file (previously specified in
       a GET FILE command), which is already  being  read   by  the
       system   for   console  input.  It is used  to re-direct the
       console input back to  the console  before the   end-of-file
       is reached.

  ///1HELP

  Syntax:

     HELP {topic} {subtopic1 ... subtopic8} {[NOPAGE|LIST]}

  Explanation:

  HELP  displays  a  list  of  topics   and   provides   summarized
  information for CP/M 3 commands.

  HELP topic displays information about that topic.
  HELP topic subtopic displays information about that subtopic.

  One or two letters is enough to identify the topics.  After  HELP
  displays   information   for   your  topic,   it   displays   the
  special  prompt  HELP> on your screen,  followed  by  a  list  of
  subtopics.

   -  Enter ? to display list of main topics.
   -  Enter a period and subtopic name to access subtopics.
   -  Enter a period to redisplay what you just read.
   -  Press the RETURN key to return to the CP/M 3 system prompt.
   -  [NOPAGE] option disables the 24 lines per page console display.
   -  Press any key to exit a display and return to the HELP> prompt.

  Examples:

       A>HELP
       A>HELP DATE
       A>HELP DIR OPTIONS
       A>HELP>.OPTIONS
       HELP>SET
       HELP>SET PASSWORD
       HELP>.PASSWORD
       HELP>.
       HELP><cr>

  ///1HEXCOM

  Syntax:

      HEXCOM filename

  Explanation:

  The HEXCOM Command generates a command file (filetype .COM)  from
  a   .HEX  input  file.  It  names  the  output file with the same
  filename as the input file but with filetype .COM.  HEXCOM always
  looks for a file with filetype .HEX.

  Example:

  A>HEXCOM B:PROGRAM

       Generates a command file PROGRAM.COM from the input hex file
       PROGRAM.HEX.

  ///1INITDIR

  Syntax:

      INITDIR {d:}

  Explanation:

  The INITDIR Command  initializes a disk directory  to  allow date
  and time stamping of files on that disk. INITDIR can also recover
  time/date directory space.

  Example:

      A>INITDIR C:

      INITDIR WILL ACTIVATE TIME-STAMPS FOR SPECIFIED DRIVE.
      Do you want to re-format the directory on C: (Y/N)?Y

  ///1LIB

  Syntax:

          LIB filespec{[I|M|P|D]}
          LIB filespec{[I|M|P]}=filespec{modifier}
                                  {,filespec{modifier} ... }

  Explanation:

  A library is a file that contains a collection of object modules.
  Use  the LIB utility to create libraries, and to append, replace,
  select or delete modules from an existing library.   Use  LIB  to
  obtain information about the contents of library files.

  LIB creates and  maintains  library  files  that  contain  object
  modules in Microsoft REL file format.  These modules are produced
  by Digital Research's relocatable macro-assembler program,  RMAC,
  or  any  other  language  translator  that  pruduces  modules  in
  Microsoft REL file format.

  You can use LINK-80 to link the object  modules  contained  in  a
  library  to  other  object  files.  LINK-80 automatically selects
  from the library only those modules needed by the  program  being
  linked, and then forms an executable file with a filetype of COM.

  ///2Options

     I      The INDEX option creates an indexed  library  file
            of  type .IRL.  LINK-80 searches faster on indexed
            libraries than on non-indexed libraries.

     M      The MODULE option displays module names.

     P      The PUBLICS option displays module names  and  the
            public variables for the new library file.

     D      The DUMP option displays the  contents  of  object
            modules in ASCII form.

  ///2Modifiers

  Use modifiers in  the   command   line   to   instruct   LIB   to
  delete,  replace,  or  select  modules  in a library file.  Angle
  brackets  enclose  the  modules  to  be  deleted   or   replaced.
  Parentheses enclose the modules to be selected.

                              LIB Modifiers

                Delete     <module=>

                Replace    <module=filename.REL>

                           If module name and filename are the
                           same this shorthand can be used:

                           <filename>

                Select     (modFIRST-modLAST,mod1,mod2,...,modN)

  ///2Examples

  A>LIB TEST4[P]

       Displays  all  modules and publics in TEST4.REL.

  A>LIB TEST5[P]=FILE1,FILE2

       Creates TEST5.REL from FILE1.REL and FILE2.REL and  displays
       all modules and publics in  TEST5.REL.

  A>LIB TEST=TEST1(MOD1,MOD4),TEST2(C1-C4,C6)

       Creates a library file TEST.REL from modules in  two  source
       files.  TEST1.REL  contributes  MOD1 and MOD4.  LIB extracts
       modules C1, C4, and all the  modules  located between  them,
       as well as module C6 from TEST2.REL.

  A>LIB FILE2=FILE3<MODA=>

       Creates  FILE2.REL  from  FILE3.REL, omitting MODA which  is
       a module in FILE3.REL.

  A>LIB FILE6=FILE5<MODA=FILEB.REL>

       Creates  FILE6.REL  from FILE5.REL, FILEB.REL replaces MODA.

  A>LIB FILE6=FILE5<THISNAME>

       Module   THISNAME  is  in  FILE5.REL.   When   LIB   creates
       FILE6.REL  from FILE5.REL the file THISNAME.REL replaces the
       similarly named module THISNAME.

  A>LIB FILE1[I]=B:FILE2(PLOTS,FIND,SEARCH-DISPLAY)

       Creates FILE1.IRL on drive A  from   the  selected   modules
       PLOTS,   FIND,   and   modules  SEARCH  through  the  module
       DISPLAY, in FILE2.REL on drive B.

  ///1LINK

  Syntax:

          LINK d:{filespec,{[options]}=}filespec{[options]}{,...}

  Explanation:

  LINK  combines  relocatable  object   modules   such  as    those
  produced  by  RMAC  and  PL/I-80  into  a  .COM  file  ready  for
  execution.  Relocatable files can contain external references and
  publics.  Relocatable  files  can  reference  modules  in library
  files.   LINK  searches  the  library  files  and  includes   the
  referenced    modules   in  the  output  file.  See  the  CP/M  3
  Programmer's Utilities Guide for a complete description of  LINK-
  80.

  ///2Options

  Use LINK option switches to control  execution parameters.   Link
  options    follow    the    file  specifications and are enclosed
  within square  brackets.   Multiple  switches  are  separated  by
  commas.

                             LINK-80 Options

          A          Additional memory; reduces buffer space
                     and writes temporary data to disk

          B          BIOS link in banked CP/M 3 system.
                     1.  Aligns data segment on page boundary.
                     2.  Puts length of code segment in header.
                     3.  Defaults to .SPR filetype.

          Dhhhh      Data origin; sets memory origin for
                     common and data area

          Gn         Go; set start address to label n

          Lhhhh      Load; change default load address
                     of module to hhhh.   Default 0100H

          Mhhhh      Memory size; Define free memory
                     requirements for MP/M modules.

          NL         No listing of symbol table at console

          NR         No symbol table file

          OC         Output .COM command file.  Default

          OP         Output .PRL page relocatable file for
                     execution under MP/M in relocatable
                     segment

          OR         Output .RSP resident system process file
                     for execution under MP/M

          OS         Output .SPR system page relocatable file
                     for execution under MP/M

          Phhhh      Program origin; changes default
                     program origin address to hhhh.
                     Default is 0100H.

          Q          Lists symbols with leading question mark

          S          Search preceding file as a library

          $Cd        Destination of console messages
                     d can be X (console), Y (printer),
                     or Z (zero output).  Default is X.

          $Id        Source of intermediate files;
                     d is disk drive A-P. Default
                     is current drive.

          $Ld        Source of library files;
                     d is disk drive A-P.  Default
                     is current drive.

          $Od        Destination of of object file;
                     d can be Z or disk drive A-P.
                     Default is to same drive as
                     first file in the LINK-80 command.

          $Sd        Destination of symbol fi