{ ========================================================================= }
{ !                   ** FORMATIER-PROGRAMM **                            ! }
{ !                                                                       ! }
{ !  Version 2.3                                                          ! }
{ !  Fuer PROF-180 ,CONITEC-Darmstadt. Von Manfred Oheimer .              ! }
{ !  Letzte Aenderung : 18.02.87                                          ! }
{ ========================================================================= }


TYPE  bytearray=array[0..15]of char;

      BLK_REC=record
                disktyp,
                fsektor,
                lsektor,
                lwpre,
                tth1,
                gap,
                spuren,
                wrpspur            :byte;
                spt                :integer;
                bsh,
                blm,
                exm                :byte;
                dsm,
                drm                :integer;
                al0,
                al1                :byte;
                cks,
                syso               :integer;
                psh,
                phm                :byte;
                spointer,
                tpointer           :integer;
                barray             :bytearray;
                fgap,
                fskew,
                reserved           :byte;
        end;

     blk_typ=array[0..200]of blk_rec;
     skew_type=array[0..159]of byte;          { Datenformat der Skew-Tabellen }
     string7=string[7];
     itable  =array[0..255]of byte;
     bcblock =array[0..7]of byte;                        { Fuer CP/M BIOSCALL }
     vbuff   =array[0..8191]of byte;               { Sektorpuffer fuer Verify }
     menueeintrag=string[38];
     zweizahl=string[2];
     dreizahl=string[3];
     vierzahl=string[4];
     fuenfzahl=string[5];
     zeile              =string[80];
     position           =array[1..2]of integer;
     dfname             =string[11];
     string16           =string[16];
     fd                 =record
                           nummer:dreizahl;
                           fname :string16;
                           lawegu:vierzahl;
                         end;

var
     verifybuffer            :vbuff;
     formdat                 :array[0..200]of fd;
     i,laenge,ein2,drivenr   :integer;
     aktseitanf,aktformnr    :integer;
     AKTFNR,formondrive      :integer;
     aktpos,merkpos          :position;
     ein                     :char;
     bidtable                :itable;   { Tabelle fuer SektorID's, max.255 Stueck }
     kennung                 :string7 absolute $ff65;
     hilf                    :byte absolute $ff65;
     leng                    :byte;
     ganzschluss,noheadinv   :boolean;
     monken                  :byte absolute $ff6d;
     blkparameter            :blk_typ;
     xdpb_anz                :byte;




procedure makefnames(wieviel:integer);
var i,j:integer;
begin
   for i:=0 to 200 do
      begin
{         formdat[i].nummer:='   ';  }
         if i>wieviel-1 then begin formdat[i].fname:='                ';
                                   formdat[i].lawegu:='    ';
                                   formdat[i].nummer:='   ';
                             end

            else begin
                    formdat[i].fname:=blkparameter[i].barray;
                    str(i:3,formdat[i].nummer);                    
                 end;
      end;
end;


procedure writecomspacemain;  { Kommandofeld Eintragung fuer Blaetter-Mode    }
begin
   gotoxy(1,21);                             { Erste Zeile des Kommandofeldes }

   write('   ^E: Format zurueck   ^R: Seite zurueck  S: zeige Formatparameter            ');
   gotoxy(1,23);                            { Zweite Zeile des Kommandofeldes }
   write('   ^X: Format vor       ^C: Seite vor     CR: Formatiere  ESC: Programmende    ');
end;


procedure write_show_comspace;  { Kommandofeld Eintragung fuer SHOW-Mode      }
begin
   gotoxy(4,22);
   write('                                           weiter mit beliebiger Taste ');
end;



procedure clearcomspace;
var i:integer;
    space:zeile;
begin
   space:='                                        ';
   gotoxy(1,21);
   for i:=0 to 2 do
      begin
         gotoxy(1,21+i);write(space+space);
      end;
end;


procedure hbild;
var grenz1,grenz2:zeile;
begin
   gotoxy(1,1);
   grenz1:='=======================================';
   grenz2:='========================================';
   write(grenz1+grenz2);gotoxy(1,3);write(grenz1+grenz2);gotoxy(1,20);
   write(grenz1+grenz2);gotoxy(1,24);write(grenz1+grenz2);gotoxy(2,2);
   write('   PROF-180X Formatierprogramm Version: 2.3   ');
   writecomspacemain;
end;


function warnung:boolean;
var ein:char;
begin
   if drivenr=formondrive then begin
       warnung:=true;
       clearcomspace;
       gotoxy(5,22);write('Richtige Diskette eingelegt ? Bestaetigen :');
       read(kbd,ein);
       clearcomspace;
       formondrive:=0;
       end
     else
       warnung:=false;
end;



procedure clearworkspace;
var i:integer;
    lz:zeile;
begin
   lz:='                                        ';
   for i:=1 to 16 do
      begin
         gotoxy(1,i+3);
         write(lz+lz);
      end;
end;

procedure feldaendern(x,y,len:integer;atext:zeile);

var i      :integer;
    leerstr:zeile;

begin
   leerstr:=' ';
   gotoxy(x,y);
   for i:=1 to len-1 do leerstr:=leerstr+' ';
   write(leerstr);
   gotoxy(x,y);
   write(atext);
end;


procedure neuseit;

var i,len,x,y:integer;
    fnam     :menueeintrag;

begin
   for i:=(aktseitanf+16) to (aktseitanf+31) do
      begin
         if i-(aktseitanf+24)<0 then begin x:=2;
                                           y:=(i-(aktseitanf+15))*2+3;
                                     end
                                else begin x:=42;
                                           y:=(i-(aktseitanf+23))*2+3;
                                     end;
         len:=38;
         fnam:=formdat[i].nummer+' '+formdat[i].fname+' '+formdat[i].lawegu;
         feldaendern(x,y,len,fnam);
      end;
   aktseitanf:=aktseitanf+16;
end;








procedure formdefstep(richtung:integer);
var i,t,base:integer;
begin
    if ((xdpb_anz div 16)*16) >= (AKTFNR+1) then begin
          if((((AKTFNR)mod 16)=15)and(richtung=1)) then AKTFNR:=AKTFNR-16;
          if ((((AKTFNR)mod 16)=0)and(richtung=-1)) then begin
                                                   AKTFNR:=AKTFNR+14;
                                                   richtung:=1;
                                                end;
                              AKTFNR:=AKTFNR+richtung;
                  end
    else begin
          base:=xdpb_anz mod 16;
          if((AKTFNR=xdpb_anz-1)and(richtung=1)) then AKTFNR:=AKTFNR-base;
          if ((((AKTFNR)mod 16)=0)and(richtung=-1)) then begin
                                                   AKTFNR:=AKTFNR+base-2;
                                                   richtung:=1;
                                                end;
                              AKTFNR:=AKTFNR+richtung;
         end;
    feldaendern(56,2,19,formdat[AKTFNR].fname);
    feldaendern(50,2,3,formdat[AKTFNR].nummer);
    feldaendern(76,2,4,formdat[AKTFNR].lawegu);
    i:=((AKTFNR) mod 16) ;
    if i<8 then gotoxy(2,i*2+5)
           else gotoxy(41,(i-8)*2+5);
end;




function biosversiontest:boolean;
begin
   biosversiontest:=(mem[$ff49]>$00);
end;



function p180test:boolean;
var DISPADR   :byte absolute $ff28;
    DISPADR1  :byte absolute $ff29;
begin
   p180test:=true;
   if DISPADR1<>$01 then p180test:=false;
   if DISPADR<>$80 then p180test:=false;
end;