;*********************************************************
;***                                                   ***
;***  sgen180: DIESES PROGRAMM KOPIERT DIE SYSTEM-     ***
;***  SPUREN VON/AUF MINI UND MAXI 		       ***
;***  LETZTE AENDERUNG AM: 29.08.1986 (Heydenbluth)    ***
;***                                                   ***
;*********************************************************
;
	maclib	pvec
	maclib	psys
	MACLIB	hd64180
	MACLIB	pdef
;
	TITLE	'PROF-180x SYSGEN'
;
BDOS		EQU	00005H
WBOOT		EQU	00000H
TPA		EQU	100H
EPROMCODE	EQU	2000H	;HIERHER WERDEN DIE EPROM ROUTINEN GELADEN
SYSTEMSAVE	EQU	EPROMCODE+900H
STACK		EQU	EPROMCODE+400H
;
;
;
	ORG	TPA
	;
	LXI	H,dispadr	;PRUEFE OB PROF-180 COMPUTER
	mov	a,m
	cpi	080h
	jrnz	computer$falsch	
	inx	h
	mov	a,m
	cpi	1
	jrz	checkok
COMPUTER$FALSCH:
	LXI	H,FALSCHTXT	;GEBE FEHLERMELDUNG AUS
	CALL	SOUT		;
	JMP	WBOOT		;
;
FALSCHTXT:
	DB	0DH,0AH,'Error SGEN180 runs only '
	DB	0DH,0AH,'on a PROF-180 computer',0DH,0AH,'$'
;
CHECKOK:
;
	LXI	SP,STACK	;SETZE STACK NEU
	LXI	H,SWITCHCODE	;COPIERE EPROM
	LXI	D,EPROMCODE	;ROUTINEN
	LXI	B,EPROMCODEL	;
	LDIR			;
	LXI	H,ANFTXT	;GEBE VERSION AUS
	CALL	SOUT		;
START:	
	LXI	H,STEXT		;LESE SOURCE DRIVE EIN
	CALL	SOUT		;
	CALL	CONIN		;LESE LAUFWERKBUCHSTABEN EIN
	CALL	ECHO		;
	JC	MAINLP2		;
	CALL	VALID		;LAUFWERKS ANGABE KORREKT?
	JRNC	MAINLP1		;SPRUNG WENN OK
	LXI	H,ETEXT		;
	CALL	SOUT		;
	JR	START		;NEUE EINGABE
MAINLP1	STA	DRIVECR		;SPEICHERE BUCHSTABEN AB
	LXI	H,SETEXT	;GEBE LW. NOCHMAL AUS
	CALL	SOUT		;
	LDA	DRIVECR		;
	MOV	C,A		;
	CALL	CONOUT		;
	LXI	H,EETEXT	;
	CALL	SOUT		;
	CALL	CONIN		;
	CALL	ECHO		;
	JNC	START		;
	CALL	GETSYS		;LESE SYSTEM EIN
	LXI	H,QTEXT		;
	CALL	SOUT		;
MAINLP2:
	LXI	H,DTEXT		;
	CALL	SOUT		;
	CALL	CONIN		;LESE ZEICHEN
	CALL	ECHO		;ZURUECK ZUR KONSOLE
	JC	WBOOT		;WAR RETURN, ZURUECK ZUM CP/M
	CALL	VALID		;PRUEFE OB ZEICHEN OK
	JRNC	MAINLP3		;
	LXI	H,ETEXT		;
	CALL	SOUT		;
	JR	MAINLP2		;NEUE EINGABE
MAINLP3	STA	DRIVECR		;LEGE LAUFWERKBUCHSTABE AB
	LXI	H,DETEXT	;
	CALL	SOUT		;
	LDA	DRIVECR		;
	CALL	ECHO		;
	LXI	H,EETEXT	;
	CALL	SOUT		;
	CALL	CONIN		;
	CALL	ECHO		;
	JRNC	MAINLP2		;
	CALL	PUTSYS		;
	LXI	H,QTEXT		;
	CALL	SOUT		;
	JMP	MAINLP2		;
;
;
;
GETSYS:
	MVI	A,0		;
	STA	WRITEFLAG	;
	JMP	GETPUTSYS	;
;
;
;
PUTSYS:
	MVI	A,0FFH		;
	STA	WRITEFLAG	;
	JMP	GETPUTSYS	;
;
;
;
GETPUTERR:
		;FEHLERMELDUNG FUER SCHLECHTE SYSTEMSPUREN
	LXI	H,BTRKTXT
	CALL	SOUT
	LXI	H,SOTXT
	LDA	WRITEFLAG
	ORA	A
	JRZ	BADTRK1
	LXI	H,DETXT
BADTRK1	CALL	SOUT
	JMP	START
BTRKTXT	DB	0DH,0AH,'BAD SYSTEM TRACK ON $'
SOTXT	DB	'SOURCE$'
DETXT	DB	'DESTINATION$'
;
;
;
ANFTXT	DB	0AH,0DH
	DB	'SGEN180 Version 1.0',0AH,0DH,24H
;
;
;
STEXT	DB	0AH,0DH
	DB	'SOURCE DRIVE NAME (OR RETURN TO SKIP) '
	DB	24H
;
QTEXT:
	DB	'FUNCTION COMPLETE'
	DB	24H
;
ETEXT	DB	0AH,0DH
	DB	'INVALID DRIVE NAME (USE A,B,C OR D)'
	DB	24H
;
DTEXT	DB	0AH,0DH
	DB	'DESTINATION DRIVE NAME (OR RETURN TO REBOOT) '
	DB	24H
;
DETEXT	DB	0AH,0DH
	DB	'DESTINATION ON '
	DB	24H
;
SETEXT	DB	0AH,0DH
	DB	'SOURCE ON '
	DB	24H
;
EETEXT	DB	', THEN TYPE RETURN'
	DB	24H
;
;
;
VALID:
	;SETZT CARRY FLAG, WENN ZEICHEN IN A
	;KEIN GUELTIGER LAUFWERKSBUCHSTABE IST
	CPI	'A'
	RC
	CPI	'E'
	JRC	NRET
SRET	STC
	RET
NRET	STC
	CMC
	RET
;
;
;
ECHO:
	;SCHREIBT ZEICHEN IN A AUF KONSOLE
	;BEI CR WIRD CR LF AUSGEGEBEN UND CARRY GESETZT
	;
	MOV	C,A		;
	CALL	CONOUT		;
	CPI	0DH		;
	JNZ	NRET		;OHNE CARRY ZURUECK
	MVI	C,0AH		;
	CALL	CONOUT		;
	JMP	SRET		;MIT CARRY ZURUECK
;
;
;
CONOUT	PUSH	PSW		;
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
	MOV	E,C		;
	MVI	C,6		;
	CALL	BDOS		;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	RET			;
;
;
;
CONIN	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
CONIN1	MVI	E,0FFH		;INPUT
	MVI	C,6		;
	CALL	BDOS		;
	CPI	00H		;
	JRZ	CONIN1		;
	CPI	'a'		;WANDLE IN GROSSBUCHSTABEN
	JRC	CONIN2		;
	SUI	'a'-'A'		;
CONIN2	POP	H		;
	POP	D		;
	POP	B		;
	RET			;
;
;
;
SOUT:
        ;GIBT ASCIISTRING AUS (ANFANG IN HL,ENDE DURCH $)
	;
        MOV	A,M		;
	CPI	24H		;ENDE DES STRINGS ?
        RZ			;
        MOV     C,A		;
        CALL    CONOUT		;
        INX     H		;
        JMP     SOUT		;
;
;
;
;------------------------------------------------------------
;
;
GETPUTSYS:
	;WENN WRITEFLAG=0 DANN LESE DIE SYSTEMSPUREN
	;WENN WRITEFLAG <> 0 DANN SCHREIBE DIE SYSTEMSPUREN
	;
	XRA	A		;SETZE CMDTAB FUER SPUR EINS
	STA	TEST$TRACK	;
	LDA	DRIVECR		;SETZE UNIT
	DCR	A		;
	ANI	00000011B	;
	STA	UNIT		;
	CALL	TEST		;TESTE DRIVE
	CALL	SETCMDT		;SETZE CMDTABELLE
	XRA	A		;
	STA	TRACK		;
	STA	HEAD		;
				;
	MVI	A,1		;LADE/SCHREIBE BOOTSEKTOR
	STA	SECTOR		;
	STA	SECTCNT		;
	LXI	H,SYSTEMSAVE	;
	SHLD	DMAADR		;
	LDA	WRITEFLAG	;
	ORA	A		;
	JRZ	BOOTSEK1	;
	CALL	WRITE		;
	JR	BOOTSEK2	;
BOOTSEK1:			;
	CALL	READ		;
BOOTSEK2:			;
	JNZ	GETPUTERR	;
				;
				;LADE/SCHREIBE CCP,BDOS UND BIOS
	LXI	H,SYSTEMSAVE+80H;
	SHLD	NEXTDMA		;DMA-ADRESSE FUER NAECHSTE SPUR
	MVI	A,2		;ANFANGS SECTOR DER SPUR
GETPUT0	STA	SECTOR		;
	LDA	SECSZ		;BERECHNE BYTES/SEKTOR
	LXI	H,64		;
	INR	A		;
GETPUT1	DAD	H		;
	DCR	A		;
	JRNZ	GETPUT1		;
	XCHG			;BYTES/SEKTOR IN DE
	LHLD	NEXTDMA		;NEUE DMA-ADRESSE
	SHLD	DMAADR		;FUER READ SETZEN
				;
	LDA	EOT		;
	MOV	C,A		;
	LDA	SECTOR		;
	MVI	B,1		;SEKTOR ZAEHLER
GETPUT3	LHLD	NEXTDMA		;BERRECHNE ANZAHL DER SEKTOREN
	DAD	D		;DIE VON DIESER SPUR GELESEN WERDEN
	SHLD	NEXTDMA		;SOLLEN.
	CMP	C		;LETZTER SEKTOR
	JRZ	GETPUT5		;
	INR	A		;
	INR	B		;
	JR	GETPUT3		;
				;
GETPUT5	MOV	A,B		;LEGE BERRECHNETE SEKTORZAHL AB
	STA	SECTCNT		;
	LDA	WRITEFLAG	;LESEN ODER SCHREIBEN?
	ORA	A		;WENN NULL LESEN
	JRZ	GETPUT8		;SONST SCHREIBEN
	CALL	WRITE		;
	JR	GETPUT9		;
GETPUT8	CALL	READ		;
GETPUT9	JNZ	GETPUTERR	;BEI FEHLER MELDUNG
				;
	LDA	TEST$TYPE	;LADE MAXIMAL 2 SPUREN BEI MAXI
	ANI	20H		;BZW. 3 SPUREN BEI MINI
	MVI	C,2		;
	JRZ	GETPUT6		;
	MVI	C,3		;
GETPUT6	LDA	TRACK		;ERHOEHE SPUR UM EINS
	INR	A		;
	CMP	C		;GENUG SPUREN UEBERTRAGEN?
	RZ			;DANN ENDE
	STA	TRACK		;
	STA	TEST$TRACK	;TESTE NAECHSTE SPUR
	CALL	TEST		;
	CALL	SETCMDT		;SETZE CMDTAB FUER SPUR > 0
	MVI	A,1		;LESE ALLE ANDEREN SPUREN AB SEKTOR EINS
	JR	GETPUT0		;
				;
;-------------------------------------------------------------------
;
;
;
SWITCHCODE:	;DIESER BEREICH WIRD NACH EPROMCODE
		;KOPIERT, DAMIT MONITOR UP'S BENUTZT WERDEN
		;KOENNEN
;
;
;
READOFF		EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MREAD
		CALL	EPROMOFF
		RET
;
WRITEOFF	EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MWRITE
		CALL	EPROMOFF
		RET
;
TESTOFF		EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MTEST
		CALL	EPROMOFF
		RET
;
SETCMDTOFF	EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MSETCMDT
		CALL	EPROMOFF
		RET
;
EPROMONOFF	EQU	$-SWITCHCODE
		PUSH	PSW		;
		LDA	EPROMZ		;
		ORA	A		;
		JRNZ	EPROMON1	;
		INR	A		;
		STA	EPROMZ		;
		mvi	a,0f1h
		out0	cbar,a
		POP	PSW		;
		RET			;
EPROMON1	INR	A		;
		STA	EPROMZ		;
		POP	PSW		;
		RET
;
EPROMOFFOFF	EQU	$-SWITCHCODE
		PUSH	PSW		;
		LDA	EPROMZ		;
		DCR	A		;
		JRNZ	EPROMOFF1	;
		STA	EPROMZ		;
		mvi	a,0f0h
		out0	cbar,a
		POP	PSW		;
		RET			;
EPROMOFF1	STA	EPROMZ		;
		POP	PSW		;
		RET
;
;
READ		EQU	READOFF+EPROMCODE
WRITE		EQU	WRITEOFF+EPROMCODE
TEST		EQU	TESTOFF+EPROMCODE
SETCMDT		EQU	SETCMDTOFF+EPROMCODE
EPROMON		EQU	EPROMONOFF+EPROMCODE
EPROMOFF	EQU	EPROMOFFOFF+EPROMCODE
;
EPROMCODEL	EQU	$-SWITCHCODE
;
;
;
;-------------------------------------------------------------------
;
;
NEXTDMA		DS	2	;
DRIVECR		DS	1	;ZWISCHENSPEICHER FUER LAUFWERK CHR
WRITEFLAG	DS	1	;
;
;
		end