;***************************************************************
;***        						     ***
;***  DISK FORMATIER PROGRAMM FUER PROF180x                  ***
;***						             ***
;***  VERSION 1.0                                            ***
;***                                                         ***
;***  LETZTE AENDERUNG AM: 29.08.1986 (Heydenbluth)          ***
;***                                                         ***
;***************************************************************
;
		maclib	pvec22
		maclib	psys
		MACLIB	hd64180
		MACLIB	pdef
		;
BDOS		EQU	0005H
WBOOT		EQU	0000H
TPA		EQU	0100H
EPROMCODE	EQU	2000H	;HIERHER WERDEN DIE EPROM ROUTINEN GELADEN
STACK		EQU	EPROMCODE+400H
		;
		;
		;
FILLBYT 	EQU     0E5H	;FUELL BYTE
		;
		;
	ORG	TPA
		;
	lxi	h,dispadr
	mov	a,m
	cpi	080h
	jrnz	computer$falsch
	inx	h
	mov	a,m
	cpi	1
	jrz	checkok
COMPUTER$FALSCH:
	LXI	H,FALSCHTXT	;GEBE FEHLERMELDUNG AUS
	CALL	SOUT		;
	JMP	WBOOT		;
	;
FALSCHTXT:
	DB	0DH,0AH,'Fehler: CINIT180 arbeitet nur auf '
	DB	0DH,0AH,'einem PROF-180 Computer',0DH,0AH,'$'
PROF80	DB	'PROF-80'
	;
CHECKOK:
	;
	LXI	SP,STACK	;SETZE STACK NEU
	LXI	H,SWITCHCODE	;COPIERE EPROM
	LXI	D,EPROMCODE	;ROUTINEN
	LXI	B,EPROMCODEL	;
	LDIR			;
	;
START:
	;
	LXI     H,HEADPMT 
        CALL    SOUT
NLAUF	LXI	H,FRAGE1
        CALL    SOUT
	LXI     SP,STACK	;SETZE STACK NEU
	;
	;
INPUT:
	CALL	CONIN		;LESE DISK-NR
        CPI	0DH		;RETURN?
        JZ      WBOOT1          ;OK, BACK TO CP/M
        CPI     41H
        JC      INPUT           ;KLEINER ALS "A"?
        CPI     45H
        JNC     INPUT           ;GROESSER ALS "D"?
	PUSH	PSW		;RETTE LW.-NR.
	MOV	C,A
        CALL    CONOUT
	POP	PSW		;HOLE LW NR.
        DCR     A               ;WANDLE IN ZAHLEN WERT
        ANI     003H
        STA     LWNR
;
;
INPUT2	LXI     H,FRAGE2
        CALL    SOUT
INP2    CALL    CONIN
	MOV	C,A		;RETTE FUER AUSGABE
        CPI     'J'		;EINGABE PRUEFEN
        JZ      INPU2
        CPI     'N'
        JNZ     INP2
	MVI	A,000H
        STA     MINIMAX		;MAXI LW EINTRAGEN
        JMP     IN2
INPU2   MVI     A,0FFH
        STA     MINIMAX         ;MINI LW EINTRAGEN
IN2     CALL    CONOUT          ;GEBE REG C AUS
;
;
INPUT3	LXI	H,FRAGE3
        CALL    SOUT
INP3	CALL	CONIN
	MOV	C,A		;RETTE ZEICHEN FUER AUSGABE
        CPI     '0'
	JZ	INPU3
        CPI     '1'
        JNZ     INP3
INPU3	CALL	CONOUT
        ANI     001H
        STA     ZWEISD
;
;
INPUT4	LXI	H,FRAGE4
        CALL    SOUT
INP4    CALL    CONIN
	MOV	C,A		;RETTE ZEICHEN FUER AUSGABE
        CPI     'S'
        JZ	INPU4
	CPI	'D'
        JNZ     INP4
	MVI	A,040H		;SETZE DENSITY FLAG
	JMP	INP41
INPU4   MVI     A,000H
INP41	STA	DENS
        CALL    CONOUT
;
;
INPUT5	LDA	DENS	;BERRECHNE BEREICH DER SEKTORGROESSE
        ORA     A
        JZ      INP51   ;OK SEKTORGROESE VON 0-2
        LXI     D,'41'
        LXI     H,FRAGE5B
        JMP     INP52
INP51   LXI     D,'30'
        LXI     H,FRAGE5A
INP52   CALL    SOUT
        XCHG
INP5    CALL    CONIN
	CMP	H
        JC      INP5
	CMP	L
        JNC     INP5
        MOV     C,A
        CALL    CONOUT
	ANI	003H	;WANDLE IN ZAHLENWERT
        STA     SEKGR   ;UND TRAGE DIE SEKTORGROESSE EIN
;
;
INPUT6	LXI	H,FRAGE6
        CALL    SOUT
INP6    CALL    CONIN	;HEX ZAHL ODER CR
        CPI     0DH     ;RETURN?
        JNZ     INPU6   ;NEIN PRUEFE OB HEXZAHL
        LDA     MINIMAX ;MINI LAUFWERK?
        ORA     A
	JZ	INP61   ;NEIN ES IST EIN MAXI LW
        MVI     A,40    ;STANDART BEI MINI LW
        STA     SPZAHL 
        JMP     INP62 
INP61   MVI     A,77    ;STANDART BEI MAXI LW
        STA     SPZAHL 
INP62   CALL    NMOUT   ;GEBE STANDART SPUR ZAHL AUS
        JMP     INPUT7  ;WEITER ZUR NAECHSTEN FRAGE
;
INPU6	LXI	H,00000H	;LOESCHE EINGABE REGISTER
        MVI     D,00H
	MOV	C,A
	CALL	HEXZIF		;PRUEFE OB HEXZIFFER
        JC      INP6            ;NEIN NEUE EINGABE
        MOV     L,A             ;ERSTE ZIFFER DIREKT NACH HL
        CALL    CONOUT          ;GEBE ZIFFER AUS
INP63   CALL    CONIN
        CPI     0DH             ;RETURN?
        JZ      INP64
	MOV	C,A
        CALL    HEXZIF
        JC      INP63
        CALL    CONOUT
	MOV	E,A
        DAD     H
        DAD     H
        DAD     H
        DAD     H
        DAD     D
        JMP     INP63
INP64   MOV     A,L	;LETZTEN ZWEI ZIFFERN ABSPEICHERN
        STA     SPZAHL
;
;
;
INPUT7  LXI     H,FRAGE7
        CALL    SOUT
INP7	CALL	CONIN
        CPI	'J'
        JZ      LOOS
        CPI     'N'
        JNZ     INP7
        MOV     C,A
        CALL    CONOUT
        JMP     NLAUF
LOOS    MOV     C,A
        CALL    CONOUT
;
; ALLES OK, INITIALISIERE
;
;
	MVI	A,2		;SETZE PRECOMPENSATION AUF FESTEN WERT
	CALL	SEND$PRECOM	;
;
;
;
	LDA	SPZAHL		;WENN 0 SPUREN ZU INITIALISIEREN
        ORA     A       	;DONN DUSCHDE NIX DOUN
        JZ      NLAUF		;
	LDA	LWNR		;SETZE PARAMETER IN CMDTAB
        STA     UNIT
SLOOP:				;
	CALL	SENSD		; SCHREIBGESCHUETZT ?
	BIT	6,A		;
	JZ	SLOOP2		; SPRUNG WENN NEIN
				;
	LXI	H,PTXT		;
	CALL	SOUT		;
PMSG1	CALL	CONIN		;
	CPI	'J'		;
	JZ	OSLOOP		;
	CPI	'N'		;
	JZ	ONLF		;
	JMP	PMSG1		;
				;
OSLOOP	MOV	C,A	;
	CALL	CONOUT	;
	JMP	SLOOP	;
			;
ONLF	MOV	C,A	;
	CALL	CONOUT	;
	JMP	NLAUF	;
			;
			;
SLOOP2:			;
	LXI	H,ETXT	;
	CALL	SOUT	;
        XRA     A       ;TRACK 0
        STA     TRACK
        STA     HEAD
        INR     A
        STA     SECTOR
	CALL	RECAL	;SPUR 0 EINSTELLEN
	LDA     MINIMAX ;MINI ODER MAXI?
        ORA     A
        JNZ     MINI    ;SETZE PARAMETER FUER MINI
;
MAXI:
	CALL	GETPAR
	LDA	DENS
	STA	DENSI
	CALL	MAXIS
        JMP     FZIL            ;EINEN ZYLINDER INIT.
;
MINI:
	CALL	GETPAR
	LDA	DENS
	STA	DENSI
        CALL    MINIS
;
FZIL:
	LDA	UNIT	;SETZE SEITE NULL
        ANI     03H
        STA     UNIT
        XRA     A
        STA     HEAD
        CALL    FTRACK
;
        LDA     ZWEISD	;MUSS AUCH NOCH SEITE EINS FORMATIERT WERDEN
        ORA     A
        JZ      FZIL1   ;NEIN
FZIL2:
        LDA     UNIT
        ORI     04H     ;SEITE EINS AUSWAEHLEN
        STA     UNIT
        MVI     A,01H
        STA     HEAD
        CALL    FTRACK
FZIL1:
        LDA     SPZAHL	;ALLES FORMATIERT?
        DCR     A
        JZ      FZILEND ;JA => ZURUECK IN HAUPTSCHLEIFE
        STA     SPZAHL  ;NEUE SPURZAHL
        LDA     TRACK   ;ERHOEHE SPUR NR. UM EINS
        INR     A
        STA     TRACK
        CALL    SEEK    ;STELLE SPUR NR. EIN
        CALL    GETPAR  ;TRAGE PARAMETER EIN
	LDA	DENS	;COPIERE DICHTE AUS EINGABE
	STA	DENSI
        JMP     FZIL    ;NEUEN ZYLINDER FORMATIREN
;
FZILEND:
	LXI	H,ENDTXT
	CALL	SOUT
	call	recal
	JMP	NLAUF
;
;
;DIESES UP FORMATIERT EINE SPUR
;IN CMDTAB MUSS DIE LW.NR.,DIE SEITE, DIE SPUR UND DIE SEK.NR STEHEN
;IN SCSL SEHT DIE ANZAHL DER SEK./SPUR UND DIE SEK. GROESSE
;IN DATAGAB STEHT GAPLAENGE UN FUELLBYTE
;IN DENSI STEHT 00 FUER SINGLE DENSITY UND 40 FUER DD
;
FTRACK:
	LHLD	UNIT		;SETZTE AUF NONDMA BETRIEB
	PUSH	H		;
	lhld	specd$word
	mvi	a,1
	ora	h
	mov	h,a
	LXI	B,0303H		;
	SHLD	UNIT		;
	CALL	CMFD		;
	POP	H		;
	SHLD	UNIT		;
				;
	LXI	H,SPTXT	;GEBE SPUR NR AUS
	CALL	SOUT	;
	LDA	TRACK	;
	CALL	NMOUT	;	
	LXI	H,KTXT	;
	CALL	SOUT	;
	LDA	HEAD	;
	ADI	31H	;
	MOV	C,A	;
	CALL	CONOUT	;
			;
	LHLD	TRACK
        SHLD    FTAB
        PUSH    H	;RETTEN UM CMDTAB ZU REGENERIERN
        LHLD    SECTOR  ;SEKTOR UND N RETTEN
        PUSH    H
        MVI     A,1     ;SEKTOR ZAEHLER SETZEN
        STA     FTAB+2
        LHLD    SCSL    ;SEKTORANZAHL UND LAENGE LADEN
	MOV     A,L     ;SEK. LAENGE MUSS AUCH NACH FTAB
        STA     FTAB+3
        SHLD    TRACK
        LHLD    DATAGAP ;INHALT UND GAPLAEGE LADEN
        SHLD    SECTOR
        LDA     DENSI    ;FORMATBEFEHL ERZEUGEN
        MVI     C,0DH   ;GRUND BEFEHL
        ORA     C       ;JETZT MIT ODER OHNE MFM-BIT
        MOV     C,A     ;IN REG C UMLADEN FUER MOTO
        MVI     B,06H   ;6 BYTES SIND ZU UEBERTRAGEN
        CALL    MOTO    ;GEBE KOMMANDO AUS
        LXI     H,FTAB-1;ZEIGER AUF FTAB
        LDA     SCSL+1  ;ANZAHL DER SEKTOREN
        MOV     D,A     ;NACH D LADEN
        INX     H
F00     PUSH    H       ;ZEIGER ADDRESSE RETTEN
        MVI     B,4     ;VIER BYTES AUSGEBEN
F01     IN      FDC     ;REQUEST FOR MASTER
        RLC  
        JNC     F01
        MOV     A,M     ;BYTE AUSGEBEN
        OUT     FDD
        INX     H
        DCR     B
        JNZ     F01
        DCR     D
        JZ      F02	;OK,SPUR IST FORMATIERT
        DCX     H
        DCX     H       ;SEKTOR UM EINS WEITER ZAEHLEN
        INR     M
        POP     H       ;ALTER ZEIGER
        JMP     F00     ;NAECHSTER SEKTOR FORMATIEREN
F02     POP     H
        CALL    RESULT  ;ERGEBNIS HOLEN
        POP     H       ;CMDTAB WIEDER HERSTELLEN
        SHLD    SECTOR
        POP     H
        SHLD    TRACK
	RET
;
;
;
WBOOT1	CALL	MAXIS	;AUF MAXI FUER STANDART SYSTEM
	JMP	WBOOT
;
;
;
SENSD	LXI	B,0204H	;SENSE DRIVE
        CALL    CMFD
        CALL    NEXT
        RET
;
;
;
;BERRECHNET AUS SEKGR, DENS UND MINIMAX
;DIE WERTE FUER SCSL UND DATAGAP
;
GETPAR  PUSH    PSW
        PUSH    B
        PUSH    D
        PUSH    H
       	LDA	MINIMAX
        ORA     A
        JNZ     MIPAR
        LDA     DENS	;WELCHE DICHTE?
        ORA     A
        JNZ     MADD
	LXI	D,MAXISD
        JMP     GETBR
MADD    LXI     D,MAXIDD
        JMP     GETBR
MIPAR   LDA     DENS
        ORA     A
        JNZ     MIDD
        LXI     D,MINISD
        JMP     GETBR
MIDD    LXI     D,MINIDD
;
GETBR:
	MVI	H,0
        LDA     SEKGR
        MOV     L,A
        DAD     H
        DAD     D	;HL ZEIGT JETZT AUF DIE RICHTIGEN PARAMETER
;
        MOV     E,A     ;SEKTOR GROESSE NACH REG. E
        MOV     D,M     ;SEKTOR ANZAHL NACH REG. D
        INX     H
        MOV     L,M     ;GPL NACH M
        MVI     H,FILLBYT
        SHLD    DATAGAP
        XCHG    
        SHLD    SCSL
;
        POP     H
        POP     D
        POP     B
        POP     PSW
        RET
;
;
;
HEXZIF:
	;WANDELT ASCII ZEICHEN IN HEXADEZIMAL ZIFFER
        ;EINGABE IN REG.C AUSGABE IN REG.A
        ;BEI FEHLER WIRD CARRY-FLAG GESETZT
	MOV 	A,C	;ZEICHEN NACH A
	SUI	30H
        RC		;FEHLER RETURN MIT CARRY
        CPI	0AH
        CMC
        RNC		;RETURN , WERT SCHON DA
        CPI	11H
        RC              ;FEHLER (ZWISCHEN 3A UND 40)
        SUI     7
        CPI     10H
        CMC
        RET
;
;
NMOUT:
	;GIBT AKKU INHALT ALS HEXZAHL AUS
	PUSH	B	;RETTE BC REG
        PUSH    PSW
        RRC
        RRC
        RRC
        RRC
        ANI	0FH	;OBERE ZIFFER 0
        CALL    PRVAL   ;WANDLE NACH ASCII
        CALL    CONOUT  ;GEBE ZEICHEN AUS
        POP     PSW     ;HOLE ORG. BYTE
        ANI     0FH
        CALL    PRVAL
        CALL    CONOUT
        POP     B	;RESTORE BC
        RET
;
;
PRVAL:
	;WANDELT INTEGER IN A (RANGE 0-F)
        ;IN ASCII ZEICHEN (REG. C)
	ANI	0FH     ;LOESCHE OBERE 4 BITS
	CPI	0AH	;A-F?
        JNC     PRVAL1  ;JA
        ADI     30H     ;0-9 => ADDIERE 30H DAZU
        MOV     C,A  
        RET
PRVAL1  ADI     37H     ;A-F => ADDIERE 37H DAZU
	MOV	C,A
        RET
;
;
;
SOUT:
        ;GIBT ASCIISTRING AUS (ANFANG IN HL,ENDE DURCH $)
        MOV	A,M
	CPI	24H	;ENDE DES STRINGS ?
        RZ
        MOV     C,A
        CALL    CONOUT
        INX     H
        JMP     SOUT
;
;
;
CONOUT	PUSH	PSW
        PUSH    B
        PUSH    D
        PUSH    H
        MOV     E,C
        MVI     C,06H
        CALL    BDOS
        POP     H
        POP     D
        POP     B
        POP     PSW
        RET
;
;
;
CONIN	PUSH	B
        PUSH    D
        PUSH    H
LOOT	MVI	E,0FFH	;INPUT
        MVI     C,06H
        CALL    BDOS
        CPI     00
        JZ      LOOT
	CPI	'a'	;WANDLE IN GROSSBUCHSTABEN
	JRC	CONIN1
	SUI	'a'-'A'
CONIN1	POP     H
        POP     D
        POP     B
        RET
;
;
;
;
;
;
;
;
;ASCII-STRINGS
;
HEADPMT DB	0AH,0DH
	DB	'***************************************************'
	DB	0AH,0DH
	DB	'***                                             ***'
        DB	0AH,0DH
        DB      '***         Disketten Formatier-Programm        ***'
	DB	0AH,0DH
	DB	'***         Version: 1.0                        ***'
        DB      0AH,0DH
	DB	'***         PROF180x                            ***'
        DB      0AH,0DH
        DB      '***************************************************'
        DB      0AH,0DH
        DB      24H
FRAGE1  DB      0AH,0DH
	DB	0AH,0DH
	DB	'***  welches Laufwerk ?  (oder RETURN fuer CP/M) :'
        DB	24H
FRAGE2	DB	0AH,0DH
	DB	'***  Handelt es sich um ein Mini-Laufwerk ? (J/N):'
	DB	24H
FRAGE3	DB	0AH,0DH
	DB	'***  single sided (0) ,  oder double sided (1) ? :'
        DB      24H
FRAGE4	DB	0AH,0DH
        DB      '***  single density (S), oder double density (D)?:'
        DB	24H
FRAGE5A DB      0AH,0DH
        DB	'***  Sektorgroesse  ? ( 0=128,1=256,2=512 BYTE ) :'
	DB	24H
FRAGE5B DB	0AH,0DH
        DB      '***  Sektorgroesse  ? (1=256,2=512,3=1024 BYTE ) :'
        DB      24H
FRAGE6  DB	0AH,0DH
        DB      '***  Anzahl der Spuren (in Hexadezimal-Ziffern)? :'
        DB      24H
FRAGE7  DB      0AH,0DH
        DB      '***  pruefen Sie Ihre Angaben - alles ok ? (J/N) :'
        DB      24H
ETXT	DB	0AH,0DH,0AH
	DB	'***  Beginn der Formatierung                    ***'
	DB	0DH,0AH,24H
PTXT	DB	0AH,0DH,0AH
	DB	'***  bitte entfernen Sie den Schreibschutz (J/N) :'
	DB	24H
SPTXT	DB	0DH,'***  Spur Nr: $'
KTXT	DB	' Seite: $'
ENDTXT	DB	' Ende der Formatierung ***$'
;
;
;
;ZUORDNUNGS TABELLEN FUER MAXI SD, MAXI DD
;                         MINI SD, MINI DD
;SEKTOR GROESSE ZU ANZAHL/SPUR UND GPL
;
MAXISD	DB	26	;SEK/SPUR
        DB      1BH     ;GPL 
;
        DB      15
        DB      2AH
;
        DB      8
        DB      3AH
;
        DW      0	;NICHT RELEVANT
;
MAXIDD  DW      0       ;NICHT RELEVANT
;
        DB      26
        DB      36H
;
        DB      15
        DB      54H
;
        DB      8
        DB	74H
;
MINISD  DB      18
        DB      07H
;
        DB      10
        DB      1BH
;
        DB      5
        DB      2AH
;
        DW      0	;NICHT RELEVANT
;
MINIDD  DW      0       ;NICHT RELEVANT
;
        DB      16
        DB      2AH
;  
        DB      10
        DB      2AH
;
        DB      5
        DB      3AH
;
;
;
SCSL	DB	0
        DB      26
DATAGAP DB      1BH
	DB	FILLBYT
;
;
;
;-------------------------------------------------------------------
;
;
;
SWITCHCODE:	;DIESER BEREICH WIRD NACH EPROMCODE
		;KOPIERT, DAMIT MONITOR UP'S BENUTZT WERDEN
		;KOENNEN
;
;
;
NEXTOFF		EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MNEXT
		CALL	EPROMOFF
		RET
;
MOTOOFF		EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MMOTO
		CALL	EPROMOFF
		RET
;
CMFDOFF		EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MCMFD
		CALL	EPROMOFF
		RET
;
SEEKOFF		EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MSEEK
		CALL	EPROMOFF
		RET
;
RECALOFF	EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MRECAL
		CALL	EPROMOFF
		RET
;
RESULTOFF	EQU	$-SWITCHCODE
		CALL	EPROMON
		CALL	MRESULT
		CALL	EPROMOFF
		RET

MAXISOFF	equ	$-switchcode
		call	epromon
		call	mmaxiset
		call	epromoff
		ret

MINISOFF	equ	$-switchcode
		call	epromon
		call	mminiset
		call	epromoff
		ret

SEND$PRECOMOFF	equ	$-switchcode
		call	epromon
		call	mbasic$precom
		call	epromoff
		ret
;
;
;
EPROMONOFF	EQU	$-SWITCHCODE
		PUSH	PSW		;
		LDA	EPROMZ		;EPROM SCHON EINGESCHALTET?
		ORA	A		;DANN TUE NICHTS
		JRNZ	EPROMON1	;
		INR	A		;
		STA	EPROMZ		;
		mvi	a,0f1h
		out0	cbar,a
		POP	PSW		;
		RET			;
EPROMON1:	INR	A		;
		STA	EPROMZ		;
		POP	PSW		;
		RET			;
;
EPROMOFFOFF	EQU	$-SWITCHCODE
		PUSH	PSW		;
		LDA	EPROMZ		;
		DCR	A		;
		JRNZ	EPROMOFF1	;
		STA	EPROMZ		;
		mvi	a,0f0h
		out0	cbar,a
		POP	PSW		;
		RET			;
EPROMOFF1	STA	EPROMZ		;
		POP	PSW		;
		RET			;
;
NEXT		EQU	NEXTOFF+EPROMCODE
MOTO		EQU	MOTOOFF+EPROMCODE
CMFD		EQU	CMFDOFF+EPROMCODE
SEEK		EQU	SEEKOFF+EPROMCODE
RECAL		EQU	RECALOFF+EPROMCODE
maxis		equ	maxisoff+epromcode
minis		equ	minisoff+epromcode
RESULT		EQU	RESULTOFF+EPROMCODE
EPROMON		EQU	EPROMONOFF+EPROMCODE
EPROMOFF	EQU	EPROMOFFOFF+EPROMCODE
send$precom	equ	send$precomoff+epromcode
;
EPROMCODEL	EQU	$-SWITCHCODE
;
;
;
;-------------------------------------------------------------------
;
;
;
FTAB	DS	1
        DS      1
        DS      1
        DS      1
;
;
;
;NACHFOLGEND WERDEN DIE EINGABE PARAMETER ABGESPEICHERT
LWNR	DS	1
MINIMAX DS      1
ZWEISD  DS      1
DENS    DS      1
SEKGR   DS      1
SPZAHL  DS      1
;
;
;ZWISCHEN SPEICHER
DENSI   DS	1
;
;
;
;
;------------------------------------------------------------------
				;
	END
