;*********************************************************
;***                                                   ***
;***  CP/M 2.2 BIOS FUER PROF-180x COMPUTER            ***
;***                                                   ***
;***  LETZTE AENDERUNG AM: 29.08.1986 (Heydenbluth)    ***
;***                                                   ***
;*********************************************************
;
		TITLE	'CP/M 2.2 BIOS FUER PROF-180x COMPUTER'
		;
		;
		maclib	psys
		maclib	pvec
		MACLIB	hd64180
		MACLIB	pdef
		;
		;
MSIZE		EQU	61	;CP/M MEMORY SIZE IN K-BYTE
BIAS		EQU	(MSIZE-20)*1024
CCP		EQU	3400H+BIAS
BDOS		EQU	CCP+806H
BIOS		EQU	CCP+1600H
CDISK		EQU	0004H	;LAUFWERKSNUMMER
IOBYTE		EQU	0003H	;INTEL I/O BYTE
		;
		;
RAM$DRIVE	EQU	4	;DRIVE NUMMER DER RAM FLOPPY
				;4=E,5=F,........15=P
		;
WRALL		EQU	0	;WRITE TO ALLOCATED
WRDIR		EQU	1	;WRITE TO DIRECTORY
WRUAL		EQU	2	;WRITE TO UNALLOCATED
		;
BELL		EQU	07H
		;
		;
		;
		ORG	BIOS
;
;
;SPRUNGTABELLE FUER BIOS ROUTINEN
boote	JMP	BOOT-(ccp-4900h)
WBOOTE	JMP	WBOOT
	JMP	CONST
	JMP	CONIN
	JMP	CONOUT
	JMP	LIST
	JMP	PUNCH
	JMP	READER
	JMP	HOME
	JMP	SELDSK
	JMP	SETTRK
	JMP	SETSEC
	JMP	SETDMA
	JMP	READ
	JMP	WRITE
	JMP	LISTST
	JMP	SECTRAN
;
;
;
DBASE	DW	0000H,0000H
	DW	0000H,0000H
	DW	DIRBF,0000H
	DW	CHK00,ALL00
;
	DW	0000H,0000H
	DW	0000H,0000H
	DW	DIRBF,0000H
	DW	CHK01,ALL01
;
	DW	0000H,0000H
	DW	0000H,0000H
	DW	DIRBF,0000H
	DW	CHK02,ALL02
;
	DW	0000H,0000H
	DW	0000H,0000H
	DW	DIRBF,0000H
	DW	CHK03,ALL03
;
RAMDPH	DW	NOSKEW,0000H
	DW	0000H,0000H
	DW	DIRBF,FLOPPYBLK
	DW	0000H,ALL04
;
;
;
BOOT:
	;das Betriebssystem wurde in den Bereich ab 04900h geladen
	;(Endadresse je nach Laenge), es wird nach 4d800h verschoben
	;Bei 128k belegt die Ramfloppy den Bereich 02000h - 0efffh
	;Bei 512k die Bereiche 02000h - 03ffffh und 50000h - 7efffh
	;Eine Kopie des CCP und BDOS befindet sich im
	;Bereich 0900h - 1effh (1600h Laenge)
	;Dem logischen Adressbereich 0f000h -0ffffh ist in jedem Fall
	;auch der physikalische Adressbereich 0f000h - 0ffffh 
	;zugeordnet.
;
;kopiere nach d800h
;
	di
	lxi	b,0fe00h-0d800h
	lxi	d,0d800h
	lxi	h,04900h
	ldir
;
;kopiere ccp und bdos nach 0900h
;
	lxi	d,0900h
	lxi	h,04900h
	lxi	b,01600h
	ldir
;
;verschiebe mit DMA 04900h - 6effh nach 4d800h
;
	xra	a
	out0	sar0l,a
	out0	dar0l,a
	out0	sar0b,a
	out0	bcr0l,a
	mvi	a,049h
	out0	sar0h,a
	mvi	a,0d8h
	out0	dar0h,a
	mvi	a,4
	out0	dar0b,a
	mvi	a,(0fe00h-0d800h) shr 8
	out0	bcr0h,a
	mvi	a,11000011b	;memory -> memory, aufwaertszaehlend
	out0	dmode,a
	mvi	a,01100011b
	out0	dstat,a		;transfer beginnt
;
;
	LXI	H,WBOOTE	;SETZE UMLEIT VEKTOREN
	SHLD	UMLEIT$GETCM+1	;DER PROF-180x SYSTEMPAGE
	lxi	h,conout	;setze umleit vektoren
	shld	mco+1		;der Epromkopie
	lxi	h,conin
	shld	mci+1
	lxi	h,const
	shld	mcs+1
;
;loesche directory der ramfloppy
;
	mvi	a,0f0h
	out0	cbar,a
	mvi	a,040h
	out0	cbr,a
	lxi	h,0f000h
	mvi	m,0e5h
	lxi	d,0f001h
	lxi	b,0fffh
	ldir
	xra	a
	out0	cbr,a
;
;jetzt kann der logische adressbereich der tpa-bank zugeordnet werden
;
	jmp	cont		;dieser sprung ist wichtig
cont:	mvi	a,0f0h
	out0	cbar,a
	mvi	a,40h
	out0	bbr,a
;
	XRA	A		;
	STA	EPROMZ		;
	LDA	IO$JUMPERBYTE	;SETZE IOBYTE ENTSPRECHEND
	MOV	L,A		;DEM IO$JUMPERBYTE
	MVI	H,0		;
	LXI	D,IOBYTELIST	;
	DAD	D		;
	MOV	A,M		;
	STA	IOBYTE		;
				;
	lda	ram$chips	;stelle fest, ob 128k oder 512k
	ora	a
	jrnz	r512		;sprung wenn 512k
	lxi	h,floppyblk1
	shld	ramdph+10
				;
r512:	XRA	A		;AKKU=0
	STA	CDISK		;SELECT DISK A
	MVI	B,CSUML		;WURDE GANZES BIOS GELADEN?
	LXI	H,COPRGHT	;ACHTUNG, AKKU MUSS NULL SEIN
BOOT11	ADD	M		;
	INX	H		;
	DJNZ	BOOT11		;
	CPI	CSUM		;
	JRNZ	NOTLOAD		;MELDUNG WENN NICHT VOLLSTAENDIG GELADEN
				;
	LXI	H,PROMT		;
	CALL	SOUT		;
	JMP	GOCPM		;
				;
IOBYTELIST:			;DIESE LISTE GIBT DIE IOBYTE DEFAULTWERTE
				;FUER FUENF IO$JUMPERBYTE WERTE AN
	DB	00000000B	;KEIN JUMPER AUF J4
	DB	01010101B	;J4/1-3
	DB	01010110B	;J4/2-4
	DB	01010111B	;J4/3-5
	DB	01010110B	;J4/4-6
;
;
;
NOTLOAD:
	LXI	H,NLTXT		;GEBE FEHLERMELDUNG AUS
	CALL	SOUT		;
DEADLP	JR	DEADLP		;FEIERABEND
NLTXT	DB	BELL,0DH,0AH,'Error, BIOS not complete$'
;
;
;
WBOOT:
	mvi	a,3		;ermoegliche cp/m autostart nur bei kaltstart
	sta	wboot1+1
	CALL	EPROM$OFF2	;SCHALTE ALS ERSTES EPROM WEG
	LXI	SP,BIOSSTACK	;
	CALL	CCP$MOVE$ON	;
	JMP	GOCPM		;
;
;
;
GOCPM:
	;INITIALISIERE NOCH EINIGES
	;UND UEBERGEBE DANN KONTROLLE AN CCP
	;
	MVI	A,0C3H		;SETZE WARM BOOT EINSPRUNG
	STA	0000H		;UND BDOS-EINSPRUNG
	STA	0005H		;IN PAGE 0
	mvi	a,0c9h
	sta	boote		;der Einsprung BOOT darf nicht mehr benutzt werden
	lxi	h,0180h
	shld	dispadr		;psysgen prueft, ob hier 0180h steht
	LXI	H,WBOOTE	;
	SHLD	0001H		;
	LXI	H,BDOS		;
	SHLD	0006H		;
	LXI	B,80H		;SETZE DEFAULT
	CALL	SETDMA		;DMA-ADRESSE
				;
	XRA	A		;
	STA	HSTACT		;HOST BUFFER INACTIVE
	STA	UNACNT		;CLEAR UNALLOC COUNT
	STA	EPROMZ		;EPROM IST AUSGESCHALTET
				;
	mvi	a,4		;SETZE CURRENT BANK BYTE
	STA	CURRENT$BANK	;
				;
	LDA	CDISK		;LADE LAUFENDE DISK-NR
	MOV	C,A		;
wboot1:	JMP	CCP		;UND SPRINGE ZUM CCP
;
;
;
SOUT:
	;GIBT ASCIISTRING AUS (ANFANG IN HL,ENDE DURCH $)
	MOV	A,M		;
	CPI	24H		;ENDE DES STRINGS ?
	RZ
	MOV	C,A
	CALL	CONOUT
	INX	H
	JMP	SOUT
;
;
;
EPROM$ON:
	;SCHALTE STACK AUF BIOSSTACK UM UND
	;RETTE DEN ALTEN STACKPOINTER STAND
	;SCHALTE DANN EPROM-BEREICH EIN
	;
	PUSH	PSW		;
	LDA	EPROMZ		;
	ORA	A		;EPROM SCHON AN?
	JRNZ	EPROM$ON3	;
	INR	A		;
	STA	EPROMZ		;
	POP	PSW		;
	SHLD	TEMP2		;SAVE HL
	POP	H		;
	SSPD	USERSTACK	;SAVE OLD STACK
	LXI	SP,BIOSSTACK	;
	PUSH	H		;
	LHLD	TEMP2		;
EPROM$ON2:
	PUSH	PSW		;
	mvi	a,0f1h		;schalte kopie des eproms in adressbereich
	out0	cbar,a		;0-0fffh
	POP	PSW		;
	RET
EPROM$ON3:
	INR	A		;
	STA	EPROMZ		;
	POP	PSW		;
	RET
;
;
;
EPROM$OFF:
	;SCHALTE EPROM-BEREICH WEG
	;SCHALTE DANN STACKPOINTER WIEDER
	;AUF USER-STACK UM
	;
	PUSH	PSW		;
	LDA	EPROMZ		;
	DCR	A		;
	JRNZ	EPROM$OFF3	;
	STA	EPROMZ		;
	POP	PSW		;
	CALL	EPROM$OFF2	;
	SHLD	TEMP2		;
	POP	H		;
	LSPD	USERSTACK	;
	PUSH	H		;
	LHLD	TEMP2		;
	RET			;
				;
EPROM$OFF2:			;SCHALTE kopie des EPROM WEG
	PUSH	PSW		;
	mvi	a,0f0h
	out0	cbar,a
	POP	PSW		;
	RET			;
EPROM$OFF3:
	STA	EPROMZ		;
	POP	PSW		;
	RET
;
;
;
CCP$MOVE$ON:
	;verschiebt ccp und bdos von 0900h - 1effh nach 4d800h
;
;verschiebe mit DMA 0900h - 01effh nach 4d800h
;
	xra	a
	out0	sar0l,a
	out0	dar0l,a
	out0	sar0b,a
	out0	bcr0l,a
	mvi	a,09h
	out0	sar0h,a
	mvi	a,0d8h
	out0	dar0h,a
	mvi	a,4
	out0	dar0b,a
	mvi	a,16h
	out0	bcr0h,a
	mvi	a,11000011b	;memory -> memory, aufwaertszaehlend
	out0	dmode,a
	mvi	a,01100010b
	out0	dstat,a		;transfer beginnt
	RET
;
;
;
;---------------------LOGISCHE I/O ROUTINEN--------------------
;
;
;
CONST:
	LDA	IO$JUMPERBYTE	;CONSOLEN STATUS
	CALL	VERTEILER	;
	DW	GRAFIST		;
	DW	DUPLEXIST	;
	DW	USER1IST	;
	DW	USER2IST	;
;
;
;
CONIN:
	LDA	IO$JUMPERBYTE	;CONSOLEN EINGABE
	CALL	VERTEILER	;
	DW	GRAFIN		;
	DW	DUPLEXIN	;
	DW	USER1IN		;
	DW	USER2IN		;
;
;
;
CONOUT:
	LDA	EPROMZ		;
	ORA	A		;KOPIERE IOBYTE
	JRNZ	CONOUT1		;
	LDA	IOBYTE		;
	ANI	00000011B	;
	STA	IO$JUMPERBYTE	;
CONOUT1	LDA	IO$JUMPERBYTE	;CONSOLEN AUSGABE
	CALL	VERTEILER	;
	DW	GRAFOUT		;
	DW	DUPLEXOUT	;
	DW	USER1OUT	;
	DW	USER2OUT	;
;
;
;
LIST:
	LDA	IOBYTE		;DRUCKER AUSGABE
	RLC			;
	RLC			;
	CALL	VERTEILER	;
	DW	SPOOLEROUT	;
	DW	SIMPLEXOUT	;
	DW	USER1OUT	;
	DW	USER2OUT	;
;
;
;
LISTST:
	LDA	IOBYTE		;DRUCKER STATUS
	RLC			;
	RLC			;
	CALL	VERTEILER	;
	DW	SPOOLEROST	;
	DW	SIMPLEXOST	;
	DW	USER1OST	;
	DW	USER2OST	;
;
;
;
PUNCH:
	LDA	IOBYTE		;
	RRC			;
	RRC			;
	RRC			;
	RRC			;
	CALL VERTEILER		;
	DW	DUPLEXOUT	;
	DW	SIMPLEXOUT	;
	DW	USER1OUT	;
	DW	USER2OUT	;
;
;
;
READER:
	LDA	IOBYTE		;
	RRC			;
	RRC			;
	CALL	VERTEILER	;
	DW	DUPLEXIN	;
	DW	DUPLEXIN	;
	DW	USER1IN		;
	DW	USER2IN		;
;
;
;
VERTEILER:
	ANI	00000011B	;MASKIERE AKKU
	XTHL			;LEGE RETURN ADRESSE IN HL
VERTEILER1:
	DCR	A		;WAR AKKU NULL?
	JM	VERTEILER2	;DANN ZEIGT HL AUF DIE RICHTIGE ADRESSE
	INX	H		;EINE ADRESSE WEITER
	INX	H		;
	JR	VERTEILER1	;
VERTEILER2:
	MOV	A,M		;LADE ADRESSE IN HL
	INX	H		;
	MOV	H,M		;
	MOV	L,A		;
	XTHL			;
	RET
;
;
;
;-----------------------PHYSIKALISCHE I/O ROUTINEN------------
;
;
;
DUPLEXIST:
	CALL	EPROM$ON
	CALL	MDUPLXIST
	CALL	EPROM$OFF
	RET
;
DUPLEXIN:
	CALL	EPROM$ON
	CALL	MDUPLXIN
	CALL	EPROM$OFF
	RET
;
DUPLEXOUT:
	CALL	EPROM$ON
	CALL	MDUPLXOUT
	CALL	EPROM$OFF
	RET
;
SIMPLEXOUT:
	CALL	EPROM$ON
	CALL	EPROM$OFF
	RET
;
SIMPLEXOST:
	CALL	EPROM$ON
	CALL	EPROM$OFF
	RET
;
USER1IN:
	CALL	EPROM$ON
	CALL	mgradeIN
	CALL	EPROM$OFF
	RET
;
USER1OUT:
	CALL	EPROM$ON
	CALL	mgradeOUT
	CALL	EPROM$OFF
	RET
;
USER1IST:
	CALL	EPROM$ON
	CALL	mgradeIST
	CALL	EPROM$OFF
	RET
;
USER1OST:
	CALL	EPROM$ON
	CALL	mgradeOST
	CALL	EPROM$OFF
	RET
;
USER2IN:
	CALL	EPROM$ON
	CALL	MUSERIN
	CALL	EPROM$OFF
	RET
;
USER2OUT:
	CALL	EPROM$ON
	CALL	MUSEROUT
	CALL	EPROM$OFF
	RET
;
USER2IST:
	CALL	EPROM$ON
	CALL	MUSERIST
	CALL	EPROM$OFF
	RET
;
USER2OST:
	CALL	EPROM$ON
	CALL	MUSEROST
	CALL	EPROM$OFF
	RET
;
GRAFIN:
	CALL	EPROM$ON
	CALL	MGRAFIN
	CALL	EPROM$OFF
	RET
;
GRAFOUT:
	MOV	A,C
	ANI	7FH
GRAFOUT1:
	MOV	C,A
	CALL	EPROM$ON
	CALL	MGRAFOUT
	CALL	EPROM$OFF
	RET
;
GRAFIST:
	CALL	EPROM$ON
	CALL	MGRAFIST
	CALL	EPROM$OFF
	RET
;
SPOOLEROUT:
	MOV	A,C
	ORI	80H
	JR	GRAFOUT1
;
SPOOLEROST:
	CALL	EPROM$ON
	CALL	MGRAFOST
	CALL	EPROM$OFF
	RET
;
;
;
;--------------I/O TREIBER FUER DISK FOLGEN-------------
;
;
;
HOME:
	LDA	SEKDSK		;
	CPI	RAM$DRIVE	;RAM FLOPPY
	JRZ	HOME1		;
	STA	UNIT		;
	CALL	EPROM$ON	;
	CALL	MRECAL	;
	CALL	EPROM$OFF	;
HOME1	LXI	H,0		;SELECT TRACK ZERO
	SHLD	SEKTRK		;
	RET
;
;
;
SELDSK:
	LXI	H,0000H		;ERROR RETURN CODE
	MOV	A,C
	CPI	4		;DIE UNTEREN 4 LAUFWERKE
	JNC	SEL3		;SIND FLOPPYS, WEITERE AUSWAHL BEI SEL3
	STA	SEKDSK		;
				;
	MVI	A,001H		;WURDE LAUFWERK SCHON BENUTZT
	ANA	E		;
	JRNZ	SEL5		;SPRUNG WENN SCHON BENUTZT
				;
	CALL	TEST$FORMAT	;NOCH NICHT BENUTZT, TESTE FORMAT
	LXI	H,0		;
	ORA	A		;KONNTE FORMAT ERMITTELT WERDEN
	RNZ			;WENN NEIN RUECKSPRUNG
				;
	LDA	SEKDSK		;
	CALL	SET$HL$DISK	;TRAGE DPB UND TRANS IN DPH EIN
	INX	H		;
	INX	H		;
	INX	H		;
	INX	H		;
	MOV	C,M		;LADE DPB
	INX	H		;
	MOV	B,M		;IN BC JETZT DPB ADRESSE
	PUSH	B		;RETTE DPB ADRESSE
	INX	H		;LADE TRANS-VEKTOR ADRESSE
	MOV	C,M		;
	INX	H		;
	MOV	B,M		;IN BC JETZT TRANS ADRESSE
	CALL	SET$HL$DPH	;SETZE HL AUF ENTSPRECHENDEN DPH
	MOV	M,C		;TRAGE TRRANS IN DPH EIN
	INX	H		;
	MOV	M,B		;
	POP	B		;
	LXI	D,9		;DPB EINTRAG 9 BYTES SPAETER
	DAD	D		;
	MOV	M,C		;
	INX	H		;
	MOV	M,B		;OK,DPB IST EINGETRAGEN
				;
SEL5	CALL	SET$DEBLOCK$PAR	;SETZE DIE PARAMETER FUER DEBLOCKING
	CALL	SET$HL$DPH	;HL AUF DPH
	RET			;
				;
SET$HL$DPH:
	;SETZE HL AUF ADRESSE DES RICHTIGEN DPH
	LDA	SEKDSK		;
	MOV	L,A		;HL SHOULD CONTAIN DISK NO.
	MVI	H,0		;
	DAD	H		;MULTIPLY WITH 16
	DAD	H		;
	DAD	H		;
	DAD	H		;
	LXI	D,DBASE		;
	DAD	D		;
	RET			;
				;
				;
SEL3:	CPI	RAM$DRIVE	;RAM FLOPPY?
	RNZ			;NEIN RETURN
	MOV	A,C		;IN C STEHT NOCH DRIVE NO.
	STA	SEKDSK		;SETZE RAM FLOPPY DRIVE NR.
	LXI	H,FDEB		;SETZE RAM FLOPPY DEBLOCKING
	LXI	D,SEKTBLK	;
	LXI	B,5		;
	LDIR			;
	LXI	H,RAMDPH	;SETZE HL AUF DPH DER RAM FLOPPY
	RET			;ZURUECK ZUM BDOS
				;
FDEB	DB	8
	DB	16
	DB	0
	DB	0
	DB	16
;
;
;
SETTRK:
	MOV	H,B		;
	MOV	L,C		;
	SHLD	SEKTRK		;
	RET			;
;
;
;
SETSEC:
	MOV	A,C		;SECTOR UM EINS ERNIEDRIGEN
	DCR	A		;DA DIE DEBLOCKING ROUTINEN
	STA	SEKSEC		;VON SEKTOR NULL AUSGEHEN
	RET
;
;
;
SETDMA:
	MOV	L,C
	MOV	H,B
	SHLD	DMAADR1
	RET
;
;
;
SECTRAN:
	;BERECHNET ZU DEM IN REG. C GEGEBENEN
	;SEKTOR DEN SKEW-FAKTOR UND GIBT DEN
	;NEUEN SEKTOR IN HL AUS
	;BENUTZT DAZU DIE IN SELDSK GEWONNENEN WERTE
	;
	;
	SDED	TEMP1		;RETTE TRANS-VEKTOR IN TEMP1
	PUSH	B		;RETTE SEKTOR AUS BDOS
	MOV	B,C		;WANDLE IN HOSTSEKTOR
	LDA	SECSHF		;UM WIEVIEL BITS MUSS VERSCHOBEN WERDEN
SECTR1	ORA	A		;FERTIG ?
	JRZ	SECTR2		;SPRUNG WENN JA
	MOV	H,A		;RETTE A
	MOV	A,B		;B IN AKKU
	RRC			;SCHIEBE AKKU UM EINS NACH RECHTS
	ANI	07FH		;OBERSTES BIT = 0
	MOV	B,A		;ZURUECK IN B
	MOV	A,H		;ZAEHLER IN AKKU
	DCR	A		;EINS WENIGER
	JMP	SECTR1		;NOCHMAL
SECTR2	LDA	EOTRK		;WELCHE SEITE ?
	MOV	H,A		;
	MOV	A,B		;
	SUB	H		;SEKTOR GROESSER ALS EOT ?
	PUSH	PSW		;
	JRNC	SECTR3		;OK, WERT STIMMT DA ZWEITE SEITE
	MOV	A,B		;ALTER WERT WAR RICHTIG
SECTR3	MOV	C,A		;IN C FUER PSECTR
	CALL	PSECTR		;ERZEUGE SKEW-FAKTOR
	DCR	C		;WAR UM EINS ZU HOCH
	POP	PSW		;HOLE CARRY-FLAG VON OBEN
	JRC	SECTR4		;EOT MUSS NICHT ADDIERT WERDEN
	LDA	EOTRK		;ADDIERE EOT
	ADD	C		;
	MOV	C,A		;
SECTR4	LDA	SECSHF		;VERSCHIEBE WIEDER NACH LINKS
SECTR5	ORA	A		;FERTIG ?
	JRZ	SECTR6		;
	MOV	H,A		;
	MOV	A,C		;
	RLC			;UM EIN BIT NACH LINKS
	ANI	0FEH		;UNTERSTES BIT = 0
	MOV	C,A
	MOV	A,H		;
	DCR	A		;
	JMP	SECTR5
SECTR6	POP	D		;EINGANGS SEKTOR NACH E
	LDA	SECMSK		;BLENDE OBERE BITS AUS
	ANA	E		;
	ORA	C		;TEISEKTOREN DAZU
	MOV	L,A		;AUSGABE IST HL
	MVI	H,00H		;
	INX	H		;SOLL BEI EINS ANFANGEN
	RET
;
;
;
;*****************************************************
;*                                                   *
;*  THE READ ENTRY POINT TAKES THE PLACE OF          *
;*  THE PREVIOUS BIOS DEFINITION FOR READ            *
;*                                                   *
;*****************************************************
READ:
	;READ THE SELECTED CP/M SECTOR
	XRA	A
	STA	UNACNT
	MVI	A,1
	STA	READOP		;READ OPERATION
	STA	RSFLAG		;MUST READ DATA
	MVI	A,WRUAL
	STA	WRTYPE		;TREAT AS UNALLOC
	JMP	RWOPER		;TO PERFORM THE READ
;
;****************************************************
;*                                                  *
;*  THE WRITE ENTRY POINT TAKES THE PLACE OF        *
;*  THE PREVIOUS BIOS DEFINITION FOR WRITE          *
;*                                                  *
;****************************************************
WRITE:
	;WRITE THE SELECTED CP/M SECTOR
	XRA	A		;0 TO ACCUMULATOR
	STA	READOP		;NOT A READ OPERATION
	MOV	A,C		;WRITE TYPE IN C
	STA	WRTYPE
	CPI	WRUAL		;WRITE UNALLOCATED?
	JRNZ	CHKUNA		;CHECK FOR UNALLOC
;
;	WRITE TO UNALLOCATED, SET PARAMETERS
	LDA	SEKTBLK
	STA	UNACNT
	LDA	SEKDSK		;DISK TO SEEK
	STA	UNADSK		;UNADSK = SEKDSK
	LHLD	SEKTRK
	SHLD	UNATRK		;UNATRK = SECTRK
	LDA	SEKSEC
	STA	UNASEC		;UNASEC = SEKSEC
;
CHKUNA:
	;CHECK FOR WRITE TO UNALLOCATED SECTOR
	LDA	UNACNT		;ANY	UNALLOC REMAIN?
	ORA	A
	JRZ	ALLOC		;SKIP IF NOT
;
;	MORE UNALLOCATED RECORDS REMAIN
	DCR	A		;UNACNT = UNACNT-1
	STA	UNACNT
	LDA	SEKDSK		;SAME DISK?
	LXI	H,UNADSK
	CMP	M		;SEKDSK = UNADSK?
	JRNZ	ALLOC		;SKIP IF NOT
;
;	DISKS ARE THE SAME
	LXI	H,UNATRK
	CALL	SEKTRKCMP	;SEKTRK = UNATRK?
	JRNZ	ALLOC		;SKIP IF NOT
;
;	TRACKS ARE THE SAME
	LDA	SEKSEC		;SAME SECTOR?
	LXI	H,UNASEC
	CMP	M		;SEKSEC = UNASEC?
	JRNZ	ALLOC		;SKIP IF NOT
;
;	MATCH, MOVE TO NEXT SECTOR FOR FUTURE REF
	INR	M		;UNASEC = UNASEC+1
	LDA	CPMSPT
	CMP	M
	JRNC	NOOVF
;
;	OVERFLOW TO NEXT TRACK
	MVI	M,0		;UNASEC = 0
	LHLD	UNATRK
	INX	H
	SHLD	UNATRK		;UNATRK = UNATRK+1
;
NOOVF:
	;MATCH FOUND, MARK AS UNNECESSARY READ
	XRA	A		;0 TO ACCUMULATOR
	STA	RSFLAG		;RSFLAG = 0
	JMP	RWOPER		;TO PERFORM THE WRITE
;
ALLOC:
	;NOT AN UNALLOCATED RECORD, REQUIRES PRE-READ
	XRA	A		;0 TO ACCUMULATOR
	STA	UNACNT		;UNACNT = 0
	INR	A		;1 TO ACCUM.
	STA	RSFLAG		;RSFLAG	= 1
;
;*******************************************************
;*                                                     *
;*    COMMON CODE FOR READ AND WRITE FOLLOWS           *
;*                                                     *
;*******************************************************
RWOPER:
	;ENTER HERE TO PERFORM THE READ/WRITE
	XRA	A		;ZERO TO ACCUM.
	STA	ERFLAG		;NO ERRORS (YET)
	LDA	SECSHF
	MOV	B,A
	LDA	SEKSEC
	MOV	C,A
RWOP1	MOV	A,B
	ORA	A
	JRZ	RWOP2
	MOV	A,C
	ORA	A
	RAR
	MOV	C,A
	DCR	B
	JMP	RWOP1
RWOP2	MOV	A,C
	STA	SEKHST		;HOST SECTOR TO SEEK
;
;	ACTIVE HOST SECTOR?
	LXI	H,HSTACT	;HOST ACTIVE FLAG
	MOV	A,M
	MVI	M,1		;ALWAYS BECOMES 1
	ORA	A		;WAS IT ALREADY?
	JRZ	FILHST		;FILL HOST IF NOT
;
;	HOST BUFFER ACTIVE, SAME AS SEEK BUFFER?
	LDA	SEKDSK
	LXI	H,HSTDSK	;SAME DISK ?
	CMP	M		;SEKDSK =HSTDSK?
	JRNZ	NOMATCH
;
;	SAME DISK, SAME TRACK ?
	LXI	H,HSTTRK
	CALL	SEKTRKCMP	;SEKTRK = HSTTRK?
	JRNZ	NOMATCH
;
;	SAME DISK, SAME TRACK, SAME BUFFER?
	LDA	SEKHST
	LXI	H,HSTSEC	;SEKHST = HSTSEC?
	CMP	M
	JRZ	MATCH
;
NOMATCH:
	;PROPER DISK, BUT NOT CORRECT SECTOR
	LDA	HSTWRT		;HOST WRITTEN?
	ORA	A
	CNZ	WRITEHST	;CLEAR HOST BUFF
;
FILHST
	;MAY HAVE TO FILL THE HOST BUFFER
	LDA	SEKDSK
	STA	HSTDSK
	LHLD	SEKTRK
	SHLD	HSTTRK
	LDA	SEKHST
	STA	HSTSEC
	LDA	RSFLAG		;NEED TO READ?
	ORA	A
	CNZ	READHST		;YES, IF 1
	XRA	A		;0 TO ACCUM
	STA	HSTWRT		;NO PENDING WRITE
;
MATCH:
	;COPY DATA TO OR FROM BUFFER
	LDA	SEKSEC		;MASK BUFFER NUMBER
	MOV	L,A
	LDA	SECMSK		;LEAST SIGNIF BITS
	ANA	L
	MOV	L,A		;READY TO SHIFT
	MVI	H,0		;DOUBLE COUNT
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
;	HL HAS RELATIVE HOST BUFFER ADDRESS
	LXI	D,HSTBUF
	DAD	D		;HL = HOST ADDRESS
	LDED	DMAADR1		;GET/PUT CP/M DATA
	LXI	B,128		;LENGTH OF MOVE
	LDA	READOP		;WHICH WAY
	ORA	A
	JRNZ	RWMOVE
;
;	WRITE OPERATION, MARK AND SWITCH DIRECTION
	MVI	A,1
	STA	HSTWRT		;HSTWRT = 1
	XCHG
;
RWMOVE:
	;BC INITIALLY 128, DE IS DEST., HL IS SOURCE
	LDIR
;
;	DATA HAS BEEN MOVED TO/FROM HOST BUFFER
	LDA	WRTYPE		;WRITE TYPE
	CPI	WRDIR		;TO DIRECTORY
	LDA	ERFLAG		;IN CASE OF ERRORS
	RNZ			;NO FURTHER PROCESSING
;
;	CLEAR HOST BUFFER FOR DIRECTORY WRITE
	ORA	A		;ERRORS?
	RNZ			;SKIP IF 80
	XRA	A		;0 TOACCUM.
	STA	HSTWRT		;BUFFER WRITTEN
	CALL	WRITEHST
	LDA	ERFLAG
	RET
;
;;*******************************************************
;*                                                      *
;*    UTILITY SUBROUTINE FOR 16-BIT COMPARE             *
;*                                                      *
;********************************************************
SEKTRKCMP:
	;HL = .UNATRK OR .HSTTRK, COMPARE WITH SEKTRK
	XCHG
	LXI	H,SEKTRK
	LDAX	D		;LOW BYTE COMPARE
	CMP	M		;SAME?
	RNZ			;RETURN IF NOT
;	LOW BYTE EQUAL, TEST IF HIGH IS
	INX	D
	INX	H
	LDAX	D
	CMP	M	;SETS FLAGS
	RET
;
;******************************************************
;*                                                    *
;*   WRITEHST PERFORMS THE PHYSICAL WRITE TO          *
;*   THE HOST DISK. READHST READS THE PHYSICAL        *
;*   DISKS.                                           *
;*                                                    *
;******************************************************
;
;
;
WRITEHST:
	;HSTDSK = HOST DISK #.HSTTRK = HOST TRACK #.
	;HSTSEC = HOST SECT #.WRITE "HSTSIZ" BYTES
	;FROM HSTBUF AND RETURN ERROR FLAG IN ERFLAG.
	;RETURN ERFLAG NON-ZERO IF ERROR
;
	LDA	HSTDSK		;RAM-FLOPPY?
	CPI	RAM$DRIVE	;
	JRNZ	WRITEHST2	;
	JMP	RAM$FLOPPY$WRITE;
WRITEHST2:
	CALL	SETCMDTAB	;
	CALL	EPROM$ON	;SCHREIB ROUTINE BEFINDET
	CALL	MWRITE	;SICH IM EPROM
	CALL	EPROM$OFF	;
	STA	ERFLAG		;
	RET
;
;
;
READHST:
	;HSTDSK = HOST DISK #. HSTTRK = HOST TRACK #.
	;HSTSEC = HOST SECT #. READ "HSTSIZ" BYTES
	;INTO HSTBUF AND RETURN ERROR FLAG IN ERFLAG
	;
	LDA	HSTDSK		;PRUEFE OB RAM
	CPI	RAM$DRIVE	;FLOPPY
	JRNZ	READHST2	;
	JMP	RAM$FLOPPY$READ	;
READHST2:
	CALL	SETCMDTAB	;
	CALL	EPROM$ON	;LESE ROUTINE BEFINDET
	CALL	MREAD		;SICH IM EPROM
	CALL	EPROM$OFF	;
	STA	ERFLAG		;
	RET
;
;
;
;*************************************************************
;
;HILFS UNTERPROGRAMME
;
;
;
	TEST$FORMAT:
	;TESTET DAS FORMAT DER DISK, DIE SICH IM VON
	;SEKDSK SPEZIFIERTEN LAUFWERK BEFINDET UND VERGLEICHT
	;ES MIT DEN IN DISK$TYPE$LIST ERLAUBTEN FORMATEN.
	;IST DAS FORMAT NICHT ERKENNBAR, ODER IN DISK$TYPE$LIST
	;NICHT VEREINBART, SO KEHRT TEST$FORMAT MIT AKKU=0FFH
	;ZURUECK. KONNTE DAS FORMAT ERMITTELT WERDEN UND WAR ES AUCH IN
	;DISK$TYPE$LIST VEREINBART, DANN KEHRT TEST$FORMAT MIT AKKU=0
	;ZURUECK. IN DIESEM FALL WIRD IN ABHAENGIGKEIT VON SEKDSK
	;DER DISK-TYP IN DISK$TYPA, -B, -C ODER -D NEU GESETZT
	;DER DISK-TYP ENTSPRICHT DER LAUFENDEN NUMMER DES EINTRAGS
	;IN DER DISK$TYPE$LIST TABELLE.
	;bei mini laufwerken wird das dside-bit entsprechend der
	;80 track einstellung des monitors gesetzt
	;80 track = dside
	;40 track = sside
	;
	LDA	SEKDSK		;SETZE DAS ZU TESTENDE LAUFWERK
	STA	UNIT		;
	MVI	B,5		;FUENF TEST-VERSUCHE
	MVI	A,1		;AUF SPUR 1
	STA	TEST$TRACK	;
TESTF1:	PUSH	B		;
	CALL	EPROM$ON	;BENUTZE TEST-PROGRAMM
	CALL	MTEST		;AUS MONITOR
	CALL	EPROM$OFF	;
	POP	B		;
	ORA	A		;WAR TEST ERFOLGREICH?
	JRZ	TESTF3		;SPRUNG WENN JA
	DJNZ	TESTF1		;SONST MAXIMAL 5 VERSUCHE
TESTF2	MVI	A,0FFH		;SONST RUECKSPRUNG MIT AKKU=0FFH
	RET
				;OK, FORMAT DATEN STEHEN IN TEST$TYPE
				;UND IN TEST$TRACK
TESTF3:	
	lda	test$type
	ani	minif
	jrz	nchange
	lda	unit
	inr	a
	mov	b,a
	mvi	a,08h
testf5:	rlc
	djnz	testf5
	mov	b,a
	lda	seeknr
	ana	b
	jrz	nchange		;80 track bit nicht gesetzt
	lda	test$type
	ori	80h
	sta	test$type	;80 track => dside
	;
nchange:MVI	B,0		;ZAEHLER FUER DISKTYP
	LDA	TEST$TYPE	;TYPE IN D
	MOV	D,A		;
	LDA	TEST$MSEK	;SEKTORGROESSE IN E
	MOV	E,A		;
	LXI	H,DISK$TYPE$LIST;ZEIGER AUF VEREINBARTE FORMATE
TESTF4:	MOV	A,M
	ANI	010H		;ENDE DER LISTE
	JRNZ	TESTF2		;DANN MIT FEHLERMELDUNG ZURUECK
	MOV	A,M		;VERGLEICHE EINTRAG MIT DE
	CMP	D		;IST TYP GLEICH?
	JNZ	INX8		;NEIN, EINEN EINTRAG WEITER
	INX	H		;TYP WAR GLEICH
	MOV	A,M		;STIMMT AUCH NOCH DIE SEKTORGROESSE?
	CMP	E		;
	JNZ	INX7		;NEIN, EINEN EINTRAG WEITER
				;
				;OK, DISK WURDE ERKANNT
	LXI	H,DISKTYPA	;TRAGE DISKTYP EIN
	LDA	SEKDSK		;
	MOV	E,A		;
	MVI	D,0		;
	DAD	D		;ZEIGER AUF DISKTYPX
	MOV	M,B		;LEGE DISKTYP AB
	XRA	A		;ZURUECK OHNE FEHLER
	RET
				;
INX8	INX	H		;EINEN DISKTYP WEITER
INX7	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	INR	B
	JR	TESTF4
;
;
;
SET$HL$DISK:
	;
	;SETZT HL AUF EINTRAG IN DISK$TYPE$LISTE
	;IM AKKU MUSS DIE LAUFWERKSNUMMER STEHEN
	;
	;
	MOV	L,A		;
	MVI	H,0		;
	LXI	D,DISKTYPA	;
	DAD	D		;
	MOV	L,M		;LADE DISK TYP NACH HL
	MVI	H,0		;
	DAD	H		;UND ZEIGE AUF EINTRAG IN DISK$TYPE$LIST
	DAD	H		;
	DAD	H		;
	LXI	D,DISK$TYPE$LIST;
	DAD	D		;HL ZEIGT JETZT AUF RICHTIGEN EINTRAG
	RET			;
;
;
;
SET$DEBLOCK$PAR:
	;
	;SETZE DEBLOCKING PARAMETER
	;FUER DAS IN SEKDSK GESETZTE LAUFWERK
	;
	LDA	SEKDSK		;
	CALL	SET$HL$DISK	;SETZE HL AUF EINTRAG IN DISK$TYPE$LIST
	MOV	A,M		;LADE SEKTORGROESSE
	ANI	00FH		;
	STA	SECSHF		;ENTSPRICHT SECSHF
				;
	MOV	B,A		;BERECHNE DARAUS HOSTSIZE/128-1
	MVI	A,1		;
SETDPR1	MOV	C,A		;
	MOV	A,B		;
	ORA	A		;
	JRZ	SETDPR2		;OK, WENN 0
	MOV	A,C		;
	RLC			;
	DCR	B		;
	JR	SETDPR1		;
SETDPR2	MOV	A,C		;ES MUSS NOCH UM EINS DEKREMENTIERT
	DCR	A		;WERDEN
	STA	SECMSK		;
				;
	INX	H		;SETZE EOTRK FUER SECTRAN
	MOV	A,M		;
	STA	EOTRK		;
				;
	INX	H		;SETZE HL AUF DPB
	INX	H		;ADRESSE
	INX	H		;
	MOV	A,M		;
	INX	H		;
	MOV	H,M		;
	MOV	L,A		;HL JETZT AUF ZUGEHOERIGEM DPB
				;
	MOV	A,M		;LADE CP/M SEKTOREN/SPUR
	STA	CPMSPT		;
				;
	INX	H		;BLM IST 3 BYTES SPAETER
	INX	H		;
	INX	H		;
	MOV	A,M		;BLM NACH A
	INR	A		;IN A JETZT BLOCKGROESSE/128
	STA	SEKTBLK		;
				;
	RET
;
;
;
SETCMDTAB:
	;SETZT ALLE WERTE IN DER CMDTAB FUERV READ/WRITE
	;SETZT UPD 765 AUF MINI/MAXI FREQUENZ
	;SETZT DMAADR AUF HOST BUFFER
	;SETZT SECTCNT AUF EINEN SEKTOR
	;SETZT WRITE-PRECOMPENSATION
	;
	MVI	A,1		;SECTOR-COUNT AUF 1
	STA	SECTCNT		;
	LXI	H,HSTBUF	;UEBERTRAGE IMMER IN HOST-BUFFER
	SHLD	DMAADR		;
				;
	LDA	HSTDSK		;ZEIGE AUF DISK-TYP
	STA	UNIT		;UNIT IN CMDTAB
	CALL	SET$HL$DISK	;
				;
	MOV	A,M		;SETZE UPD AUF MINI/MAXI
	ANI	020H		;ISOLIERE MINI/MAXIBIT
	JRZ	SETCT1		;
	call	eprom$on
	CALL	MMINISET	;
	call	eprom$off
	JR	SETCT2		;
SETCT1:	call	eprom$on
	CALL	MMAXISET
	call	eprom$off
SETCT2:				;OK, MINI ODER MAXI IST EINGESTELLT
				;
	MOV	A,M
	MOV	C,A		;
	ANI	40H		;SETZE MFM-BIT
	STA	CMDTAB		;
	MOV	A,C		;
	ANI	0FH		;SETZE N
	STA	SECSZ		;
	ORA	A		;SETZE DTL
	MVI	A,0FFH		;
	JRNZ	SETCT3		;
	MVI	A,80H		;
SETCT3:	STA	DTLL		;
	INX	H		;SETZE EOT
	MOV	A,M		;
	STA	EOT		;
	MOV	C,A		;SAVE EOT IN C
	INX	H		;SETZE GAP-LAENGE
	MOV	A,M		;
	STA	GAPLL		;
	INX	H		;SETZE WRITE PRE-COMPENSATION
	MOV	A,M		;
	STA	WRITE$PRECOM	;
				;
	LDA	HSTTRK		;SETZE SPUR
	STA	TRACK		;
	LDA	HSTSEC		;SETZE	SEKTOR
	SUB	C		;
	JRNC	SETCT4		;SPRUNG WENN ZWEITE SEITE
	LDA	HSTSEC		;
	INR	A		;
	STA	SECTOR		;
	XRA	A		;HEAD 0
	STA	HEAD		;
	RET			;
				;
SETCT4:	INR	A		;
	STA	SECTOR		;
	MVI	A,1		;
	STA	HEAD		;
	RET			;

;
;
;
PSECTR:
	;WANDELT LOGISCHEN SECKTOR IN PHYSIKALISCHEN SEKTOR
	;LOGISCHER SEKTOR IN REG. C
	;PHYSIKALISCHER SEKTOR WIRD EBENFALLS IN C ABGELEGT
	;TEMP1 ZEIGT AUF DIE ZU BENUTZENDE UMRECHNUNGSTABELLE
	;
	LHLD	TEMP1		;
	MVI	B,0		;
	DAD	B		;HL ZEIGT AUF PHYSIKALISCHEN SEKTOR
	MOV	C,M		;
	RET
;
;
;
;
ram$floppy$read:
	lda	dma$bank
	push	psw
	call	ram$floppy$adr	;bei rueckkehr stehen in hl und dma$bank
				;die sourceadresse
	mvi	a,hstbuf and 0ffh
	out0	dar0l,a
	mvi	a,hstbuf shr 8
	out0	dar0h,a
	xra	a
	out0	dar0b,a
	out0	sar0l,l
	out0	sar0h,h
	lda	dma$bank
	out0	sar0b,a
	mvi	a,80h
	out0	bcr0l,a
	xra	a
	out0	bcr0h,a
	mvi	a,11000011b	;memory -> memory, aufwaertszaehlend
	out0	dmode,a
	mvi	a,01100010b
	out0	dstat,a		;transfer beginnt
	pop	psw
	sta	dma$bank
	xra	a
	sta	erflag
	ret
ram$floppy$write:
	lda	dma$bank
	push	psw
	call	ram$floppy$adr	;bei rueckkehr stehen in hl und dma$bank
				;die destinationadresse
	mvi	a,hstbuf and 0ffh
	out0	sar0l,a
	mvi	a,hstbuf shr 8
	out0	sar0h,a
	xra	a
	out0	sar0b,a
	out0	dar0l,l
	out0	dar0h,h
	lda	dma$bank
	out0	dar0b,a
	mvi	a,80h
	out0	bcr0l,a
	xra	a
	out0	bcr0h,a
	mvi	a,11000011b	;memory -> memory, aufwaertszaehlend
	out0	dmode,a
	mvi	a,01100010b
	out0	dstat,a		;transfer beginnt
	pop	psw
	sta	dma$bank
	xra	a
	sta	erflag
	ret
ram$floppy$adr:
	lda	hsttrk
	cpi	2
	jrnc	notbank4	;nicht in 4f000h - 4ffffh
	mvi	a,4
	sta	dma$bank
	jr	adr2
notbank4:
	lda	hsttrk
	cpi	28		;spuren in bank 0 und 4
	jrnc	adr1		;sprung wenn nicht in bank 0
	mvi	a,0
	sta	dma$bank
	jr	adr2
adr1:	
	;bestimmt anhand von hsttrk die dma$bank
	lxi	h,dma$bank
	mvi	m,0
	lda	hsttrk
	sui	28		;28 spuren sind schon in bank 0 und 4
	mvi	d,20h		;32 spuren in jeder bank
	sub	d
	inr	m
	jrc	adr2
	sub	d
	inr	m
	jrc	adr2
	sub	d
	inr	m
	jrc	adr2
	sub	d
	inr	m
	inr	m		;bank 4 auslassen
	jrc	adr2
	sub	d
	inr	m
	jrc	adr2
	sub	d
	inr	m
	;
	;dma$bank ist jetzt gesetzt
	;
adr2:
	;bestimmt die adresse anhand von hstsec und hsttrk
	lda	hstsec
	mov	b,a
	mvi	c,80h
	mult	b		;bestimmt die adresse innerhalb einer 2k kachel
	mov	h,b
	mov	l,c
	lda	hsttrk
	cpi	28
	jrnc	adr3
	lxi	b,1000h
	dad	b		;bei spur 0 - 27 ein offset von 2000h
	cpi	2
	jrnc	adr3
	lxi	b,0e000h
	dad	b		;bei spur 0 und 1 ein offset von 0f000h
adr3:	ani	1fh
	rlcr	a
	rlcr	a
	rlcr	a
	mov	b,a
	mvi	c,0
	dad	b
	ret
;
;
;
;*******************************************************
;
;HIER WERDEN DIE MOEGLICHEN DISK-FORMATE VEREINBART
;
;
;
DISK$TYPE$LIST:
	;
	;DIESE LISTE DEFINIERT DIE VOM BETRIEBSSYSTEM
	;LESBAREN PLATTEN-TYPEN
	;DIE LISTE BESTEHT AUS BELIEBIG VIELEN EIN-
	;VON JE ACHT BYTE, DIE WIE FOLGT AUFGEBAUT
	;SIND
	;BYTE 1	:DISK-TYP WIE VON MONTEST ERMITTELT
	;BYTE 2	:SEKTOR-ANZAHL
	;BYTE 3	:GAP-LAENGE, DIE UPD765 VERWENDEN SOLL
	;BYTE 4 :WRITE-PRECOMPENSATION
	;BYTE 5-6:ADRESSE DES DPB FUER DIESES FORMAT
	;BYTE 7-8:ADRESSE DER SEKTOR SKEW-TABELLE
	;
	;TEST$FORMAT VERGLEICHT DIE BEIDEN ERSTEN BYTES
	;MIT TEST$TYPE UND TEST$MSEK DIE MONTEST
	;LIEFERT.
	;
	SSIDE	EQU	000H	;EQUATES FUER TYPE
	DSIDE	EQU	080H	;
	SDENS	EQU	000H	;
	DDENS	EQU	040H	;
	MAXIF	EQU	000H	;
	MINIF	EQU	020H	;
	S0128	EQU	000H	;
	S0256	EQU	001H	;
	S0512	EQU	002H	;
	S1024	EQU	003H	;
	;
	;
	DB	SSIDE OR SDENS OR MAXIF OR S0128
	DB	26
	DB	07,0
	DW	DP8S0,SKEW26
	;
	DB	SSIDE OR DDENS OR MAXIF OR S1024
	DB	8
	DB	35H,2
	DW	DP8D3,SKEW8
	;
	DB	DSIDE OR DDENS OR MAXIF OR S0256
	DB	26
	DB	07,0
	DW	DP8D1A,SKEW26
	;
	DB	DSIDE OR DDENS OR MAXIF OR S0512
	DB	15
	DB	18H,2
	DW	DP8D2A,SKEW15
	;
	DB	DSIDE OR DDENS OR MAXIF OR S1024
	DB	8
	DB	35H,2
	DW	DP8D3A,SKEW8
	;
	db	sside or ddens or minif or s0256
	db	16
	db	1bh,2
	dw	dp5d1,noskew
	;
	DB	SSIDE OR DDENS OR MINIF OR S1024
	DB	5
	DB	1bH,02
	DW	DP5D2,SKEW5
	;
	DB	DSIDE OR DDENS OR MINIF OR S1024
	DB	5
	DB	1bH,02
	DW	DP5D3,SKEW5
	;
	DB	SSIDE OR DDENS OR MINIF OR S0512
	DB	10
	DB	0eH,02
	DW	DP5D2A,skew10
	;
	DB	DSIDE OR DDENS OR MINIF OR S0512
	DB	10
	DB	0eH,02
	DW	DP5D3A,skew10
	;
	DB	010H		;ENDE-KENNUNG
;
;
;
SKEW26:		;LISTE FUER 26 SEKTOREN
	DB	1,7,13,19
	DB	25,5,11,17
	DB	23,3,9,15
	DB	21,2,8,14
	DB	20,26,6,12
	DB	18,24,4,10
	DB	16,22
		;
NOSKEW:		;LISTE FUER 18 SEKTOREN
	DB	1,2,3,4,5,6,7,8,9,10
	DB	11,12,13,14,15,16
		;
SKEW15:		;LISTE FUER 15 SEKTOREN
	DB	1,5,9,13
	DB	2,6,10,14
	DB	3,7,11,15
	DB	4,8,12
		;
SKEW8:		;LISTE FUER 8 SEKTOREN
	DB	1,4,7
	DB	2,5,8
	DB	3,6
		;
skew10:		;liste fuer 10 sektoren
	db	1,3,5,7,9
	db	2,4,6,8,10
		;
skew5:		;liste fuer 5 sektoren
	db	1,2,3,4,5
		;
	DB	0		;ENDE DER LISTE
;
;
;
			;DISK-PARAMETER BLOECKE
FLOPPYBLK:
	DW	16	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	0fh	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	219	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	0c0h	;ALLOC 0
	DB	0	;ALLOC 1
	D		;NO DIR CHECK
	D		;N OFFSET
			;
FLOPPYBLK1:
	DW	16	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	55	;BLOCKS PER DISKETTE
	DW	31	;# DIRECTORY ENTRIES
	DB	80H	;ALLOC 0
	DB	0	;ALLOC 1
	D		;NO DIR CHECK
	D		;N OFFSET
			;
DP8S0:	DW	26	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	242	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	D	16	;DIR CHECK VECTOR SIZE
	D	2	;SYSTEM TRACK OFFSET
			;
DP8D3:	DW	64	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	299	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	D	32	;DIR CHECK VECTOR SIZE
	D	2	;SYSTEM TRACK OFFSET
			;
DP5D1:	DW	32	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	143	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	D	16	;DIR CHECK VECTOR SIZE
	D	4	;SYSTEM TRACK OFFSET
		;
DP5D2:	DW	40	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	184	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	D	32	;DIR CHECK VECTOR SIZE
	D	3	;SYSTEM TRACK OFFSET
		;
DP5D3:	DW	40	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	191	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	D	32	;DIR CHECK VECTOR SIZE
	D	3	;SYSTEM TRACK OFFSET
		;
DP5D2A:	DW	80	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	184	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	D	32	;DIR CHECK VECTOR SIZE
	D	3	;SYSTEM TRACK OFFSET
			;
DP5D3A:	DW	80	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	384	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	D	32	;DIR CHECK VECTOR SIZE
	D	3	;SYSTEM TRACK OFFSET
			;
DP8D1A:	DW	104	;SECTORS PER TRACK
	DB	5	;BLOCK SHIFT FACTOR
	DB	31	;BLOCK MASK
	DB	3	;EXTENT MASK
	DW	242	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	D	32	;DIR CHECK VECTOR SIZE
	D	2	;SYSTEM TRACK OFFSET
			;
DP8D2A:	DW	120	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	561	;BLOCKS PER DISKETTE
	DW	255	;# DIRECTORY ENTRIES
	DB	0F0H	;ALLOC 0
	DB	0	;ALLOC 1
	DW	64	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
			;
DP8D3A:	DW	128	;SECTORS PER TRACK
	DB	6	;BLOCK SHIFT FACTOR
	DB	63	;BLOCK MASK
	DB	7	;EXTENT MASK
	DW	149	;BLOCKS PER DISKETTE
	DW	255	;# DIRECTORY ENTRIES
	DB	080H	;ALLOC 0
	DB	0	;ALLOC 1
	DW	64	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
			;
;ENDE DER DISK-PARAMETER-BLOECKE
;
;
;
PROMT	DB	0AH,0DH
	DB	'            61K CP/M Version 2.2'
	DB	0AH,0DH
	DB	'    Copyright (C) 26.08.1986 '
COPRGHT	DB	'C. Ueberschaar$'
CSUML	EQU	$-COPRGHT
	;
CSUM	EQU	('C'+'.'+' '+'U'+'e'+'b'+'e'+'r'+'s'+'c'+'h'+'a'+'a'+'r'+'$') and 0ffh
;
;
;
;
;***********************************************************
;
;JETZT KOMMT UNINITIALISIERTER RAM-BEREICH
;
			;DEBLOCKING PARAMETER, WERDEN
			;VON SET$DEBLOCK$PAR GESETZT
SEKTBLK	DS	1	;BLOCKSIZE/128
CPMSPT	DS	1	;CPM SEKTOREN/SPUR
SECMSK	DS	1	;HOSTSIZE/128-1
SECSHF	DS	1	;
EOTRK	DS	1	;END OF TRACK FUER SECTRAN
;
;
;
SEKDSK	DS	1	;SEEK DISK NUMBER
SEKTRK	DS	2	;SEEK TRACK NUMBER
SEKSEC	DS	1	;SEEK SECTOR NUMBER
;
HSTDSK	DS	1	;HOST DISK NUMBER
HSTTRK	DS	2	;HOST TRACK NUMBER
HSTSEC	DS	1	;HOST SECTOR NUMBER
;
SEKHST	DS	1	;SEEK SHR SECSHF
HSTACT	DS	1	;HOST ACTIVE FLAG
HSTWRT	DS	1	;HOST WRITTEN FLAG
;
UNACNT	DS	1	;UNALLOC REC CNT
UNADSK	DS	1	;LAST UNALLOC DISK
UNATRK	DS	2	;LAST UNALLOC TRACK
UNASEC	DS	1	;LAST UNALLOC SECTOR
;
ERFLAG	DS	1	;ERROR REPORTING
RSFLAG	DS	1	;READ SECTOR FLAG
READOP	DS	1	;1 IF READ OPERATION
WRTYPE	DS	1	;WRITE OPERATION TYPE
DMAADR1	DS	2	;LAST DMA ADDRESS
;
DISKTYPA	DS	1	;DISK-TYP WIRD FUER JEDES
DISKTYPB	DS	1	;LAUFWERK VON TEST$FORMAT
DISKTYPC	DS	1	;GESETZT
DISKTYPD	DS	1	;
;
USERSTACK	DS	2	;MERKZELLE FUER TPA STACK
TEMP1		DS	2	;ZWISCHENSPEICHER
TEMP2		DS	2	;
NEXTDMA		DS	2	;
RESTBYTES	DS	2	;
		DS	80	;BIOS STACKBEREICH
BIOSSTACK:
;
HSTBUF		DS	1024
;
;RAM FUER BDOS BENUTZUNG
;
DIRBF	DS	128
ALL00	DS	72
ALL01	DS	72
ALL02	DS	72
ALL03	DS	72
ALL04	DS	30
;
CHK00	DS	64
CHK01	DS	64
CHK02	DS	64
CHK03	DS	64
;
ENDCODE	EQU	$
	END
