{ ========================================================================= }
{ !                   ** FORMATIER-PROGRAMM **                            ! }
{ !                                                                       ! }
{ !  Version 2.3                                                          ! }
{ !  Fuer PROF-180 ,CONITEC-Darmstadt. Von Manfred Oheimer .              ! }
{ !  Letzte Aenderung : 13.02.87                                          ! }
{ ========================================================================= }



procedure formatiere;
var cmdtab     :byte absolute $ff18;
    unit       :byte absolute $ff19;
    track      :byte absolute $ff1a;
    head       :byte absolute $ff1b;
    sektor     :byte absolute $ff1c;
    sektsize   :byte absolute $ff1d;
    eot        :byte absolute $ff1e;
    gapll      :byte absolute $ff1f;
    dtl        :byte absolute $ff20;
    dermsg     :byte absolute $ff2d;
    byps,spt,gpl,densi,cylindernr,headid,fillerbyte,headfdc,erstsnr,
    rwstat,scmdtab,sunit,strack,shead,ssektor,ssektsize,seot,sgapll,
    sdtl,ssectcnt,sdmaadr :byte;
    sectcnt    :byte absolute $ff46;
    dmaadr     :integer absolute $ff44;
    SEEKPOINTER    :integer absolute $0027;
    RECALPOINTER   :integer absolute $0012;
    MOTOPOINTER    :integer absolute $001e;
    NEXTPOINTER    :integer absolute $002a;
    RESULTPOINTER  :integer absolute $0024;
    CMFDPOINTER    :integer absolute $0021;
    READPOINTER    :integer absolute $0015;
    DRIVETRANSPTER :integer absolute $0081;
    MINISETPOINTER :integer absolute $008a;
    MAXISETPOINTER :integer absolute $0087;
    POINTOFBIOSCALL:integer;
    JMPTABLEPOINTER:INTEGER;
    skewfakt,sektanz:byte;
    ein,sein  :char;
    headinvers,verifizieren,ok,abbruch,noverify :boolean;
    biospb : bcblock; { 8 -byte Array fuer CP/M-BIOSCALL }

procedure bioscall;
begin
   inline($08/                     { EXAF                    }
          $d9/                     { EXX                     }
          $2a/JMPTABLEPOINTER/     { LD     HL,(JMPTABLEPTR) }
          $22/biospb+6/             { SHLD   BIOSPB+6         }
          $3e/$1e/                 { MVI    A,30             }
          $32/biospb/              { STA    BIOSPB           }
          $3e/$02/                 { MVI    A,2              }
          $32/biospb+2/             { STA    BIOSPB+2         }
          $0e/$32/                 { MVI    C,50             }
          $11/biospb/              { LXI    D,BIOSPB         }
          $cd/$05/$00/             { CALL   BDOS             }
          $d9/                     { EXX                     }
          $08                      { EXAF                    });
end;

procedure recalibrate;
begin
   jmptablepointer:=addr(recalpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;


procedure bbfseek(dest:integer);
begin
   track:=dest;   { track:byte nur das lower-byte von dest uebergeben }
   jmptablepointer:=addr(seekpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;

procedure miniset;
begin
   jmptablepointer:=addr(minisetpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;
procedure maxiset;
begin
   jmptablepointer:=addr(maxisetpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;

procedure sendprecomp(compwert:byte);
begin
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($3a/compwert/           { LDA    COMPWERT             }
          $4f/                    { MOV    C,A                  }
          $e6/$01/                { ANI    01h                  }
          $f6/$02/                { ORI    PAD$M0               }
          $d3/$d8/                { OUT    P$LS259              }
          $79/                    { MOV    A,C                  }
          $0f/                    { RRC                         }
          $e6/$01/                { ANI    01h                  }
          $f6/$04/                { ORI    PAD$M1               }
          $D3/$D8/                { OUT    P$LS259              }
          $79/                    { MOV    A,C                  }
          $0f/                    { RRC                         }
          $0f/                    { RRC                         }
          $e6/$01/                { ANI    01h                  }
          $f6/$00/                { ORI    PAD$DATA             }
          $d3/$d8                 { OUT    P$LS259              } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;

procedure spcdnondma;
begin
   JMPTABLEPOINTER:=addr(CMFDPOINTER);
   inline($2a/unit/               { RETTEN CMDTAB (2-BYTES )    }
          $e5/                    { PUSH HL                     }
          $21/$00/$01/            { NON-DMA--> HL               }
          $01/$03/$03/            { FDD-OPCODE + ANZ-BYTE       }
          $22/$19/$ff/            { HL --> CMDTAB               }
          $08/                     { EXAF    anfang bioscall }
          $d9/                     { EXX                     }
          $2a/JMPTABLEPOINTER/     { LD     HL,(JMPTABLEPTR) }
          $22/biospb+6/             { SHLD   BIOSPB+6         }
          $3e/$1e/                 { MVI    A,30             }
          $32/biospb/              { STA    BIOSPB           }
          $3e/$02/                 { MVI    A,2              }
          $32/biospb+2/             { STA    BIOSPB+2         }
          $0e/$32/                 { MVI    C,50             }
          $11/biospb/              { LXI    D,BIOSPB         }
          $cd/$05/$00/             { CALL   BDOS             }
          $d9/                     { EXX                     }
          $08/                     { EXAF   ende bioscall    }
          $e1/                    { POP HL                      }
          $22/unit);              { RESTORE CMDTAB              }
end;



procedure gencomdat;
var temp,i,found:integer;
    wert:byte;
begin
         sektanz:=GET_SEKT_ANZ(AKTFNR);spt:=sektanz;
         skewfakt:=GET_SKEW(AKTFNR);
         byps:=GET_CODED_SECTOR_SIZE(AKTFNR);
         gpl:=GET_FORMAT_GAP(AKTFNR);
         if INVERTED_FORMAT(AKTFNR) then fillerbyte:=$1A
                                    else fillerbyte:=$E5;
         erstsnr:=GET_NR_1_SEKT(AKTFNR);
         SET_BIDTABLE(AKTFNR,1);
         if GET_MIMA(AKTFNR) then maxiset
                             else miniset;
         sendprecomp(1);
end;

procedure testwriteprot;
var wrprot:byte;
    once:boolean;
    ein:char;
begin
 once:=false;
 repeat
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5/    { PUSH ALL }
          $01/$04/$02/
          $21/motopointer/        { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9/                    { JMP    HL                   }
          $21/nextpointer/        { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9/                    { JMP    HL                   }
          $cb/$77/$ca/*+10/
          $3e/$ff/$32/wrprot/$c3/*+7/$3e/$00/$32/wrprot);
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1);
       { wenn WRPROT=FF dann ist diskette schreibgeschuetzt }
   if not(wrprot=0) then begin
                feldaendern(6,14,50,'Schreibschutz Entfernt? (J/N) : ');
                      read(kbd,ein);ein:=upcase(ein);write(ein);
                      if ein='J' then once:=true
                                 else begin abbruch:=true;once:=false end;
                         end
                   else once:=false;
 until not(once);
 feldaendern(1,14,70,'');
end;


procedure fat;    (* Format a Track *)
begin
   { epromon }
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5/ { PUSH ALL }
          $21/byps/                        { LXI     H,byps     }
          $4e/                             { LD      C,(HL)     }
          $21/spt/                         { LXI     H,spt      }
          $46/                             { LD      B,(HL)     }
          $21/track/$71/$21/head/$70/      { SBCD    track      }
          $21/gpl/                         { LXI     H,gpl      }
          $4e/                             { LD      C,(HL)     }
          $21/fillerbyte/                  { LXI     H,fillerby }
          $46/                             { LD      B,(HL)     }
          $21/sektor/$71/$21/sektsize/$70/ { SBCD    sektor     }
          $3a/densi/                       { LDA     densi      }
          $0e/$0d/                         { MVI     C,0dh      }
          $b1/                             { ORA     C          }
          $4f/                             { MOV     C,A        }
          $06/$06/                         { MVI     B,06h      }

          (* formatieren *)

          $21/motopointer/        { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9/                    { JMP    HL                   }
          $3a/spt/                         { LDA     spt        }
          $57/                             { MOV     d,a        }
          $21/bidtable/                    { LXI     H,bidtable }
          $db/$dc/$07/$d2/*-4/             { LOOP    WFR        }
          $3a/cylindernr/                  { LDA     cylindernr }
          $d3/$dd/                         { OUT     FDD        }
          $db/$dc/$07/$d2/*-4/             {   WFR              }
          $3a/headid/                      { LDA     headid     }
          $d3/$dd/                         { OUT     FDD        }
          $db/$dc/$07/$d2/*-4/             {   WFR              }
          $7e/                             { MOV     A,M        }
          $d3/$dd/                         { OUT     FDD        }
          $db/$dc/$07/$d2/*-4/             {   WFR              }
          $3a/byps/                        { LDA     byps       }
          $d3/$dd/                         { OUT     FDD        }
          $23/                             { INX     H          }
          $15/                             { DCR     D          }
          $c2/*-45/                        { JNZ     LOOP       }
          $21/resultpointer/      { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   });

   { epromoff }
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1);
end;