;*********************************************************
;***                                                   ***
;***  PSYSGEN: DIESES PROGRAMM KOPIERT DIE SYSTEM-     ***
;***  SPUREN EINES PROF-180X SYSTEMS		       ***
;***						       ***
;***  LETZTE AENDERUNG AM: 18.02.1986 (JOACHIM)        ***
;***                                                   ***
;*********************************************************
;
	MACLIB	HD64180		; HITACHI CPU-SATZ
				;
	MACLIB	PVEC		; MONITOR VEKTOR
	ULT LESE-SCHREIBVERFAHREN, WENN
DEFTRK	DB	002H		;KEIN PROF-180X BOOTSEKTOR VORLIEGT
					;
	DB	'           '		; COPYRIGHT TEXT
	DB	'(c) CONITEC 1985'	;
	DB	'                '	;
	DB	'                '	;
	DB	'    PSYSGEN     '      ;
	DB	'    VERSION     '      ;
	DB	'      1.0       '      ;
	DB	'                '	;
	DB	'                '      ;
	DB	'                '	;
	DB	'                '	;
	DB	'                '	;
	DB	'                '	;
					;
STACK	EQU	$			; UND STACK
					;
FALSCH' '			;BEI BLANK IST SCHLEIFE
	JRNZ	PARCHK			;BEENDET DA PARAMETER DA SEIN KOENNEN
					;
	MOV	A,M			;
	CPI	'1'			;PARAMETER ZWISCHEN 1 UND 9
	JRC	WRONGPAR		;
	CPI	'9'			;
	JRNC	WRONGPAR		;
	SUI	'0'			;
	STA	WRITETRACKS		;LEGE SCHREIBSPUREN AB
	XRA	A			;
	STA	WRITESIDES		;
	INX	H			;AUF NAECHSTES ZEICHEN ZEIGEN
	MOV	A,M			;
	CPI	000H			;WENN KEIN ZWEITER PARAMETER
	JRZ	PARWRITE		;DANN EINSEITIG
	CPI	'D'			;ZWEITER PARAMETER MUSS GLEICH D SEIN
	MVI	A,1			;
	STA	WRITESIDES		;
	JRNZ	WRONGPAR		;SONST FEHLER
	INX	H			;
	MOV	A,M			;
	CPI	000H			;ABSCHLUSS DER ZEILE SONST EBENFALLS
	JRZ	PARWRITE		;FEHLER
WRONGPAR:				;
	LXI	H,WPARTXT		;
	CALL	SOUT			;
	JMP	WBOOT			;
WPARTXT	DB	13,10,'ERROR, WRONG PARAMETER IN COMMAND LINE',13,10,'$'
DEFWRITE:				;
	LDA	DEFSID			;
	STA	WRITESIDES		;
	LDA	DEFTRK			;
	STA	WRITETRACKS		;
PARWRITE:
;
	LXI	H,ANFTXT	;GEBE VERSION AUS
	CALL	SOUT		;
START:	
	LXI	H,STEXT		;LESE SOURCE DRIVE EIN
	CALL	SOUT		;
	CALL	CONIN		;LESE LAUFWERKBUCHSTABEN EIN
	ICHEN
	CALL	ECHO		;ZURUECK ZUR KONSOLE
	JC	WBOOT		;WAR RETURN, ZURUECK ZUM CP/M
	CALL	VALID		;PRUEFE OB ZEICHEN OK
	JRNC	MAINLP3		;
	LXI	H,ETEXT		;
	CALL	SOUT		;
	JR	MAINLP2		;NEUE EINGABE
MAINLP3	STA	DRIVECR		;LEGE LAUFWERKBUCHSTABE AB
	LXI	H,DETEXT	;
	CALL	SOUT		;
	LDA	DRIVECR		;
	CALL	ECHO		;
	LXI	H,EETEXT	;
	CALL	SOUT		;
	CALL	CONIN		;
	CALL	ECHO		;
	JRNC	MAINLP2		;
	CALL	PUTSYS		;
	LXI	H,QTEXT		;
	CALL	SOUT		;
	JMP	MAINLP2		;
;
;
;
GETSYS:
	MVI	A,0		;
	STA	WRITEFLAG	;
	JMP	G	LXI	H,SOTXT
	LDA	WRITEFLAG
	ORA	A
	JRZ	SRCDST
	LXI	H,DETXT
SRCDST	CALL	SOUT
	RET
;
BTRKTXT	DB	0DH,0AH,'BAD SYSTEM TRACK ON $'
NO180X	DB	0DH,0AH,'WARNING, NO PROF-180X BOOTSEKTOR ON $'
TXT180	DB	'PROF-180X'
TXT180L	EQU	$-TXT180
SOTXT	DB	'SOURCE$'
DETXT	DB	'DESTINATION$'
;
;
;
ANFTXT	DB	0AH,0DH
	DB	'PSYSGEN Version 1.0',0AH,0DH,24H
;
;
;
STEXT	DB	0AH,0DH
	DB	'SOURCE DRIVE NAME (OR RETURN TO SKIP) '
	DB	24H
;
QTEXT:
	DB	13,10,'FUNCTION COMPLETE'
	DB	24H
;
ETEXT	DB	0AH,0DH
	DB	'IB	0EDH,0BBH
	ENDM


RLCR	MACRO	?R	
	DB	0CBH, 00H + ?R
	ENDM
RLCX	MACRO	?D	
	@CHK	?D
	DB	0DDH, 0CBH, ?D, 06H
	ENDM
RLCY	MACRO	?D	
	@CHK	?D
	DB	0FDH, 0CBH, ?D, 06H
	ENDM
RALR	MACRO	?R	
	DB	0CBH, 10H+?R
	ENDM
RALX	MACRO	?D	
	@CHK	?D
	DB	0DDH, 0CBH, ?D, 16H
	ENDM
RALY	MACRO	?D	
	@CHK	?D
	DB	0FDH, 0CBH, ?D, 16H
	ENDM
RRCR	MACRO	?R	
	DB	0CBH, 08H + ?R
	ENDM
RRCX	MACRO	?D	
	@CHK	?D
	DB	0DDH, 0CBH, ?D, 0EH
	ENDM
RRCY	MACRO	?D	
	@CHK	?D
	DB	0FDH, 0CBH, ?D, 0EH
	ENDM
RARR	MACRO	?R			;
	MACLIB	PSYS		; SYSTEMPAGE
;
	TITLE	'PROF-180X SYSGEN'
				;
BDOS		EQU	00005H	;
WBOOT		EQU	00000H	;
TPA		EQU	00100H	;
SYSTEMSAVE	EQU	00900H	;AB DIESER ADRESSE WERDEN SYSTEMSPUREN
				;GELESEN UND GESCHRIEBEN
PHYSTPABANK	EQU	004H	;DMA-BANK IN DER SYSTEMSAVE LIEGT
				;
PRECOM		EQU	000H	;WRITEPRECOMPENSATION
PRECOMTRACK	EQU	0FFH	;ERSTE SPUR MIT WRITEPRECOMPENSATION
				;
DEFBUF		EQU	00080H	;
				;
				;
	ORG	TPA		;
				;
				;
	JMP	ANFANG		; SPRINGE ZUM START

DEFSID	DB	000H		;DEFATXT:
	DB	0DH,0AH,'Error, PSYSGEN runs only on PROF-180X',0DH,0AH,'$'


COMPUTERFALSCH:
	LXI	H,FALSCHTXT		;
	CALL	SOUT			;
	JMP	WBOOT			;



ANFANG:
	LHLD	DISPADR			;TESTE OB UEBERHAUPT EIN
	MVI	A,01H			;PROF-180X SYSTEM
	CMP	H			;VORLIEGT
	JRNZ	COMPUTERFALSCH		;
	MVI	A,80H			;
	CMP	L			;
	JRNZ	COMPUTERFALSCH		;
					;
CHECKOK:				;
	LXI	H,DEFBUF+1		;SUCHE PARAMETERANFANG
PARCHK:	MOV	A,M			;
	INX	H			;
	ORA	A			;WENN HIER NULLBYTE KOMMT
	JRZ	DEFWRITE		;SIND KEINE PARAMETER DA.
	CPI	NVALID DRIVE NAME (USE A,B,C OR D)'
	DB	24H
;
DTEXT	DB	0AH,0DH
	DB	'DESTINATION DRIVE NAME (OR RETURN TO REBOOT) '
	DB	24H
;
DETEXT	DB	0AH,0DH
	DB	'DESTINATION ON '
	DB	24H
;
SETEXT	DB	0AH,0DH
	DB	'SOURCE ON '
	DB	24H
;
EETEXT	DB	', THEN TYPE RETURN'
	DB	24H
;
;
;
VALID:
	;SETZT CARRY FLAG, WENN ZEICHEN IN A
	;KEIN GUELTIGER LAUFWERKSBUCHSTABE IST
	CPI	'A'
	RC
	CPI	'E'
	JRC	NRET
SRET	STC
	RET
NRET	STC
	CMC
	RET
;
;
;
ECHO:
	;SCHREIBT ZEICHEN IN A AUF KONSOLE
	;BEI CR WIR
	JRC	CONIN2		;
	SUI	'a'-'A'		;
CONIN2	POP	H		;
	POP	D		;
	POP	B		;
	RET			;
;
;
;
SOUT:
        ;GIBT ASCIISTRING AUS (ANFANG IN HL,ENDE DURCH $)
	;
        MOV	A,M		;
	CPI	24H		;ENDE DES STRINGS ?
        RZ			;
        MOV     C,A		;
        CALL    CONOUT		;
        INX     H		;
        JMP     SOUT		;
;
;
;
;------------------------------------------------------------
;
;
GETPUTSYS:
	;WENN WRITEFLAG=0 DANN LESE DIE SYSTEMSPUREN
	;WENN WRITEFLAG <> 0 DANN SCHREIBE DIE SYSTEMSTPABANK	;SETZE TPABANK
	STA	DMABANK		;
	MVI	A,PRECOM	;SETZE WRITEPRECOMPENSTION
	STA	WRITEPRECOM	;
	MVI	A,PRECOMTRACK	;SETZE ERSTE SPUR DER WRITEPRECOMPENSTION
	STA	PRECOMBEGIN	;
				;
	LDA	WRITEFLAG	;LESEN ODER SCHREIBEN
	ORA	A		;
	JRZ	BOOTSEK1	;SPRUNG WENN LESEN
				;
	CALL	TEST180XBOOT	;TESTE OB PROF180X BOOTSEKTOR GESCHRIEBEN WIRD
	JRNZ	BOOTSEK3	;
				;
	LDA	WRITESIDES	;WENN JA PATCHE ANZAHL DER
	STA	SYSTEMSAVE+2	;SYSTEMSPUREN UND SEITENFLAG
	STA	SIDES		;IN BOOTROUTINE.
	LDA	WRITETRACKS	EXAF			;
		EXX			;
		LXI	H,MSETCMDT	;
		CALL	BANK0CALL	;
		EXX			;
		EXAF			;
		RET
;
DRIVETRANS:
		EXAF			; UEBERSETZTE LOG.-/PHYS-LAUFWERK
		EXX			;
		LXI	H,MDRIVE$TRANS	;
		CALL	BANK0CALL	;
		EXX			;
		EXAF			;
		RET			;
;
;
;
BANK0CALL:				; RUFE PROGRAMM IN HL AUF
		SHLD	BIOSREG+6	; SETZTE REGISTER FUER BDOS 50
		MVI	A,30		; WAEHLE BIOSFUNKTION 30
		STA	BIOSREG		;
		MVI	A,2		; WAEHLE USERFUNKTION 2
		STA	BIOSREG+2	;
		MVI	C,50		; WAEHLE BDOS FUNKTION 50
		LXI	D,BIOSREG	;
		C	;
	STA	SYSTEMSAVE+3	;
	STA	TRACKS		;
	JR	BOOTSEK4	;
BOOTSEK3:			;
	LDA	DEFSID		;WENN KEIN PROF180X BOOTSEKTOR
	STA	SIDES		;DANN SCHREIBE NACH DEFAULT
	LDA	DEFTRK		;VERFAHREN OHNE PATCH.
	STA	TRACKS		;
BOOTSEK4:			;
	CALL	WRITE		;SCHREIBE BOOTSEKTOR
	JNZ	GETPUTERR	;
	JR	BOOTSEK5	;WENN KEIN FEHLER, SCHREIBE REST
				;
BOOTSEK1:			;
	CALL	READ		;LESE BOOTSEKTOR
	JNZ	GETPUTERR	;
	CALL	TEST180XBOOT	;WENN KEIN FEHLER, TESTE OB PROF180X BOOTSEKTOR
	JRNZ	BOOTSEK2	;
				;
	LDA	SYSTEMSAVE+2	;WENN BYTES/SEKTOR
	LXI	H,64		;
	INR	A		;
	MOV	B,A		;
GETPUT1	DAD	H		;
	DJNZ	GETPUT1		;
	XCHG			;BYTES/SEKTOR IN DE
	LHLD	NEXTDMA		;NEUE DMA-ADRESSE
	SHLD	DMAADR		;FUER READ SETZEN
				;
	LDA	SECTOR		;BERECHENE JETZT DMAADRESSE
	MOV	B,A		;DER NAECHSTEN SPUR.
	LDA	EOT		;
	SUB	B		;
	INR	A		;
	MOV	B,A		;
	STA	SECTCNT		;
GETPUT2	DAD	D		;
	DJNZ	GETPUT2		;
	SHLD	NEXTDMA		;SOLLEN.
				;
	CALL	PRINTTRK	;
	LDA	WRITEFLAG	;LESEN ODER SCHREIBEN?
	ORA	A		;WENN NULL LESEN
	JRZ	GETPUT8		;SONST SCHREIBENT$LSEK	;
	JR	GETPUT0		;
				;
PRINTTRK:			;GEBE SPUR UND SEITE AUS DIE
				;GERADE GELESEN/GESCHRIEBEN WIRD
	LDA	WRITEFLAG	;
	LXI	H,PTRKWTXT	;
	ORA	A		;
	JRNZ	PTRK1		;
	LXI	H,PTRKRTXT	;
PTRK1	CALL	SOUT		;
	LXI	H,PTRK2TXT	;
	CALL	SOUT		;
	LDA	TRACK		;
	ADI	'0'		;
	MOV	C,A		;
	CALL	ECHO		;
	LXI	H,PTRK3TXT	;
	CALL	SOUT		;
	LDA	HEAD		;
	ADI	'0'		;
	MOV	C,A		;
	CALL	ECHO		;
	RET			;

PTRKWTXT	DB	13,10,'WRITING$'
PTRKRTXT	DB	13,10,'READING$'
PTRK2TXT	DB	' TRACK $'
PTRK3TXT	DB	', HEAD $D CR LF AUSGEGEBEN UND CARRY GESETZT
	;
	MOV	C,A		;
	CALL	CONOUT		;
	CPI	0DH		;
	JNZ	NRET		;OHNE CARRY ZURUECK
	MVI	C,0AH		;
	CALL	CONOUT		;
	JMP	SRET		;MIT CARRY ZURUECK
;
;
;
CONOUT	PUSH	PSW		;
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
	MOV	E,C		;
	MVI	C,6		;
	CALL	BDOS		;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	RET			;
;
;
;
CONIN	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
CONIN1	MVI	E,0FFH		;INPUT
	MVI	C,6		;
	CALL	BDOS		;
	CPI	00H		;
	JRZ	CONIN1		;
	CPI	'a'		;WANDLE IN GROSSBUCHSTABENPUREN
	;
	XRA	A		;SETZE CMDTAB FUER SPUR NULL
	STA	ZAEHLER		;
	STA	TEST$TRACK	;
	LDA	DRIVECR		;WANDLE LOGISCHEN LAUFWERKS
	DCR	A		;BUCHSTABEN IN PHYSIKALISCHES
	CALL	DRIVETRANS	;LAUFWERK UM.
	STA	UNIT		;
	CALL	TEST		;TESTE DRIVE
	CALL	SETCMDT		;SETZE CMDTABELLE
				;
	LDA	TEST$LSEK	;LADE/SCHREIBE BOOTSEKTOR
	STA	SECTOR		;
	XRA	A		;VON SPUR0, KOPF 0
	STA	HEAD		;
	MVI	A,1		;ES IST EIN SEKTOR ZU LESEN/SCHREIBEN
	STA	SECTCNT		;
	LXI	H,SYSTEMSAVE	;SETZE DMA ADRESSE
	SHLD	DMAADR		;
	MVI	A,PHYS'
				;
				;
;-------------------------------------------------------------------
;
;
;
READ:					; MONITOR LESEROUTINE
		EXAF			;
		EXX			;
		LXI	H,MREAD		;
		CALL	BANK0CALL	;
		EXX			;
		EXAF			;
		RET
;
WRITE:					; MONITOR SCHREIBROUTINE
		EXAF			;
		EXX			;
		LXI	H,MWRITE	;
		CALL	BANK0CALL	;
		EXX			;
		EXAF			;
		RET
;
TEST:					; MONITOR TEST DISK
		EXAF			;
		EXX			;
		LXI	H,MTEST		;
		CALL	BANK0CALL	;
		EXX			;
		EXAF			;
		RET
;
SETCMDT:				; MONITOR SETCMDT 
	ALL	5		;
		RET			;
;
;
;
;
BIOSREG		DS	8	;
NEXTDMA		DS	2	;
DRIVECR		DS	1	;ZWISCHENSPEICHER FUER LAUFWERK CHR
WRITEFLAG	DS	1	;
SIDES		DS	1	;EIN- ODER ZWEISEITENLESEN/SCHREIBEN
TRACKS		DS	1	;ANZAHL DER SPUREN BEIM LESEN/SCHREIBEN
WRITESIDES	DS	1	;
WRITETRACKS	DS	1	;
ZAEHLER		DS	1	;
;
;
	END
 JA, DANN LESE REST WIE IN BOOTSEKTOR
	MOV	B,A		;BESCHRIEBEN.
	LDA	SYSTEMSAVE+3	;
	JR	BOOTSEK6	;
BOOTSEK2:			;
	LDA	DEFSID		;ANSONSTEN LESE NACH DAFAULT VERFAHREN
	MOV	B,A		;
	LDA	DEFTRK		;
BOOTSEK6:			;
	STA	TRACKS		;
	MOV	A,B		;
	STA	SIDES		;
				;
BOOTSEK5:			;
				;LADE/SCHREIBE CPMLDR+LDRBIOS
	LXI	H,SYSTEMSAVE+80H;DMA-ADRESSE DER ERSTEN SPUR
	SHLD	NEXTDMA		;ABL