	title	'PROF-180X D-RAM-Disk driver'

;	Letzte Aenderung am 10.02.1986 (Joachim)

	dseg

	maclib	cpm3

	maclib	psys

	maclib	hd64180

	public	fdram

	extrn	@adrv,@rdrv,@dma,@trk,@sect,@dbnk,@cbnk
	extrn	adrtab,dmatrans,@dtbl

rspace	equ	384		; ramfloppy in kb

block	set	1024
dirs	set	32
	if	rspace gt 96
dirs	set	64
	endif
	if	rspace gt 256
block	set	2048
dirs	set	128
	endif
	if	rspace gt 512
dirs	set	256
	endif
	if	rspace gt 1024
dirs	set	512
	endif

	; extended disk parameter header

	dw	fwrite
	dw	fread
	dw	flogin
	dw	finit
	db	0,0
fdram	dph	0,dpbr,0,rspace/(block/1024)/4

	cseg

dpbr	dpb	128,128,rspace/16,block,dirs,0,8000h

	dseg

flogin:				; kein login notwendig
	ret

finit:				; loesche direktory der ramfloppy mit e5h
				;
	lda	ramchips	; teste ob ramfloppy ueberhaupt erlaubt
	inr	a		;
	jrz	finit1		; sprung wenn ja
				;
	lxi	h,0		; ansonsten loesche eintrag in
	shld	@dtbl+8		; drivetable
	ret			;
				;
finit1:	lxi	h,fillbyte	;
	shld	adrtab		;
	xra	a		; aus bank 0
	sta	adrtab+2	;
	lxi	h,0		;
	shld	adrtab+3	;
	lxi	h,1		; laenge eins
	shld	adrtab+6	;
	lxi	h,banktab	;
	mov	a,m		; erste bank der ramfloppy in a
	sta	adrtab+5	;
	call	dmatrans	; im ersten byte steht e5h
				;
	lda	adrtab+5	;
	sta	adrtab+2	; vervielfaeltige e5h
	lxi	h,0		;
	shld	adrtab		;
	inx	h		;
	shld	adrtab+3	;
	lxi	h,7fffh		;
	shld	adrtab+6	;
	call	dmatrans	;
				;
	ret			;

fillbyte	db	0e5h	;

fread:	call	getadr		; berrechne adresse in ramfloppy
	shld	adrtab		; lege source adresse ab
	sta	adrtab+2	;
	lhld	@dma		; lege destination adresse ab
	shld	adrtab+3	;
	lxi	h,adrtab+5	;
trans:	lda	@dbnk		; lade dma bank, hier nur 0 oder 1
	rlc			; zwei nach links
	rlc			;
	ani	00000100b	; und maskieren
	mov	m,a		; und ablegen
	lxi	h,128		; lege laenge ab
	shld	adrtab+6	;
	call	dmatrans	;
	xra	a		;
	ret			;

fwrite:	call	getadr		; berechne adresse in ramfloppy
	shld	adrtab+3	; lege als destination ab
	sta	adrtab+5	;
	lhld	@dma		; lege dma adr als source ab
	shld	adrtab		;
	lxi	h,adrtab+2	;
	jr	trans		;


getadr:				; berrechne bank und adresse in
				; ram floppy.
				; eingang: @trk,@sekt
				; ausgang: adresse in hl, bank in akku
				;
	lda	@trk		; lade spur
	rrc			; schiebe um 2 positionen
	rrc			; nach rechts
	mov	c,a		; rette in c
	ani	00000111b	; maskiere fuer bank
	mov	l,a		; bilde auf richtige bank ab
	mvi	h,0		;
	lxi	d,banktab	;
	dad	d		;
	mov	b,m		; bank in b
	mov	a,c		; rest von track
	ani	11000000b	;
	mov	h,a		; nach h
	lda	@sect		; sektor
	rrc			; um eins nach rechts
	mov	c,a		; und in c retten
	ani	80h		; bilde untere
	mov	l,a		; adresse
	mov	a,c		; bilde
	ani	00111111b	; obere adresse
	ora	h		;
	mov	h,a		;
	mov	a,b		;
	ret			;

banktab:
	db	1,2,3,5,6,7	; benutzbare 64k banks

	end
