	title 'bank & move module for PROF-180 CP/M 3 linked BIOS'

	; letzte Aenderung am:
	; 12.12.1985 (Joachim)	

	cseg

	public ?move,?xmove,?bank,dmatrans,adrtab
	extrn @cbnk

	maclib hd64180

	maclib pdef

	maclib psys

?xmove:
	sbcd	sbank		; lege source und dest. bank ab
	mvi	a,0ffh		; setze flag fuer xmove
	sta	x$flg		;
	ret

sbank	db	0		; source bank fuer xmove
dbank	db	0		; destination bank fuer xmove
x$flg	db	0		; flag fuer xmove aktiv
sadrs	dw	0		; zwischenspeicher fuer xmove
dadrs	dw	0		;
length	dw	0		;

?move:
	xchg			; we are passed source in DE and dest in HL
	lda	x$flg		; xmove aktiv?
	inr	a		;
	jrz	xmv		; sprung wenn ja
	ldir			; use Z80 block move instruction
	xchg			; need next addresses in same regs
	ret

xmv:	sded	dadrs		; save destination
	sbcd	length		; save length
	lda	sbank		; switch to source bank
	call	?bank		;
	lxi	d,xmv$buff	; ziel ist buffer
	ldir			; uebertrage
	shld	sadrs		;
	lda	dbank		; switch to dest. bank
	call	?bank		;
	lded	dadrs		;
	lbcd	length		;
	lxi	h,xmv$buff	;
	ldir			;
	lda	@cbnk		; orginal bank ein
	call	?bank		;
	xchg			;
	lded	sadrs		;
	xra	a		;
	sta	x$flg		;
	ret

xmv$buff:	ds	128

?bank:
	sta	current$bank	; wichtig fuer cinit u. csysgen
	rlc ! rlc ! rlc ! rlc ! rlc ! rlc
	ani	40h
	out0	bbr,a
	ret

dmatrans:			; dma transfer, source und destination
				; daten stehen in @adrtab.
	lxi	h,adrtab	; zeiger auf datenliste.
	lxi	b,sar0l+(8*256)	; port und laenge angeben.
	otimr			; spezial ausgabe hd64180
	mov	a,m		; dcntl byte in akku
	out0	dmode,a		; und ausgeben.
	mvi	a,01100000b	; starte dma transfer
	out0	dstat,a		;
	ret			;
				;
adrtab:				;
	db	0,0,0,0,0,0,0,0	; datenliste
	db	000000010b	;

	end
