	title	'Boot loader module for PROF-180 CP/M 3.0'

	; Letzte Aenderung am:
	; 10.02.1986 (Joachim)

	public	?init,?ldccp,?rlccp,binit
	extrn	?pmsg,?conin,?cono,?const,?wboot
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn 	@cbnk,?bnksl,?pmsg,?bank,@ctbl
	extrn	monon,monoff,dmatrans,adrtab

	maclib	pdef
;
	maclib	pvec
;
	maclib	hd64180
;
	maclib	psys
;
	maclib	modebaud

bdos		equ 5

tpa$bank	equ 1

	dseg	; init done from banked memory

?init:
	xra	a					; setze mmu
	out0	cbr,a					;
	out0	bbr,a					;
	sta 	epromz					;
	mvi	a,com$page and 0f0h			;
	out0	cbar,a					;

	lxi	h,0180h					; setze kennung
	shld	dispadr					; in dispadr

	mvi	a,0					; setze biosversion
	sta	temp					; in temp

	lxi h,xwboot ! shld umleit$getcm + 1		; setze umleit
	lxi h,xconst ! shld mcs + 1			; vektoren
	lxi h,xconin ! shld mci + 1			;
	lxi h,xcono ! shld mco + 1			;

	lda	io$jumperbyte		; waehle richtige Voreinstellung
	cpi	4 ! jrz io4		; der Geraetetreiber
	cpi	3 ! jrz io3		; in Abhaengigkeit des IO Jumpers
	cpi	2 ! jrz io2		;
	cpi	1 ! jrz io1		;

io0:	lxi h,00400h ! lxi d,02000h ! lxi b,04000h ! jr ioset	; j4 kein jumper 
io1:	lxi h,08000h ! lxi d,02000h ! lxi b,04000h ! jr ioset	; j4/1-3
io2:	lxi h,01000h ! lxi d,02000h ! lxi b,04000h ! jr ioset	; j4/2-4
io3:	lxi h,00800h ! lxi d,02000h ! lxi b,04000h ! jr ioset	; j4/3-5
io4:	lxi h,00400h ! lxi d,02000h ! lxi b,04000h		; j4/4-6

ioset:	shld @civec ! shld @covec
	sded @lovec
	sbcd @aivec
	sbcd @aovec



	lxi h,signon$msg ! call ?pmsg			; print signon message
	ret

signon$msg:	db	13,10
		db	'PROF-180X CP/M Version 3, '
		db	'(C) 20.01.1986  Digital Research & Conitec'
		db	13,10,0


binit:
	lda	serbaud0		;setze die baudraten
	ani	0fh			;der beiden V-24 Schnittstellen
	sta	@ctbl+7			;wie im monitor definiert
	lda	serbaud1		;
	ani	0fh			;
	sta	@ctbl+7+8		;
	ret				;

j4baudlist:
	db	baud$9600
	db	baud$4800
	db	baud$2400
	db	baud$1200
	db	baud$300

	
			; diese Routinen werden von Monitor UP's benutzt

xwboot:
	mvi a,1 ! sta epromz
	call monoff ! jmp ?wboot

xconst:
	push b ! push d ! push h
	call ?const
	pop h ! pop d ! pop b ! ret

xconin:
	push b ! push d ! push h
	call ?conin
	pop h ! pop d ! pop b ! ret

xcono:
	push b ! push d ! push h
	call ?cono
	pop h ! pop d ! pop b ! ret

	cseg

	; Laden des CCP.COM von default drive

?ldccp:
	; First time, load the CCP.COM file into TPA

	mvi c,13 ! call bdos		; reset disk system
	xra a ! sta ccp$fcb+15		; zero extent
	lxi h,0 ! shld fcb$nr		; start at beginning of file
	lxi d,ccp$fcb ! call open	; open file containing CCP
	inr a ! jz no$CCP		; error if no file...
	lxi d,0100h ! call setdma	; start of TPA
	lxi d,128 ! call setmulti	; allow up to 16k bytes
	lxi d,ccp$fcb ! call read	; load the thing
					;
	lxi	h,100h			; save ccp
	shld	adrtab			;
	mvi	a,04h			; source bank is 1
	sta	adrtab+2		;
	lxi	h,0f300h		;
	shld	adrtab+3		;
	sta	adrtab+5		; gleiche dest. bank wie source
	lxi	h,0d00h			; laenge ccp etwas groeser wg. patch
	shld	adrtab+6		;
	jmp	dmatrans		; uebertrage


no$CCP:			; here if we couldn't find the file
	lxi h,ccp$msg1 ! call ?pmsg	; report this...
	mvi c,19h ! call bdos		; read current disk
	adi 'A' ! mov c,a ! call ?cono	; and display
	lxi h,ccp$msg2 ! call  ?pmsg	;
	call ?conin			; get a response
	jmp ?ldccp			; and try again


?rlccp:	
	lxi	h,0f300h		; get ccp
	shld	adrtab			;
	mvi	a,04h			; source bank is 1
	sta	adrtab+2		;
	lxi	h,0100h			;
	shld	adrtab+3		;
	sta	adrtab+5		; gleiche dest. bank wie source
	lxi	h,0d00h			; laenge ccp etwas groeser wg. patch
	shld	adrtab+6		;
	jmp	dmatrans		; uebertrage


	; CP/M BDOS Function Interfaces

open:
	mvi c,15 ! jmp bdos		; open file control block

setdma:
	mvi c,26 ! jmp bdos		; set data transfer address

setmulti:
	mvi c,44 ! jmp bdos		; set record count

read:
	mvi c,20 ! jmp bdos		; read records


ccp$msg1	db	13,10,'BIOS Err on ',0
ccp$msg2: 	db	': No CCP.COM file',13,10,0


ccp$fcb		db	0,'CCP     ','COM',0,0,0,0
		ds	16
fcb$nr		db	0,0,0


	end
