	title	 'PROF-180X Multi density diskette handler'

;
;	Disk I/O Module fuer PROF-180X
;
;		Letzte Aenderung am 26.02.1986 (Joachim)
;
	dseg

    ; Disk drive dispatching tables for linked BIOS

	public	fdsd0,fdsd1,fdsd2,fdsd3,fdsdk


    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk

    ; System Control Block variables

	extrn	@ermde		; BDOS error mode

    ; Utility routines in standard BIOS

	extrn	?wboot		; warm boot vector
	extrn	?pmsg		; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec		; print binary number in <A> from 0 to 99.
	extrn	?pderr		; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status


	maclib pdef
;
	maclib cpm3
;
	maclib hd64180
;
	maclib pvec
;
	maclib psys

;	common control characters

cr	equ 13
lf	equ 10
bell	equ 7


    ; Extended Disk Parameter Headers (XPDHs)

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init
	db	0,0		; relative drive zero, may be changed
fdsd0	dph     skew8,dpb0,64,144

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	1,0		; relative drive one, may be changed
fdsd1	dph	skew8,dpb1,64,144

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	2,0		; relative drive two, may be changed
fdsd2	dph	skew8,dpb2,64,144

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	3,0		; relative drive three, may be changed
fdsd3	dph	skew8,dpb3,64,144

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	0,0		; relative drive zero, may be changed
fdsdk	dph	skew8,dpbk,64,144

	cseg	; DPB must be resident

dpb0	dpb 1024,16,77,8192,256,2	; dummy dphs fuer GENCPM
dpb1	dpb 1024,16,77,8192,256,2	; und platzhalter fuer
dpb2	dpb 1024,16,77,8192,256,2	; richtigen dph, der von
dpb3	dpb 1024,16,77,8192,256,2	; fd$login reinkopiert wird
dpbk	dpb 1024,16,77,8192,256,2	;


	dseg

; Disk I/O routines for standardized BIOS interface

; Initialization entry point.

;		called for first time initialization.


fd$init:
	lxi	h,disk$type$list	; setze Zeiger auf
	shld	typelist		; disk$type$list.
	lxi	h,dtblg			; setze laenge der disk$type$list
	shld	ldtl			; in der systempage.
					;
	lxi	h,dphtab		; setze die relativen
	mvi	b,5			; laufwerksnummern entsprechend
fd$init1:				; der definition im monitor.
	mov	a,b			; abbildung log. => phys.
	dcr	a			; laufwerk.
	call	mdrive$trans		;
	mov	e,m			; lade zeiger auf dph-2
	inx	h			;
	mov	d,m			;
	inx	h			;
	stax	d			; setze relatives laufwerk.
	djnz	fd$init1		;
fd$init0:				;
	ret				;
					;
dphtab:					;
	dw	fdsdk-2			;
	dw	fdsd3-2			; tabelle mit zeigern auf
	dw	fdsd2-2			; dph-2 (relative drive).
	dw	fdsd1-2			;
	dw	fdsd0-2			;



fd$login:
		; This entry is called when a logical drive is about to
		; be logged into for the purpose of density determination.

		; It may adjust the parameters contained in the disk
		; parameter header pointed at by <DE>

	push	d		; save pointer to dph
	call	test$format	; test disk format
	popiy			; lade dph pointer in indexregister y
	cpi	0ffh		; disk not correct
	jrz	disk$not$korr	; dann sprung
	sty	a,-1		; setzte disktyp in dph fest
	pushix			; kopiere dph
	pop	h		;
	lxi	d,dpb$off	;
	dad	d		; in hl adresse des richtigen dpb
	ldy	e,12		; lade ziel adresse
	ldy	d,13		;
	lxi	b,dpblng	;
	ldir			; kopiere
				; wegen aufbau von disk$type$list
				; zeigt hl jetzt auf sektortranstabelle
	mov	e,m		;
	inx	h		;
	mov	d,m		;
	sty	e,0		; schreibe adresse der sektortranstabelle
	sty	d,1		; in dph
	ret			;
disk$not$korr:
	; setze stack so, dass hl=0 wenn seldsk zum bdos zurueckkehrt
	pop	d	; returnadresse
	pop	h	; dph adresse
	lxi	h,0	; setze dph adresse auf 0 (platte nicht erkennbar)
	push	h	; stack wieder herstellen
	push	d	;
	ret		;


; disk READ and WRITE entry points.

		; these entries are called with the following arguments:

			; relative drive number in @rdrv (8 bits)
			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)
			; pointer to XDPH in <DE>

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>
fd$write:
	mvi	a,0ffh		;
	jr	rwcom		;


fd$read:
	xra	a		;
rwcom:
	sta	roderw		; read oder write
	xchg			; save dph adress
	shld	current$dph	;
more$retries:			;
	mvi	a,0ffh		; unterdruecke fehlermeldung
	sta	dermsg		;
	mvi	a,5		; fuenf versuche
	sta	rwretry		;
				;
	call	rwcom1		; lesen oder schreiben
				;
	ora	a		; fehler?
	jrz	rwcom3		; sprung wenn nein
	lda	rest+1		; war diskette write protect?
	ani	2		;
	jrnz	rwcom3		; ja, fehlercode 2 (zufall)
	call	test$format	; hat sich das format geaendert?
	lhld	current$dph	;
	dcx	h		;
	cmp	m		; format gleich ?
	mvi	a,0ffh		;
	jrnz	rwcom3		; sprung wenn formatwechsel
	lda	@ermde		; fehlermeldung zugelassen?
	sta	dermsg		;
				;
	call	rwcom1		; zweiter lese-schreib-versuch
				;
	ora	a		;
	jrz	rwcom3		;
	lda	@ermde		;
	ora	a		;
	jrnz	rwcom6		;
	lxi	h,retrymsg	;
	call	?pmsg		;
	call	conin$echo	;
	cpi	'Y'		;
	jrz	more$retries	;
rwcom6	mvi	a,1		;
rwcom3	ret			;

rwcom1:				;
	call	chchg		;
	call	setup		; lese-schreib-kern
	call	setmem		;
	lda	roderw		;
	ora	a		;
	jz	mread		;
	jmp	mwrite		;


chchg:				; dieses unterprogramm prueft, ob
				; ein wechsel zwischen laufwerk A
				; und dem dummy laufwerk (K) stattgefunden
				; hat. wenn ja wird zum diskwechsel
				; aufgefordert und eine bestaetigung
				; des bedieners erwartet.
				;
	lda	@adrv		; teste ob aktuelles drive gleich drive A
	cpi	0		;
	jrz	chchg1		; sprung wenn ja.
	cpi	10		; teste ob aktuelles drive gleich drive K
	rnz			; return wenn nein
chchg1: mov	c,a		;
	lda	last$ch$drive	; war vorher laufwerks
	cmp	c		; wechsel ?
	rz			; return wenn nein.
	mov	a,c		;
	sta	last$ch$drive	; fuer naechsten zugriff
	adi	'A'		; ergaenze text
	sta	chtxt2		;
	lxi	h,chtxt1	; gebe text zum
	call	?pmsg		; wechseln der disks aus.
	call	?conin		; warte auf eingabe
	ret			;

chtxt1:	db	0dh,0ah,'insert disk '
chtxt2:	db	0
	db	', then press any key'
	db	0dh,0ah,0

last$ch$drive:
	db	0


conin$echo:			;
	call	?conin		;
	push	psw		;
	mov	c,a		;
	call	?cono		;
	pop	psw		;
	cpi	'a'		;
	rc			;
	sui	'a'-'A'		;
	ret			;

retrymsg:
	db	10,13,' Retry (Y/N) ?',0


setup:
				; setze alle parameter in CMDTAB.
				; setze 9229 auf mini/maxi betrieb.
				; setze writeprecompensation byte.
				;
	lhld	current$dph	; zeiger auf plattentyp setzen
	dcx	h		;
	mov	l,m		; rel. eintrag von disk$type$list steht in l
	mvi	h,l$dtyl	; laenge eines eintrages nach h
	mult	h		; multipliziere beide werte
	lxi	d,disk$type$list;
	dad	d		; hl zeigt auf richtigen disk$type$list eintrag
	push	h		; bringe zeiger
	popix			; nach indexregister x
	bitx	5,0		; teste auf mini/maxi bit
	jrz	setup1		;
	call	mminiset	; wenn null dann mini frequenz einstellen
	jr	setup2		;
setup1	call	mmaxiset	; wenn eins dann maxi frequenz einstellen
setup2	ldx	c,0		; setze diskformat in cmdtab
	mov	a,c		; setze mfm bit
	ani	01000000b	;
	sta	cmdtab		;
	mov	a,c		; setze sektorgroesse
	ani	00000011b	;
	sta	secsz		;
	mvi	a,0ffh		; setze dtl auf 0ffh wenn sektor groesser 128
	jrnz	setup3		;
	mvi	a,80h		; setze dtl auf 000h wenn sektor gleich 128
setup3	sta	dtll		;
	ldx	a,2		; setze eot geich letztem sektor
	sta	eot		;
	ldx	a,5		; setze gap laenge
	sta	gapll		;
	ldx	a,3		; setze writeprecompensation
	ani	00000111b	;
	sta	write$precom	;
	ldx	a,7		; setze erste spur mit
	sta	precom$begin	; writeprecompensation
	lda	@rdrv		; setze laufwerk
	ani	00000011b	;
	sta	unit		;
				; setze spur sektor und head
	lda	@trk		; lade spur nach
	mov	c,a		; register c
	lda	@sect		; lade sektor nach
	mov	b,a		; register b
	ldx	a,4		; welche track reihenfolge (VERFAHREN) ?
	ani	00000111b	; 
	jrz	ttrans0		; VERFAHREN 1
	cpi	1		;
	jrz	ttrans1		; VERFAHREN 2
	cpi	2		;
	jrz	ttrans2		; VERFAHREN 3
	cpi	3		;
	jrz	ttrans3		; VERFAHREN 4
				; wenn Bit2 gesetzt, dann
	jr	ttrans4		; VERFAHREN 5
				;
ttrans0:			; VERFAHREN 1 spur umwandlung, es gilt:
				; eine spur besteht aus vorder- und
				; rueckseite. das oberste bit der sektor-
				; angabe gibt die seite an. dieses verfahren
				; wurde bei prof-80 ausschliesslich verwendet.
				; einseitige prof-80 formate lassen sich
				; gleichwertig mit VERFAHREN 1, 3
				; oder 4 verwirklichen. fuer zweiseitige
				; prof-80 formate sind VERFAHREN 1 und 2
				; moeglich, VERFAHREN 2 ist jedoch guenstiger,
				; da sektran-tabelle um faktor 2 kleiner wird.
				; mit VERFAHREN 1 lassen sich exotische
				; formate mit beliebig wechselnden sektoren
				; auf vorder- und rueckseite verwirklichen.
				;
	mov	d,b		; sektor nach reg. d
	mov	a,b		; und akku kopieren.
	ani	01111111b	; blende oberstes bit aus
	mov	b,a		; ergibt richtiger sektor.
	mov	a,d		; oberstes bit gibt seite an
	rlc			; also schiebe oberstes bit in unterstes
	ani	00000001b	; und maskiere es.
	jr	setup4		;
				;
ttrans1:			; VERFAHREN 2 spur umwandlung, es gilt:
				; v0,r0,v1,r1,........,vn,rn
				;
	mov	d,c		; kopiere spur in reg. c
	mov	a,c		; und in akku.
	rrc			; teile spur durch 2
	ani	01111111b	; und lege neue spur
	mov	c,a		; wieder in c ab.
	mov	a,d		; head gleich
	ani	00000001b	; unterstem altspur bit.
	jr	setup4		; weiter bei setup4
				;
ttrans2:			; VERFAHREN 3 spur umwandlung, es gilt:
				; v0,v1,........vn,r0,r1,......rn
				;
	ldx	a,6		; lade anzahl der spuren einer seite nach a.
	mov	d,a		; kopiere anzahl der spuren nach reg. d
	dcr	a		; spuren beginnen mit null, 1 weniger
	cmp	c		; ist aktuelle spur groesser als letzte spur ?
	xra	a		; nein, dann seite 0
	jrnc	setup4		; und weiter.
	mov	a,c		; sonst rueckseite
	sub	d		; bei spur 0 weiter
	mov	c,a		;
	mvi	a,1		; und seite eins anwaehlen.
	jr	setup4		;
				;
ttrans3:			; VERFAHREN 4 spur umwandlung, es gilt:
				; v0,v1,......,vn,rn,rn-1,.......,r0
				;
	ldx	a,6		; lade anzahl der spuren einer seite nach a.
	mov	d,a		; kopiere anzahl nach reg d.
	dcr	a		; eins weniger.
	cmp	c		; ist aktuelle spur groesser als letzte spur ?
	xra	a		; nein, dann seite 0
	jrnc	setup4		; und weiter.
	mov	a,d		; anzahl der spuren nach a
	add	d		; verdoppeln
	dcr	a		; und weniger eins.
	sub	c		; ziehe aktuelle spur ab
	mov	c,a		; ergibt spurnr. auf rueckseite.
	mvi	a,1		; setzte rueckseite.
	jr	setup4		;
				;
ttrans4:			; VERFAHREN 5 spur umwandlung. 
				; Es wird kein fester Algorithmus verwendet,
				; sondern eine Trackuebersetzungstabelle
				; herangezogen. Byte 27 und 28 des
				; Disktypelisteintrags zeigen auf die gueltige
				; Uebersetzungstabelle. Ist Bit8 eines Eintrages
				; in der Trackuebersetzungstabelle gesetzt,
				; dann wird die Rueckseitenspur verwendet.
				;
	ldx	l,27		; lade zeiger auf trackuebersetungstabelle
	ldx	h,28		; nach hl.
	mov	e,c		; setze zeiger auf relativen eintrag
	mvi	d,0		; zur gewuenschten spur.
	dad	d		; ok, hl zeigt auf richtige spur.
	mov	a,m		; lade nach a
	ani	01111111b	; und blende rueckseitenbit aus.
	mov	c,a		; spur nach c.
	mov	a,m		; rueckseitenbit in akku.
	rlc			;
	ani	00000001b	;
	jr	setup4		;
				;
setup4:				; trage die aus dem jeweiligen VERFAHREN
				; gewonnenen Werte in die CMDTAB ein.
				;
	ora	a		; 
	jrz	setup5		;
				;
	bitx	4,4		; headbit auf rueckseite
	jrnz	setup6		;
	mvi	a,00000011b	;
	jr	setup6		;
				;
setup5:	bitx	4,0		; headbit auf vorderseite
	jrz	setup6		;
	mvi	a,00000010b	;
				;
setup6:	sta	head		;
	mov	a,c		;
	sta	track		;
	mov	a,b		;
	sta	sector		;
	ret			;


setmem:
				; setze dmaadresse
				;
	mvi	a,1		; einen sektor uebertragen
	sta	sectcnt		;
	lhld	@dma		; lese dma adresse
	shld	dmaadr		; trage dmaadresse ein
	lda	@dbnk		; setze dmabank
	rlc ! rlc
	ani 4h			;
	sta	dmabank		;
	ret			;


roderw	ds	1



TEST$FORMAT:
	;TESTET DAS FORMAT DER DISK, DIE SICH IM VON
	;@RDRV SPEZIFIZIERTEN LAUFWERK BEFINDET UND VERGLEICHT
	;ES MIT DEN IN DISK$TYPE$LIST ERLAUBTEN FORMATEN.
	;IST DAS FORMAT NICHT ERKENNBAR, ODER IN DISK$TYPE$LIST
	;NICHT VEREINBART, SO KEHRT TEST$FORMAT MIT AKKU=0FFH
	;ZURUECK. KONNTE DAS FORMAT ERMITTELT WERDEN UND WAR ES AUCH IN
	;DISK$TYPE$LIST VEREINBART, DANN KEHRT TEST$FORMAT MIT AKKU GLEICH
	;NUMMER DES EINTRAGES ZURUECK. IX ZEIGT AUF ANFANG DES EINTRAGS.
	;
	call	chchg		;
	lda	@rdrv		;SETZE DAS ZU TESTENDE LAUFWERK
	ani	03h		;maskiere die oberen 6 bits
	STA	UNIT		;
	MVI	B,5		;FUENF TEST-VERSUCHE
	MVI	A,1		;AUF SPUR 1
	STA	TEST$TRACK	;
TESTF1:	PUSH	B		;
	CALL	mtest		;
	POP	B		;
	ORA	A		;WAR TEST ERFOLGREICH ?
	JRZ	TESTF3		;SPRUNG WENN JA
	DJNZ	TESTF1		;SONST MAXIMAL FUENF VERSUCHE
TESTF2	MVI	A,0FFH		;SONST RUECKSPRUNG MIT AKKU=0FFH
	RET			;
TESTF3:				;OK, FORMAT DATEN STEHEN IN TEST$TYPE
				;TEST$LSEK UND TEST$TRACK.
	LXIX	DISK$TYPE$LIST	;IX ZEIGT AUF ERSTEN EINTRAG DER LISTE.
	LDA	TEST$TYPE	;TEST$TYPE
	MOV	D,A		;NACH D.
	LDA	TEST$MSEK	;LETZTER SEKTOR
	MOV	E,A		;NACH E.
	LDA	TEST$LSEK	;ERSTER SEKTOR
	MOV	H,A		;NACH H.
	LDA	@RDRV		;BERECHNE MASKE FUER UNIT.
	INR	A		;
	MOV	B,A		;
	MVI	A,00001000B	;
TESTF5:	RLC			;
	DJNZ	TESTF5		;
	MOV	L,A		;OK, MASKE IN L.
	MVI	B,0		;ZAEHLER FUER FORMATNUMMER AUF NULL.
TESTF4:	BITX	3,0		;ENDE DER LISTE WENN BIT 3 AUF 1.
	JRNZ	TESTF2		;WENN DIES DER FALL ZURUECK, NICHT ERKANNT.
	LDX	A,0		;VERGLEICHE TEST$TYPE.
	CMP	D		;
	JRNZ	NEXT$ENTRY	;SPRUNG WENN UNGLEICH.
	LDX	A,1		;VERGLEICHE TEST$LSEK.
	CMP	H		;
	JRNZ	NEXT$ENTRY	;SPRUNG WENN UNGLEICH.
	LDX	A,2		;VERGLEICHE TEST$MSEK.
	CMP	E		;
	JRNZ	NEXT$ENTRY	;SPRUNG WENN UNGLEICH.
	LDX	A,3		;IST DAS FORMAT AUCH AUF DIESEM
	ANA	L		;LAUFWERK GUELTIG ?
	JRZ	NEXT$ENTRY	;SPRUNG WENN NICHT GUELTIG.
				;
				;OK, DISK WURDE ERKANNT
	mov	a,b		;
	RET			;
				;
NEXT$ENTRY:			;SETZE IX AUF NAECHSTEN EINTRAG
				;DER DISK$TYPE$LIST, ERHOEHE B UM 1.
	push	b		;
	lxi	b,l$dtyl	;LAENGE DER DISK$TYPE$LIST
	dadx	b		;ZU IX ADDIEREN.
	pop	b		;
	inr	b		;ERHOEHE B UM EINS.
	jr	testf4		;


;********************************************************************
;
;	HIER WERDEN DIE MOEGLICHEN DISK-FORMATE VEREINBART
;
;
;
DISK$TYPE$LIST:
	;
	;DIESE LISTE DEFINIERT DIE VOM BETRIEBSSYSTEM LESBAREN
	;PLATTEN-TYPEN.
	;DIE LISTE BESTEHT AUS BELIEBIG VIELEN EINTRAEGEN,
	;DIE WIE NACHFOLGEND BESCHRIEBEN AUFGEBAUT
	;SIND:
	;	BYTE 1		:DISK-TYP WIE VON MONTEST ERMITTELT
	;	BYTE 2		:ERSTER SEKTOR AUF SPUR
	;	BYTE 3		:LETZTER SEKTOR AUF SPUR
	;	BYTE 4		:WRITE PRECOMPENSATION UND LW GUELTIGKEIT
	;	BYTE 5		:BYTE FUER LOGISCHE DISK VERWALTUNG
	;	BYTE 6		:GAP-LAENGE FUER UPD765
	;	BYTE 7		:ANZAHL DER CYLINDER
	;	BYTE 8		:AB DIESER SPUR ERFOLGT PRECOMPENSATION
	;	BYTE 9-25	:ZUGEHOEHRIGER DISK PARAMETER BLOCK
	;	BYTE 26-27	:ZEIGER AUF SEKTOR UEBERSETZUNGSTABELLE
	;	BYTE 28-29	:ZEIGER AUF TRACK UEBERSETUNGSTABELLE
	;
	;TEST$FORMAT VERGLEICHT DIE DREI ERSTEN BYTES MIT
	;TEST$TYPE TEST$LSEK UND TEST$MSEK DIE DAS UNTERPROGRAM MONTEST
	;LIEFERT. AUSSERDEM WIRD UEBERPRUEFT, OB DAS FORMAT AUF DEM
	;GETESTETEN LAUFWERK GUELTIG IST.
	;
	SSIDE	EQU	000H	;EQUATES FUER TYPE
	DSIDE	EQU	080H	;
	SDENS	EQU	000H	;
	DDENS	EQU	040H	;
	MAXIF	EQU	000H	;
	MINIF	EQU	020H	;
	VHB0	EQU	000H	;
	VHB1	EQU	010H	;
	S0128	EQU	000H	;
	S0256	EQU	001H	;
	S0512	EQU	002H	;
	S1024	EQU	003H	;
	;
	RHB0	EQU	000H	;EQUATES FUER LOGISCHE DISK VERWALTUNG
	RHB1	EQU	010H	;
	TUV1	EQU	000H	;
	TUV2	EQU	001H	;
	TUV3	EQU	002H	;
	TUV4	EQU	003H	;
	TUV5	EQU	004H	;
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 5 PROF-80 (8" STANDARD CP/M)	***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR SDENS OR MAXIF OR VHB0 OR S0128
	DB	1,26
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	07
	DB	77
	DB	0FFH
DPB$OFF	EQU	$-DISK$TYPE$LIST
	DPB	128,26,77,1024,64,2
DPBLNG	EQU	$-DISK$TYPE$LIST-DPB$OFF
	DW	SKEW26
	DW	0
L$DTYL	EQU	$-DISK$TYPE$LIST
;
	;	***************************************************
	;	***						***
	;	***	FORMAT ELAB 8" SS/DD			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MAXIF OR VHB0 OR S0256
	DB	1,26
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	07
	DB	77
	DB	0FFH
	DPB	256,26,77,2048,128,2
	DW	SKEW3$26
	DW	0

	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 6 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MAXIF OR VHB0 OR S1024
	DB	1,8
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	35H
	DB	77
	DB	0FFH
	DPB	1024,8,77,2048,128,2
	DW	SKEW8
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 7 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S0256
	DB	1,26
	DB	000H			;AUSSER GEFECHT
	DB	RHB1 OR TUV1
	DB	7
	DB	77
	DB	0FFH
	DPB	256,52,77,4096,128,2
	DW	SKEW26
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT ELAB 8" DS/DD			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S0256
	DB	1,26
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	7
	DB	77
	DB	0FFH
	DPB	256,52,77,4096,256,2
	DW	SKEW$ELAB$DS
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 8 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S0512
	DB	1,15
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	18H
	DB	77
	DB	0FFH
	DPB	512,30,77,2048,256,2
	DW	SKEW15
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 9 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S1024
	DB	1,8
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	35H
	DB	77
	DB	0FFH
	DPB	1024,16,77,8192,256,2
	DW	SKEW8
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 10 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	1,16
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	1BH
	DB	40
	DB	0FFH
	DPB	256,16,40,1024,64,4
	DW	NOSKEW1
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 1 PROF-80 (OSBORNE 1 DD)		***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S1024
	DB	1,5
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	1BH
	DB	40
	DB	0FFH
	DPB	1024,5,40,1024,64,3
	DW	SKEW5
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 3 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S1024
	DB	1,5
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	1BH
	DB	80
	DB	0FFH
	DPB	1024,5,80,2048,128,3
	DW	SKEW5
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 2 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	1,10
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	0EH
	DB	40
	DB	0FFH
	DPB	512,20,40,2048,128,3
	DW	SKEW10
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 4 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	1,10
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	0EH
	DB	80
	DB	0FFH
	DPB	512,20,80,2048,128,3
	DW	SKEW10
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT BONDWELL 14			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	0,17
	DB	0F0H
	DB	RHB1 OR TUV3
	DB	0EH
	DB	40
	DB	0FFH
	DPB	256,18,80,2048,128,2
	DW	NOSKEW0
	DW	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT PHILIPS P2000-C			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	1,16
	DB	0F0H
	DB	RHB1 OR TUV2
	DB	0EH
	DB	80
	DB	0FFH
	DPB	256,16,160,4096,128,2
	DW	SKEW2$16
	DW	0
	;
	;
	DB	008H

skew26		skew	26,6,1
		skew1	26,6,1

skew15		skew	15,4,1
		skew1	15,4,1

skew8		skew	8,3,1
		skew1	8,3,1

skew5		skew	5,1,1
		skew1	5,1,1

skew10		skew	10,2,1
		skew1	10,2,1

noskew1		skew	48,1,1
noskew0		skew	18,1,0
skew3$26:	skew	26,3,1
skew2$16:	skew	16,2,1

skew$elab$ds:
	db	1,4,7,10,13,16,19,22,25
	db	130,133,136,139,142,145,148,151,154
	db	3,6,9,12,15,18,21,24
	db	129,132,135,138,141,144,147,150,153
	db	2,5,8,11,14,17,20,23,26
	db	131,134,137,140,143,146,149,152


	ds	disk$type$list-$+dtblg		; halte speicherbereich
						; entsprechend der maximal
						; laenge der patch aerra frei.
;
;	ENDE DER DISK$TYPE$LIST PATCH-AERA
;
;*************************************************************************

current$dph	ds	2	

	end
