	title	'Boot loader module for PROF-180 CP/M 3.0'

	; Letzte Aenderung am:
	; 03.03.1987 (Joachim)
	;  9.12.1986  JCL  Bootfile-Attribute eingebaut

	public	?init,?ldccp,?rlccp,binit
	extrn	?pmsg,?conin,?cono,?const,?wboot
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn 	@cbnk,?bnksl,?pmsg,?bank,@ctbl
	extrn	monon,monoff,dmatrans,adrtab
	extrn	signon,scb$base

	maclib	pdef
;
	maclib	pvec
;
	maclib	hd64180
;
	maclib	psys
;
	maclib	modebaud
;
	maclib	pkonfig

bdos		equ 	5
def$fcb		equ	80h

tpa$bank	equ 	1

	dseg	; init done from banked memory


binit:
	lda	serbaud0		;setze die baudraten
	ani	0fh			;der beiden V-24 Schnittstellen
	sta	@ctbl+7			;wie im monitor definiert
	lda	serbaud1		;
	ani	0fh			;
	sta	@ctbl+7+8		;
	ret				;


?init:
	xra	a					; setze mmu
	out0	cbr,a					;
	out0	bbr,a					;
	sta 	epromz					;
	mvi	a,com$page and 0f0h			;
	out0	cbar,a					;

	lxi	h,0180h					; setze kennung
	shld	dispadr					; in dispadr

	mvi	a,12h					; setze biosversion
	sta	temp					; in temp
	
	if	loginmsg				; defaulteinstellung
	mvi	a,001h					; fuer anzeige des
	else						; formatnamens
	mvi	a,000h					;
	endif						;
	sta	login					;

	lxi h,xwboot ! shld umleit$getcm + 1		; setze umleit
	lxi h,xconst ! shld mcs + 1			; vektoren
	lxi h,xconin ! shld mci + 1			;
	lxi h,xcono ! shld mco + 1			;

	lda	io$jumperbyte		; waehle richtige Voreinstellung
	cpi	4 ! jrz io0		; der Geraetetreiber
	cpi	3 ! jrz io3		; in Abhaengigkeit des IO Jumpers
	cpi	2 ! jrz io2		;
	cpi	1 ! jrz io1		;

io0:	lxi h,00400h
	if griplist
	lxi d,00200h
	else
	lxi d,02000h
	endif
	lxi b,04000h ! jr ioset				      ; j4 kein jumper 
io1:	lxi h,08000h ! lxi d,02000h ! lxi b,04000h ! jr ioset ; j4/1-3
io2:	lxi h,01000h ! lxi d,02000h ! lxi b,04000h ! jr ioset ; j4/2-4
io3:	lxi h,00800h ! lxi d,02000h ! lxi b,04000h ! jr ioset ; j4/3-5

ioset:	shld @civec ! shld @covec
	sded @lovec
	sbcd @aivec
	sbcd @aovec

	lhld	boot$name	; wurde von EPROM Floppy gebootet?
	mov	a,h		;
	ora	l		;
	jrz	no$eboot	; Sprung wenn nein
	lxi	h,filedt	; wenn ja: kopiere per dma
	lxi	d,adrtab	; den Bereich 00100h bis 0efffh
	lxi	b,8		; nach 40000h bis 4efffh
	ldir			;
	call	dmatrans	;

no$eboot:
	call	signon		; Drucke Startmeldung, die Rotine befindet
	ret			; sich im Modul PS.ASM

filedt:	dw	100h
	db	0
	dw	100h
	db	4
	dw	0ef00h
	
			; diese Routinen werden von Monitor UP's benutzt

xwboot:
	mvi a,1 ! sta epromz
	call monoff ! jmp ?wboot

xconst:
	push b ! push d ! push h
	call ?const
	pop h ! pop d ! pop b ! ret

xconin:
	push b ! push d ! push h
	call ?conin
	pop h ! pop d ! pop b ! ret

xcono:
	push b ! push d ! push h
	call ?cono
	pop h ! pop d ! pop b ! ret

	cseg

	; Laden des CCP.COM von default drive

?ldccp:
	mvi c,13 ! call bdos		; reset disk system

	; pruefe ob vom EPROM gebootet wurde, wenn ja kopiere
	; Dateien aus der TPA in die RAM-Floppy (ist dann default drive)

	lhld	boot$name		; lade zeiger auf EPROM Dateien
	mov	a,h			; wenn null, dann war kein
	ora	l			; EPROM-Boot
	jrz	ldccp1			;
					;
	mvi	a,4			; setze default drive E
	sta	scb$base+13h		;
	sta	scb$base+3eh		;
					;
eprl:	lxi	d,def$fcb+1		; kopiere Namen in
	lxi	b,11			; default FCB
	ldir				;
	push	h			; rette hl
	xra	a			;
	sta	def$fcb+12		; ex := 0
	sta	def$fcb+32		; cr := 0
	lxi	d,def$fcb		;
	stax	d			; default drive
	mvi	c,22			; make file
	call	bdos			;

	LXI	H,DEF$FCB+9		;->R/O-Flag
	if BOOTRO
	  SETB	7,M
	endif
	INX	H			;->SYS-Flag
	if BOOTSYS
	  SETB	7,M
	endif
	INX	H			;->ARCHIVE-Flag
	SETB	7,M
	LXI	D,DEF$FCB
	MVI	C,30			;SET ATTRIBUTES
	CALL	BDOS

	pop	h			;
	mov	e,m			; 
	inx	h			;
	mov	d,m			; de zeigt auf dma adresse
	inx	h			;
	mov	b,m			; b zeigt auf record anzahl
	push	h			; rette hl
writel:	push	d			; rette de
	push	b			; rette bc
	call	setdma			; setze dma adresse
	lxi	d,def$fcb		; schreibe einen record
	mvi	c,21			;
	call	bdos			;
	pop	b			;
	pop	d			;
	lxi	h,128			; dma adresse eins weiter
	dad	d			;
	xchg				;
	djnz	writel			; schreibe alle records
	lxi	d,def$fcb		; close file
	mvi	c,16			;
	call	bdos			;
	pop	h			;
	inx	h			;
	mov	a,m			; ende kennung ?
	inx	h			;
	ana	m			;
	inx	h			; hl zeigt auf naechsten eintrag
	inr	a			;
	jrnz	eprl			; weiter bis ende kennung

	; First time, load the CCP.COM file into TPA
ldccp1:
	xra a ! sta ccp$fcb+15		; zero extent
	lxi h,0 ! shld fcb$nr		; start at beginning of file
	lxi d,ccp$fcb ! call open	; open file containing CCP
	inr a ! jz no$CCP		; error if no file...
	lxi d,0100h ! call setdma	; start of TPA
	lxi d,128 ! call setmulti	; allow up to 16k bytes
	lxi d,ccp$fcb ! call read	; load the thing
					;
	lxi	h,100h			; save ccp
	shld	adrtab			;
	mvi	a,04h			; source bank is 1
	sta	adrtab+2		;
	lxi	h,0f300h		;
	shld	adrtab+3		;
	sta	adrtab+5		; gleiche dest. bank wie source
	lxi	h,0d00h			; laenge ccp etwas groeser wg. patch
	shld	adrtab+6		;
	jmp	dmatrans		; uebertrage


no$CCP:			; here if we couldn't find the file
	lxi h,ccp$msg1 ! call ?pmsg	; report this...
	mvi c,19h ! call bdos		; read current disk
	adi 'A' ! mov c,a ! call ?cono	; and display
	lxi h,ccp$msg2 ! call  ?pmsg	;
	call ?conin			; get a response
	jmp ?ldccp			; and try again


?rlccp:	
	lxi	h,0f300h		; get ccp
	shld	adrtab			;
	mvi	a,04h			; source bank is 1
	sta	adrtab+2		;
	lxi	h,0100h			;
	shld	adrtab+3		;
	sta	adrtab+5		; gleiche dest. bank wie source
	lxi	h,0d00h			; laenge ccp etwas groeser wg. patch
	shld	adrtab+6		;
	jmp	dmatrans		; uebertrage


	; CP/M BDOS Function Interfaces

open:
	mvi c,15 ! jmp bdos		; open file control block

setdma:
	mvi c,26 ! jmp bdos		; set data transfer address

setmulti:
	mvi c,44 ! jmp bdos		; set record count

read:
	mvi c,20 ! jmp bdos		; read records


ccp$msg1	db	13,10,'BIOS Err on ',0
ccp$msg2: 	db	': No CCP.COM file',13,10,0


ccp$fcb		db	0,'CCP     ','COM',0,0,0,0
		ds	16
fcb$nr		db	0,0,0


	end
